/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;

include	parser;
include	symtab, types;
include	sbuffer, ptree, hash;
include	backend, real;
include	xcall, xstmt, xtree;
include	gencode, asmcode;
include	target;

enable386backend:	public	() =
	{
	Func = &I386Func;
	}

I386Func:	inherit	functionBody	{

startValue:	dynamic	(u: ref unit_s) =
	{
	if	(Project.outputAs & OM_ASM)
		Project.asmFd = AsmEncoder constructor(u->name);
	}

endValue:	dynamic	() =
	{
	if	(Project.outputAs & OM_ASM){
		AsmEncoder close();
		Project.asmFd = 0;
		}
	}

generateCode:	dynamic	(sym: ref symbol_s, x: ref stmt_x, 
					sc: ref blockScope) =
	{
	gencode::generateCode(sc, sym->currentValue, x);
	if	(sc->child)
		sc->child foldStaticValues(sym->currentValue);
	}

generateData:	dynamic	(sym: ref symbol_s) =
	{
	x:		ref tree_p;
	y:		ref tree_p;
	u:		ref tree_p;
	t:		ref type_s;
	initTree:	ref tree_p;

	t = sym->dtype getType();
	if	(t == 0){
		printf("t = %x name = %S dtype = ", t, sym->name spelling());
		sym->dtype display(TRUE);
		printf("\n");
		return;
		}
	if	(sym->initBase &&
		 sym->storageClass != SC_INTRINSIC)
		y = Func icon(sym->initBase, INTBITS);
	else
		y = 0;
	x = y;
	if	(sym->initializer.start ||
		 y ||
		 t needsDynamicVectors()){
		sym->currentValue registerType();
		if	(sym->initializer.start){
			src:		ref sourceParser;

			src = sym->enclosing getSourceBuffer();
			if	(src == 0)
				return;
			x = src parseWholeExpression(sym->initializer);
			if	(x == 0)
				return;
			if	(y)
				x = Func binary(O_ADD, x, y, sym->offset);
			x = x assignTypes(sym->enclosing, FALSE);
			if	(x == 0)
				return;
			x = x fold();
			}
		sym->currentValue initialize(x);
		}
	else
		sym->currentValue recordValueSize();
	}

argument:	dynamic	(l: ref tree_p, r: ref tree_p, 
				o: fileOffset) ref tree_p =
	{
	return new argument_i386[ l, r, o ];
	}

assert_:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return assert_x create(x, s);
	}

auto:	dynamic	(sym: ref symbol_s) ref auto_x =
	{
	return new auto_i386[ sym ];
	}

binary:	dynamic	(op: operators, l: ref tree_p, 
				r: ref tree_p, 
				o: fileOffset) ref binary_x =
	{
	return new binary_i386[ op, l, r, o ];
	}

block:	dynamic	(x: ref stmt_x) ref stmt_x =
	{
	return new block_i386[ x ];
	}

cast:	dynamic	(d: ref type_p, t: ref tree_p, o: fileOffset) ref tree_p =
	{
	return new cast_i386[ d, t, o ];
	}

conditional:	dynamic	(t: ref tree_p, tp: ref tree_p, 
				fp: ref tree_p, 
				o: fileOffset) ref tree_p =
	{
	return conditional_x create(t, tp, fp , o);
	}

continueExcept:	dynamic	() ref stmt_x =
	{
	return continueExcept_x create();
	}

criticalRegion:	dynamic	(t: ref tree_p, s: textRange) ref critical_x =
	{
	return new critical_i386[ O_CRITICAL, t, s ];
	}

decl:	dynamic	(d: ref declaration_p, s: textRange) ref stmt_x =
	{
	return decl_x create(d, s);
	}

ellipsis:	dynamic	() ref tree_p =
	{
	return ellipsis_x create();
	}

endCritical:	dynamic	(c: ref critical_x) ref stmt_x =
	{
	return new endCritical_i386[ O_ENDCRITICAL, c ];
	}

endExcept:	dynamic	(m: ref try_x) ref stmt_x =
	{
	return endExcept_x create(m);
	}

endTry:	dynamic	(x: ref try_x) ref stmt_x =
	{
	return endTry_x create(x);
	}

error:	dynamic	() ref tree_p =
	{
	return error_x create();
	}

errorStmt:	dynamic	(o: fileOffset) ref stmt_x =
	{
	return errorStmt_x create(o);
	}

expr:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return new expr_i386[ x, s ];
	}

fcon:	dynamic	(v: ref real, w: int) ref tree_p =
	{
	return fcon_x create(v, w);
	}

goto_:	dynamic	(id: ref identifier, s: textRange) ref stmt_x =
	{
	return goto_x create(id, s);
	}

icon:	dynamic	(v: long, w: int) ref tree_p =
	{
	return new icon_i386[ v, w ];
	}

iden:	dynamic	(un: ref identifier, uno: fileOffset,
		 id: ref identifier, o: fileOffset) ref tree_p =
	{
	return new iden_i386[ un, uno, id, o ];
	}

jump:	dynamic	(t: ref label_x, s: textRange) ref jump_x =
	{
	return new jump_i386[ t, s ];
	}

label_:	dynamic	() ref label_x =
	{
	return new label_i386[ O_LABEL, 0, 0 ];
	}

literal:	dynamic	() ref literal_x =
	{
	return literal_x create();
	}

methodCall:	dynamic	(l: ref tree_p, id: ref identifier,
				r: ref tree_p,
				o: fileOffset) ref tree_p =
	{
	return methodCall_x create(l, id, r, o);
	}

namedLabel:	dynamic	(id: ref identifier, o: fileOffset) ref label_x =
	{
	return new label_i386[ O_LABEL, id, o ];
	}

new_:	dynamic	(d: ref type_p, t: ref tree_p, o: fileOffset) ref tree_p =
	{
	return new_x create(d, t, o);
	}

offsetof_:	dynamic	(d: ref type_p, id: ref identifier) ref tree_p =
	{
	return offsetof_x create(d, id);
	}

reference:	dynamic	(op: operators, l: ref tree_p, 
				id: ref identifier,
				o: fileOffset) ref tree_p =
	{
	return reference_x create(op, l, id, o);
	}

reply_:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return reply_x create(x, s);
	}

return_:	dynamic	(x: ref tree_p, s: textRange) ref stmt_x =
	{
	return return_x create(x, s);
	}

sconst:	dynamic	(c: ref tree_p, o: fileOffset) ref tree_p =
	{
	return sconst_x create(c, o);
	}

self_:	dynamic	(op: operators, o: fileOffset) ref tree_p =
	{
	return self_x create(op, o);
	}

sizeof_:dynamic	(d: ref type_p) ref tree_p =
	{
	return sizeof_x create(d);
	}

slice:	dynamic	(t: ref tree_p, l: ref tree_p, r: ref tree_p, o: fileOffset)
							ref tree_p =
	{
	return slice_x create(t, l, r, o);
	}

staticCall:	dynamic	(l: ref tree_p, r: ref tree_p,
				o: fileOffset) ref tree_p =
	{
	return new staticCall_i386[ l, r, o ];
	}

switch_:	dynamic	(x: ref tree_p, s: textRange) ref switch_x =
	{
	return switch_x create(x, s);
	}

test:	dynamic	(t: ref tree_p, destination: ref label_x, 
					s: textRange) ref stmt_x =
	{
	s1:		ref stmt_x;
	s2:		ref stmt_x;
	falslab:	ref label_x;
	left:		ref tree_p;
	right:		ref tree_p;

	switch	(t->operator){
	default:
		t = binary(O_NE, t, icon(0L, INTBITS), s.start);

	case	O_EQ:
	case	O_NE:
	case	O_LT:
	case	O_GT:
	case	O_LE:
	case	O_GE:
	case	O_ORD:			// <>=
	case	O_UNORD:		// !<>=
	case	O_NLT:			// !<
	case	O_NLE:			// !<=
	case	O_NGT:			// !>
	case	O_NGE:			// !>=
	case	O_LT_GT:		// <>
	case	O_NLT_GT:		// !<>
		return new test_i386[ t, destination, s ];

	case	O_NOT:
		left = ref binary_x(t)->left;
		return testFalse(left, destination, s);

	case	O_LAND:
		left = ref binary_x(t)->left;
		right = ref binary_x(t)->right;
		falslab = Func label_();
		s1 = testFalse(left, falslab, s);
		s2 = test(right, destination, s);
		s1 post(s2);
		s1 post(falslab);
		return s1;

	case	O_LOR:
		left = ref binary_x(t)->left;
		right = ref binary_x(t)->right;
		s1 = test(left, destination, s);
		s2 = test(right, destination, s);
		s1 post(s2);
		return s1;
		}
	}

testFalse:	dynamic	(t: ref tree_p, destination: ref label_x, 
					s: textRange) ref stmt_x =
	{
	s1:		ref stmt_x;
	s2:		ref stmt_x;
	falslab:	ref label_x;
	left:		ref tree_p;
	right:		ref tree_p;

	switch	(t->operator){
	case	O_EQ:
	case	O_NE:
	case	O_LT:
	case	O_GT:
	case	O_LE:
	case	O_GE:
	case	O_ORD:			// <>=
	case	O_UNORD:		// !<>=
	case	O_NLT:			// !<
	case	O_NLE:			// !<=
	case	O_NGT:			// !>
	case	O_NGE:			// !>=
	case	O_LT_GT:		// <>
	case	O_NLT_GT:		// !<>
		t->operator = negateCondition(t->operator);
		return test(t, destination, s);

	default:
		t = binary(O_EQ, t, icon(0L, INTBITS), s.start);
		return test(t, destination, s);

	case	O_NOT:
		left = ref binary_x(t)->left;
		return test(left, destination, s);

	case	O_LAND:
		left = ref binary_x(t)->left;
		right = ref binary_x(t)->right;
		s1 = testFalse(left, destination, s);
		s2 = testFalse(right, destination, s);
		s1 post(s2);
		return s1;

	case	O_LOR:
		left = ref binary_x(t)->left;
		right = ref binary_x(t)->right;
		falslab = Func label_();
		s1 = test(left, falslab, s);
		s2 = testFalse(right, destination, s);
		s1 post(s2);
		s1 post(falslab);
		return s1;
		}
	}

try_:	dynamic	(x: ref label_x) ref try_x =
	{
	return try_x create(x);
	}

	};

argument_i386:	type	inherit argument_x {

	};

auto_i386:	type	inherit auto_x {
	public:

coerce:	dynamic	(t: ref type_s) ref tree_p =
	{
	return coerceLvalue(self, t);
	}

	};

binary_i386:	type	inherit	binary_x {
	public:

coerce:	dynamic	(t: ref type_s) ref tree_p =
	{
	if	(operator == O_IND)
		return coerceLvalue(self, t);
	else
		return 0;
	}

	};

block_i386:	type	inherit	block_x {

	};

cast_i386:	type	inherit cast_x {

	};

critical_i386:	type	inherit	critical_x {

	};

endCritical_i386:type	inherit	endCritical_x {

	};

expr_i386:	type	inherit	expr_x {

	};

icon_i386:	type	inherit icon_x {

	};

iden_i386:	type	inherit iden_x {
	public:

coerce:	dynamic	(t: ref type_s) ref tree_p =
	{
	return coerceLvalue(self, t);
	}

	};

jump_i386:	type	inherit	jump_x {

	};

label_i386:	type	inherit	label_x {

	};

staticCall_i386:	type	inherit staticCall_x {

	};

test_i386:	type	inherit test_x {

	};
/*
	This coerce code detects a conversion from one integral or pointer
	type to another and does a little-endian truncate as needed.  The
	arguments are:

	x	an lvalue expression
	t	the type to be coerced to

	returns:

	0	means coercion failed
	x	(with type changed) means coercion succeeded
 */
coerceLvalue:	(x: ref tree_p, t: ref type_s) ref tree_p =
	{
	switch	(t->topType){
	case	T_SIGNED:
	case	T_UNSIGNED:
	case	T_REF:
		switch	(x->dtype->topType){
		case	T_SIGNED:
		case	T_UNSIGNED:
		case	T_REF:
			dst:	int;
			src:	int;

			dst = t sizeOf();
			src = x->dtype sizeOf();
			if	(dst <= src){
				x->dtype = t;
				return x;
				}
			}
		}
	return 0;
	}

