/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	file;

include	i386back, cback, backend;
include	symtab;
include	link;

main:	entry	() =
	{
	if	(ArgumentCount == 0){
		printf( "Use is: PC [ options ] project_name\n"
			"Options:\n\n"
			"			Project type\n\n"
			"	-d	Loadable Driver\n"
			"	-l	Library\n"
			"	-r	Run file (default)\n"
			"\n			Support options\n\n"
			"	-ixxx	Include library name\n"
			"	-o-	Don't optimize\n"
			"\n			Output options\n\n"
//			"	-2	Output an ALYS2 run file\n"
			"	-a	Output assembly\n"
			"	-c	Output C source\n"
			"	-f	Full link (disable smart link)\n"
//			"	-h	Output C headers\n"
//			"	-m	Generate makefile\n"
			);
		return;
		}
	cp:		[:] char;
	n:		long;
	om:		outputModes = 0;
	inc:		[:] char;
	pt:		projectTypes = PT_RUN;
	smartLink:	boolean = TRUE;

	n = long(_brklvl);
	inc = "";
	while	(ArgumentCount > 1){
		cp = getNextArgument();
		if	(cp[0] != '-'){
			printf("Invalid argument: %S\n", cp);
			return;
			}
		switch	(cp[1]){
		case	'd':	pt = PT_DRIVER;			break;
		case	'l':	pt = PT_LIBRARY;		break;
		case	'r':	pt = PT_RUN;			break;

		case	'=':	DebugList = TRUE;		break;
		case	'i':	inc = cp[2:];			break;
		case	'o':
			if	(cp[2] == '-')
				Project.optimize = FALSE;
			else if	(cp[2] == 0)
				Project.optimize = TRUE;
			else	{
				printf("Invalid argument: %S\n", cp);
				return;
				}
			break;

		case	'a':	om |= OM_ASM;			break;
//		case	'2':	LinkVersion = ALYS2;		break;
		case	'f':	smartLink = FALSE;		break;
//		case	'h':	om |= OM_H;			break;
		case	'c':	om |= OM_C;			break;
//		case	'm':	om |= OM_MAKE;			break;
			}
		}

	Project = [ getNextArgument(), pt, inc, smartLink ];
	if	(om & OM_C)
		enableCbackend();
	else
		enable386backend();

	x:	exceptionContext;

	try	{
		Project build(om);
		}
	except	(x){
	case	MemTrap:
		cause:	int;
		size:	unsigned;

		x.context nextArg(&cause, sizeof cause);
		x.context nextArg(&size, sizeof size);
		printf("cause = %d size = 0x%x\n", cause, size);
		break;

	case	FuncTrap:
		x.context nextArg(&cause, sizeof cause);
		printf("cause = %d (%s)\n", cause, OperTable[cause]);
		break;

	default:
		continue;
		}
//	Project save();
	printf("Heap size = %ldK Free list = %ldK\n", 
				((long(_brklvl) - n) + 512) / 1024, 
				(Heap freeListSize() + 512) / 1024);
	}
