/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
/*
	This is the code that starts a Parasol program.  It must determine
	the actual size of the static data area, initialize the heap, load 
	the command line description and call the entry functions.
 */
__realStartup:	public	() =
	{
	cp:	* char;
	ip:	* _entryVector;
	i:	int;

	i = _ESI;

	i += 3;
	i &= ~3;
	_brklvl = pointer(i);		// align the actual heap base
	_EBX = int(&catchSignal);
	_emit(0x9a, _null, _GDT_CATCHSIGNAL);

	base.size = 0;
	base.next = &base;
	allocp = &base;

	al:	* argList;

	al = pointer(_heapbase_);
	ArgumentCount = 0;
	CommandPath = al->text[:al->cmdLength];
	_ArgumentVector = (al->text + al->cmdLength)[:al->argsLength];
	for	(i = 0; i < al->argsLength; i++)
		if	(_ArgumentVector[i] == 0)
			ArgumentCount++;

		// If the last argument is not null-terminated count it

	if	(|_ArgumentVector){
		if	(_ArgumentVector[|_ArgumentVector - 1])
			ArgumentCount++;
		else
			--|_ArgumentVector;
		}

	_activeCleanup_ = _cleanup_;
	_Thread declareObject(&defaultObject);
	for	(ip = _entry_; ip < ref _entryVector(_cleanup_); ip++){
		_activeCleanup_ = ip->exit;
		ip->func();
		}
	_activeCleanup_ = _endCleanup_;
	exit(0);
	}

_threadLaunch:	public	(ex: ref external, t: ref threadContext,
				stack: ref byte, 
				func: ref ()) ref far external =
	{
	_EBX = int(ex);
	_EDX = int(t);
	_ECX = int(stack);
	_EAX = int(func);
	_emit(0x9a, _null, _GDT_THREADLAUNCH);
	return ref far external(_EAX);
	}

argList:	type	packed	{
	public:

	cmdLength:	unsigned[32];
	argsLength:	unsigned[32];
	text:		[] char;
	};
/*
------------------------------------------------------------------------------
	Heap support code:
 */
base:		header;
allocp:		* header;

header:	type	{
	public:

	size:	size_t;			/* Size of this free block */
	next:	* header;		/* Pointer to next header */

nextHeader:	() * header =
	{
	return ref header(long(self) + size);
	}

	};

_alloc:	public	(size: size_t) pointer =
	{
	p:	* header;
	q:	* header;
	cp:	* char;

	size = (size + sizeof unsigned + sizeof header - 1) &
				~(sizeof header - 1);
	q = allocp;
	for	(p = q->next; ; q = p, p = p->next){
		if	(p->size >= size){
			if	(p->size <= size + sizeof header)
				q->next = p->next;
			else	{
				p->size -= size;
				p = p nextHeader();
				p->size = size;
				}
			allocp = q;
			return &p->next;
			}
		if	(p == allocp)
			break;
		}
	p = _brklvl;
	cp = ref byte(p) + size;
	if	(!_grow(cp))
		MemTrap raise(H_NOMEMORY, size);
	_brklvl = cp;
	p->size = size;
	return &p->next;
	}

_free:	public	(block: pointer) =
	{
	p:	* header;
	q:	* header;

	p = ref header(long(block) - sizeof size_t);
	for	(q = &base; p >= q->next; q = q->next)
		if	(q >= q->next)
			break;

	if	(p nextHeader() == q->next){
		p->size += q->next->size;
		p->next = q->next->next;
		}
	else
		p->next = q->next;
	if	(q nextHeader() == p){
		q->size += p->size;
		q->next = p->next;
		p = q;
		}
	else
		q->next = p;

		/* If the block just freed is at the top of memory,
			use growDS to free it up.
		 */

	if	(p nextHeader() == _brklvl){

			/* Find the new end of list */

		for	(q = p; q->next != p; q = q->next)
			;
		q->next = p->next;
		_grow(p);
		_brklvl = p;
		}
	allocp = q;
	}

_freeListSize:	public	() size_t =
	{
	j:	int;
	p:	* header;

	j = 0;
	for	(p = base.next; p != &base; p = p->next){
		j += p->size;
		}
	return j;
	}

/*
------------------------------------------------------------------------------
		Critical region stuff
 */
_lock_enter:	public	(latch: ref _latchValues_t) =
	{
	_emit(0x9a, _null, _GDT_KERNELBLOCK);
	if	(*latch){
		*latch = _LATCH_WAITERS;
		_EBX = unsigned(latch);
		_emit(0x9a, _null, _GDT_KERNELDOWN);
		}
	else	{
		*latch = _LATCH_CLOSED;
		_emit(0x9a, _null, _GDT_KERNELUNBLOCK);
		}
	}

_lock_leave:	public	(latch: ref _latchValues_t) =
	{
	_emit(0x9a, _null, _GDT_KERNELBLOCK);
	if	(*latch == _LATCH_WAITERS){
		_EBX = unsigned(latch);
		_emit(0x9a, _null, _GDT_KERNELUP);
		*latch = _EAX;
		}
	else
		*latch = _LATCH_OPEN;
	_emit(0x9a, _null, _GDT_KERNELUNBLOCK);
	}

/*
------------------------------------------------------------------------------
		Kernel message interface

	These functions perform the primitive message calls.  In order to
	have access to the necessary information, this code will have to
	somehow get access to the internal message handling logic.
 */
_receive:	public	(hdr: ref messageHeader) = 
	{
	_EBX = int(hdr);
	_emit(0x9a, _null, _GDT_RECEIVE);
	}

_reject:	public	(seq: _sequence_t, code: int) = 
	{
	_BX = seq;
	_EDX = code;
	_emit(0x9a, _null, _GDT_REJECT);
	}

_readText:	public	(seq: _sequence_t, offs: unsigned, buf: pointer, len: int) int = 
	{
	_BX = seq;
	_ECX = len;
	_EDX = int(buf);
	_EAX = offs;
	_emit(0x9a, _null, _GDT_READTEXT);
	return _EAX;
	}

_reply:		public	(seq: _sequence_t, buf: pointer, len: int) = 
	{
	_BX = seq;
	_ECX = len;
	_EDX = int(buf);
	_emit(0x9a, _null, _GDT_REPLY);
	}

_replyPartial:	public	(seq: _sequence_t, buf: pointer, len: int) = 
	{
	_BX = seq;
	_ECX = len;
	_EDX = int(buf);
	_emit(0x9a, _null, _GDT_REPLYPARTIAL);
	}

_alarm:	public	(i: time_t) =
	{
	_EBX = i;
	_emit(0x9a, _null, _GDT_ALARM);
	}

_discardText:	public	(seq: _sequence_t) =
	{
	_BX = seq;
	_emit(0x9a, _null, _GDT_DISCARDTEXT);
	}

catchSignal:	interrupt	(ifr: interruptFrame_t) =
	{
	obj:	ref external;

	obj = _Thread->myThread;
	if	(obj == 0)
		abort(0);
	obj _signal(ifr.extra);
	}
/*
_setSignalThreshold:	public	(sig: signal_t) signal_t =
	{
	_EBX = sig;
	_emit(0x9a, _null, _GDT_SETSIGNALTHRESHOLD);
	return _EAX;
	}
 */
_grow:	public	(brk: pointer) boolean =
	{
	_EBX = unsigned(brk);
	_emit(0x9a, _null, _GDT_GROW);
	return _AL;
	}

defaultObject:	external;
