/*
	Copyright (c) 1993 by Robert Jervis
	All rights reserved.

	Permission to use, copy, modify and distribute this software is
	subject to the license described in the READ.ME file.
 */
include	string;
include	error;
include	file;
include	filesys;
include	runfile;
include	alys;
include	hardware;

SCtable:	[] * char = [
	"static",
	"type",
	"const",
	"extern",
	"member",
	"intrinsic",
	"register",
	"auto",
	"parm",
	"dynamic",
	"label"
	];

Ttable:		[] * char = [
	"void",
	"bit",
	"unsignedBit",
	"char",
	"unsignedChar",
	"short",
	"unsignedShort",
	"long",
	"unsignedLong",
	"float",
	"double",
	"extended",		/* Long double */
	"*",			/* pointer */
	"array",
	"function",
	"struct",
	"extern"
	];

Ltable:		[] * char = [
	"normal",
	"interrupt",
	];

SRtable:	[] * char = [
	"header",
	"usage",
	"symbol",
	"type",
	"param",
	"member",
	"bit",
	"value",
	"data",
	"fixup",
	"literal",
	"line",
	"tcode",
	"debug"
	];

DumpDetail:	int = 0;
DumpSummary:	int = 0;

main:	entry	() =
        {
	args:		[:] char;

	printf("Dump Version 1.4  (c) Copyright 1993 Robert Jervis\n");
	if	(ArgumentCount == 0){
		printf(	"Syntax is: DUMP [ option(s) ] filename(s)\n"
			"Options may appear before each filename and filenames may have wildcards\n"
			"\tOptions:\n"
			"\t\t-s\tSummary only\n"
			"\t\t-s-\tDump all records (default)\n"
			"\t\t-v\tVerbose dump\n"
			"\t\t-v-\tDo not dump fixups and line #'s (default)\n");
		exit(0);
		}
	while	(ArgumentCount){
		args = getNextArgument();
		if	(args[0] == '-'){
			switch	(args[1]){
			case	'v':
				if	(args[2] == '-')
					DumpDetail = 0;
				else
					DumpDetail = 1;
				break;

			case	's':
				if	(args[2] == '-')
					DumpSummary = 0;
				else
					DumpSummary = 1;
				}
			}
		dumpFiles(args);
		}
	}

dumpFiles:	(filename: [:] char) =
	{
	ff:	finder;
	i:	int;
	dir, pattern:	[:] char;

	dir = getDirectory(filename);
	pattern = stripDirectory(filename);
	if	(i = ff open(dir, pattern, 0)){
		printf("Could not find %s: %s\n", filename, cmdError(i));
		return;
		}
	while	(ff next() == SUCCESS)
		dumpFile(ff.pathname);
	ff close();
	}

dumpFile:	(filename: [:] char) =
	{
	fext:	[:] char;

	fext = getExtension(filename);
	if	(|fext == 0)
		dumpCoreDump(filename);
	else if	(stringCompare(fext, ".run") == 0)
		dumpRunFile(filename);
	else if	(stringCompare(fext, ".lod") == 0)
		dumpLodFile(filename);
	}

rhead:	runHeader;

descKinds:	[] * char = [
	"DATA_SEG",
	"CODE_SEG",
	"SVC_SEL ",
	"GATE_SEL",
	"GRP_BODY"
	];

segClasses:	public	type	char = {
//	DATA_SEG,
	CODE_SEG = 1,
//	SVC_SEL,
//	GATE_SEL,
//	GRP_BODY,
	};

dumpRunFile:	(rf: [:] char) =
	{
	fd:	stream;
	i:	long;
	j:	long;
	fix:	long;
	n:	int;
	dig:	int;
	dc:	int;
	d:	debugUnitHeader;
	xp:	pointer;
	cp:	* char;
	desc:	type	packed	{
		public:

		kind:		segClasses;
		imageOff:	long;
		initLen:	long;
		totalLen:	long;
		};
	dp:	* desc;

	if	(fd open(rf, AR_READ)){
		printf("Couldn't open file %S\n", rf);
		exit(1);
		}
	i = fd seek(0, 2);
	fd seek(0, 0);
	if	(fd read(ref byte(&rhead)[:sizeof rhead]) != sizeof rhead){
		printf("Couldn't read header for %S\n", rf);
		exit(1);
		}
	if	(rhead.magic != RUN_MAGIC){
		printf("Runfile magic number is not correct in %s\n", rf);
		exit(1);
		}
	printf("\nRun file version %d      File %S\n\n", rhead.version, rf);
	printf("cs:ip = %04x:%08x\n", rhead.cs, rhead.ip);
	printf("ss:sp = %04x:%08x\n", rhead.ss, rhead.sp);
	printf("ds =    %04x\n", rhead.ds);
	printf("thread =     %08x\n\n", rhead.threadLoc);
	printf("image =       %08x\n", rhead.image);
	printf("debug info =  %08x\n", rhead.debugInfo);
	printf("file length = %08x (%dK)\n\n", i, (i + 512) / 1024);
	printf("code base   = %08x (%dK)\n", rhead.codeOffset, (rhead.codeOffset + 512) / 1024);
	printf("code length = %08x (%dK)\n", rhead.codeLen, (rhead.codeLen + 512) / 1024);
	printf("data base   = %08x (%dK)\n", rhead.dataOffset, (rhead.dataOffset + 512) / 1024);
	printf("data length = %08x (%dK)\n", rhead.dataInitLen, (rhead.dataInitLen + 512) / 1024);
	printf("DS length =   %08x (%dK)\n\n", rhead.dataTotalLen, (rhead.dataTotalLen + 512) / 1024);
	fd close();
	}

dumpCoreDump:	(rf: [:] char) =
	{
	fd:	stream;
	i:	long;
	j:	long;
	fix:	long;
	n:	int;
	dig:	int;
	dc:	int;
	drec:	coreDumpHeader;
	d:	debugUnitHeader;
	xp:	pointer;
	cp:	* char;
	desc:	type	packed	{
		public:

		kind:		segClasses;
		imageOff:	long;
		initLen:	long;
		totalLen:	long;
		};
	dp:	* desc;

	if	(fd open(rf, AR_READ)){
		printf("Couldn't open file %S\n", rf);
		exit(1);
		}
	i = fd seek(0, 2);
	fd seek(0, 0);
	if	(fd read(ref byte(&drec)[:sizeof drec]) != sizeof drec){
		printf("Couldn't read header for %S\n", rf);
		exit(1);
		}
	if	(drec.magic != COR_MAGIC){
		printf("Core dump magic number is not correct in %s\n", rf);
		exit(1);
		}
	printf("\nCore dump version %d      File %S\n\n", drec.version, rf);

	if	(drec.task.state == TS_TRAP){
		i:	int;

		i = drec.task.errorCode;
		if	(i < int(&external.kill) ||
			 i > int(&external.alarmExpired))
			printf("Unknown trap (%x)", i);
		else
			printf("%s trap", TrapNames[i - int(&external.kill)]);
		}
	else if	(drec.task.state == TS_EXIT)
		printf("exit(%d)", drec.task.errorCode);
	else if	(drec.task.state == TS_ABORT)
		printf("abort(%d)", drec.task.errorCode);
	else
		printf("%s", TaskStateMessages[drec.task.state]);
	printf(" at %04x:%08x\n", drec.task.cs & 0xffff, drec.task.eip);

	printf("  eax %08x ebx %08x ecx %08x edx %08x\n", drec.task.eax,
			drec.task.ebx,
			drec.task.ecx,
			drec.task.edx);
	printf("  esp %08x ebp %08x esi %08x edi %08x\n", 
			drec.task.esp,
			drec.task.ebp,
			drec.task.esi,
			drec.task.edi);
	printf("   ds     %04x  es     %04x  fs     %04x  gs     %04x\n",
			drec.task.ds & 0xFFFF,
			drec.task.es & 0xFFFF,
			drec.task.fs & 0xFFFF,
			drec.task.gs & 0xFFFF);
	printf("               ");
	if	(drec.task.eflags & 1)
		printf("CY ");
	else
		printf("NC ");
	if	(drec.task.eflags & 4)
		printf("PA ");
	else
		printf("NP ");
	if	(drec.task.eflags & 0x10)
		printf("AC ");
	else
		printf("NA ");
	if	(drec.task.eflags & 0x40)
		printf("ZF ");
	else
		printf("NZ ");
	if	(drec.task.eflags & 0x80)
		printf("SG ");
	else
		printf("NS ");
	if	(drec.task.eflags & 0x100)
		printf("TF ");
	else
		printf("NT ");
	if	(drec.task.eflags & 0x200)
		printf("IE ");
	else
		printf("NI ");
	if	(drec.task.eflags & 0x400)
		printf("DN ");
	else
		printf("UP ");
	if	(drec.task.eflags & 0x800)
		printf("OV ");
	else
		printf("NO ");
	if	(drec.task.eflags & 0x4000)
		printf("NT ");
	if	(drec.task.eflags & 0x10000)
		printf("RF ");
	if	(drec.task.eflags & 0x20000)
		printf("VM ");
	printf("iopl = %x\n\n", drec.task.eflags >> 12 & 3);
	printf("file length = %08x (%dK)\n", i, (i + 512) / 1024);
	i -= sizeof drec;
	printf("data length = %08x (%dK)\n", i, (i + 512) / 1024);
	fd close();
	}

TaskStateMessages:	[] * char = [
	"Error",
	"Running",				// TS_RUN
	"Trapped",				// TS_TRAP
	"Rejected",				// TS_REJECT
	"Interrupted",				// TS_INTERRUPT
	"Aborted",				// TS_ABORT
	"Uncaught exception",			// TS_EXCEPTION
	"Exit called",				// TS_EXIT
	"Breakpoint",				// TS_BREAK
	"Single-step",				// TS_STEP
	];

StateMessages:	[] * char = [
	"",					// DEB_STEP
	"New",					// DEB_NEW
	"Program finished",			// DEB_DEAD
	"",					// DEB_BKPT
	"Signal raised",			// DEB_SIG
	"Trapped",				// DEB_TRAP
	];

TrapNames:	[] * char = [
	"Kill",
	"Illegal instruction",
	"Memory error",
	"Page fault",
	"Array bounds",
	"System call",
	"Math",
	"Integer overflow",
	"Reject",
	"Interrupt",
	"Power failure",
	"Hangup",
	"Attention",
	"Quit",
	"Broken send",
	"Alarm expired",
	];

dumpLodFile:	(rf: [:] char) =
	{
	fd:	stream;
	i:	long;
	j:	long;
	fix:	long;
	n:	int;
	dig:	int;
	dc:	int;
	d:	debugUnitHeader;
	xp:	pointer;
	cp:	* char;
	desc:	type	packed	{
		public:

		kind:		segClasses;
		imageOff:	long;
		initLen:	long;
		totalLen:	long;
		};
	dp:	* desc;

	if	(fd open(rf, AR_READ)){
		printf("Couldn't open file %S\n", rf);
		exit(1);
		}
	i = fd seek(0, 2);
	fd seek(0, 0);
	if	(fd read(ref byte(&rhead)[:sizeof rhead]) != sizeof rhead){
		printf("Couldn't read header for %S\n", rf);
		exit(1);
		}
	if	(rhead.magic != LOD_MAGIC){
		printf("Runfile magic number is not correct in %s\n", rf);
		exit(1);
		}
	printf("\nLoad file version %d      File %s\n\n", rhead.version, rf);
	printf("init code = %08x\n",   rhead.ip);
	printf("sp        = %08x\n\n", rhead.sp);
	printf("image =       %08x\n", rhead.image);
	printf("fixups =      %08x\n", rhead.fixups);
	printf("file length = %08x (%dK)\n\n", i, (i + 512) / 1024);
	printf("code length = %08x (%dK)\n", rhead.codeLen, (rhead.codeLen + 512) / 1024);
	printf("data length = %08x (%dK)\n", rhead.dataInitLen, (rhead.dataInitLen + 512) / 1024);
	printf("DS length =   %08x (%dK)\n\n", rhead.dataTotalLen, (rhead.dataTotalLen + 512) / 1024);
	fd seek(rhead.descriptors, 0);
	n = rhead.image - rhead.descriptors;
	xp = cp = alloc(n);
	if	(cp == 0){
		printf("Couldn't allocate space for descriptors\n");
		exit(1);
		}
	if	(fd read(cp[:n]) != n){
		printf("Couldn't read descriptors\n");
		exit(1);
		}
	dig = 7;
	free(xp);
	fd seek(rhead.fixups, 0);
	j = rhead.fixups;
	printf("\nFixups (%d entries)\n\n", (i - j) / 4);
	n = 0;
	while	(j < i){
		fd read(ref byte(&fix)[:sizeof fix]);
		j += sizeof fix;
		if	(fix & 0x40000000)
			printf("  D");
		else
			printf("  C");
		printf("->");
		if	(fix & 0x80000000)
			printf("D");
		else
			printf("C");
		printf(" %08x", fix & 0x3fffffff);
		n++;
		if	(n == 5){
			n = 0;
			printf("\n");
			}
		}
	if	(n)
		printf("\n");
	fd close();
	}

hexout:	(value: int) =
	{
	dc:	int;
	dig:	int;

	for	(dc = 0; dc < 4; dc++){
		dig = value >> 12 & 0xf;
		printf("%x", dig);
		value <<= 4;
		}
	}

