/*------------------------------ file information -----------------------------*/
																											
/* 		
	custom controls demo.c	

 		c source code file for a minimal Mac program that demonstrates 
 			controls drawn with a custom CDEF resource

 		the custom CDEF resource that's demonstrated provides 16 button variations
 		the buttons 
 				  live in a rectangular space
 				  can be outlined, shadowed, or bare
 				  can contain text in any font-style-size, an icon, or a picture
 				  can indicate highlighting via inversion or a change of content
 	
	edited and compiled with Lightspeed C 2.13
	
	written and 1987 by Stan Krute. all rights reserved. no part of this file, 
	or the object code it leads to, may be reproduced, in any form or by any means, 
	without	the express written permission of the author and copyright holder. 
	
	timestamp:		3:49 pm PST     			November 16, 1987 
	spacestamp:		18617 Camp Creek Road	Hornbrook, California   96044
	
 	this file looks good in 9 point Courier, LSC tabs set to 3
*/


/*--------------------------------- include files -----------------------------*/

/* definitions for Mac OS managers used herein */
#include	"ControlMgr.h"
#include	"DialogMgr.h"		
#include	"EventMgr.h"	
#include	"FontMgr.h"	
#include	"MenuMgr.h"	
#include	"Quickdraw.h"					
#include	"StdFilePkg.h"

/* our stuff */
#include	"custom controls demo.h"		/*   private definitions for this file  */ 


/*----------------------------- main program block ----------------------------*/

void	main()

		{
		/* local variable */
		int		theItem ;
		
		/* initialize Mac OS managers  */
		initializeManagers() ; 			
		
		/* see what the world is like */
		studyAndSetEnvironment () ;
		
		/* set up and draw a (dummy) title menu */
		InsertMenu( GetMenu(titleMenuID), append ) ;
		DrawMenuBar() ;

		/* set up and draw a modal dialog window */
		getThatDialogCookin () ;
		
		/* initalize our doneness indicator */
		finished = false ;
		
		/*  run the main event loop   */
		do													
			{
			ModalDialog (noFilterProcedure, &theItem) ;
			dealWithDialogItem (theItem) ;
			}
		while											
			( ! finished ) ;

		/*  leave neatly when done */
		DisposDialog (ourDialog) ;			/* bye bye to dialog */
		ExitToShell() ;						/* bye bye to program */
		}


/*---------------------------- initializeManagers -----------------------------*/

/*   initialize the heap, cursor, and Mac Operating System managers    */

void	initializeManagers()
		
		{
		/* local variable */
		Handle		someDay ;
		
		/* get some space */
		MoreMasters() ;									/* get some master pointers */
		if (someDay = NewHandle(humungousBlock))	/* grow a maximal heap by */ 
			DisposHandle (someDay) ; 					/* asking for the future */ 
			  
		/* get those managers going */
		InitGraf(&thePort) ;						/* set up Quickdraw */
		InitFonts();								/* set up the Font Manager */
		InitWindows();								/* set up the Window Manager */
		InitMenus();								/* set up the Menu Manager */
		TEInit();									/* set up Text Edit */
		InitDialogs (noResumeProcedure) ;	/* set up the Dialog Manager */

		/* final adjustments */
		FlushEvents (everyEvent, dontStop ) ;	/* clear the event queue */
		InitCursor();									/* turn the cursor on */
		}


/*---------------------------- studyAndSetEnvironment -------------------------*/

/*   check out screens, machines, ROMs, et al */

void	studyAndSetEnvironment () 
		
		{
		/* check out the screen */
		screenRect = screenBits.bounds ;
		screenHeight = screenRect.bottom - screenRect.top ;
		screenWidth = screenRect.right - screenRect.left ; 
		
		/* determine height of the menu bar */
		if 	( ROM85 & 0x8000 )
			menuBarHeight = stdMBarHeight ;  	/* for 64K ROMs	*/
		else
			menuBarHeight = MBarHeight ;			/* for newer ROMs	*/
		}


/*------------------------------- getThatDialogCookin -------------------------*/

/* set up and draw our main modal dialog window */

void	getThatDialogCookin ()

		{
		/* local variables */
		Point				tempPoint ;
		Rect				scratch ;
		ControlHandle	theButton ;
		
		/* get the dialog window */
		ourDialog = GetNewDialog (ourDialogID, storeInHeap, inFront) ;
		
		/* adjust its position  */
		MoveWindow ( ourDialog, 
					   (tempPoint = figureCenteredRectTLC (&(*ourDialog).portRect)).h,
				 	       tempPoint.v, inFront ) ;
		
		/* make dialog window the current grafPort so we can change its font */
		SetPort (ourDialog) ;
		
		/* change its font to Geneva 12 */
		TextFont (geneva) ;
		TextSize (12) ;
		
		/* show the dialog */
		ShowWindow (ourDialog ) ;
		}


/*-------------------------------- dealWithDialogItem -------------------------*/

 /* deal with the hit item */  
 
void	dealWithDialogItem (theItem) 
		int		theItem ;
		
		{
		/* local constants */
		#define		oolSize		6
		
		/* local variables */
		static	short	onOffList[oolSize] = { 	orwellItem, hupCoupleItem, 
															ronItem, saveAsItem, 
															pinheadItem, duplicateItem} ; 
		/* case out on the item */
		switch (theItem)
			{
			case quitItem:
				finished = true ;
				break ;
			case orwellItem:
				doOrwellItem () ;
				break ;
			case snapshotItem:
				doSnapshotItem () ;
				break ;
			case mushroomItem:
				doMushroomItem () ;
				break ;
			case openItem:
				doOpenItem () ;
	 			break ;
			case saveAsItem:
				doSaveAsItem () ;
				break ;
			case flipItem:
				doFlipItem () ;
				break ;
			case someOffItem:
				doSomeOffItem (onOffList, oolSize) ;
				break ;
			case someOnItem:
				doSomeOnItem (onOffList, oolSize) ;
				break ;
			case copyrightItem:
				doCopyrightItem () ;
				break ;
			default:
				break ;
			}
		
		/* remove local constants */
		#undef		oolSize
		}


/*--------------------------------- doOrwellItem ------------------------------*/

/* deal with a click of the orwellItem  button */

void	doOrwellItem () 
		
		{
		/* local constants */
		#define			cyclesDesired		4
		#define			delayTicksOne		20
		#define			delayTicksTwo		10
		
		/* local variables */
		Rect				scratch ;
		ControlHandle	theItemHandle ;
		short				cycleCounter ;
		ControlHandle	ronItemHandle ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, orwellItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
		
		/* get a handle to the ronItem button */
		GetDItem ( ourDialog, ronItem, &scratch, &ronItemHandle, &scratch) ;

		/* run several fade cycles on the ronItem button  */
		for ( cycleCounter = 0; cycleCounter < cyclesDesired; cycleCounter++)
			{
			/* fade out */
			HiliteControl (ronItemHandle, inactiveHS ) ;

			/* wait a while */
			Delay (delayTicksOne, &scratch) ;
			
			/* back into view */
			HiliteControl (ronItemHandle, activeHS ) ;

			/* wait a while */
			Delay (delayTicksTwo, &scratch) ;
			}

		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;

		/* remove local constants */
		#undef		cyclesDesired
		#undef		delayTicksOne
		#undef		delayTicksTwo	
		}

		
/*--------------------------------- doSnapshotItem ----------------------------*/

/* deal with a click of the snapshotItem button */

void	doSnapshotItem () 
		
		{
		/* local variables */
		ControlHandle	theItemHandle ;
		Rect				scratch ;
		GrafPtr			entryGrafPort ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, snapshotItem, &scratch, &theItemHandle, &scratch) ;
		
		/* hilite the button */
		HiliteControl (theItemHandle, hilitedHS ) ;
	
		/* save a pointer to the grafPort */
		GetPort(&entryGrafPort) ;			

		/* this lets me take some snapshots */
		/* has no effect unless you have a desk accessory named Camera */
		OpenDeskAcc ("\007\000Camera") ;
		
		/* restore the grafPort */
		SetPort(entryGrafPort) ;
		
		/* unhilite the button */
		HiliteControl (theItemHandle, activeHS ) ;
		}
		
		
/*--------------------------------- doMushroomItem ----------------------------*/

/* deal with a click of the mushroomItem  button */

void	doMushroomItem () 
		
		{
		/* local constants */
		#define			cyclesDesired		4
		#define			delayTicks			30
		
		/* local variables */
		Rect				scratch ;
		short				cycleCounter ;
		ControlHandle	itemHandleOne ;
		ControlHandle	itemHandleTwo ;
		
		/* get a handle to the button */
		GetDItem ( ourDialog, mushroomItem, &scratch, &itemHandleOne, &scratch) ;
		
		/* hilite the button */
		HiliteControl (itemHandleOne, hilitedHS ) ;
		
		/* get a handle to the bumperStickersItem button */
		GetDItem ( ourDialog, bumperStickersItem, &scratch, 
						&itemHandleTwo, &scratch) ;

		-* ruHτ 	ψ	O5':421: "\2!P Z\0 $dT2VFW"a T6TL 1#+K+!0  L''' ''$  ''!8   H 8 8 8  8D$''$   8 ''!$8   D@H<$'''''$  ''!8   H 8 8 d H|߱UI5'@gq[1	#w![T#&Kh}'gq5gpQe\ЕVF0^
_5Xv_4W=u!,_4eW\(JB`u`.X_F3YzeP#>Cabb9fT;Td#yFy$n3TQq4	0k"?UKCU:#3:hk10(7xxlakds LS2/ 6#X'H]:6d3@I3ci_SUTHJQe;
EWp]%M a_}gFݦi$Z1HpgILԱ|I( 2s+
}#Vb'B5`_LfyT DIF&|	oKPmMZ6w		>	Лy,\ٕl[%0_`%.E.b/.&$_@%(	X%/ ץ%y^pEb5.
JZ$vg%`@bApzQIS1=ictQ%9؀aMM6PAS7Ws19s[FKɣ"
d#V>P` SP="HE`QPl3Qғmdu*q7cRm$S bLtyK$C(wt~XtYLx2ǉG!6ynx)b{
{d2>1SԦtLPC`L:t$)Zֈ$beepoH+E hR|HV~h+1Qv˪YbDcQ+*-cj$ϊֲYi:cʟ&bE- VZRgʢ؇$:&Lu<*.:{)a	Id%9d
pd RSCHEDULE.ASM Z  ڪp    
Hj`cN(@H%	&ALR*P\D<sib7cִhL3iƄr̜%$hGzH*GSD;4e϶	4nTq
9yڈy(:ba捜 BL1uΜ{E@!* dcG" v*0씱iAHmsNn)#'4CSYH'3q楘-섑5pFΞ?ޅS:p,CY)S*1
(eLB*4`t|R(PAr iIEq$D EJ	t@t=\v!!Bz=w@XcuHYfcXDH0ōd ^YhWJ+Lk FTBM:e=T  p Xce Q]Y9F=w$/ShVVmrHVcjg 8VdleL|DQw]h(£1ajGm}wGM](Ԇ/e@,ƎieFXӺaZv
9a-A9I

*;Qn ܑƫ^ӫ1*kheAl씵9.ZjFFqY4d9]ʱS5twQ`@OR[/gۥY+7iSQ=DӢZߤ)ٰrSG=5(OWg@@ה-2Yq3$Shs'8 >hC.Y[\Nb⩇ TTiJ-׺[)A/o@ug v?}a碱:D0㺆eU$ ^uNi*yXqBR&ݷ<Y/7 /
N@&0Q:,ŪE9Ӽsdn۴AM{\"w&5}N/<HD9HY~65lu> "m)kY^3mR '`"Wܐ4l՚+lX/JcelKШ"rf@"`
BЄ"8 B
	(TALH@p!<*'$BHC"R $ !R!TȘ@HGB
Oh,IMr%$F/ SH*[ O:a
 -H %3N>T$Lh"Da0U`&6wM_S&Hπ XsBI8`$ 	KY@1Hka
&)!J S;MR( I	jP)JE"a
)YP H! I!uS}!m#CTdJSB/)
<@jQMP&HC`HQX@2@(I:.oַA]i *h}e1E5ɷ5	nc 3e3L+)IAQ 40$h uBxQ/w$חTPRb0-(.!*h%ZEzhzc$Ű4AyrX	oP	Ȓ\/Kͦ=.|Z
Q^g]΢@k'8T2SA[!F(uieb^r.䵖-DmDR$L"@F232|aH5I*_ A 0'
U@ 5e Q
< (@L"f+  	FL"PHP*0hJi5d`$8H&Lza&dL{I5&r*@ڶncXє¢R		*լO>9KyCD僔ih8P\0Ѫpf{NIE00X@y2-iaAk|J}'w[B:hGG+/Zu
mJ۞\#)`qD'Pt
CSC,<y?ey[	y8.M  '@& 4NN8)lN;8ʔN89TSs@˚+멬Fɪ$4֍3jvZj릯^Z뤯7 f E,ȡ		hF%2JHZji6 m7 ^={o.ề'.i6R? }g|8	 xB <s	 P 5J  L@/b#5``BA@HH0 .2Tc=N #(<&£<zc<#? M 8.Pp+FePP

P s+:x@$
q@  !zb)di)l  i&;T:N0C*>BAjA
@*9TM9zfCd Pi6 eD{KDKIoD;FOD;D.D{A2Y.4	kfFVĮk(  0T\C̏ p <L<l8</2"JɃ,GcD/Bw ʃs ΁0>t <=ӣ<Ma<}(<m"{M|K p@HL(8ے}@` ?LLhz#` .{~JHAyzK(nc7?vc7>vc7=vc7<v"`Юh*Ўc7M4/K4֎4Go4FEI4D34 4wx@ @;?p;ZMo[;ώ?$cΎʵn ;jfGQF`&!F̓v]6hgv(@@HQ_ HL/E QHl' 	HeD Hl Ac38c8[#tv8mGȷc!4F]fH," ]'EI]dEEtnpkF .B\
+ry\> Q.҇a
`1E`@2)\d\5m`ئ ]
8` v%<`\di|!(Ӡ`BcP.
`MG.
mG5xUGPL=S8}.b\	>@	\$FEP̂T	\D; 0ppU E V0*>pU E!WHEWy `0z	
.
*:XpxPV ,)i Tpgi/")8  lӡZk
lSV m~{*r@\@K^Q+bW njpW CE^EqD#~_MWu~?!_[(t@K^`K"F xah؅=R,$8,. !R"1O.1 ^8OvIN8l#>8l#.8
l#8l#K8l#e>.{ ;?7?[33,R" &PhD
UX;pM!V"' H
	4AACAu .x 0&H[#@޸#
GGa{d9Xqv@	ж.$aWkB+qbZ7Mۋ0rm>a " #vT "EӆEaib @:N   1nb|A0t| 3W"`E\A @H+c	:rp|&Pax( tP&z(:ߢz Aiō.R>oCG\.t@-'` :y zD7 Ώc>;q l# g]|Xl7">M}/WGf# isdw| w~ͷo8~|nv ;rkj;bo`k@ m%F6
 &<V uF
x}7P' -hm`ɳn6+(' 	jR)J'MG7uuN؄KΆ K(O fJh	qk
j8x `yVyk "~	4 + 7KGP]3 KDh& j(x	 Og{  3&0`9Pnw6 tLt 
u	Z (RXh H f
s	p0Ƨkl(SV  ňf0xPwޘGt kHgH"6޸F P 	'wNgo@Ʒwh yLtpttmm#6F h19rĠ /gr G7@ Ӏ;`p`@PtYKٔO-xȘ{GhiqkU  i/( `5FVxpF &pF0ךpP 0kJi2EY(j	I9@PvvИv&x!Vpٙ@ , Й0  UWX
i)?"&~Sdd	D"TPÈ.4D\\pyP١R
`Pp
 Ҏ$ @%K;4@pQ.˪,b MteB MM
$DVuhu2UR-$+ MM%R9(7!&5IPl(*#@d޺+ d`BLCGg}<)@:# B^Hn:ڷs;o
? 3C@P (A3=1!Vc{HGɯFՔJb^tI`>te@ni^tuU^{	RBieR)ŔOEU,bE
%	`G@GG1x 딃we`sVZMAV\[Ux[tIZ	ȘȎ`$*S  Hq +_.f(yf[!`>&ssgG(z2h^੧ PERH(TzKXEVHXb?w8V	=`c=&s: W 4@C&c<hz'NdO.
H`WN4JJ\u=WaQG%.:A% Vbr 0.>Op *Q?"l;,ĚHWOv`16poE2*i+/ܲ6,*APs/3OW)M?}:7Ph&.s?-^0Hö6lö9es[aίXN c0t"zL~x+H,=ēZ4D3?ԁ L0ͫȭÈ0prO<41,.";S.8V:;!<0
NxV%LCHnXitA'- Pi%mrH;(.6 2q|%]xdOGH@%: BB#HPƚg7AZF%
X@ 
		{
		 /* local variable */
		Point	theResult ;
		 
		 /* figure the vertical position */
		 theResult.v = menuBarHeight + ((screenHeight - menuBarHeight) - 
		 								(theRect->bottom - theRect->top) )  /  2 ;
		 	
		 /* figure the horizontal position */
		 theResult.h = ( screenWidth - (theRect->right - theRect->left) )   /   2 ;
		 
		 /* done, so return the point */
		 return (theResult) ;
		}
