/*------------------------------ file information -----------------------------*/

/*
	custom controls demo.h

 	private definitions for custom controls demo.c

	edited and compiled with Lightspeed C 2.13

	1987 by Stan Krute   --   all rights reserved
		
	timestamp:		5:56 pm PST     			November 16, 1987 
	spacestamp:		18617 Camp Creek Road	Hornbrook, California   96044

	this file looks good in 9 point Courier, LSC tabs set to 3
*/


/*-------------------------------- constants ----------------------------------*/

/* booleans */
#define		true			1
#define		false			0

/* parameters */
#define		humungousBlock			0x8FFFFFFF
#define		noResumeProcedure		0
#define		dontStop					0
#define		nil						0
#define		allTypes					-1

/* control stuff */
#define		activeHS			0		/* three hilite states */
#define		inactiveHS		255
#define		hilitedHS		10

/* menu stuff */
#define		stdMBarHeight	20
#define		titleMenuID		1
#define		append			0

/* dialog stuff */
#define 	storeInHeap					0
#define		inFront					-1
#define		ourDialogID				1
#define		copyrightDlogID		210
#define		noFilterProcedure		0

#define		quitItem					1
#define		orwellItem				2
#define		snapshotItem			3
#define		bumperStickersItem	4
#define		mushroomItem			5
			
#define		hupCoupleItem		6
#define		openItem				7
#define		ronItem				8
#define		saveAsItem			9
#define		duplicateItem		10

#define		woozyItem			11
#define		trashItem			12
#define		flipItem				13
#define		mouthOpensItem		14
#define		copyItem				15

#define		melancholyItem		16
#define		pinheadItem			17
#define		someOffItem			18
#define		someOnItem			19
#define		eeekShrinkItem		20

#define		copyrightItem		21


/*-------------------------------- type definitions ---------------------------*/

typedef		short	boolean;	


/*---------------------------- function prototypes ----------------------------*/

void	main (void) ;
void	initializeManagers (void) ;
void	studyAndSetEnvironment (void) ; 
void	getThatDialogCookin (void) ;
void	dealWithDialogItem (int   theItem) ;
void	doSnapshotItem (void) ;
void	doOrwellItem (void) ;
void	doMushroomItem (void) ;
void	doOpenItem (void) ; 
void	doSaveAsItem (void) ; 
void	doFlipItem (void) ; 
void	doSomeOffItem (short  theOffList[], short   listSize); 
void	doSomeOnItem (short  theOnList[], short   listSize); 
void	doCopyrightItem (void) ;
Point	figureCenteredRectTLC (Rect   *theRect) ;


/*------------------------------ global variables -----------------------------*/

boolean			finished ;			/* indicates when the program should end */
DialogPtr		ourDialog ;			/* points to our main dialog */

int				menuBarHeight ;	/* know your environment */	
int				screenHeight ;	
int				screenWidth ;
Rect				screenRect ;
