// ---------- search.c

#include <string.h>
#include "textsrch.h"

extern HFILE fp;
static unsigned docct;
static unsigned wordno;
static int wildcard;
static char word[100];

static char *GetWordValue(void)
{
	static char wordv[100];
	char *wd = wordv;
	long adr = wordno * sizeof(long);
	_llseek(fp, adr, SEEK_SET);
	_lread(fp, &adr, sizeof(long));
	_llseek(fp, adr+IDXOFFSET, SEEK_SET);
	do
		_lread(fp, wd, 1);
	while (*wd++);
	return wordv;
}

#ifdef SHAREWARE
#define MAXWDS 5887
#else
#define MAXWDS 12509
#endif

static int wstrcmp(char *w)
{
	if (wildcard)
		*(w + wildcard) = '\0';
	return strcmp(word, w);
}

/* ------------------ Search for word ------------ */
static BOOL WordScan(void)
{
	long rt = 1;
	int wdct = MAXWDS;

	if (wordno == 0)	{
		while (wdct > 0 && wdct > 8)	{
			wdct /= 2;
			if (rt < 0)
				wordno -= wdct;
			else 
				wordno += wdct;
			rt = wstrcmp(GetWordValue());
			if (rt == 0)
				return TRUE;
		}
	}
	if (rt > 0)	{
		while (rt > 0)	{
			wordno++;
			if (wordno == MAXWDS)
				break;
			rt = wstrcmp(GetWordValue());
			if (rt == 0)
				return TRUE;
		}
	}
	else {
		while (rt < 0)	{
			if (wordno == 0)
				return FALSE;
			--wordno;
			rt = wstrcmp(GetWordValue());
			if (rt == 0)
				return TRUE;
		}
		wordno++;
	}
	return FALSE;
}

static void GetDocCt(void)
{
	long offset;
	_lread(fp, &offset, sizeof(long));
	_llseek(fp, offset+DLSOFFSET, SEEK_SET);
	// ----- read in the document count
	_lread(fp, &docct, sizeof(unsigned));
}

static long nextdocoffset;

unsigned FindWord(char *wd)
{
	unsigned docno = 0;
	char *cp;

	strcpy(word, wd);
	cp = strchr(word, '*');
	wildcard = 0;
	if (cp != NULL)
		*cp = '\0';
	wordno = 0;
	if (WordScan())	{
		// --- load the document count, this word
		GetDocCt();
		// ---- return the first document number
		nextdocoffset = _llseek(fp, 0L, SEEK_CUR);
		docno = NextDocNo();
	}
	if (cp != NULL)
		wildcard = cp - word;
	if (wildcard && docno == 0)	{
		--wordno;
		if (WordScan())	{
			// --- load the document count, this word
			GetDocCt();
			// ---- return the first document number
			nextdocoffset = _llseek(fp, 0L, SEEK_CUR);
			docno = NextDocNo();
		}
	}
	return docno;
}

unsigned NextDocNo(void)
{
	unsigned docno = 0;
	if (docct)	{
		--docct;
		_llseek(fp, nextdocoffset, SEEK_SET);
		_lread(fp, &docno, sizeof(unsigned));
		nextdocoffset = _llseek(fp, 0L, SEEK_CUR);
	}
	else if (wildcard)	{
		if (WordScan())	{
			GetDocCt();
			--docct;
			_lread(fp, &docno, sizeof(unsigned));
			nextdocoffset = _llseek(fp, 0L, SEEK_CUR);
		}
	}
	return docno ? docno + (FIRSTDOCNO - 1) : 0;
}


