;
;  CALLASM.ASM:  This program calls the C printf() function 
;                and prints a string on the terminal.
;
                NAME    CALLASM
                EXTRN   _printf:BYTE               ; Prototype for printf()
                EXTRN   __acrtused:BYTE            ; Used to initialize C
                                                   ;  startup code
DGROUP          GROUP   _DATA,CONST,_BSS           ; Establish the DGROUP
_TEXT           SEGMENT WORD PUBLIC 'CODE'         ; Name the code
                                                   ;  segment _TEXT
                ASSUME  CS:_TEXT,DS:DGROUP,SS:DGROUP
                PUBLIC  _main                      ; Our function is main()
_main:          mov     word ptr nCount,0000H      ; Initialize nCount to zero
                mov     ax,offset DGROUP:szBuffer  ; Get address of szBuffer[]
                push    ax                         ; Push on stack as the last
                                                   ;  parameter to printf()
                mov     ax,offset DGROUP:L1        ; Get format string address
                push    ax                         ; Push on stack as the next
                                                   ;  parameter to printf()
                call    near ptr _printf           ; Now call printf()
                add     sp,0004H                   ; Discard printf()'s
                                                   ;  parameters
                mov     word ptr nCount,ax         ; Save printf()'s return
                                                   ;  value
                ret                                ; Done, return to caller
_TEXT           ENDS

_DATA           SEGMENT WORD PUBLIC 'DATA'         ; Set up the data segment
                                                   ; PUBLIC is the same as C's
                                                   ; extern variables
                PUBLIC  szBuffer                   ; szBuffer is a public name
                PUBLIC  nCount                     ; nCount is a public name
szBuffer        LABEL   BYTE
                DB      "This is an assembly program."
                DB      0aH,00H                    ; append the \n for newline
nCount          LABEL   BYTE
                DB      00H,00H                    ; nCount, init to zero
_DATA           ENDS

CONST           SEGMENT WORD PUBLIC 'CONST'
L1              LABEL   BYTE
                DB      "%s",00H                   ; Our format string, a
                                                   ; constant, in the CONST
                                                   ; segment
CONST           ENDS

_BSS            SEGMENT WORD PUBLIC 'BSS'          ; The BSS segment is used
                                                   ; by C to find the stack and
                                                   ; has other uses, including 
                                                   ; storage for global variables 
                                                   ; not initialized explicitly
_BSS            ENDS                               ; by the program

                END                                ; End of our program
