;/* CALLNOTC program, written 1992 by Peter D. Hipson */
;
;/* This is an assembly program that calls FORTRAN or assembly */
;
;#include <stdio.h>
;#include <stddef.h>
;#include <stdlib.h>
;#include <string.h>
;#include <time.h>
;
;int  cdecl   maximum(int nVar1, int nVar2);
;

; Enable 386 instruction set

.386

                NAME    callnotc

; maximum(), sscanf(), gets(), and printf() are called

                EXTRN   _maximum:BYTE
                EXTRN   _sscanf:BYTE
                EXTRN   _gets:BYTE
                EXTRN   _printf:BYTE

; _acrtused is used to initialize C at runtime

                EXTRN   __acrtused:BYTE

;  The datagroup is _DATA (misc data), CONST (constants),
;  and _BSS (uninitialized data)

DGROUP          GROUP   _DATA,CONST,_BSS

_TEXT           SEGMENT WORD PUBLIC USE16 'CODE'
                ASSUME  CS:_TEXT,DS:DGROUP,SS:DGROUP

;  The program's main function, called by C's startup code.
;  Microsoft C naming conventions require the underscore 
;  prefix. Other compilers may use an underscore
;  following the name.

                PUBLIC  _main

_main:          push    bp         ; Start up, save registers,
                mov     bp,sp      ; and get ready to run
                sub     sp,0000H
                push    si
                push    di

; Initialize nVar1 and nVar2 so that they are not the same!

                mov     word ptr -104H[bp],0000H
                mov     word ptr -106H[bp],0001H

; Call to printf(szMsg1);

                mov     ax,offset DGROUP:szMsg1
                push    ax
                call    near ptr _printf
                add     sp,0002H

                jmp     near ptr Loop1

; Loop back to Loop1

Loop1:           mov     ax,offset DGROUP:szMsg2
                push    ax
                call    near ptr _printf
                add     sp,0002H

                lea     ax,-102H[bp]
                push    ax
                call    near ptr _gets
                add     sp,0002H

                lea     ax,-106H[bp] ; nVar2's address
                push    ax
                lea     ax,-104H[bp] ; nVar1's address
                push    ax
                mov     ax,offset DGROUP:szScanFormat
                push    ax
                lea     ax,-102H[bp]    ; szBuffer (auto var on stack)
                push    ax
                call    near ptr _sscanf
                add     sp,0008H

                push    word ptr -106H[bp]  ; nVar2
                push    word ptr -104H[bp]  ; nVar1
                call    near ptr _maximum
                add     sp,0004H

                push    ax
                push    word ptr -106H[bp]  ; nVar2
                push    word ptr -104H[bp]  ; nVar1
                mov     ax,offset DGROUP:szPrintFormat
                push    ax
                call    near ptr _printf
                add     sp,0008H

                mov     ax,word ptr -106H[bp]
                cmp     word ptr -104H[bp],ax
                je      short AllDone         ; We are finished
                jmp     near ptr Loop1        ; Go around another time
AllDone:        mov     ax,0000H              ; A zero return code
                jmp     near ptr Dummy
Dummy:          pop     di                    ; Clean up and go home
                pop     si
                mov     sp,bp
                pop     bp
                ret
_TEXT           ENDS


_DATA           SEGMENT WORD PUBLIC USE16 'DATA'

szMsg1          LABEL   BYTE
                DB      "Enter the same number twice to end", 0AH, 00H
szMsg2          LABEL   BYTE
                DB      "Enter two integers, separated with blanks", 00H
szScanFormat    LABEL   BYTE
                DB      "%d %d", 00H
szPrintFormat   LABEL   BYTE
                DB      "The values entered are %d and %d, "
                DB      "the larger is %d",0AH, 00H
_DATA           ENDS

CONST           SEGMENT WORD PUBLIC USE16 'CONST'
CONST           ENDS

_BSS            SEGMENT WORD PUBLIC USE16 'BSS'
_BSS            ENDS

                END
