// Program EXAMP7.CPP, written 27 July 1992 by Peter D. Hipson
// Shows C++ classes, initialization, and so on.

#include <string.h>    // Used for strcpy(), str...(), etc.
#include <iostream.h>  // C++'s stream I/O header.

// Define your class structure, similar to those
// created in earlier chapters showing database techniques.

#define CUSTOMER_RECORD 1
#define SUPPLIER_RECORD 2

/* Define your structure for the customer database. */

class  Customer
{
public:
    Customer();              // The default constructor
    Customer(int nRecType,   // The class constructor
        char * szCustName,
        char * szAddr,
        double dSales);

    void GetCustomer();
    void PrintCustomer();    // Print a customer's information

    ~Customer();             // Destructor

private:

    int    nRecordType;
    char   szCustomerName[120];
    char   szAddress[120];
    double dCurrentSales;

};

Customer::Customer()   // The class constructor, default values.
{
    nRecordType = CUSTOMER_RECORD;
    strcpy(szCustomerName, "-NONE-");
    strcpy(szAddress, "-NONE");
    dCurrentSales = 0.0;
}

Customer::Customer(int nRecType,   // The class constructor, explicit values
        char * szCustName,
        char * szAddr,
        double dSales)
{
    nRecordType = nRecType;
    strcpy(szCustomerName, szCustName);
    strcpy(szAddress, szAddr);
    dCurrentSales = dSales;
}

void Customer::GetCustomer()
{
char szLine[2]; // Used to store a NEWLINE for cin.getline

// You get, from the console, the object's data values, using a simple
// multiline format:

    cout << "Enter '" << CUSTOMER_RECORD << "' for a Customer '" <<
        SUPPLIER_RECORD << "' for a supplier: ";
    cin  >> nRecordType;

// Below you don't use cin, but cin.getline, which gets all
// characters until the delimiting character (the optional third
// character). If the delimiting character is omitted, a
// newline is assumed. When getting input, cin.getline() does not
// retrieve more characters than the second parameter specifies,
// taking into consideration the ending NULL for the string.

    cin.getline(szLine, sizeof(szLine)); // discard NEWLINE from last input.
    cout << "Enter the name: ";
    cin.getline(szCustomerName, sizeof(szCustomerName));

    cout << "Enter the address: ";
    cin.getline(szAddress, sizeof(szAddress));

    cout << "Enter the sales: ";
    cin  >> dCurrentSales;
}

void Customer::PrintCustomer()
{
// You print the object's data values, using a simple
// multiline format:

    cout << "Type\t" << nRecordType << "\n" <<
        "Name\t" << szCustomerName << "\n" <<
        "Address\t" << szAddress << "\n" <<
        "Sales:\t" << dCurrentSales << "\n";
}

Customer::~Customer()
{
// Nothing done here. You don't have anything to do when the
// object is destroyed.
}

void    main()

{

// The first object is initialized with the default values.
Customer Customer1;

// The second object is initialized with explicit values.
Customer Customer2(CUSTOMER_RECORD, "John Smith", "New York, NY 10000", 1234.5);

     Customer1.PrintCustomer();

     cout << "\n";

     Customer2.PrintCustomer();

     cout << "\n";

     Customer2.GetCustomer();

     cout << "\n";

     Customer2.PrintCustomer();

     cout << "\n";
}
