/* MENU1, written 23 May 1992 by Peter D. Hipson */
/* A simple menu program. */

/* This program assumes and uses Microsoft's extensions to C.
 * Readers with other compilers may have to change the program
 * to use the calls that their compiler supplies to perform
 * the same functions.
 */

#include <stdio.h>   // Make includes first part of file
#include <string.h>  // For string functions.
#include <stdlib.h>  // Standard include items.
#include <process.h> // For exit(), etc.
#include <conio.h>   // For getch() and other console I/O.
#include <ctype.h>   // For char functions (_toupper()...)

/* ANSI.SYS screen control #define's below: */

#define BOLD      "\x1B[1m"
#define NORMAL    "\x1B[0m"
#define RED       "\x1B[31m"
#define BLACK     "\x1B[30m"
#define GREEN     "\x1B[32m"

#define CLEAR_SCREEN "\x1B[2J"
#define CLEAR_EOL    "\x1B[K"

#define MOVE_CURSOR  "\x1B[%d;%df"

char  szTopBar[] = {/* Must be 80 characters long MAX. */
    CLEAR_SCREEN
    BOLD"F"NORMAL"iles   "
    BOLD"E"NORMAL"dit    "
    BOLD"V"NORMAL"iew    "
    BOLD"P"NORMAL"roject "
    BOLD"R"NORMAL"un     "
    BOLD"D"NORMAL"ebug   "
    CLEAR_EOL
    };

/* Line-drawing characters for the PC = " _ _  _ _ _ _   _ _"*/

void     MenuBar(); /* Never called! Make the array look good. */

char    *szFiles[] = {
    "_Ŀ",
    "_"BOLD"N"NORMAL"ew            _",
    "_"BOLD"O"NORMAL"pen           _",
    "_"BOLD"C"NORMAL"lose          _",
    "_"BOLD"S"NORMAL"ave           _",
    "_save "BOLD"A"NORMAL"s        _",
    "__",
    "_"BOLD"P"NORMAL"rint          _",
    "__",
    "_e"BOLD"X"NORMAL"it           _",
    "__",
    NULL};


void     DoFilesNew();
void     DoFilesOpen();
void     DoFilesClose();
void     DoFilesSave();
void     DoFilesSaveAs();
void     DoFilesPrint();
void     DoFilesEXit();
   
void    (*FilesFunctions[])(void) = {
    MenuBar,
    DoFilesNew,
    DoFilesOpen,
    DoFilesClose,
    DoFilesSave,
    DoFilesSaveAs,
    MenuBar,
    DoFilesPrint,
    MenuBar,
    DoFilesEXit,
    MenuBar,
    NULL
    };


int main(           // Define main() and the fact that this program uses
    int     argc,   // the passed parameters.
    char   *argv[],
    char   *envp[]
    );

void PullDown(char **, int, void (__cdecl **)(void));

int main(
    int     argc,
    char   *argv[],
    char   *envp[]
    )

{

char    chEntered;

    while (1)
    {
        printf(szTopBar);

        chEntered = (char)getch();

        if (chEntered == '\0' || chEntered == '\xE0')
        {   // PC Extended character (function key etc.)
            chEntered = (char)getch();
        }

        printf(MOVE_CURSOR, 10, 10); /* Using printf() fully here! */

        switch (_toupper((int)chEntered))
        {
            case 'F':
                PullDown(szFiles, 1, FilesFunctions);
                break;

            case 'E':
                printf("Edit submenu called" CLEAR_EOL);
                break;

            case 'V':
                printf("View submenu called" CLEAR_EOL);
                break;

            case 'P':
                printf("Project submenu called" CLEAR_EOL);
                break;

            case 'R':
                printf("Run submenu called" CLEAR_EOL);
                break;

            case 'D':
                printf("Debug submenu called" CLEAR_EOL);
                break;

            default:
                printf("Invalid key!" CLEAR_EOL);
                break;
        }

    }
    
    return(0);
}

void PullDown(
    char *  szMenu[],
    int     nColumn,
    void (__cdecl *pFunctions[])(void))

{

int     i;
int     nMenuItem = -1;

char    chEntered;

    for (i = 0; szMenu[i]; i++)
    {
        printf(MOVE_CURSOR, i + 1, nColumn);
        printf(szMenu[i]);
    }

    while (nMenuItem < 0)
    {
        chEntered = (char)getch();

        if (chEntered == '\0' || chEntered == '\xE0')
        {   // PC Extended character (function key etc.)
            chEntered = (char)getch();
        }

        chEntered = (char)_toupper((int)chEntered);

/* find the correct menu item index */

        if (isalnum((int)chEntered))
        {
            for (i = 0; szMenu[i]; i++)
            {
                if (strchr(szMenu[i], chEntered))
                {
                    nMenuItem = i;
                    break;
                }
            }
        }

        if (nMenuItem >= 0)
        {
            pFunctions[nMenuItem]();
        }
    }
}

void     DoFilesNew()

{
    printf(MOVE_CURSOR, 20, 10);

    printf("Files, new");

    printf(MOVE_CURSOR, 24, 10);

    printf("Any key to continue");

    (void)getch();
}

void     DoFilesOpen()

{
/*  Presents to the user a simple get a filename dialog box,
 *  enabling character string to be entered. Basic editing supported.
 */

int     i;
/*  These hard-coded constants, for placement of dialog box,
 *  normally would be passed.
 */
int     nColumn = 15;
int     nRow = 15;
int     nInputColumn = 2;
int     nInputRow = 4;

char    szFileName[132];
char    *szFilesOpen[] = {
    "_Ŀ",
    "_                                           _",
    "_Enter the name of the file to open:        _",
    "_                                           _",
    "_ ........................................  _",
    "_                                           _",
    "__",
    NULL};

    for (i = 0; szFilesOpen[i]; i++)
    {
        printf(MOVE_CURSOR, i + nRow, nColumn);
        printf(szFilesOpen[i]);
    }

    printf(MOVE_CURSOR,
        nInputRow + nRow,
        nInputColumn + nColumn);

    scanf("%s", szFileName);

    printf(MOVE_CURSOR, 24, 10);

    printf("NAME: '%s' Any key to continue", szFileName);

    (void)getch();
}

void     DoFilesClose()

{
    printf(MOVE_CURSOR, 20, 10);

    printf("Files, close selected");

    printf(MOVE_CURSOR, 24, 10);

    printf("Any key to continue");

    (void)getch();
}

void     DoFilesSave()

{
    printf(MOVE_CURSOR, 20, 10);

    printf("Files, save selected");

    printf(MOVE_CURSOR, 24, 10);

    printf("Any key to continue");

    (void)getch();
}

void     DoFilesSaveAs()

{
    printf(MOVE_CURSOR, 20, 10);

    printf("Files, save as selected");
   
    printf(MOVE_CURSOR, 24, 10);

    printf("Any key to continue");

    (void)getch();
}

void     DoFilesPrint()

{
    printf(MOVE_CURSOR, 20, 10);

    printf("Files, print selected");

    printf(MOVE_CURSOR, 24, 10);

    printf("Any key to continue");

    (void)getch();
}

void     DoFilesEXit()

{
    printf(MOVE_CURSOR, 20, 10);

    printf("Files, exit selected");

    exit(0);
}

void     MenuBar()

{
/* This function is never called! */
}
