/* VARGS, written 1992 by Peter D. Hipson */
/* This program demonstrates stdarg.h     */

#include <limits.h>
#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>

#define TRUE                1
#define FALSE               (!TRUE)
 
int     AddList(int nFirst, ...);
int     OurErrors(char * OutputFormat, ...);

void    main()

{

int     nSum;

    nSum = AddList(10, 20, 30, 40, 50, 60, 70, 80, 90, INT_MIN);

    (void)OurErrors("%s - %d, %s\n", "First", nSum, "Second");

}

int     AddList(
    int nFirst,
    ...)

{

int     nReturnValue = nFirst;
int     nThisValue;

va_list Arguments;

    va_start(Arguments, nFirst);

    while((nThisValue = va_arg(Arguments, int)) != INT_MIN)
    {
        nReturnValue += nThisValue;
    }

    va_end(Arguments);

    return(nReturnValue);
}


int     OurErrors(
    char * OutputFormat,
    ...)

{

va_list Arguments;

    va_start(Arguments, OutputFormat);

    vfprintf(stderr, OutputFormat, Arguments);

    va_end(Arguments);

    return(0);

}
