/* FDATA.C  This program demonstrates the use of the
            formatted I/O functions. Formatted I/O
            functions are used for both terminal and
            file I/O.  */

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include <io.h>

#define DATA_FILE "data.fil"

int menu( void );
int add( void );
int display( void );

/* main() - The main() function calls functions based on
            the value returned by the menu() function.

            If main() executes correctly, a value of 0 is
            returned. */

main() {
  int return_value;

  while( ( return_value = menu() ) != 0 ) {
    switch( return_value ) {
      case 1:   add();
                break;
      case 2:   display();
                break;
      case 3:   clrscr();
                printf( "Enter a correct menu value.\n" );
                printf( "Press a key to continue.\n" );
                while( !kbhit() );
                break;
    }
  }
  return 0;
}

/* menu() - The menu function displays a menu screen and
            prompts the user to select a menu item. The
            user's character input is converted to an
            integer value.

            menu() returns an integer value that represents
            a menu selection. */

int menu() {
  char char_in[2];
  int i;

  clrscr();
  printf( "\n\n\n\n\n" );
  printf( "1.  Add data to the data file.\n" );
  printf( "2.  Display the data file.\n" );
  printf( "0.  Quit.\n" );

  printf( "\n\nEnter your selection ==> " );
  gets( char_in );
  i = atoi( char_in );
  if( i >= 0 && i <= 3 )
    return( i );
  else
    return( 3 );
}

/* add() - The add() function opens a data file, prompts
           the user for the product information, and adds
           the product information to the data file. When
           all the new items are added to the file, add()
           closes the data file.

           If add() executes correctly, a value of 0 is
           returned. */

int add() {
  FILE   *fp;
  char   more = 'Y';
  char   name[30];
  int    count;
  float  weight;

  clrscr();

  if( ( fp = fopen( DATA_FILE, "ab" ) ) == NULL ) {
    clrscr();
    printf( "\n\nData file could not be opened.\n" );
    exit( 0 );
  }

  while( more == 'Y' ) {
    clrscr();
    printf( "\n\nEnter product name ==> " );
    scanf( "%s", name );
    printf( "\nEnter number of items ==> " );
    scanf( "%d", &count );
    printf( "\nEnter product weight ==> " );
    scanf( "%f", &weight );
    fflush( stdin );

    fprintf( fp, "%s %d %f", name, count, weight );

    printf( "\n\n\nEnter another product? Y/N ==> " );
    more = getche();
    if( more == 'y' ) more = 'Y';
  }

  fclose( fp );
  return 0;
}

/* display() - The display function displays the contents
               of the data file that was created or
               appended by the add() function.

               A value of 0 is returned if display()
               executes correctly. */

int display() {
  FILE   *fp;
  char   name[30];
  int    count;
  float  weight;

  clrscr();
  if( ( fp = fopen( DATA_FILE, "rb" ) ) == NULL ) {
    clrscr();
    printf( "\n\nData file could not be opened.\n" );
    exit( 0 );
  }

  while( !feof( fp ) ) {
    fscanf( fp, "%s %d %f", name, &count, &weight );
    printf( "\n\n" );
    printf( "Product name: %s\n", name );
    printf( "Product count = %d\n", count );
    printf( "Product weight = %4.2f\n", weight );
  }

  printf( "\n\nPress any key to continue." );
  while( !kbhit() );

  fclose( fp );
  return 0;
}
