/* PRTLAB.C  This program reads and prints the records in
             an address-label database file. The file can
             contain a variable number of records.
             Even though the number of records in the file
             is variable, the size of each of the fields in
             the records is fixed. The size of each of the
             fields is determined by the typedef structure
             address_t.  */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stddef.h>

#define MAXLABS 180

typedef struct {
  char name[36];
  char street[36];
  char apt[36];
  char city[36];
  char state[6];
  char zip[5];
  char fill[2];
} address_t;

void null_term( char* str, int length );
int compzip( const char*, const char* );

void main( int argc, char* argv[] )
{
  int j = 0, k = 0;
  FILE* adrfile;
  FILE* labels;
  char adrname[81];
  char labname[81];
  address_t* list;

  if ( argc < 3 ) {
    puts( "Command format is: prtlab addressfile labelfile" );
    exit( 0 );
  }

  if ( NULL == ( list = malloc(MAXLABS*sizeof(address_t) ) ) ) {
    puts( "Unable to acquire memory for address table.");
    exit( 8 );
  }

  strcpy( adrname, argv[1] );
  strcpy( labname, argv[2] );

  if ( NULL == ( adrfile = fopen( adrname, "rb" ) ) ) {
    puts( "Can't open input address file." );
    exit( 8 );
  }
  if ( NULL == ( labels = fopen( labname, "w" ) ) ) {
    puts( "Can't open output label file." );
    exit( 8 );
  }

  while ( j<MAXLABS-1 && fread( &list[j], sizeof(address_t),
    1, adrfile ) ) {list[j].fill[0] = ' ';
    ++j;     /* go to next address record slot */
  }
  fclose( adrfile );

  printf( "Read %d address records.\n", j );

  qsort( list, j, sizeof(address_t), compzip );

  for ( k=0; k<j; ++k ) {   /* null terminate line strings */
    null_term( list[k].name,36 );
    null_term( list[k].street,36 );
    null_term( list[k].apt,36 );
    null_term( list[k].city,36 );
    null_term( list[k].state,6 );
    null_term( list[k].zip,6 );
  }
  k = 0;
  while ( k<j ) {
    fprintf( labels, "%s\n", list[k].name );
    fprintf( labels, "%s\n", list[k].street );
    fprintf( labels, "%s\n", list[k].apt );
    fprintf( labels, "%s  %s    %s\n", list[k].city,
      list[k].state, list[k].zip );
    fprintf( labels, "\n" );
    ++k;
  }
  fclose( labels );
}

void null_term( char* str, int length )
{
  static int i;

  str += length - 1;   /* point to last byte */
  for( i=length; i>0; --i ) {
    if ( *str != ' ' ) {
      ++str;
      break;
    }
    --str;
  }
  if ( i == 0 ) ++str;
  *str = '\0';
}

int compzip( const char* arg1, const char* arg2 )
{
  return( strncmp( &arg1[offsetof(address_t,zip)],
                   &arg2[offsetof(address_t,zip)], 5 ));
}
