/* 17A03.c */
#include <stdio.h>  
#include <stdlib.h>

/* function declarations */  
void DataMultiply(int max, int *ptr);
void TablePrint(int max, int *ptr);
/* main() function */
main()
{
   int *ptr_int, max;
   int termination;
   char key = 'c';

   max = 0;
   termination = 0;
   ptr_int = 0;   
   while (key != 'x'){
      printf("Enter a single digit number:\n");
      scanf("%d", &max);   
      /* call realloc() */                    
      ptr_int = realloc(ptr_int, max * max * sizeof(int));                    
      if (ptr_int != NULL){
         DataMultiply(max, ptr_int);        
         TablePrint(max, ptr_int);      
      }
      else{
         printf("malloc() function failed.\n");
         termination = 1;
         break;
      }
      printf("\nPress x-key to quit; other key to continue.\n");
      scanf("%s", &key);   
   }
   free(ptr_int);
   printf("\nBye!\n");
   return termination;
}             
/* function definition */
void DataMultiply(int max, int *ptr)
{
   int i, j;
   
   for (i=0; i<max; i++)
      for (j=0; j<max; j++)
         *(ptr + i * max + j) = (i+1) * (j+1);
}
/* function definition */
void TablePrint(int max, int *ptr)
{
   int i, j;

   printf("The multiplication table of %d is:\n", 
           max);
   printf(" ");
   for (i=0; i<max; i++)
      printf("%4d", i+1);
   printf("\n ");
   for (i=0; i<max; i++)
      printf("----", i+1);      
   for (i=0; i<max; i++){
      printf("\n%d|", i+1);
      for (j=0; j<max; j++)
        printf("%3d ", *(ptr + i * max + j));  
   }
}
