# standard MacMach .login

set COLOR = ""
set GREY = ""

set XINITRC = $HOME/.xinitrc
if ( ! -r $XINITRC ) then
  set XINITRC = /usr/lib/X11/system.xinitrc
endif
if ( ! -r $XINITRC ) then
  set XINITRC = /usr/local/lib/X11/system.xinitrc
endif

umask 2

stty dec

echo -n "term: "
set i = $<

switch ( "$i" )
  case "mac":
  case "MAC":
    if ( `tty` != /dev/console ) then
      echo "tty is not console"
      exit 1      
    endif
    if ( ! -x /usr/bin/mac ) then
      echo "can not execute /usr/bin/mac"
      exit 1
    endif
    exec /usr/bin/mac
  case "gx":
  case "GX":
    set GREY = "-cc 1"
  case "cx":
  case "CX":
    set COLOR = "-depth 8"
  case "x":
  case "X":
    if ( `tty` != /dev/console ) then
      echo "tty is not console"
      exit 1      
    endif
    if ( ! -r $XINITRC ) then
      echo "can not read $XINITRC"
      exit 1
    endif
    if ( ! -x /usr/bin/X11/X ) then
      if ( ! -x /usr/local/bin/X ) then
        echo "can not execute X server"
        exit 1
      endif
    endif
    setenv DISPLAY unix:0
    exec xinit $XINITRC -- -dev /dev/scn0 $COLOR $GREY -s 10 -p 10 -v
endsw

set term = "$i"
unset i
unset d
