#!/bin/csh -f
######################################################################
# HISTORY
#  9-Jun-88  Michael Young (mwyoung) at Carnegie-Mellon University
#	Fixed to allow the source directory to be specified.  It only
#	works for creating the configuration file... actually configuring
#	or building would want to use the build directory.  I don't
#	want to understand how I'd use this script for more than just
#	making the configuration file anyway.
#
# 09-Apr-88  Mike Accetta (mja) at Carnegie-Mellon University
#	Add "mach.h" and "cmucs.h" to FEATURES_H list.
#	[ V5.1(XF23) ]
#
#  1-Dec-87  Michael Young (mwyoung) at Carnegie-Mellon University
#	Added "-verbose" switch, so this script produces no output
#	in the normal case.
#
# 09-Nov-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Moved configuration commands to conf/Makefile.config and
#	changed to use this makefile when building configurations so
#	that MASTER*, Makefile* and files* can be stored under RCS.
#	[ V5.1(XF21) ]
#
# 30-Oct-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Significantly revised to provide generalized macro expansion
#	capability and embedded attribute control within the
#	configuration name.
#	[ V5.1(XF20) ]
#
# 10-Oct-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Flushed cmu_*.h, spin_locks.h and romp_fpa.h
#	[ V5.1(XF18) ]
#
# 25-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Removed use of obsolete wb_*.h files when building the feature
#	list;  modified to save the previous configuration file and
#	display the differences between it and the new file.
#	[ V5.1(F8) ]
#
# 25-Mar-87  Avadis Tevanian (avie) at Carnegie-Mellon University
#	If there is no /etc/machine just print out a message telling
#	user to use the -cpu option.  I thought this script was supposed
#	to work even without a /etc/machine, but it doesn't... and this
#	is the easiest way out.
#
# 13-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Added "romp_fpa.h" file to extra features for the RT.
#	[ V5.1(F7) ]
#
# 11-Mar-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Updated to maintain the appropriate configuration features file
#	in the "machine" directory whenever the corresponding
#	configuration is generated.  This replaces the old mechanism of
#	storing this directly in the <sys/features.h> file since it was
#	machine dependent and also precluded building programs for more
#	than one configuration from the same set of sources.
#	[ V5.1(F6) ]
#
# 21-Feb-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Fixed to require wired-in cpu type names for only those
#	machines where the kernel name differs from that provided by
#	/etc/machine (i.e. IBMRT => ca and SUN => sun3);  updated to
#	permit configuration descriptions in both machine indepedent
#	and dependent master configuration files so that attributes can
#	be grouped accordingly.
#	[ V5.1(F3) ]
#
# 17-Jan-87  Mike Accetta (mja) at Carnegie-Mellon University
#	Updated to work from any directory at the same level as
#	"conf"; generate configuration from both MASTER and
#	MASTER.<machine-type> files; added -cpu switch.
#	[ V5.1(F1) ]
#
# 18-Aug-86  Mike Accetta (mja) at Carnegie-Mellon University
#	Added -make switch and changed meaning of -config;  upgraded to
#	allow multiple attributes per configuration and to define
#	configurations in terms of these attributes within MASTER.
#
# 14-Apr-83  Mike Accetta (mja) at Carnegie-Mellon University
#	Added -config switch to only run /etc/config without 
#	"make depend" and "make".
#
######################################################################

set prog=$0
set prog=$prog:t
set nonomatch

unset domake
unset doconfig
unset beverbose
unset MACHINE

set source_directory=".."

while ($#argv >= 1)
    if ("$argv[1]" =~ -*) then
        switch ("$argv[1]")
	case "-c":
	case "-config":
	    set doconfig
	    breaksw
	case "-m":
	case "-make":
	    set domake
	    breaksw
	case "-cpu":
	    if ($#argv < 2) then
		echo "${prog}: missing argument to ${argv[1]}"
		exit 1
	    endif
	    set MACHINE="$argv[2]"
	    shift
	    breaksw
	case "-v":
	case "-verbose":
	    set beverbose
	    breaksw
	case "-d":
	case "-dir":
	    if ($#argv < 2) then
		echo "${prog}: missing argument to ${argv[1]}"
		exit 1
	    endif
	    set source_directory="$argv[2]"
	    shift
	    breaksw
	default:
	    echo "${prog}: ${argv[1]}: unknown switch"
	    exit 1
	    breaksw
	endsw
	shift
    else
	break
    endif
end

if ($#argv == 0) set argv=(GENERIC)

if (! $?MACHINE) then
    if (-f /etc/machine) then
	    set MACHINE="`/etc/machine`"
    else
	    echo "${prog}: no /etc/machine, specify machine type with -cpu"
	    echo "${prog}: e.g. ${prog} -cpu VAX CONFIGURATION"
	    exit 1
    endif
endif
set SUFFIX=$MACHINE

set FEATURES_EXTRA=

switch ("$MACHINE")
    case IBMRT:
	set cpu=ca SUFFIX="RT"
	set FEATURES_EXTRA="romp_dualcall.h"
	breaksw
    case SUN:
	set cpu=sun3
	breaksw
    default:
	set cpu=`echo $MACHINE | tr A-Z a-z`
	breaksw
endsw
set FEATURES=${source_directory}/h/features.h
set FEATURES_H=(cmucs.h cmucs_*.h cs_*.h mach.h mach_*.h net_*.h\
	        cputypes.h vice.h\
	        $FEATURES_EXTRA)
set MASTER_DIR=${source_directory}/conf
set MASTER =   ${MASTER_DIR}/MASTER
set MASTER_CPU=${MASTER}.${cpu}

foreach SYS ($argv)
    if ($?beverbose) then
        echo "[ generating ${SYS} from ${MASTER_DIR}/MASTER{,.${cpu}{,.local}} ]"
    endif
    make -f ${source_directory}/conf/Makefile.config \
     "MASTER=$MASTER_DIR/MASTER $MASTER_DIR/MASTER.local $MASTER_DIR/MASTER.${cpu} $MASTER_DIR/MASTER.${cpu}.local"  \
     "SYS=$SYS" $SYS
    if (! -f ${SYS} ) then
	echo "${prog}: ${SYS}: no such configuration in $MASTER_DIR/MASTER{,.$cpu}{,.local}"
	exit 1
    endif

    if ($?doconfig) then
	if (! -d ../$SYS) then
	    set base=`expr "$SYS" : '\([^+-]*\).*'`
	    set exists="`set nonomatch; cd ..; echo ${base}*`"
	    set mesg="creating ../$SYS"
	    set build="mkdir ../$SYS"
	    if ("$exists" != "${base}*") then
		set exists=($exists)
		echo "[ potential build areas: $exists ]"
		set def="$exists[1]"
		while (1)
		    echo -n 'Rename (old area or "no")?  ['"$def"']  '
		    set ans="$<"
		    if ("$ans" == "") set ans="$def"
		    if ("$ans" == no) break
		    set area="$ans"
		    if (! -d "../$area") set area=${base}${ans}
		    if (-d "../$area") then
			set mesg="renaming  ../$area to  ../$SYS"
			set build="mv ../$area ../$SYS"
			break
		    else
			echo '[ build area "'"$ans"'" not found; try again ]'
			continue
		    endif
		end
	    endif
	    echo "[ $mesg ]"
	    eval "$build"
	endif

	echo "[ configuring $SYS ]"
	make -f ../conf/Makefile.config "SYS=$SYS" "cpu=$cpu" $SYS.config

	#
	#  Use the first component of the configuration as the features
	#  file name.
	#
	set tmp=`expr $SYS : "\([^+-]*\).*"'$'`
	set FEATURES=../$cpu/$tmp.h
	if (-w $FEATURES) then
	    echo "[ updating $FEATURES ]"
	    set tmp=FEATURES.tmp
	    (cd ../$SYS;eval sort $FEATURES_H) >$tmp
	    diff $FEATURES $tmp
	    if ($status != 0) then
		chmod +w $FEATURES
		cp $tmp $FEATURES
	    endif
	    rm -f $tmp
	endif
    endif

    if ($?domake) then
        echo "[ making $SYS ]"
        (cd ../$SYS; make)
    endif
end
