/* partition and label Macintosh disks for MacMach - Art Wetzel 10/89 */
#include <stdio.h>
#define BLKS_NEEDED 35000

/* Apple driver descriptor map info - see Inside Mac V-577 */
struct dm {
  short sbSig;
  short sbBlockSize;
  long sbBlkCount;
};

/* Apple partition map info - see Inside Mac V-579 */
struct pm {
  short pmSig;
  short pmSigPad;
  long pmMapBlkCnt;
  long pmPyPartStart;
  long pmPartBlkCnt;
  char pmPartName[32];
  char pmPartType[32];
};

/* old style Apple device partition map - see Inside Mac IV-292 */
struct pd {
  short pdSig;
  long pdStart;
  long pdSize;
  long pdFSID;
};

#define MACH_PARTITION_TYPE "Mach_UNIX_BSD4.3"
#define FREE_PARTITION_TYPE "Apple_Free"
#define MAX_A_PART 64 /* max # Apple partitions to examine */

#define BLK_SIZE 512
char blk_buf[BLK_SIZE];
#define NLEN 20
char dname[NLEN];
int nfree;
int has_free[8];
int nmach;
int has_mach[8];
int nnot_apple;
int not_apple[8];

#define NORMAL 0
#define ERROR 1
#define NOT_APPLE 2
#define HAS_MACH 3

main(argc, argv)
int argc;
char *argv[];
{
  int i, j, fd_x, fd_c;
  if (argc > 2) {
    fprintf(stderr, "Usage: %s [ SCSIID ]\n", argv[0]);
    exit(1);
  }
  i = -1;
  if (argc < 2) {
    fprintf(stderr, "Searching for free disk partition ...\n");
    for (i = 0; i < 7; i++) { /* id 7 is the Mac */
      fprintf(stderr, "Trying SCSI disk %d.\n", i);
      sprintf(dname, "/dev/rsd%dx", i);
      fd_x = open(dname, 0);
      if (fd_x < 0) continue;
      j = check_disk(dname, i, fd_x, 0, 0);
      if (j == NORMAL) has_free[nfree++] = i;
      if (j == NOT_APPLE) not_apple[nnot_apple++] = i;
      if (j == HAS_MACH) has_mach[nmach++] = i;
      close(fd_x);
    }
    i = -1;
    /* first, try to allocate a free disk partition */
    if (nfree) {
      if(nfree == 1) i = has_free[0];
      else {
        fprintf(stderr, "Found %d disks with free partitions.\n", nfree);
        for(i = 0; i < nfree; i++)
          fprintf(stderr, "  SCSI disk %d\n", has_free[i]);
        fprintf(stderr, "Enter the number of the disk to use: ");
        gets(blk_buf);
        if(blk_buf[0] >= '0' && blk_buf[0] <= '7') i = atoi(blk_buf);
        else i = -1;
      }
    }
    /* next, try to allocate non-Apple disks */
    else if (nnot_apple) {
      if (nnot_apple == 1) i = not_apple[0];
      else {
        fprintf(stderr, "Found %d non Apple disks.\n", nnot_apple);
        for (i = 0; i < nnot_apple; i++)
          fprintf(stderr, "  SCSI disk %d\n", not_apple[i]);
        fprintf(stderr, "Enter the number of the disk to use: ");
        gets(blk_buf);
        if(blk_buf[0] >= '0' && blk_buf[0] <= '7') i = atoi(blk_buf);
        else i = -1;
      }
    }
    /* next, try existing mach disks */
    else if (nmach) {
      if(nmach == 1) i = has_mach[0];
      else {
        fprintf(stderr, "Found %d disks with mach partitions.\n", nmach);
        for(i = 0; i < nmach; i++)
          fprintf(stderr, "  SCSI disk %d\n", has_mach[i]);
        fprintf(stderr, "Enter the number of the disk to use: ");
        gets(blk_buf);
        if(blk_buf[0] >= '0' && blk_buf[0] <= '7') i = atoi(blk_buf);
        else i = -1;
      }
    }
  }
  else {
    if(argv[1][0] >= '0' && argv[1][1] <= '7') i = atoi(argv[1]);
    else {
      fprintf(stderr, "SCSIID must be a number in the range 0 to 7\n");
      exit(1);
    }
  }
  if (i < 0 || i > 7) {
    fprintf(stderr, "No SCSI disk selected\n");
    exit(1);
  }
  sprintf(dname, "/dev/rsd%dx", i);
  fd_x = open(dname, 2);
  if (fd_x < 0) {
    fprintf(stderr, "Could not open %s for writing\n", dname);
    exit(1);
  }
  sprintf(dname, "/dev/rsd%dc", i);
  fd_c = open(dname, 2);
  if (fd_c < 0) {
    fprintf(stderr, "Could not open %s for writing\n", dname);
    exit(1);
  }
  j = check_disk(dname, i, fd_x, fd_c, 1);
  if (j == NORMAL || j == HAS_MACH || j == NOT_APPLE) {
    printf("%d\n", i);
    exit(0);
  }
  exit(1);
}

check_disk(disk, scsiid, fd_x, fd_c, doit)
char *disk;
int scsiid;
int fd_x, fd_c;
int doit;
{
  int i, j, asize;
  struct pm *pm = (struct pm *)blk_buf;
  struct pd *pd = (struct pd *)blk_buf;

  lseek(fd_x, 0, 0);
  j = read(fd_x, blk_buf, BLK_SIZE);
  if(j != BLK_SIZE) {
    if (doit) fprintf(stderr, "ERROR: can't read block 0 on %s\n", disk);
    return(ERROR);
  }
  if ((asize = apple_disk_size(blk_buf)) <= 0) {
    if (doit) {
      fprintf(stderr, "No apple partition info on SCSI disk %d\n", scsiid);
      fprintf(stderr, "Do you want this to be a Mach only disk? (Y/N): ");
      gets(blk_buf);
      if (blk_buf[0] != 'Y' && blk_buf[0] != 'y') return(ERROR);
      j = size_disk(fd_x);
      labelit(fd_x, fd_c, j, 0);
    }
    if (is_bsd_label_block(blk_buf)) return(HAS_MACH);
    return(NOT_APPLE);
  }
  /* read Apple partition maps looking for the Mach partition */
  for(i = 1; i < MAX_A_PART; i++) {
    j = read(fd_x, blk_buf, BLK_SIZE);
    if (j != BLK_SIZE) {
      if (doit) fprintf(stderr, "ERROR: can't read block %d on %s\n", i, disk);
      return(ERROR);
    }
    /* check old style Apple partitioning - see Inside MAC IV-292 */
    if (i == 1 && pd->pdSig == 0x5453)
      return (check_old_disk(disk, scsiid, fd_x, fd_c, doit, asize));
    /* is it a partition map - see Inside MAC V-579 */
    if (pm->pmSig != 0x504D) break;
    if (strcmp(MACH_PARTITION_TYPE, pm->pmPartType) == 0) {
      if (doit) {
        fprintf(stderr, "Found existing Mach partition on SCSI disk %d\n", scsiid);
        fprintf(stderr, "Do you want use this existing partition? (Y/N): ");
        gets(blk_buf);
        if (blk_buf[0] != 'Y' && blk_buf[0] != 'y') return(ERROR);
        labelit(fd_x, fd_c, pm->pmPartBlkCnt, pm->pmPyPartStart);
      }
      return (HAS_MACH);
    }
    if (strcmp(FREE_PARTITION_TYPE, pm->pmPartType) == 0) {
      if (pm->pmPartBlkCnt < BLKS_NEEDED) continue;
      fprintf(stderr,
        "Found free partition with %d blocks at %d on SCSI disk %d\n",
        pm->pmPartBlkCnt, pm->pmPyPartStart, scsiid);
      if (!doit) return(NORMAL);
      strcpy(pm->pmPartType, MACH_PARTITION_TYPE);
      lseek(fd_x, i*BLK_SIZE, 0);
      j = write(fd_x, blk_buf, BLK_SIZE);
      if (j != BLK_SIZE) {
        fprintf(stderr, "ERROR: failed to update Apple partition info\n");
        return(ERROR);
      }
      fprintf(stderr, "New Mach partition %d, %d blocks at %d\n",
        i, pm->pmPartBlkCnt, pm->pmPyPartStart);
      labelit(fd_x, fd_c, pm->pmPartBlkCnt, pm->pmPyPartStart);
      return(NORMAL);
    }
  }
  if (doit)
    fprintf(stderr,
      "ERROR: could not find a free partition on SCSI disk %d\n", scsiid);
  return(ERROR);
}

char old_mach_string[] = "MACH";
#define OLD_MACH (*(int *)old_mach_string)
check_old_disk(disk, scsiid, fd_x, fd_c, doit, disksize)
char *disk;
int scsiid;
int fd_x, fd_c;
int doit;
int disksize;
{
  int i, j, next_block = 0;
  struct pd *pd = (struct pd *)blk_buf;

  /* examine old Apple partition info looking for Mach partition */
  for (i = 1; i < MAX_A_PART; i++, pd++) {
    if (pd->pdSig == 0x5453) {  /* see Inside MAC IV-292 */
      next_block = pd->pdStart + pd->pdSize;
      if (pd->pdFSID == OLD_MACH) {
      if (doit) {
        fprintf(stderr, "Found existing Mach partition on SCSI disk %d\n", scsiid);
        fprintf(stderr, "Do you want use this existing partition? (Y/N): ");
        gets(blk_buf);
        if (blk_buf[0] != 'Y' && blk_buf[0] != 'y') return(ERROR);
        labelit(fd_x, fd_c, pd->pdSize, pd->pdStart);
      }
      return(HAS_MACH);
    }
  }
  if (pd->pdSig == 0) {
    if(disksize - next_block < BLKS_NEEDED) return(ERROR);
      fprintf(stderr,
        "Found free space of %d blocks at %d on SCSI disk %d\n",
        disksize-next_block, next_block, scsiid);
      if (!doit) return(NORMAL);
      pd->pdSig = 0x5453; /* see Inside MAC IV-292 */
      pd->pdStart = next_block;
      pd->pdSize = disksize - next_block;
      pd->pdFSID = OLD_MACH;
      pd++;
      pd->pdSig = 0;
      pd->pdStart = 0;
      pd->pdSize = 0;
      pd->pdFSID = 0;
      pd--;
      lseek(fd_x, BLK_SIZE, 0);
      j = write(fd_x, blk_buf, BLK_SIZE);
      if (j != BLK_SIZE) {
        fprintf(stderr, "ERROR: failed to update Apple partition info\n");
        return(ERROR);
      }
      fprintf(stderr, "New Mach partition %d, %d blocks at %d\n",
        i, pd->pdSize, pd->pdStart);
      labelit(fd_x, fd_c, pd->pdSize, pd->pdStart);
      return(NORMAL);
    }
  }
  if (doit)
    fprintf(stderr,
      "ERROR: could not find a free partition on SCSI disk %d\n", scsiid);
  return(ERROR);
}

#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/disklabel.h>
char label_block[BLK_SIZE];
labelit(fd_x, fd_c, blkcnt, start_blk)
int fd_x, fd_c;
int blkcnt, start_blk;
{
  register int i;
  struct disklabel *dlbp = (struct disklabel *)(label_block + LABELOFFSET);

  if (blkcnt < BLKS_NEEDED) {
    fprintf(stderr,
      "ERROR: not enough space for Mach - have %d blocks but need %d\n",
      blkcnt, BLKS_NEEDED);
    exit(1);
  }
  dlbp->d_checksum = 0;
  dlbp->d_magic = DISKMAGIC;
  dlbp->d_magic2 = DISKMAGIC;
  strcpy(dlbp->d_typename,  "Mach partition");
  dlbp->d_rpm = 3600;
  dlbp->d_secsize = BLK_SIZE;
  dlbp->d_interleave = 1;
  dlbp->d_nsectors = 32;
  dlbp->d_ntracks = 6;
  dlbp->d_ncylinders = 823;
  dlbp->d_secpercyl = 192;
  dlbp->d_secperunit = blkcnt;
  dlbp->d_bbsize = 8192;
  dlbp->d_sbsize = 8192;
  dlbp->d_npartitions = 8;
  dlbp->d_partitions[0].p_size = 19584; /* 'a' section */
  dlbp->d_partitions[0].p_fsize = 1024;
  dlbp->d_partitions[0].p_frag = 8;
  dlbp->d_partitions[2].p_size = blkcnt; /* 'c' section */
  dlbp->d_partitions[2].p_fsize = 1024;
  dlbp->d_partitions[2].p_frag = 8;
  dlbp->d_partitions[6].p_size = blkcnt - 19584; /* 'g' section */
  dlbp->d_partitions[6].p_offset = 19584;
  dlbp->d_partitions[6].p_fsize = 1024;
  dlbp->d_partitions[6].p_frag = 8;
/*
  i = (start_blk + LABELSECTOR) * BLK_SIZE;
  if (lseek(fd_x, i, 0) != i || write(fd_x, label_block, BLK_SIZE) != BLK_SIZE) {
    fprintf(stderr, "Failed to write BSD disk label\n");
    exit(1);
  }
/* */
  if(ioctl(fd_c, DIOCWDINFO, dlbp) < 0) {
    perror("labeling failed: ioctl DIOCWDINFO");
    exit(1);
  }
  fprintf(stderr, "Allocated %.1f Mb in %d blocks for Mach\n",
    ((float)blkcnt * BLK_SIZE) / 1048576, blkcnt);
}

is_bsd_label_block(p)
char *p;
{
  struct disklabel *lp = (struct disklabel *)(p + LABELOFFSET);
  if(lp->d_magic == DISKMAGIC && lp->d_magic2 == DISKMAGIC) return(1);
  return(0);
}

apple_disk_size(a)
char *a;
{
  struct dm *dm = (struct dm *)a;
  if(dm->sbSig == 0x4552) return(dm->sbBlkCount); /* see Inside MAC V-577 */
  return(-1);
}

size_disk(fd_x)
int fd_x;
{
  int ok, i, j;
  ok = 0;
  for (i = 1; i; i <<= 1) {
    lseek(fd_x, BLK_SIZE*i, 0);
    j = read(fd_x, blk_buf, BLK_SIZE);
    if (j != BLK_SIZE) break;
  }
  for ( ; i; i >>= 1) {
    lseek(fd_x, BLK_SIZE*(ok + i), 0);
    j = read(fd_x, blk_buf, BLK_SIZE);
    if (j == BLK_SIZE) ok += i;
  }
  return(ok);
}
