/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afs_call.c,v $
 * Revision 2.8  90/02/09  12:33:12  berman
 * 	Changed print out of cache size and blocks used in afs_call()
 * 	and print outs of shutdown stages.
 * 	[90/02/09            berman]
 * 
 * Revision 2.7  89/08/28  22:30:29  af
 * 	Fixed afs_shutdown() to terminate all servers for real.
 * 	[89/08/05            af]
 * 
 * Revision 2.6  89/08/02  07:58:59  jsb
 * 	Fixed incorrect test in AFSOP_SHUTDOWN case.
 * 	[89/07/31  18:12:57  jsb]
 * 
 * Revision 2.5  89/06/03  15:26:42  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:05:39  jsb]
 * 
 * Revision 2.4  89/04/22  15:13:14  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987, 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#include <sys/var.h>
#endif
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifdef	AFS_AIX_ENV
#include <sys/errno.h>
#include <afs/aix_vfs.h>
#include <sys/var.h>
#else
#include <sys/kernel.h>
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/file.h>
#include <sys/uio.h>
#ifdef	AFS_GFS_ENV
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <sys/mbuf.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include <afs/osi.h>
#include <rx/rx.h>

#include <afs/lock.h>
#include <afs/volerrors.h>
#include <afsint/afsint.h>
#include <afs/afs.h>

struct afsop_cell {
    long hosts[MAXHOSTS];
    char cellName[100];
};

char afs_zeros[AFS_ZEROS];
char afs_rootVolumeName[64]="";
extern long afs_blocksUsed;
extern long afs_reusedFiles;
long afs_initState = 0;
long afs_termState = 0;
long afs_setTime = 0;
static CB_Running = 0;
static AFS_Running = 0;
static CacheInit_Done = 0;
static Go_Done = 0;

#ifdef	AFS_IBM_ENV
/* assume only ibm does text caching in vnode kernels */
extern int maxtextcache;
#endif	AFS_IBM_ENV

afs_call () {
    register struct a {
	    long parm;
	    long parm2;
	    long parm3;
	    long parm4;
	    long parm5;
	    long parm6;
    } *uap = (struct a *)u.u_ap;
    long code;

    if(!afs_suser()) {	/* only root can run this code */
	u.u_error = EACCES;
	return;
    }

    if (uap->parm == AFSOP_START_R || uap->parm == AFSOP_START_RFTP) {
	/* obsolete */
    }
    else if (uap->parm == AFSOP_START_CALLBACK) {
	/* callback server */
	if (CB_Running) return 0;
	CB_Running = 1;
	/* start RX */
	bzero(afs_zeros, AFS_ZEROS);
	rx_nPackets = 52;	/* smaller # of packets */
	rx_Init(htons(7001));
	rx_SetRxDeadTime(50);
	/* resource init creates the services */
	afs_ResourceInit();
	afs_initState = AFSOP_START_AFS;
	osi_Wakeup(&afs_initState);
	osi_Invisible();
	afs_RXCallBackServer();
    }
    else if (uap->parm == AFSOP_START_AFS) {
	/* afs daemon */
	long temp;

	if (AFS_Running) return 0;
	AFS_Running = 1;
#ifdef AFS_IBM_ENV
	maxtextcache = -2;
#endif AFS_IBM_ENV
	while (afs_initState < AFSOP_START_AFS) osi_Sleep(&afs_initState);
	afs_initState = AFSOP_START_BKG;
#ifdef	AFS_VFS40
	temp = 30;  /* Should fix this soon */
#else
	temp = ((afs_bufferpages * NBPG)>>11);	/* number of 2k buffers we could get from all of the buffer space */
	temp = temp>>2;	/* don't take more than 25% (our magic parameter) */
	if (temp < 10) temp = 10;   /* although we really should have this many */
#endif
	DInit(temp);
	osi_Wakeup(&afs_initState);
	osi_Invisible();
	afs_Daemon();
    }
    else if (uap->parm == AFSOP_START_BKG) {
	while (afs_initState < AFSOP_START_BKG) osi_Sleep(&afs_initState);
	if (afs_initState < AFSOP_GO) afs_initState = AFSOP_GO;
	/* start the bkg daemon */
	osi_Invisible();
	afs_BackgroundDaemon();
    }
    else if (uap->parm == AFSOP_ADDCELL) {
	/* add a cell.  Parameter 2 is 8 hosts (in net order),  parm 3 is the null-terminated
	 name.  Parameter 4 is the length of the name, including the null.  Parm 5 is the
	 home cell flag (0x1 bit) and the nosuid flag (0x2 bit) */
	struct afsop_cell tcell;

	code = copyin(uap->parm2, tcell.hosts, sizeof(tcell.hosts));
	if (code) return code;
	if (uap->parm4 > sizeof(tcell.cellName)) return EFAULT;
	code = copyin(uap->parm3, tcell.cellName, uap->parm4);
	if (code) return code;
	afs_NewCell(tcell.cellName, tcell.hosts, uap->parm5);
	return code;
    }
    else if (uap->parm == AFSOP_CACHEINIT) {
	if (CacheInit_Done) return 0;
	CacheInit_Done = 1;
	code = afs_CacheInit(uap->parm2, uap->parm3, uap->parm4);
	return code;
    }
    else if (uap->parm == AFSOP_CACHEINODE) {
	/* do it by inode */
	code = afs_InitCacheFile((char *) 0, uap->parm2);
	return code;
    }
    else if (uap->parm == AFSOP_ROOTVOLUME) {
	long bufferSize;
	if (uap->parm2) {
#if	(defined(AFS_AUX_ENV) || defined(AFS_AIX_ENV))
	    code = 0;
	    /* Check error code possibility here? */
	    bufferSize = bcopyin(uap->parm2, afs_rootVolumeName, sizeof(afs_rootVolumeName));
#else
	    code = copyinstr(uap->parm2, afs_rootVolumeName, sizeof(afs_rootVolumeName), &bufferSize);
#endif
	    afs_rootVolumeName[sizeof(afs_rootVolumeName)-1] = 0;
	}
	else code = 0;
	return code;
    }
    else if (uap->parm == AFSOP_CACHEFILE || uap->parm == AFSOP_CACHEINFO ||
	      uap->parm == AFSOP_VOLUMEINFO || uap->parm == AFSOP_AFSLOG) {
	char tbuffer[256];
	long bufferSize;
#if	(defined(AFS_AUX_ENV) || defined(AFS_AIX_ENV))
	code = 0;
	/* Check error code possibility here? */
	bufferSize = bcopyin(uap->parm2, tbuffer, 256);
	if (bufferSize == -1) return -1;
#else
	code = copyinstr(uap->parm2, tbuffer, 256, &bufferSize);
#endif
	if (code) return code;
	tbuffer[255] = 0;	/* null-terminate the name */
	/* we now have the cache dir copied in.  Call the cache init routines */
	if (uap->parm == AFSOP_CACHEFILE) code = afs_InitCacheFile(tbuffer, 0);
	else if (uap->parm == AFSOP_CACHEINFO) code = afs_InitCacheInfo(tbuffer);
	else if (uap->parm == AFSOP_VOLUMEINFO) code = afs_InitVolumeInfo(tbuffer);
	else if (uap->parm == AFSOP_AFSLOG) code = afs_SetLogFile(tbuffer);
	return code;
    }
    else if (uap->parm == AFSOP_STARTLOG) code = StartLogFile();
    else if (uap->parm == AFSOP_ENDLOG) code = EndLogFile();
    else if (uap->parm == AFSOP_GO) {
	/* the generic initialization calls come here.  One parameter: should we do the
	      set-time operation on this workstation */
	if (Go_Done) return 0;
	Go_Done = 1;
	while (afs_initState < AFSOP_GO) osi_Sleep(&afs_initState);
	afs_initState = 101;
	afs_setTime = uap->parm2;
	osi_Wakeup(&afs_initState);
	printf("afs: found %d cache files (%d blocks).\n",
	    afs_reusedFiles, afs_blocksUsed);
    }
    else if (uap->parm == AFSOP_SHUTDOWN) {
	extern struct vfs *afs_globalVFS;
	if (afs_globalVFS != 0) {
	    printf("AFS isn't unmounted yet! Call aborted\n");
/* We should return a better error code and get rid of the printf here */
	    return (EACCES);
	}
	afs_shutdown();
#if	defined(AFS_AIX_ENV) && defined(AFS_COMMON)
    } else if (uap->parm >= 30 && uap->parm < 40) {
	afs_auxcall();
#endif
    }
    return 0;
}

/*
 * Initstate in the range 0 < x < 100 are early initialization states.
 * Initstate of 100 means a AFSOP_START operation has been done.  After this,
 *  the cache may be initialized.
 * Initstate of 101 means a AFSOP_GO operation has been done.  This operation
 *  is done after all the cache initialization has been done.
 * Initstate of 200 means that the volume has been looked up once, possibly
 *  incorrectly.
 * Initstate of 300 means that the volume has been *successfully* looked up.
 */
afs_CheckInit() {
    if (afs_initState <= 100) return ENXIO;   /* never finished init phase */
    if (afs_initState == 101) {	/* init done, wait for afs_daemon */
	while (afs_initState < 200) osi_Sleep(&afs_initState);
    }
    if (afs_initState == 200) return ETIMEDOUT; /* didn't find root volume */
    else return 0;
}

afs_shutdown() {
    extern short afs_brsDaemons;
    extern struct osi_WaitHandle AFSWaitHandler;

    afs_termState = AFSOP_STOP_CALLBACK;
    while (rx_Shutdown()) osi_Sleep(&afs_termState);
    printf("Callback... ");

    afs_termState = AFSOP_STOP_AFS;
    while (afs_termState == AFSOP_STOP_AFS) {
	osi_CancelWait(&AFSWaitHandler);
	osi_Sleep(&afs_termState);
    }
    printf("Shutting down afs...");
    /* Wake-up afs_brsDaemons so that we don't have to wait for a bkg job! */
    osi_Wakeup(&afs_brsDaemons);
    while (afs_termState == AFSOP_STOP_BKG) {
	osi_Wakeup(&afs_brsDaemons);
	osi_Sleep(&afs_termState);
    }
    printf("background daemons...");
    shutdown_CB();  
#ifdef notdef
    shutdown_R();
    shutdown_RFTP();
#endif notdef
    shutdown_AFS();
    shutdown_BKG(); 
    shutdown_bufferpackage();
    shutdown_daemons();
    shutdown_cache();
    shutdown_osi();
    shutdown_osinet();
    shutdown_osifile();
    shutdown_vnodeops();
    shutdown_afstest();
    printf("and all allocated tables\n");
}

shutdown_afstest()
{
    afs_initState = afs_termState = afs_setTime = 0;
    *afs_rootVolumeName = 0;
    AFS_Running = CB_Running = 0;
    CacheInit_Done = Go_Done = 0;
}


/* In case there is a bunch of dynamically build bkg daemons to free */
shutdown_BKG()
{ }
