/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afs_physio.c,v $
 * Revision 2.7  89/06/03  15:28:45  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:06:59  jsb]
 * 
 * Revision 2.6  89/04/22  15:14:49  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

#ifndef lint
#endif

/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* File		physio.cx
Author		Mike Kazar
NOTE		This is NOT the standard physio.cx for venus or, yet alone, vice.  It is a test one for use in src/dir.
Date		Now */

/* First we have the kernel hacks' include files. */
#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#endif
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifndef	AFS_AIX_ENV
#include <sys/kernel.h>
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/uio.h>
#ifdef	AFS_GFS_ENV
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <sys/mbuf.h>
#include <afs/osi.h>

#define AFS_PAGESIZE 2048

static struct osi_dev cacheDevice;
dirp_SetCacheDev (adev)
    register struct osi_dev *adev; {
    bcopy(adev, &cacheDevice, sizeof(cacheDevice));
}

dirp_Read (fid, block, data)
    long *fid;		/* View the fid as longs. */
    long block;
    char *data; {
    struct osi_file *tf;
    long code;
    tf = osi_UFSOpen(&cacheDevice, fid[0]);
    if (!tf) Die("physio open");
    osi_Seek(tf, block * AFS_PAGESIZE);
    code = osi_Read(tf, data, AFS_PAGESIZE);
    osi_Close(tf);
    if (code < AFS_PAGESIZE) return 0;
    return 1;	    /* success */
}

dirp_Write(fid, block, data)
    long *fid;		/* View the fid as longs. */
    long block;
    char *data; {
    struct osi_file *tf;
    long code;
    tf = osi_UFSOpen(&cacheDevice, fid[0]);
    if (!tf) Die("physio open");
    osi_Seek(tf, block * AFS_PAGESIZE);
    code = osi_Write(tf, data, AFS_PAGESIZE);
    if (code < 0) Die("physio read");
    osi_Close(tf);
    return 1;	    /* success */
}

/* The following three routines provide the fid routines used by the buffer and directory packages. */

int dirp_Zap (afid)
register long *afid; {/* Zero out a file */
    *afid = 0;
}

int dirp_Eq (afid, bfid)
register long *afid, *bfid; {
    if (*afid != *bfid) return 0;
    return 1;
}

/* assign one fid to another */
int dirp_Cpy (dfid,sfid)
register long *dfid, *sfid; {
    *dfid = *sfid;
}

/* general afs abort */
Die(arg)
char *arg; {/* Print an error message and then exit. */
    char buffer[100];
    strcpy(buffer, "afs error -- ");
    strcpy(&buffer[strlen(buffer)], arg);    /* uggggh! very fun, sun */
    panic(buffer);
}
