/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	afs_vfsops.c,v $
 * Revision 2.7  90/01/11  11:34:07  berman
 * 	Set VFS_NOSUID flag under #ifdef AFS_MACH_ENV conditional to
 * 	disallow setid programs to be run from AFS.
 * 	[89/12/13            jsb]
 * 
 * Revision 2.6  89/06/03  15:29:30  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  19:07:10  jsb]
 * 
 * Revision 2.5  89/04/22  15:15:31  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987, 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#include <afs/param.h>
#include <sys/types.h>
#include <sys/param.h>
#ifdef	AFS_AUX_ENV
#include <sys/mmu.h>
#include <sys/seg.h>
#include <sys/sysmacros.h>
#include <sys/signal.h>
#include <sys/errno.h>
#endif
#if	!defined(AFS_IBM_ENV) || !defined(sys_rt_r3)
#include <sys/time.h>
#endif	AFS_IBM_ENV
#ifdef	AFS_AIX_ENV
#include <sys/errno.h>
#include <afs/aix_vfs.h>
#else
#include <sys/kernel.h>
#endif
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/protosw.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <sys/file.h>
#include <sys/uio.h>
#ifdef	AFS_GFS_ENV
/*#include "../h/fs_types.h"*/
#include <sys/mount.h>
#include <afs/gfs_vfs.h>
#include <afs/gfs_vnode.h>
#else
#ifdef	AFS_MACH_ENV
#include <vfs/vfs.h>
#include <vfs/vnode.h>
#include <sys/inode.h>
#else	AFS_MACH_ENV
#include <sys/vfs.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#endif	AFS_MACH_ENV
#endif	AFS_GFS_ENV
#include <netinet/in.h>
#include <sys/mbuf.h>
#include <rpc/types.h>
#include <rpc/xdr.h>

#include <afs/osi.h>
#include <rx/rx.h>

#include <afs/lock.h>
#include <afs/volerrors.h>
#include <afsint/afsint.h>
#include <afs/afs.h>

int afs_mount();
int afs_unmount();
int afs_root();
int afs_statfs();
int afs_sync();
#ifdef	AFS_GATEWAY
int afs_vget();
#else	AFS_GATEWAY
#ifdef	AFS_VFS34
int afs_vget();
#endif
#endif	AFS_GATEWAY
#ifdef	AFS_VFS40
int afs_mountroot();
int afs_swapvp();
#endif

struct vfs *afs_globalVFS = 0;

struct vfsops afs_vfsops = {
    afs_mount,
    afs_unmount,
    afs_root,
    afs_statfs,
    afs_sync,
#ifdef	AFS_GATEWAY
    afs_vget,
#else	AFS_GATEWAY
#ifdef AFS_VFS34
    afs_vget,
#endif
#endif	AFS_GATEWAY
#ifdef	AFS_VFS40
    afs_mountroot,
    afs_swapvp,
#endif
};


#ifdef	AFS_AUX_ENV
/* Due to the "autoconfig feature of AUX, we validate the afs-related sys calls only when the afs module is existent in the running kernel; afsinit() is called early on during the booting sequence... */
#include "sys/sysent.h"
#include "rpc/auth.h"
#include "rpc/clnt.h"
#include "nfs/nfs.h"
#include "nfs/nfs_clnt.h"
#include "nfs/rnode.h"
#include "sys/mount.h"
afsinit()
{
    extern int afs_xioctl(), afs_xsetgroups(), afs_xflock(), afs_pioctl(), afs_setpag(), afs_call(), icreate(), iopen(), iread(), iwrite(), iinc(), idec();
    extern struct vfsops *vfssw[];

    if (afs_debug & AFSDEB_GENERAL) afs_dp("afsinit: Initializing AFS....\n");
    vfssw[MOUNT_AFS] = &afs_vfsops;

    sysent[54].sy_call = afs_xioctl;	/* Replacing ioctl */
    sysent[103].sy_call = afs_xsetgroups;	/* Replacing setgroups */
    sysent[105].sy_call = afs_xflock;	/* Replacing flock */
    /* New afs-related calls */
    sysent[170].sy_call = icreate;
    sysent[171].sy_call = iopen;
    sysent[172].sy_call = iread;
    sysent[173].sy_call = iwrite;
    sysent[174].sy_call = iinc;
    sysent[175].sy_call = idec;
    sysent[176].sy_call = afs_pioctl;
    sysent[177].sy_call = afs_setpag;
    sysent[178].sy_call = afs_call;
}
#endif

afs_mount(afsp, path, data)
    struct vfs *afsp;
    char *path;
    caddr_t data; {

#ifdef	AFS_AIX_ENV
	struct vnode *afsrootvp = NULL;
	int error;
#endif
    afs_globalVFS = afsp;
    afsp->vfs_bsize = 8192;
#if defined(AFS_VFS32) || defined(AFS_VFS40)
    afsp->vfs_fsid.val[1] = AFS_MOUNT_AFS;  /* U of M needs this for NFS/AFS xlator */
#endif AFS_VFS
#ifdef	AFS_AIX_ENV
	/* For AFS, we don't allow file over file mounts! This condition should go out of the ifdef and used by all OSs... */
	if (afsp->vfs_mntdover->v_type != VDIR)
	    return(ENOTDIR);
	error = afs_root(afsp, &afsrootvp);
	if (error) error;
	/* The setting of afs root is done in afs_root since that routine is called often (via lookupname), and setting it there prevent us from temporarily losing the root volume whenever it changes... 
	afsp->vfs_mntd = afsrootvp; 
	 */
	afsp->vfs_mntdover->v_mvfsp = afsp;
	afsp->vfs_flag |= VFS_REMOTE;
#endif
#ifdef MM_XXX
#else
#ifdef	AFS_MACH_ENV
    afsp->vfs_flag |= VFS_NOSUID;
#endif	AFS_MACH_ENV
#endif
    return 0;
}

#ifdef	AFS_AIX_ENV
afs_unmount (afsp, flag)
    int flag;
#else
afs_unmount (afsp)
#endif
    struct vfs *afsp; {
#ifdef	AFS_GFS_ENV
    register dev_t dev = ((struct mount *)(afsp->vfs_data))->m_dev;
#endif	AFS_GFS_ENV
    afs_globalVFS = 0;
#ifdef	AFS_GFS_ENV
/* Should free swap image of all unused saved-text text AFS segments */
    xumount(dev);
/* Make sure all write-behind blocks on dev AFS are flushed out... */
    bflush(dev);
#endif	AFS_GFS_ENV
/*  afs_shutdown(); DON'T do this any more! */
    return 0;
}

afs_root (afsp, avpp)
    struct vfs *afsp;
    struct vnode **avpp; {
    register long code;
    struct vrequest treq;
    register struct vcache *tvp;

    afs_InitReq(&treq, &osi_cred);
    if (code = afs_CheckInit()) return code;
    tvp = afs_GetVCache(&afs_rootFid, &treq);
    /* we really want this to stay around */
    if (!tvp) return ENOENT;
    if (tvp->vrefCount < 20000) tvp->vrefCount++;
    tvp->v.v_flag |= VROOT;	    /* No-op on Ultrix 2.2 */
    afs_globalVFS = afsp;
    *avpp = (struct vnode *) tvp;
#ifdef	AFS_AIX_ENV
    afsp->vfs_mntd = *avpp;	  
#endif
    return 0;
}

afs_sync(afsp)
    struct vfs *afsp; {
    return 0;
}

afs_statfs(afsp, abp)
    register struct vfs *afsp;
    struct statfs *abp; {

	abp->f_type = 0;
	abp->f_bsize = afsp->vfs_bsize;
	/* Fake a high number below to satisfy programs that use the ustat (for AIX), or statfs (for the rest) call to make sure that there's enough space in the device partition before storing something there (like ed(1)) */
	abp->f_blocks = abp->f_bfree = abp->f_bavail = abp->f_files = abp->f_ffree  = 9000000;	/* XXX */
#ifdef	AFS_AIX_ENV
	/* AIX specific stafs fields */
	abp->f_version = 0;
	abp->f_vfstype = AFS_MOUNT_AFS;
	abp->f_vfsnumber = afsp->vfs_number;
	abp->f_nlsdirtype = abp->f_vfsoff = abp->f_vfslen = abp->f_vfsvers = -1;
#endif
	return 0;
}

#ifdef	AFS_GATEWAY
afs_vget(afsp, avcp, fidp)
struct vfs *afsp;
struct vcache **avcp;
struct fid *fidp;
{
    struct VenusFid afid;
    struct vrequest treq;
    register long code = 0;

    bcopy(fidp->fid_data, &afid, fidp->fid_len);
    afs_InitReq(&treq, u.u_cred);
    *avcp = afs_GetVCache(&afid, &treq);
    if (! *avcp) {
	code = ENOENT;
    }
    return afs_CheckCode(code, &treq);
}
#else	AFS_GATEWAY
#ifdef AFS_VFS34
/* get a vnode by fid; not used by us */
afs_vget() {
    panic("afs vget");
}
#endif
#endif	AFS_GATEWAY

#ifdef	AFS_VFS40
/* This is only called by vfs_mount when afs is going to be mounted as root; since we don't support diskless clients we shouldn't come here. */
int afsmountroot=0;
afs_mountroot() {
    afs_dp("Entering afs_mountroot:Isn't imlemented!!\n");
    afsmountroot++;
    return(EINVAL);
}

/* It's called to setup swapping over the net for diskless clients; again not for us. */
int afsswapvp=0;
afs_swapvp() {
    afs_dp("Entering afs_swapvp: Isn't imlemented yet!\n");
    afsswapvp++;
    return(EINVAL);
}
#endif	AFS_VFS40
