/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	auth.h,v $
 * Revision 2.3  89/06/03  15:30:18  jsb
 * 	Merged with newer ITC sources.
 * 	[89/06/02  01:26:42  jsb]
 * 
 * Revision 2.2  89/04/22  15:16:11  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/*
 * auth.h:
 * This file is automatically generated; please do not edit it.
 */
/* Including auth.p.h at beginning of auth.h file. */

/*
 * P_R_P_Q_# (C) COPYRIGHT IBM CORPORATION 1987, 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */

#ifndef __AUTH_AFS_INCL_
#define	__AUTH_AFS_INCL_    1

		/* no ticket good for longer than 30 days */
#define MAXKTCTICKETLIFETIME (30*24*3600)
#define MINKTCTICKETLEN	      32
#define	MAXKTCTICKETLEN	      344
#define	MAXKTCNAMELEN	      64	/* name & inst should be 256 */
#define MAXKTCREALMLEN	      64	/* should be 256 */
#define KTC_TIME_UNCERTAINTY (15*60)	/* max skew separating machines' clocks */

struct ktc_encryptionKey {
    char data[8];
};

struct ktc_token {
    long startTime;
    long endTime;
    struct ktc_encryptionKey sessionKey;
    short kvno;
    int ticketLen;
    char ticket[MAXKTCTICKETLEN];
};

struct ktc_principal {
    char name[MAXKTCNAMELEN];
    char instance[MAXKTCNAMELEN];
    char cell[MAXKTCREALMLEN];
};

#if 0
#define	KTC_ERROR	1	/* an unexpected error was encountered */
#define	KTC_TOOBIG	2	/* a buffer was too small for the response */
#define	KTC_INVAL	3	/* an invalid argument was passed in */
#define	KTC_NOENT	4	/* no such entry */
#endif

#endif __AUTH_AFS_INCL_

/* End of prolog file auth.p.h. */

#define KTC_ERROR                                (11862784L)
#define KTC_TOOBIG                               (11862785L)
#define KTC_INVAL                                (11862786L)
#define KTC_NOENT                                (11862787L)
#define KTC_PIOCTLFAIL                           (11862788L)
extern void initialize_ktc_error_table ();
#define ERROR_TABLE_BASE_ktc (11862784L)

/* for compatibility with older versions... */
#define init_ktc_err_tbl initialize_ktc_error_table
#define ktc_err_base ERROR_TABLE_BASE_ktc
