/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	Kcallback.ss.c,v $
 * Revision 2.3  89/06/03  15:33:28  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:09:35  jsb]
 * 
 * Revision 2.2  89/04/22  15:17:57  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/* Machine generated file -- Do NOT edit */

#include <afsint/afscbint.h>
long _RXAFSCB_CallBack(z_call, z_xdrs)
	struct rx_call *z_call;
	XDR *z_xdrs;
{
	long z_result;
	AFSCBFids Fids_Array;
	AFSCBs CallBacks_Array;


	Fids_Array.AFSCBFids_val = 0;
	CallBacks_Array.AFSCBs_val = 0;
	if ((!xdr_AFSCBFids(z_xdrs, &Fids_Array))
	     || (!xdr_AFSCBs(z_xdrs, &CallBacks_Array))) {
		z_result = RXGEN_SS_UNMARSHAL;
		goto fail;
	}

	z_result = RXAFSCB_CallBack(z_call, &Fids_Array, &CallBacks_Array);
fail:
	z_xdrs->x_op = XDR_FREE;
	if (!xdr_AFSCBFids(z_xdrs, &Fids_Array)) goto fail1;
	if (!xdr_AFSCBs(z_xdrs, &CallBacks_Array)) goto fail1;
	return z_result;
fail1:
	return RXGEN_SS_XDRFREE;
}

long _RXAFSCB_InitCallBackState(z_call, z_xdrs)
	struct rx_call *z_call;
	XDR *z_xdrs;
{
	long z_result;


	z_result = RXAFSCB_InitCallBackState(z_call);
fail:
	return z_result;
}

long _RXAFSCB_Probe(z_call, z_xdrs)
	struct rx_call *z_call;
	XDR *z_xdrs;
{
	long z_result;


	z_result = RXAFSCB_Probe(z_call);
fail:
	return z_result;
}


long _RXAFSCB_CallBack();
long _RXAFSCB_InitCallBackState();
long _RXAFSCB_Probe();

static long (*StubProcsArray0[])() = {_RXAFSCB_CallBack, _RXAFSCB_InitCallBackState, _RXAFSCB_Probe};

RXAFSCB_ExecuteRequest(z_call)
	register struct rx_call *z_call;
{
	int op;
	XDR z_xdrs;
	long z_result;

	xdrrx_create(&z_xdrs, z_call, XDR_DECODE);
	if (!xdr_int(&z_xdrs, &op))
		z_result = RXGEN_DECODE;
	else if (op < RXAFSCB_LOWEST_OPCODE || op > RXAFSCB_HIGHEST_OPCODE)
		z_result = RXGEN_OPCODE;
	else
		z_result = (*StubProcsArray0[op - RXAFSCB_LOWEST_OPCODE])(z_call, &z_xdrs);
	return z_result;
}
