/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	Kvice.xdr.c,v $
 * Revision 2.3  89/06/03  15:33:58  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:10:10  jsb]
 * 
 * Revision 2.2  89/04/22  15:18:17  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */
/* Machine generated file -- Do NOT edit */

#include <afsint/afsint.h>



bool_t
xdr_AFSFid(xdrs, objp)
	XDR *xdrs;
	AFSFid *objp;
{
	if (!xdr_u_long(xdrs, &objp->Volume)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Vnode)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Unique)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSCallBack(xdrs, objp)
	XDR *xdrs;
	AFSCallBack *objp;
{
	if (!xdr_u_long(xdrs, &objp->CallBackVersion)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ExpirationTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->CallBackType)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSOpaque(xdrs, objp)
	XDR *xdrs;
	AFSOpaque *objp;
{
	if (!xdr_bytes(xdrs, (char **)&objp->AFSOpaque_val, (u_int *)&objp->AFSOpaque_len, AFSOPAQUEMAX)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSCBFids(xdrs, objp)
	XDR *xdrs;
	AFSCBFids *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->AFSCBFids_val, (u_int *)&objp->AFSCBFids_len, AFSCBMAX, sizeof(AFSFid), xdr_AFSFid)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSCBs(xdrs, objp)
	XDR *xdrs;
	AFSCBs *objp;
{
	if (!xdr_array(xdrs, (char **)&objp->AFSCBs_val, (u_int *)&objp->AFSCBs_len, AFSCBMAX, sizeof(AFSCallBack), xdr_AFSCallBack)) {
		return (FALSE);
	}
	return (TRUE);
}


#define VICECONNBAD	1234
#define VICETOKENDEAD	1235
#define AFS_LOCKWAIT	(5*60)
#define CALLBACK_VERSION	1


bool_t
xdr_VolumeId(xdrs, objp)
	XDR *xdrs;
	VolumeId *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_VolId(xdrs, objp)
	XDR *xdrs;
	VolId *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_VnodeId(xdrs, objp)
	XDR *xdrs;
	VnodeId *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_Unique(xdrs, objp)
	XDR *xdrs;
	Unique *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_UserId(xdrs, objp)
	XDR *xdrs;
	UserId *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_FileVersion(xdrs, objp)
	XDR *xdrs;
	FileVersion *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_Date(xdrs, objp)
	XDR *xdrs;
	Date *objp;
{
	if (!xdr_u_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_ErrorCode(xdrs, objp)
	XDR *xdrs;
	ErrorCode *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_Rights(xdrs, objp)
	XDR *xdrs;
	Rights *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_ViceFid(xdrs, objp)
	XDR *xdrs;
	ViceFid *objp;
{
	if (!xdr_u_long(xdrs, &objp->Volume)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Vnode)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Unique)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_ViceDataType(xdrs, objp)
	XDR *xdrs;
	ViceDataType *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}


#define Invalid 0
#define File 1 
#define Directory 2 
#define SymbolicLink 3 


bool_t
xdr_BD(xdrs, objp)
	XDR *xdrs;
	BD *objp;
{
	if (!xdr_long(xdrs, &objp->host)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->portal)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->session)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSVolSync(xdrs, objp)
	XDR *xdrs;
	AFSVolSync *objp;
{
	if (!xdr_u_long(xdrs, &objp->spare1)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare2)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare3)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare4)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare5)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare6)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSOldFetchStatus(xdrs, objp)
	XDR *xdrs;
	AFSOldFetchStatus *objp;
{
	if (!xdr_u_long(xdrs, &objp->InterfaceVersion)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->FileType)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->LinkCount)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Length)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->DataVersion)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Author)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Owner)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->CallerAccess)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->AnonymousAccess)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->UnixModeBits)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ParentVnode)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ParentUnique)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->SegSize)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ClientModTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ServerModTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Group)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSFetchStatus(xdrs, objp)
	XDR *xdrs;
	AFSFetchStatus *objp;
{
	if (!xdr_u_long(xdrs, &objp->InterfaceVersion)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->FileType)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->LinkCount)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Length)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->DataVersion)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Author)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Owner)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->CallerAccess)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->AnonymousAccess)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->UnixModeBits)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ParentVnode)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ParentUnique)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->SegSize)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ClientModTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ServerModTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Group)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->SyncCounter)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare1)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare2)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare3)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->spare4)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSStoreStatus(xdrs, objp)
	XDR *xdrs;
	AFSStoreStatus *objp;
{
	if (!xdr_u_long(xdrs, &objp->Mask)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ClientModTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Owner)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Group)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->UnixModeBits)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->SegSize)) {
		return (FALSE);
	}
	return (TRUE);
}


#define	AFS_SETMODTIME	1
#define	AFS_SETOWNER	2
#define	AFS_SETGROUP		4
#define	AFS_SETMODE		8
#define	AFS_SETSEGSIZE	16


bool_t
xdr_ViceVolumeType(xdrs, objp)
	XDR *xdrs;
	ViceVolumeType *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}


#define ReadOnly 0
#define ReadWrite 1


bool_t
xdr_DiskName(xdrs, objp)
	XDR *xdrs;
	DiskName objp;
{
	if (!xdr_opaque(xdrs, objp, AFS_DISKNAMESIZE)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_ViceDisk(xdrs, objp)
	XDR *xdrs;
	ViceDisk *objp;
{
	if (!xdr_long(xdrs, &objp->BlocksAvailable)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->TotalBlocks)) {
		return (FALSE);
	}
	if (!xdr_DiskName(xdrs, objp->Name)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_ViceStatistics(xdrs, objp)
	XDR *xdrs;
	ViceStatistics *objp;
{
	if (!xdr_u_long(xdrs, &objp->CurrentMsgNumber)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->OldestMsgNumber)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->CurrentTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->BootTime)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->StartTime)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->CurrentConnections)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalViceCalls)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalFetchs)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->FetchDatas)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->FetchedBytes)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->FetchDataRate)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalStores)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->StoreDatas)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->StoredBytes)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->StoreDataRate)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalRPCBytesSent)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalRPCBytesReceived)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalRPCPacketsSent)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalRPCPacketsReceived)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalRPCPacketsLost)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->TotalRPCBogusPackets)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->SystemCPU)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->UserCPU)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->NiceCPU)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->IdleCPU)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->TotalIO)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ActiveVM)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->TotalVM)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->EtherNetTotalErrors)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->EtherNetTotalWrites)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->EtherNetTotalInterupts)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->EtherNetGoodReads)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->EtherNetTotalBytesWritten)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->EtherNetTotalBytesRead)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ProcessSize)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->WorkStations)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ActiveWorkStations)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare1)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare2)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare3)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare4)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare5)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare6)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare7)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Spare8)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk1)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk2)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk3)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk4)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk5)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk6)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk7)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk8)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk9)) {
		return (FALSE);
	}
	if (!xdr_ViceDisk(xdrs, &objp->Disk10)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_VolumeStatus(xdrs, objp)
	XDR *xdrs;
	VolumeStatus *objp;
{
	if (!xdr_long(xdrs, &objp->Vid)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ParentId)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Online)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->InService)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Blessed)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->NeedsSalvage)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->MinQuota)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->MaxQuota)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->BlocksInUse)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->PartBlocksAvail)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->PartMaxBlocks)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSFetchVolumeStatus(xdrs, objp)
	XDR *xdrs;
	AFSFetchVolumeStatus *objp;
{
	if (!xdr_long(xdrs, &objp->Vid)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->ParentId)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Online)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->InService)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->Blessed)) {
		return (FALSE);
	}
	if (!xdr_char(xdrs, &objp->NeedsSalvage)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Type)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->MinQuota)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->MaxQuota)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->BlocksInUse)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->PartBlocksAvail)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->PartMaxBlocks)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSStoreVolumeStatus(xdrs, objp)
	XDR *xdrs;
	AFSStoreVolumeStatus *objp;
{
	if (!xdr_long(xdrs, &objp->Mask)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->MinQuota)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->MaxQuota)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_AFSVolumeInfo(xdrs, objp)
	XDR *xdrs;
	AFSVolumeInfo *objp;
{
	if (!xdr_u_long(xdrs, &objp->Vid)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Type)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type0)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type1)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type2)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type3)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type4)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ServerCount)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server0)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server1)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server2)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server3)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server4)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server5)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server6)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server7)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port0)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port1)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port2)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port3)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port4)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port5)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port6)) {
		return (FALSE);
	}
	if (!xdr_u_short(xdrs, &objp->Port7)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_VolumeInfo(xdrs, objp)
	XDR *xdrs;
	VolumeInfo *objp;
{
	if (!xdr_u_long(xdrs, &objp->Vid)) {
		return (FALSE);
	}
	if (!xdr_long(xdrs, &objp->Type)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type0)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type1)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type2)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type3)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Type4)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->ServerCount)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server0)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server1)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server2)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server3)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server4)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server5)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server6)) {
		return (FALSE);
	}
	if (!xdr_u_long(xdrs, &objp->Server7)) {
		return (FALSE);
	}
	return (TRUE);
}




bool_t
xdr_ViceLockType(xdrs, objp)
	XDR *xdrs;
	ViceLockType *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}


#define LockRead		0
#define LockWrite		1
#define LockExtend	2
#define LockRelease	3


bool_t
xdr_ViceOfflineType(xdrs, objp)
	XDR *xdrs;
	ViceOfflineType *objp;
{
	if (!xdr_long(xdrs, objp)) {
		return (FALSE);
	}
	return (TRUE);
}


#define NoSalvage 0
#define Salvage 1
