/* 
 * Mach Operating System
 * Copyright (c) 1988, 1989, 1990 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2emul/macdefs.h
 *	Author: David E. Bohman II (CMU macmach)
 */

/*
 * RCS documentation
 *
 * $Header$
 *
 * $Log$
 */

#include <sys/buf.h>

/*
 * macintosh emulation data
 * structures
 */

struct mac_internal {
    struct act *	intr;		/* thread's interrupt activity */
    struct softintr {
	unsigned long	vector;		/* address of interrupt vector */
	unsigned long	ipl;		/* priority level of interrupt */
	int		flags;
#define MAC_IF_PEND	0x00000001	/* true if interrupt is pending */
#define MAC_IF_ENB	0x00000002	/* true if interrupt is enabled */
    } softintr[7];			/* software interrupt vector table */
#define MAC_INTR_INTR	0
#define MAC_INTR_ASC	1
#define MAC_INTR_TIMER1	2
#define MAC_INTR_TIMER2	3
#define MAC_INTR_INP	4
#define MAC_INTR_CLK	5
#define MAC_INTR_SR	6
    struct via_device {			/* VIA emulation */
	struct via_port {
	    unsigned char	dir;	/* data direction register */
	    unsigned char	reg;	/* data output latch */
	    unsigned char	dat;	/* data input value */
	} portA, portB;
	unsigned char	ACR;		/* auxiliary control register */
	unsigned char	PCR;		/* peripheral control register */
	unsigned char	IFR;		/* interrupt flag register */
	unsigned char	IER;		/* interrupt enable register */
	unsigned char	T1CH;
	unsigned char	T1CL;
	unsigned char	T2CH;
	unsigned char	T2CL;
    } via1, via2;
    unsigned long	adb_trans_state;
#define ADB_TRANS_CMD	0x0
#define ADB_TRANS_EVEN	0x1
#define ADB_TRANS_ODD	0x2
#define ADB_TRANS_IDLE	0x3
    struct scsi_data {			/* scsi manager */
	struct buf	sc_buf;
	int		sc_flags;
#define SCSI_F_READ	1
#define SCSI_F_WRITE	2
    } scsi;
    unsigned short	sr;		/* software status register */
    unsigned long	ctrl[8];	/* software cpu registers */
#define R_SFC		0
#define R_DFC		1
#define R_CACR		2
#define R_USP		3
#define R_VBR		4
#define R_CAAR		5
#define R_MSP		6
#define R_ISP		7
    struct pmmu_regs {
	unsigned long	TC;
	unsigned long	CRP[2];
    } pmmu;
    int			flags;
#define	MAC_F_24BIT	0x00000001
    unsigned long	envp;		/* ptr to environment vector */
};

/*
 * Initial values
 * for machine registers
 */
#define CTRL_INIT(n)	mac->ctrl[n] = INIT_##n

#define INIT_R_SR   0x2000
#define INIT_R_SFC  0x0
#define INIT_R_DFC  0x0
#define INIT_R_CACR 0x0
#define INIT_R_USP  0x0
#define INIT_R_VBR  0x0
#define INIT_R_CAAR 0x0
#define INIT_R_MSP  0x0
#define INIT_R_ISP  0x0

/*
 * Format of
 * status register
 */
struct status_reg {
  union {
    struct {
      unsigned short t1:1,
                     t0:1,
                     s:1,
                     m:1,
                     :1,
                     ipl:3,
                     :3,
                     x:1,
                     n:1,
                     z:1,
                     v:1,
                     c:1;
    } bits;
    struct {
      unsigned char system;
      unsigned char user;
    } bytes;
  } sr_un;
};
#define sr_t1 sr_un.bits.t1
#define sr_t0 sr_un.bits.t0
#define sr_s sr_un.bits.s
#define sr_m sr_un.bits.m
#define sr_ipl sr_un.bits.ipl
#define sr_x sr_un.bits.x
#define sr_n sr_un.bits.n
#define sr_z sr_un.bits.z
#define sr_v sr_un.bits.v
#define sr_c sr_un.bits.c
#define sr_sys sr_un.bytes.system
#define sr_user sr_un.bytes.user
#define sr_cc sr_user

#ifdef	KERNEL
extern int	mac_emul;
#define MAC_EMUL_LINE_1010	0x01
#define MAC_EMUL_PRIV_INST	0x02
#define MAC_EMUL_BUS_ERR	0x04
#endif	KERNEL
