/* 
 * Mach Operating System
 * Copyright (c) 1990 Carnegie-Mellon University
 * Copyright (c) 1989 Carnegie-Mellon University
 * Copyright (c) 1988 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log$
 */

/*
 *	Apple Macintosh II Mach (macmach)
 *
 *	File: mac2/mac2_init.c
 *	Author: David E. Bohman II (CMU macmach)
 */

#include <sys/types.h>

#include <mach/vm_param.h>
#include <mach/vm_prot.h>

#include <vm/vm_page.h>

#include <mac2/vm_param.h>

vm_offset_t	avail_start, avail_end;
vm_offset_t	virtual_avail, virtual_end;

mac2_init()
{
    page_size = MAC2_PGBYTES;
    vm_set_page_size();

    /*
     * Setup the interrupt vector
     * table.
     */
    ivect_init();

    /*
     *	Initialize kernel physical map.
     *	Kernel virtual address starts at VM_KERNEL_MIN_ADDRESS.
     */
    avail_start = first_addr;
    avail_end = last_addr;

    pmap_bootstrap(&avail_start, &avail_end, &virtual_avail, &virtual_end);
}
