/* 
 * Mach Operating System
 * Copyright (c) 1989 Carnegie-Mellon University
 * All rights reserved.  The CMU software License Agreement specifies
 * the terms and conditions for use and redistribution.
 */
/*
 * HISTORY
 * $Log:	xdr_rx.c,v $
 * Revision 2.3  89/06/03  15:41:12  jsb
 * 	Merged with newer ITC sources.
 * 	[89/05/26  22:26:11  jsb]
 * 
 * Revision 2.2  89/04/22  15:30:00  gm0w
 * 	Updated to RX version.
 * 	[89/04/14            gm0w]
 * 
 */

/*
****************************************************************************
*        Copyright IBM Corporation 1988, 1989 - All Rights Reserved        *
*                                                                          *
* Permission to use, copy, modify, and distribute this software and its    *
* documentation for any purpose and without fee is hereby granted,         *
* provided that the above copyright notice appear in all copies and        *
* that both that copyright notice and this permission notice appear in     *
* supporting documentation, and that the name of IBM not be used in        *
* advertising or publicity pertaining to distribution of the software      *
* without specific, written prior permission.                              *
*                                                                          *
* IBM DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL IBM *
* BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY      *
* DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER  *
* IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING   *
* OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.    *
****************************************************************************
*/

/*
 * xdr_rx.c.  XDR using RX. 
 */

#ifdef	KERNEL
#include <sys/types.h>
#include <sys/uio.h>
#include <rpc/types.h>
#include <rpc/xdr.h>
#include <netinet/in.h>
#include <rx/rx.h>
#else	KERNEL
#include <sys/types.h>
#include <stdio.h>
#include <netinet/in.h>
#include "xdr.h"
#include "rx.h"
#endif	KERNEL

static bool_t	xdrrx_getlong();
static bool_t	xdrrx_putlong();
static bool_t	xdrrx_getbytes();
static bool_t	xdrrx_putbytes();
static long *	xdrrx_inline();
void		xdrrx_destroy();

/*
 * Ops vector for stdio type XDR
 */
static struct xdr_ops	xdrrx_ops = {
	xdrrx_getlong,	/* deserialize a long int */
	xdrrx_putlong,	/* serialize a long int */
	xdrrx_getbytes,	/* deserialize counted bytes */
	xdrrx_putbytes,	/* serialize counted bytes */
	0,		/* get offset in the stream: not supported. */
	0,		/* set offset in the stream: not supported. */
	xdrrx_inline,	/* prime stream for inline macros */
	0,		/* destroy stream */
};

/*
 * Initialize an rx xdr handle, for a given rx call.  op must be XDR_ENCODE or XDR_DECODE.
 * Call must have been returned by rx_MakeCall or rx_GetCall.  Stream should be a pointer to a local rx_stream structure.
 */
void
xdrrx_create(xdrs, call, op)
	register XDR *xdrs;
	register struct rx_call *call;
	register enum xdr_op op;
{
	xdrs->x_op = op;
	xdrs->x_ops = &xdrrx_ops;
	xdrs->x_private = (caddr_t) call;
}

static bool_t
xdrrx_getlong(xdrs, lp)
	register XDR *xdrs;
	register long *lp;
{
	long l;
	register struct rx_call *call = ((struct rx_call *) (xdrs)->x_private);
	if (rx_Read(call, &l, sizeof(l)) == sizeof(l)) {
	    *lp = ntohl(l);
	    return TRUE;
	}
	return FALSE;
}

static bool_t
xdrrx_putlong(xdrs, lp)
	register XDR *xdrs;
	register long *lp;
{
	long l = htonl(*lp);
	register struct rx_call *call = ((struct rx_call *) (xdrs)->x_private);
	return (rx_Write(call, &l, sizeof(l)) == sizeof(l));
}

static bool_t
xdrrx_getbytes(xdrs, addr, len)
	register XDR *xdrs;
	register caddr_t addr;
	register u_int len;
{
	register struct rx_call *call = ((struct rx_call *) (xdrs)->x_private);
	return (rx_Read(call, addr, len) == len);
}

static bool_t
xdrrx_putbytes(xdrs, addr, len)
	register XDR *xdrs;
	register caddr_t addr;
	register u_int len;
{
	register struct rx_call *call = ((struct rx_call *) (xdrs)->x_private);
	return (rx_Write(call, addr, len) == len);
}

static u_int
xdrrx_getpos(xdrs)
	register XDR *xdrs;
{
        /* Not supported.  What error code should we return? (It doesn't matter:  it will never be called, anyway!) */
        return -1;
}

static bool_t
xdrrx_setpos(xdrs, pos) 
	register XDR *xdrs;
	u_int pos;
{ 
        /* Not supported */
        return FALSE;
}

static long *
xdrrx_inline(xdrs, len)
	register XDR *xdrs;
	register u_int len;
{
        /* I don't know what this routine is supposed to do, but the stdio module returns null, so we will, too */
	return (0);
}
