	TITLE	'FIG FORTH - 10/25/80   CRL & MHM'
	PAGE	60
*8080*FIG*FORTH******V4.0(C)1978 FORTH INTEREST GROUP
*       * IMPLEMENTATION BY  * 790503
*       *    JOHN CASSADY    *
*       *  339 15TH STREET   *
*       *  OAKLAND,CA 94612  *
*       **********************
NSROM    EQU   0E91EH           ;  NORTHSTAR DISK READ COMMAND
EM       EQU   5D00H            ;  TOP OF MEMORY + 1 = LIMIT
CO       EQU   404H             ;  404H DISK BUFFER = FIRST
US       EQU   64               ;  USER SPACE
RTS      EQU   128              ;  RETURN & TERM BUFF SPACE

;
;	TEMP ORG @ 2A00 (NORTH STAR) FOR LISTING PROOF
;
	ORG	2A00H
;
ORIG     LXI   B,$+6            ;  VECTOR TO COLD
         JMP   NEXT
         DW    COLD
         JMP   $-3              ;  VECTOR TO WARM
         DW    0                ;  RESERVED
         DW    0                ;  COMPUTER
         DW    TASK-7           ;  FIRST WORD IN FORTH VOCAB
         DW    7FH              ;  BKSPACE CHARACTER
         DW    EM-CO-US         ;  INIT U0
         DW    EM-CO-US-RTS     ;  INIT S0
         DW    EM-CO-US         ;  INIT R0
         DW    EM-CO-US-RTS     ;  INIT TIB
         DW    32               ;  INIT WIDTH
         DW    0                ;  INIT WARNING
         DW    TASK+4           ;  INIT FENCE
         DW    TASK+4           ;  INIT DP
         DW    FORTH+6          ;  INIT VOC-LINK
*
UP       DW    EM-CO-US         ;  USER AREA POINTER
RSP       DW    EM-CO-US         ;  RETURN STACK POINTER
N        DS    14H              ;  SCRAT FOR DIV ETC
*
         PUSH  D
         PUSH  H
NEXT     LDAX  B
         INX   B
         MOV   L,A
         LDAX  B
         INX   B
         MOV   H,A              ;  HL=CFA
         MOV   E,M
         INX   H
         MOV   D,M
         XCHG
         PCHL
*
         DB    83H              ;  LIT
         DB   'LI'
         DB    'T'+80H
         DW    0                ;  MARKS END OF DICTIONARY
LIT      DW    $+2
         LDAX  B
         INX   B
         MOV   L,A
         LDAX  B                ;                PAGE02
         INX   B
         MOV   H,A
         JMP   NEXT-1
*
         DB    87H              ;  EXECUTE
         DB   'EXECUT'
         DB    'E'+80H
         DW    LIT-6
EXEC     DW    $+2
         POP   H                ;  CFA
         JMP   NEXT+6
*
         DB    86H              ;  BRANCH
         DB   'BRANC'
         DB    'H'+80H
         DW    EXEC-10
BRAN     DW    $+2
         MOV   H,B
         MOV   L,C
         MOV   E,M
         INX   H
         MOV   D,M
         DCX   H
         DAD   D
         MOV   C,L
         MOV   B,H
         JMP   NEXT
*
         DB    87H
         DB   '0BRANC'          ; 0BRANCH
         DB    'H'+80H
         DW    BRAN-9
ZBRAN    DW    $+2
         POP   H
         MOV   A,L
         ORA   H
         JZ    BRAN+2
         INX   B
         INX   B
         JMP   NEXT
*
         DB    86H              ;  (LOOP)
         DB   '(LOOP'
         DB    ')'+80H
         DW    ZBRAN-10
XLOOP    DW    $+2
         LXI   D,1
         XRI   0D1H
         LHLD  RSP
         MOV   A,M
         ADD   E                ;                PAGE03
         MOV   M,A
         MOV   E,A
         INX   H
         MOV   A,M
         ADC   D
         MOV   M,A
         MOV   D,A
         MOV   A,E
         INX   H
         SUB   M
         MOV   A,D
         INX   H
         SBB   M
         JC    BRAN+2
         INX   H
         SHLD  RSP
         INX   B
         INX   B
         JMP   NEXT
*
         DB    87H              ;  (+LOOP)
         DB   '(+LOOP'
         DB    ')'+80H
         DW    XLOOP-9
XPLOO    DW    XLOOP+6
*
         DB    84H              ;  -DO-
         DB   '(DO'
         DB    ')'+80H
         DW    XPLOO-10
XDO      DW    $+2
         POP   H
         XTHL
         XCHG
         LHLD  RSP
         DCX   H
         MOV   M,D
         DCX   H
         MOV   M,E
         POP   D
         DCX   H
         MOV   M,D
         DCX   H
         MOV   M,E
         SHLD  RSP
         JMP   NEXT
*
         DB    81H              ;  I
         DB    'I'+80H
         DW    XDO-7
I        DW    $+2
         LHLD  RSP
         MOV   E,M
         INX   H                ;                PAGE04
         MOV   D,M
         PUSH  D
         JMP   NEXT
*
         DB    85H              ;  DIGIT
         DB   'DIGI'
         DB    'T'+80H
         DW    I-4
DIGIT    DW    $+2
         POP   H
         POP   D
         MOV   A,E
         SUI   30H
         JM    DIGI2
         CPI   10
         JM    DIGI1
         SUI   7
         CPI   10
         JM    DIGI2
DIGI1    CMP   L
         JP    DIGI2
         MOV   E,A
         JMP   NEXT-2
DIGI2    MOV   L,H
         JMP   NEXT-1
*
         DB    86H              ;  (FIND)  (2-1)FAILURE
         DB   '(FIND'           ;         (2-3)SUCCESS
         DB    ')'+80H
         DW    DIGIT-8
PFIND    DW    $+2
         POP   D                ;  NFA
PFIN1    POP   H                ;  STRING ADRS
         PUSH  H
         LDAX  D
         XRA   M
         ANI   3FH
         JNZ   PFIN4
PFIN2    INX   H
         INX   D
         LDAX  D
         XRA   M
         ADD   A
         JNZ   PFIN3
         JNC   PFIN2
         LXI   H,5
         DAD   D
         XTHL
PFIN6    DCX   D
         LDAX  D
         ORA   A
         JP    PFIN6
         MOV   E,A
         MVI   D,0              ;                PAGE05
         LXI   H,1
         JMP   NEXT-2           ;  SUCCESS
PFIN3    JC    PFIN5
PFIN4    INX   D
         LDAX  D
         ORA   A
         JP    PFIN4
PFIN5    INX   D
         XCHG
         MOV   E,M
         INX   H
         MOV   D,M
         MOV   A,D
         ORA   E
         JNZ   PFIN1
         POP   H
         LXI   H,0
         JMP   NEXT-1           ;  FAILURE
*
         DB    87H              ;  ENCLOSE
         DB   'ENCLOS'
         DB    'E'+80H
         DW    PFIND-9
ENCL     DW    $+2
         POP   D
         POP   H
         PUSH  H
         MOV   A,L
         CMA
         MOV   L,A
         MOV   A,H
         CMA
         MOV   H,A
         INX   H
         SHLD  N+6
         POP   H
         PUSH  H
         DCX   H
         MOV   A,E
ENCL1    INX   H
         CMP   M
         JZ    ENCL1
         SHLD  N+4
         XRA   A
         ADD   M
         JZ    ENCL4
ENCL2    INX   H
         MOV   A,E
         CMP   M
         JZ    ENCL5
         XRA   A
         ADD   M
         JNZ   ENCL2
         SHLD  N                ;                PAGE06
         SHLD  N+2
         JMP   ENCL3
ENCL4    SHLD  N
         INX   H
         SHLD  N+2
         JMP   ENCL3
ENCL5    SHLD  N+2
         INX   H
         SHLD  N
ENCL3    LHLD  N+6
         XCHG
         LHLD  N+4
         DAD   D
         PUSH  H
         LHLD  N+2
         DAD   D
         PUSH  H
         LHLD  N
         DAD   D
         JMP   NEXT-1
*
         DB    84H              ;  EMIT
         DB   'EMI'
         DB    'T'+80H
         DW    ENCL-10
EMIT     DW    $+2
         JMP   PEMIT
*
         DB    83H              ;  KEY
         DB   'KE'
         DB    'Y'+80H
         DW    EMIT-7
KEY      DW    $+2
         JMP   PKEY
*
         DB    89H              ;  ?TERMINAL
         DB   '?TERMINA'
         DB    'L'+80H
         DW    KEY-6
QTERM    DW    $+2
         LXI   H,0
         JMP   PQTER
*
         DB    82H              ;  CR
         DB   'C'
         DB    'R'+80H
         DW    QTERM-12
CR       DW    $+2
         JMP   PCR
*
         DB    85H              ;  CMOVE
         DB   'CMOV'
         DB    'E'+80H
         DW    CR-5             ;                PAGE07
CMOVE    DW    $+2
         MOV   L,C
         MOV   H,B
         POP   B                ;  QTY
         POP   D                ;  TO
         XTHL                   ;  FROM
CMOV1    MOV   A,M
         INX   H
         STAX  D
         INX   D
         DCX   B
         MOV   A,B
         ORA   C
         JNZ   CMOV1
         POP   B
         JMP   NEXT
*
         DB    82H              ;  U*
         DB   'U'
         DB    '*'+80H
         DW    CMOVE-8
USTAR    DW    $+2
         POP   H
         POP   D
         PUSH  B
         SHLD  N
         XCHG
         SHLD  N+2
         LXI   H,0
         SHLD  N+4
         MVI   C,10H
         XRA   A
MULT2    LXI   H,N+5
         MVI   B,4
         CALL  SHFR
         LXI   H,N+4
         LXI   D,N
         MVI   B,2
         CC    BNADD-1
         DCR   C
         JNZ   MULT2
         MVI   B,4
         LXI   H,N+5
         CALL  SHFR
         POP   B
         LHLD  N+2
         XCHG
         LHLD  N+4
         JMP   NEXT-2           ;  DE=HI WORD; HL=LO WORD
SHFR     MOV   A,M
         RAR
         MOV   M,A
         DCX   H
         DCR   B
         JNZ   SHFR             ;                PAGE08
         RET
         XRA   A
BNADD    LDAX  D
         ADC   M
         MOV   M,A
         INX   H
         INX   D
         DCR   B
         JNZ   BNADD
         RET
*
         DB    82H              ;  U/
         DB   'U'
         DB    '/'+80H
         DW    USTAR-5
USLAS    DW    $+2
         POP   H
         SHLD  N
         LXI   H,0
         SHLD  N+2
         POP   H
         SHLD  N+6
         POP   H
         SHLD  N+4
         PUSH  B
         MVI   B,0CH
         XRA   A
         LXI   H,N+8
SCRIB    MOV   M,A
         INX   H
         DCR   B
         JNZ   SCRIB
         LXI   H,1
         SHLD  N+16
         MVI   B,4
         LXI   H,N
DZLP     XRA   A
         ADD   M
         JNZ   LEADZ-2
         INX   H
         DCR   B
         JNZ   DZLP
         LXI   H,0FFFFH
         XCHG
         LXI   H,0FFFFH
         POP   B
         JMP   NEXT-2           ;  DIV BY 0 ERROR
         MVI   C,-1
LEADZ    INR   C
         LXI   H,N+3
         MOV   A,M
         ORA   A
         LXI   H,N
         LXI   D,LEADZ
         PUSH  D                ;                PAGE09
         MVI   B,4
         STC
         CMC
         JP    SHFL
         POP   D
DIV5     XRA   A
         LXI   H,N+3
         MVI   B,4
         CALL  SHFR
         XRA   A
         LXI   H,N+8
         MVI   B,4
         CALL  SHFL
         LXI   H,N+4
         LXI   D,N+12
         MVI   B,4
         CALL  MOVE
         LXI   H,N
         LXI   D,N+12
         MVI   B,4
         XRA   A
         CALL  BNSUB
         LXI   H,N+15
         MOV   A,M
         ORA   A
         CP    STEP6
         DCR   C
         JNZ   DIV5
         LHLD  N+4
         XCHG
         LHLD  N+8
         POP   B
         JMP   NEXT-2
SHFL     MOV   A,M
         RAL
         MOV   M,A
         INX   H
         DCR   B
         JNZ   SHFL
         RET
STEP6    LXI   H,N+12
         LXI   D,N+4
         MVI   B,4
         CALL  MOVE
         LXI   H,N+8
         LXI   D,N+16
         MVI   B,4
         XRA   A
         CALL  BNADD
         RET
BNSUB    LDAX  D
         SBB   M
         STAX  D
         INX   H
         INX   D                ;                PAGE10
         DCR   B
         JNZ   BNSUB
         RET
MOVE      MOV   A,M
         STAX  D
         INX   H
         INX   D
         DCR   B
         JNZ   MOVE
         RET
*
         DB    83H              ;  AND
	DB	'AN'
	DB	'D'+80H
         DW    USLAS-5
AND@      DW    $+2
         POP   D
         POP   H
         MOV   A,E
         ANA   L
         MOV   L,A
         MOV   A,D
         ANA   H
         MOV   H,A
         JMP   NEXT-1
*
         DB    82H              ;  OR
         DB   'O'
         DB    'R'+80H
         DW    AND@-6
OR@       DW    $+2
         POP   D
         POP   H
         MOV   A,E
         ORA   L
         MOV   L,A
         MOV   A,D
         ORA   H
         MOV   H,A
         JMP   NEXT-1
*
         DB    83H              ;  XOR
         DB   'XO'
         DB    'R'+80H
         DW    OR@-5
XOR@      DW    $+2
         POP   D
         POP   H
         MOV   A,E
         XRA   L
         MOV   L,A
         MOV   A,D
         XRA   H
         MOV   H,A
         JMP   NEXT-1           ;                PAGE11
*
         DB    83H              ;  SP@
         DB   'SP'
         DB    '@'+80H
         DW    XOR@-6
SPAT     DW    $+2
         LXI   H,0
         DAD   SP
         JMP   NEXT-1
*
         DB    83H              ;  SP|
         DB   'SP'
         DB    '!'+80H
         DW    SPAT-6
SPSTO    DW    $+2
         LHLD  UP
         LXI   D,6
         DAD   D
         MOV   E,M
         INX   H
         MOV   D,M
         XCHG
         SPHL
         JMP   NEXT
*
         DB    83H              ;  RP|
         DB   'RP'
         DB    '!'+80H
         DW    SPSTO-6
RPSTO    DW    $+2
         LHLD  UP
         LXI   D,8
         DAD   D
         MOV   E,M
         INX   H
         MOV   D,M
         XCHG
         SHLD  RSP
         JMP   NEXT
*
         DB    82H              ;  ;S
         DB   ';'
         DB    'S'+80H
         DW    RPSTO-6
SEMIS    DW    $+2
         LHLD  RSP
         MOV   C,M
         INX   H
         MOV   B,M
         INX   H
         SHLD  RSP
         JMP   NEXT
*
         DB    85H              ;  LEAVE
         DB   'LEAV'            ;               PAGE12
         DB    'E'+80H
         DW    SEMIS-5
LEAVE    DW    $+2
         LHLD  RSP
         MOV   E,M
         INX   H
         MOV   D,M
         INX   H
         MOV   M,E
         INX   H
         MOV   M,D
         JMP   NEXT
*
         DB    82H              ;  >R
         DB   '>'
         DB    'R'+80H
         DW    LEAVE-8
TOR      DW    $+2
         LHLD  RSP
         POP   D
         DCX   H
         MOV   M,D
         DCX   H
         MOV   M,E
         SHLD  RSP
         JMP   NEXT
*
         DB    82H              ;  R>
         DB   'R'
         DB    '>'+80H
         DW    TOR-5
FROMR    DW    $+2
         LHLD  RSP
         MOV   E,M
         INX   H
         MOV   D,M
         INX   H
         PUSH  D
         SHLD  RSP
         JMP   NEXT
*
         DB    81H              ;  R
         DB    'R'+80H
         DW    FROMR-5
R        DW    $+2
         LHLD  RSP
         MOV   E,M
         INX   H
         MOV   D,M
         PUSH  D
         JMP   NEXT
*
         DB    82H              ;  0=
         DB   '0'
         DB    '='+80H          ;                 PAGE13
         DW    R-4
ZEQU     DW    $+2
         POP   H
         MOV   A,L
         ORA   H
         LXI   H,0
         JNZ   ZEQU1
         INX   H
ZEQU1    JMP   NEXT-1
*
         DB    82H               ; 0<
         DB   '0'
         DB    '<'+80H
         DW    ZEQU-5
ZLESS    DW    $+2
         POP   H
         DAD   H
         LXI   H,0
         JNC   ZLES1
         INX   H
ZLES1    JMP   NEXT-1
*
         DB    81H               ; +
         DB    '+'+80H
         DW    ZLESS-5
PLUS     DW    $+2
         POP   D
         POP   H
         DAD   D
         JMP   NEXT-1
*
         DB    82H               ; D+    (4-2)
         DB   'D'
         DB    '+'+80H
         DW    PLUS-4
DPLUS    DW    $+2
         POP   H
         SHLD  N+2               ; A HI
         POP   H
         SHLD  N                 ; A LO
         POP   H
         SHLD  N+6               ; B HI
         POP   H
         SHLD  N+4               ; B LO
         PUSH  B
         LXI   H,N
         LXI   D,N+4
         MVI   B,4
         CALL  BNADD-1
         LHLD  N
         XCHG
         LHLD  N+2
         POP   B
         JMP   NEXT-2            ; DE=LO WORD; HL=HI WORD
*                                ;                PAGE14
         DB    85H               ; MINUS
         DB   'MINU'
         DB    'S'+80H
         DW    DPLUS-5
MINUS    DW    $+2
         POP   H
         MOV   A,L
         CMA
         MOV   L,A
         MOV   A,H
         CMA
         MOV   H,A
         INX   H
         JMP   NEXT-1
*
         DB    86H               ; DMINUS
         DB   'DMINU'
         DB    'S'+80H
         DW    MINUS-8
DMINU    DW    $+2
         POP   H
         SHLD  N+2               ; HI
         POP   H
         SHLD  N                 ; LO
         PUSH  B
         LXI   H,N
         MVI   B,4
         CALL  BNCMP
         LXI   H,N
         MVI   B,4
         CALL  BNINX
         LHLD  N
         XCHG
         LHLD  N+2
         POP   B
         JMP   NEXT-2            ; DE=LO WORD; HL=HI WORD
BNCMP    MOV   A,M
         CMA
         MOV   M,A
         INX   H
         DCR   B
         JNZ   BNCMP
         RET
BNINX    XRA   A
         STC
         ADC   M
         MOV   M,A
         INX   H
         DCR   B
         JNC   BNIX1
         JNZ   BNINX+2
BNIX1    RET
*
         DB    84H               ; OVER           PAGE15
         DB   'OVE'
         DB    'R'+80H
         DW    DMINU-9
OVER     DW    $+2
         POP   D
         POP   H
         PUSH  H
         JMP   NEXT-2
*
         DB    84H               ; DROP
         DB   'DRO'
         DB    'P'+80H
         DW    OVER-7
DROP     DW    $+2
         POP   H
         JMP   NEXT
*
         DB    84H               ; SWAP
         DB   'SWA'
         DB    'P'+80H
         DW    DROP-7
SWAP     DW    $+2
         POP   H
         XTHL
         JMP   NEXT-1
*
         DB    83H               ; DUP
         DB   'DU'
         DB    'P'+80H
         DW    SWAP-7
DUP      DW    $+2
         POP   H
         PUSH  H
         JMP   NEXT-1
*
         DB    82H               ; +|
         DB   '+'
         DB    '!'+80H
         DW    DUP-6
PSTOR    DW    $+2
         POP   H
         POP   D
         MOV   A,M
         ADD   E
         MOV   M,A
         INX   H
         MOV   A,M
         ADC   D
         MOV   M,A
         JMP   NEXT
*
         DB    86H               ; TOGGLE
         DB   'TOGGL'
         DB    'E'+80H           ;                PAGE16
         DW    PSTOR-5
TOGGL    DW    $+2
         POP   D
         POP   H
         MOV   A,M
         XRA   E
         MOV   M,A
         JMP   NEXT
*
         DB    81H               ; @
         DB    '@'+80H
         DW    TOGGL-9
AT       DW    $+2
         POP   H
         MOV   E,M
         INX   H
         MOV   D,M
         PUSH  D
         JMP   NEXT
*
         DB    82H               ; C@
         DB   'C'
         DB    '@'+80H
         DW    AT-4
CAT      DW    $+2
         POP   H
         MOV   L,M
         MVI   H,0
         JMP   NEXT-1
*
         DB    81H               ; |
         DB    '!'+80H
         DW    CAT-5
STORE    DW    $+2
         POP   H
         POP   D
         MOV   M,E
         INX   H
         MOV   M,D
         JMP   NEXT
*
         DB    82H               ; C|
         DB   'C'
         DB    '!'+80H
         DW    STORE-4
CSTOR    DW    $+2
         POP   H
         POP   D
         MOV   M,E
         JMP   NEXT
*
         DB    81H               ; :  COLON
         DB    ':'+80H
         DW    CSTOR-5
COLON    DW    DOCOL             ;                PAGE17
         DW    QEXEC
         DW    SCSP
         DW    CURR
         DW    AT
         DW    CONT
         DW    STORE
         DW    CREAT
         DW    RBRAC
         DW    PSCOD
DOCOL    LHLD  RSP
         DCX   H
         MOV   M,B
         DCX   H
         MOV   M,C
         SHLD  RSP
         INX   D
         MOV   C,E
         MOV   B,D
         JMP   NEXT
*
         DB    0C1H              ; ;  SEMI-COLON
         DB    ';'+80H
         DW    COLON-4
SEMI     DW    DOCOL
         DW    QCSP
         DW    COMP
         DW    SEMIS
         DW    SMUDG
         DW    RBRAC
         DW    SEMIS
*
         DB    88H               ; CONSTANT
         DB   'CONSTAN'
         DB    'T'+80H
         DW    SEMI-4
CON      DW    DOCOL
         DW    CREAT
         DW    SMUDG
         DW    COMMA
         DW    PSCOD
DOCON    INX   D
         XCHG
         MOV   E,M
         INX   H
         MOV   D,M
         PUSH  D
         JMP   NEXT
*
         DB    88H               ; VARIABLE
         DB   'VARIABL'
         DB    'E'+80H
         DW    CON-11
VAR      DW    DOCOL             ;                PAGE18
         DW    CON
         DW    PSCOD
DOVAR    INX   D
         PUSH  D
         JMP   NEXT
*
         DB    84H               ; USER
         DB   'USE'
         DB    'R'+80H
         DW    VAR-11
USER     DW    DOCOL
         DW    CON
         DW    PSCOD
DOUSE    INX   D
         XCHG
         MOV   E,M
         MVI   D,0
         LHLD  UP
         DAD   D
         JMP   NEXT-1
*
         DB    81H               ; 0
         DB    '0'+80H
         DW    USER-7
ZERO     DW    DOCON
         DW    0
*
         DB    81H               ; 1
         DB    '1'+80H
         DW    ZERO-4
ONE      DW    DOCON
         DW    1
*
         DB    81H               ; 2
         DB    '2'+80H
         DW    ONE-4
TWO      DW    DOCON
         DW    2
*
         DB    81H               ; 3
         DB    '3'+80H
         DW    TWO-4
THREE    DW    DOCON
         DW    3
*
         DB    82H               ; BL
         DB   'B'
         DB    'L'+80H
         DW    THREE-4
BL       DW    DOCON
         DW    20H
*
         DB    85H               ; FIRST
         DB   'FIRS'
         DB    'T'+80H           ;                PAGE19
         DW    BL-5
FIRST    DW    DOCON
         DW    EM-CO
*
         DB    85H               ; LIMIT
         DB   'LIMI'
         DB    'T'+80H
         DW    FIRST-8
LIMIT    DW    DOCON
         DW    EM
*
         DB    85H               ; B/BUF
         DB   'B/BU'
         DB    'F'+80H
         DW    LIMIT-8
BBUF     DW    DOCON
         DW    400H
*
         DB    85H               ; B/SCR
         DB   'B/SC'
         DB    'R'+80H
         DW    BBUF-8
BSCR     DW    DOCON
         DW    1
*
         DB    87H               ; +ORIGIN
         DB   '+ORIGI'
         DB    'N'+80H
         DW    BSCR-8
PORIG    DW    DOCOL
         DW    LIT
         DW    ORIG
         DW    PLUS
         DW    SEMIS
*
         DB    82H               ; S0
         DB   'S'
         DB    '0'+80H
         DW    PORIG-10
SZERO    DW    DOUSE
         DW    6
*
         DB    82H               ; R0
         DB   'R'
         DB    '0'+80H
         DW    SZERO-5
RZERO    DW    DOUSE
         DW    8
*
         DB    83H               ; TIB
         DB   'TI'
         DB    'B'+80H
         DW    RZERO-5
TIB      DW    DOUSE             ;                PAGE20
         DB    10
*
         DB    85H               ; WIDTH
         DB   'WIDT'
         DB    'H'+80H
         DW    TIB-6
WIDTH    DW    DOUSE
         DB    12
*
         DB    87H               ; WARNING
         DB   'WARNIN'
         DB    'G'+80H
         DW    WIDTH-8
WARN     DW    DOUSE
         DB    14
*
         DB    85H               ; FENCE
         DB   'FENC'
         DB    'E'+80H
         DW    WARN-10
FENCE    DW    DOUSE
         DB    16
*
         DB    82H               ; DP
         DB   'D'
         DB    'P'+80H
         DW    FENCE-8
DP       DW    DOUSE
         DB    18
*
         DB    88H               ; VOC-LINK
         DB   'VOC-LIN'
         DB    'K'+80H
         DW    DP-5
VOCL     DW    DOUSE
         DW    20
*
         DB    83H               ; BLK
         DB   'BL'
         DB    'K'+80H
         DW    VOCL-11
BLK      DW    DOUSE
         DB    22
*
         DB    82H               ; IN
         DB   'I'
         DB    'N'+80H
         DW    BLK-6
IN@       DW    DOUSE
         DB    24
*
         DB    83H               ; OUT
         DB   'OU'               ;               PAGE21
         DB    'T'+80H
         DW    IN@-5
OUT@      DW    DOUSE
         DB    26
*
         DB    83H               ; SCR
         DB   'SC'
         DB    'R'+80H
         DW    OUT@-6
SCR      DW    DOUSE
         DB    28
*
         DB    86H               ; OFFSET
         DB   'OFFSE'
         DB    'T'+80H
         DW    SCR-6
OFSET    DW    DOUSE
         DB    30
*
         DB    87H               ; CONTEXT
         DB   'CONTEX'
         DB    'T'+80H
         DW    OFSET-9
CONT     DW    DOUSE
         DB    32
*
         DB    87H               ; CURRENT
         DB   'CURREN'
         DB    'T'+80H
         DW    CONT-10
CURR     DW    DOUSE
         DB    34
*
         DB    85H               ; STATE
         DB   'STAT'
         DB    'E'+80H
         DW    CURR-10
STATE    DW    DOUSE
         DB    36
*
         DB    84H               ; BASE
         DB   'BAS'
         DB    'E'+80H
         DW    STATE-8
BASE     DW    DOUSE
         DB    38
*
         DB    83H               ; DPL
         DB   'DP'
         DB    'L'+80H
         DW    BASE-7
DPL      DW    DOUSE             ;                PAGE22
         DB    40
*
         DB    83H               ; FLD
         DB   'FL'
         DB    'D'+80H
         DW    DPL-6
FLD      DW    DOUSE
         DB    42
*
         DB    83H               ; CSP
         DB   'CS'
         DB    'P'+80H
         DW    FLD-6
CSP      DW    DOUSE
         DB    44
*
         DB    82H               ; R#
         DB   'R'
         DB    '#'+80H
         DW    CSP-6
RNUM     DW    DOUSE
         DB    46
*
         DB    83H               ; HLD
         DB   'HL'
         DB    'D'+80H
         DW    RNUM-5
HLD      DW    DOUSE
         DW    48
*
         DB    82H               ; 1+
         DB   '1'
         DB    '+'+80H
         DW    HLD-6
ONEP     DW    DOCOL
         DW    ONE
         DW    PLUS
         DW    SEMIS
*
         DB    82H               ; 2+
         DB   '2'
         DB    '+'+80H
         DW    ONEP-5
TWOP     DW    DOCOL
         DW    TWO
         DW    PLUS
         DW    SEMIS
*
         DB    84H               ; HERE
         DB   'HER'
         DB    'E'+80H
         DW    TWOP-5
HERE     DW    DOCOL
         DW    DP
         DW    AT                ;                PAGE23
         DW    SEMIS
*
         DB    85H               ; ALLOT
         DB   'ALLO'
         DB    'T'+80H
         DW    HERE-7
ALLOT    DW    DOCOL
         DW    DP
         DW    PSTOR
         DW    SEMIS
*
         DB    81H               ; ,
         DB    ','+80H
         DW    ALLOT-8
COMMA    DW    DOCOL
         DW    HERE
         DW    STORE
         DW    TWO
         DW    ALLOT
         DW    SEMIS
*
         DB    82H               ; C,
         DB   'C'
         DB    ','+80H
         DW    COMMA-4
CCOMM    DW    DOCOL
         DW    HERE
         DW    CSTOR
         DW    ONE
         DW    ALLOT
         DW    SEMIS
*
         DB    81H               ; -
         DB    '-'+80H
         DW    CCOMM-5
SUB@      DW    DOCOL
         DW    MINUS
         DW    PLUS
         DW    SEMIS
*
         DB    81H               ; =
         DB    '='+80H
         DW    SUB@-4
EQUAL    DW    DOCOL
         DW    SUB@
         DW    ZEQU
         DW    SEMIS
*
         DB    81H               ; <
         DB    '<'+80H
         DW    EQUAL-4
LESS     DW    DOCOL
         DW    SUB@
         DW    ZLESS
         DW    SEMIS             ;                PAGE24
*
         DB    81H               ; >
         DB    '>'+80H
         DW    LESS-4
GREAT    DW    DOCOL
         DW    SWAP
         DW    LESS
         DW    SEMIS
*
         DB    83H               ; ROT
         DB   'RO'
         DB    'T'+80H
         DW    GREAT-4
ROT      DW    $+2
         POP   D
         POP   H
         XTHL
         JMP   NEXT-2
*
         DB    85H               ; SPACE
         DB   'SPAC'
         DB    'E'+80H
         DW    ROT-6
SPACE    DW    DOCOL
         DW    BL
         DW    EMIT
         DW    SEMIS
*
         DB    84H               ; -DUP
         DB   '-DU'
         DB    'P'+80H
         DW    SPACE-8
DDUP     DW    DOCOL
         DW    DUP
         DW    ZBRAN             ; IF
         DW    DDUP1-$
         DW    DUP               ; ENDIF
DDUP1    DW    SEMIS
*
         DB    88H               ; TRAVERSE
         DB   'TRAVERS'
         DB    'E'+80H
         DW    DDUP-7
TRAV     DW    DOCOL
         DW    SWAP
TRAV1    DW    OVER              ; BEGIN
         DW    PLUS
         DW    LIT
         DW    7FH
         DW    OVER
         DW    CAT
         DW    LESS
         DW    ZBRAN             ; UNTIL
         DW    TRAV1-$
         DW    SWAP
         DW    DROP
         DW    SEMIS
*
         DB    86H               ; LATEST
         DB   'LATES'
         DB    'T'+80H
         DW    TRAV-11
LATEST   DW    DOCOL
         DW    CURR
         DW    AT
         DW    AT
         DW    SEMIS
*
         DB    83H               ; LFA
         DB   'LF'
         DB    'A'+80H
         DW    LATEST-9
LFA      DW    DOCOL
         DW    LIT
         DW    4
         DW    SUB@
         DW    SEMIS
*
         DB    83H               ; CFA
         DB   'CF'
         DB    'A'+80H
         DW    LFA-6
CFA      DW    DOCOL
         DW    TWO
         DW    SUB@
         DW    SEMIS
*
         DB    83H               ; NFA
         DB   'NF'
         DB    'A'+80H
         DW    CFA-6
NFA      DW    DOCOL
         DW    LIT
         DW    5
         DW    SUB@
         DW    LIT
         DW    -1
         DW    TRAV
         DW    SEMIS
*
         DB    83H               ; PFA
         DB   'PF'
         DB    'A'+80H
         DW    NFA-6
PFA      DW    DOCOL
         DW    ONE
         DW    TRAV
         DW    LIT               ;               PAGE26
         DW    5
         DW    PLUS
         DW    SEMIS
*
         DB    84H               ; |CSP
         DB   '!CS'
         DB    'P'+80H
         DW    PFA-6
SCSP     DW    DOCOL
         DW    SPAT
         DW    CSP
         DW    STORE
         DW    SEMIS
*
         DB    86H               ; ?ERROR
         DB   '?ERRO'
         DB    'R'+80H
         DW    SCSP-7
QERR     DW    DOCOL
         DW    SWAP
         DW    ZBRAN             ; IF
         DW    QERR1-$
         DW    ERROR
         DW    BRAN              ; ELSE
         DW    QERR2-$
QERR1    DW    DROP              ; ENDIF
QERR2    DW    SEMIS
*
         DB    85H               ; ?COMP
         DB   '?COM'
         DB    'P'+80H
         DW    QERR-9
QCOMP    DW    DOCOL
         DW    STATE
         DW    AT
         DW    ZEQU
         DW    LIT
         DW    17
         DW    QERR
         DW    SEMIS
*
         DB    85H               ; ?EXEC
         DB   '?EXE'
         DB    'C'+80H
         DW    QCOMP-8
QEXEC    DW    DOCOL
         DW    STATE
         DW    AT
         DW    LIT
         DW    18
         DW    QERR
         DW    SEMIS
*
         DB    86H               ; ?PAIRS        PAGE27
         DB   '?PAIR'
         DB    'S'+80H
         DW    QEXEC-8
QPAIRS   DW    DOCOL
         DW    SUB@
         DW    LIT
         DW    19
         DW    QERR
         DW    SEMIS
*
         DB    84H               ; ?CSP
         DB   '?CS'
         DB    'P'+80H
         DW    QPAIRS-9
QCSP     DW    DOCOL
         DW    SPAT
         DW    CSP
         DW    AT
         DW    SUB@
         DW    LIT
         DW    20
         DW    QERR
         DW    SEMIS
*
         DB    88H               ; ?LOADING
         DB   '?LOADIN'
         DB    'G'+80H
         DW    QCSP-7
QLOAD    DW    DOCOL
         DW    BLK
         DW    AT
         DW    ZEQU
         DW    LIT
         DW    22
         DW    QERR
         DW    SEMIS
*
         DB    87H               ; COMPILE
         DB   'COMPIL'
         DB    'E'+80H
         DW    QLOAD-11
COMP     DW    DOCOL
         DW    QCOMP
         DW    FROMR
         DW    DUP
         DW    TWOP
         DW    TOR
         DW    AT
         DW    COMMA
         DW    SEMIS
*
         DB    0C1H              ; LEFT BRACKET    PAGE28
         DB    5BH+80H           ; LEFT BRACKET
         DW    COMP-10
LBRAC    DW    DOCOL
         DW    ZERO
         DW    STATE
         DW    STORE
         DW    SEMIS
*
         DB    81H               ; RIGHT BRACKET
         DB    5DH+80H           ; RIGHT BRACKET
         DW    LBRAC-4
RBRAC    DW    DOCOL
         DW    STATE
         DW    LIT
         DW    0C0H
         DW    TOGGL
         DW    SEMIS
*
         DB    86H               ; SMUDGE
         DB   'SMUDG'
         DB    'E'+80H
         DW    RBRAC-4
SMUDG    DW    DOCOL
         DW    LATEST
         DW    LIT
         DW    20H
         DW    TOGGL
         DW    SEMIS
*
         DB    83H               ; HEX
         DB   'HE'
         DB    'X'+80H
         DW    SMUDG-9
HEX      DW    DOCOL
         DW    LIT
         DW    16
         DW    BASE
         DW    STORE
         DW    SEMIS
*
         DB    87H               ; DECIMAL
         DB   'DECIMA'
         DB    'L'+80H
         DW    HEX-6
DEC      DW    DOCOL
         DW    LIT
         DW    10
         DW    BASE
         DW    STORE
         DW    SEMIS
*
         DB    87H               ; (;CODE)
         DB   '(;CODE'           ;              PAGE29
         DB    ')'+80H
         DW    DEC-10
PSCOD    DW    DOCOL
         DW    FROMR
         DW    LATEST
         DW    PFA
         DW    CFA
         DW    STORE
         DW    SEMIS
*
         DB    0C5H              ; ;CODE
         DB   ';COD'
         DB    'E'+80H
         DW    PSCOD-10
SEMIC    DW    DOCOL
         DW    QCSP
         DW    COMP
         DW    PSCOD
         DW    SMUDG
         DW    LBRAC
         DW    SPACE
         DW    QSTAC             ; ( ASSEMBLER )
         DW    SEMIS
*
         DB    87H               ; <BUILDS
         DB   '<BUILD'
         DB    'S'+80H
         DW    SEMIC-8
BUILD    DW    DOCOL
         DW    ZERO
         DW    CON
         DW    SEMIS
*
         DB    85H               ; DOES>
         DB   'DOES'
         DB    '>'+80H
         DW    BUILD-10
DOES     DW    DOCOL
         DW    FROMR
         DW    LATEST
         DW    PFA
         DW    STORE
         DW    PSCOD
DODOE    LHLD  RSP
         DCX   H
         MOV   M,B
         DCX   H
         MOV   M,C
         SHLD  RSP
         INX   D
         XCHG
         MOV   C,M
         INX   H                 ;               PAGE30
         MOV   B,M
         INX   H
         JMP   NEXT-1
*
         DB    85H               ; COUNT
         DB   'COUN'
         DB    'T'+80H
         DW    DOES-8
COUNT    DW    DOCOL
         DW    DUP
         DW    ONEP
         DW    SWAP
         DW    CAT
         DW    SEMIS
*
         DB    84H               ; TYPE
         DB   'TYP'
         DB    'E'+80H
         DW    COUNT-8
TYPE     DW    DOCOL
         DW    DDUP
         DW    ZBRAN             ; IF
         DW    TYPE1-$
         DW    OVER
         DW    PLUS
         DW    SWAP
         DW    XDO               ; DO
TYPE2    DW    I
         DW    CAT
         DW    EMIT
         DW    XLOOP             ; LOOP
         DW    TYPE2-$
         DW    BRAN              ; ELSE
         DW    TYPE3-$
TYPE1    DW    DROP              ; ENDIF
TYPE3    DW    SEMIS
*
         DB    89H               ; -TRAILING
         DB   '-TRAILIN'
         DB    'G'+80H
         DW    TYPE-7
DTRAI    DW    DOCOL
         DW    DUP
         DW    ZERO
         DW    XDO               ; DO
DTRA1    DW    OVER
         DW    OVER
         DW    PLUS
         DW    ONE
         DW    SUB@
         DW    CAT
         DW    BL
         DW    SUB@
         DW    ZBRAN             ; IF            PAGE31
         DW    DTRA2-$
         DW    LEAVE
         DW    BRAN              ; ELSE
         DW    DTRA3-$
DTRA2    DW    ONE
         DW    SUB@               ; ENDIF
DTRA3    DW    XLOOP             ; LOOP
         DW    DTRA1-$
         DW    SEMIS
*
         DB    84H               ; (.")
         DB   '(."'
         DB    ')'+80H
         DW    DTRAI-12
PDOTQ    DW    DOCOL
         DW    R
         DW    COUNT
         DW    DUP
         DW    ONEP
         DW    FROMR
         DW    PLUS
         DW    TOR
         DW    TYPE
         DW    SEMIS
*
         DB    0C2H              ; ."
         DB   '.'
         DB    '"'+80H
         DW    PDOTQ-7
DOTQ     DW    DOCOL
         DW    LIT
         DW    34
         DW    STATE
         DW    AT
         DW    ZBRAN             ; IF
         DW    DOTQ1-$
         DW    COMP
         DW    PDOTQ
         DW    WORD
         DW    HERE
         DW    CAT
         DW    ONEP
         DW    ALLOT
         DW    BRAN              ; ELSE
         DW    DOTQ2-$
DOTQ1    DW    WORD
         DW    HERE
         DW    COUNT
         DW    TYPE              ; ENDIF
DOTQ2    DW    SEMIS
*
         DB    86H               ; EXPECT
         DB   'EXPEC'
         DB    'T'+80H           ;               PAGE32
         DW    DOTQ-5
EXPEC    DW    DOCOL
         DW    OVER
         DW    PLUS
         DW    OVER
         DW    XDO               ; DO
EXPE1    DW    KEY
         DW    DUP
         DW    LIT
         DW    14
         DW    PORIG
         DW    AT
         DW    EQUAL
         DW    ZBRAN             ; IF
         DW    EXPE2-$
         DW    DROP
         DW    LIT
         DW    8
         DW    OVER
         DW    I
         DW    EQUAL
         DW    DUP
         DW    FROMR
         DW    TWO
         DW    SUB@
         DW    PLUS
         DW    TOR
         DW    SUB@
         DW    BRAN              ; ELSE
         DW    EXPE3-$
EXPE2    DW    DUP
         DW    LIT
         DW    13
         DW    EQUAL
         DW    ZBRAN             ; IF
         DW    EXPE4-$
         DW    LEAVE
         DW    DROP
         DW    BL
         DW    ZERO
         DW    BRAN              ; ELSE
         DW    EXPE5-$
EXPE4    DW    DUP               ; ENDIF
EXPE5    DW    I
         DW    CSTOR
         DW    ZERO
         DW    I
         DW    ONEP
         DW    STORE             ; ENDIF
EXPE3    DW    EMIT
         DW    XLOOP             ; LOOP
         DW    EXPE1-$
         DW    DROP
         DW    SEMIS
*                                ;               PAGE33
         DB    85H               ; QUERY
         DB   'QUER'
         DB    'Y'+80H
         DW    EXPEC-9
QUERY    DW    DOCOL
         DW    TIB
         DW    AT
         DW    LIT
         DW    80
         DW    EXPEC
         DW    ZERO
         DW    IN
         DW    STORE
         DW    SEMIS
*
         DB    0C1H              ; (NULL)
         DB    00+80H
         DW    QUERY-8
NULL     DW    DOCOL
         DW    BLK
         DW    AT
         DW    ZBRAN             ; IF
         DW    NULL1-$
         DW    ONE
         DW    BLK
         DW    PSTOR
         DW    ZERO
         DW    IN
         DW    STORE
         DW    BLK
         DW    AT
         DW    BSCR
         DW    ONE
         DW    SUB@
         DW    AND@
         DW    ZEQU
         DW    ZBRAN             ; IF
         DW    NULL2-$
         DW    QEXEC
         DW    FROMR
         DW    DROP              ; ENDIF
NULL2    DW    BRAN              ; ELSE
         DW    NULL3-$
NULL1    DW    FROMR
         DW    DROP              ; ENDIF
NULL3    DW    SEMIS
*
         DB    84H               ; FILL
         DB   'FIL'
         DB    'L'+80H
         DW    NULL-4
FILL     DW    DOCOL
         DW    SWAP
         DW    TOR
         DW    OVER              ;               PAGE34
         DW    CSTOR
         DW    DUP
         DW    ONEP
         DW    FROMR
         DW    ONE
         DW    SUB@
         DW    CMOVE
         DW    SEMIS
*
         DB    85H               ; ERASE
         DB   'ERAS'
         DB    'E'+80H
         DW    FILL-7
ERASE    DW    DOCOL
         DW    ZERO
         DW    FILL
         DW    SEMIS
*
         DB    86H               ; BLANKS
         DB   'BLANK'
         DB    'S'+80H
         DW    ERASE-8
BLANK    DW    DOCOL
         DW    BL
         DW    FILL
         DW    SEMIS
*
         DB    84H               ; HOLD
         DB   'HOL'
         DB    'D'+80H
         DW    BLANK-9
HOLD     DW    DOCOL
         DW    LIT
         DW    -1
         DW    HLD
         DW    PSTOR
         DW    HLD
         DW    AT
         DW    CSTOR
         DW    SEMIS
*
         DB    83H               ; PAD
         DB   'PA'
         DB    'D'+80H
         DW    HOLD-7
PAD      DW    DOCOL
         DW    HERE
         DW    LIT
         DW    68
         DW    PLUS
         DW    SEMIS
*
         DB    84H               ; WORD
         DB   'WOR'              ;              PAGE35
         DB    'D'+80H
         DW    PAD-6
WORD     DW    DOCOL
         DW    BLK
         DW    AT
         DW    ZBRAN             ; IF
         DW    WORD1-$
         DW    BLK
         DW    AT
         DW    BLOCK
         DW    BRAN              ; ELSE
         DW    WORD2-$
WORD1    DW    TIB
         DW    AT                ; ENDIF
WORD2    DW    IN
         DW    AT
         DW    PLUS
         DW    SWAP
         DW    ENCL
         DW    HERE
         DW    LIT
         DW    34
         DW    BLANK
         DW    IN
         DW    PSTOR
         DW    OVER
         DW    SUB@
         DW    TOR
         DW    R
         DW    HERE
         DW    CSTOR
         DW    PLUS
         DW    HERE
         DW    ONEP
         DW    FROMR
         DW    CMOVE
         DW    SEMIS
*
         DB    88H               ; (NUMBER)
         DB   '(NUMBER'
         DB    ')'+80H
         DW    WORD-7
PNUMB    DW    DOCOL
PNUM1    DW    ONEP              ; BEGIN
         DW    DUP
         DW    TOR
         DW    CAT
         DW    BASE
         DW    AT
         DW    DIGIT
         DW    ZBRAN             ; WHILE
         DW    PNUM2-$
         DW    SWAP
         DW    BASE              ;               PAGE36
         DW    AT
         DW    USTAR
         DW    DROP
         DW    ROT
         DW    BASE
         DW    AT
         DW    USTAR
         DW    DPLUS
         DW    DPL
         DW    AT
         DW    ONEP
         DW    ZBRAN             ; IF
         DW    PNUM3-$
         DW    ONE
         DW    DPL
         DW    PSTOR             ; ENDIF
PNUM3    DW    FROMR
         DW    BRAN              ; REPEAT
         DW    PNUM1-$
PNUM2    DW    FROMR
         DW    SEMIS
*
         DB    86H               ; NUMBER
         DB   'NUMBE'
         DB    'R'+80H
         DW    PNUMB-11
NUMB     DW    DOCOL
         DW    ZERO
         DW    ZERO
         DW    ROT
         DW    DUP
         DW    ONEP
         DW    CAT
         DW    LIT
         DW    45
         DW    EQUAL
         DW    DUP
         DW    TOR
         DW    PLUS
         DW    LIT
         DW    -1
NUMB1    DW    DPL               ; BEGIN
         DW    STORE
         DW    PNUMB
         DW    DUP
         DW    CAT
         DW    BL
         DW    SUB@
         DW    ZBRAN             ; WHILE
         DW    NUMB2-$
         DW    DUP
         DW    CAT
         DW    LIT
         DW    46                ;               PAGE37
         DW    SUB@
         DW    ZERO
         DW    QERR
         DW    ZERO
         DW    BRAN             ;  REPEAT
         DW    NUMB1-$
NUMB2    DW    DROP
         DW    FROMR
         DW    ZBRAN            ;  IF
         DW    NUMB3-$
         DW    DMINU            ;  ENDIF
NUMB3    DW    SEMIS
*
         DB    85H              ;  -FIND    (0-3) SUCCESS
         DB   '-FIN'            ;          (0-1) FAILURE
         DB    'D'+80H
         DW    NUMB-9
DFIND    DW    DOCOL
         DW    BL
         DW    WORD
         DW    HERE
         DW    CONT
         DW    AT
         DW    AT
         DW    PFIND
         DW    DUP
         DW    ZEQU
         DW    ZBRAN            ;  IF
         DW    DFIN1-$
         DW    DROP
         DW    HERE
         DW    LATEST
         DW    PFIND            ;  ENDIF
DFIN1    DW    SEMIS
*
         DB    87H              ;  (ABORT)
         DB   '(ABORT'
         DB    ')'+80H
         DW    DFIND-8
PABOR    DW    DOCOL
         DW    ABORT
         DW    SEMIS
*
         DB    85H              ;  ERROR
         DB   'ERRO'
         DB    'R'+80H
         DW    PABOR-10
ERROR    DW    DOCOL
         DW    WARN
         DW    AT
         DW    ZLESS
         DW    ZBRAN            ;  IF
	DW	ERRO1+$
	DW	PABOR		;ENDIF
ERRO1	DW	HERE
	DW	COUNT
	DW	TYPE
	DW	PDOTQ
         DB    2
         DB   '??'
         DW    MESS
         DW    SPSTO
         DW    IN
         DW    AT
         DW    BLK
         DW    QUIT
*
         DB    83H              ;  ID.
         DB   'ID'
         DB    '.'+80H
         DW    ERROR-8
IDDOT    DW    DOCOL
         DW    PAD
         DW    LIT
         DW    20H
         DW    LIT
         DW    5FH
         DW    FILL
         DW    DUP
         DW    PFA
         DW    LFA
         DW    OVER
         DW    SUB@
         DW    PAD
         DW    SWAP
         DW    CMOVE
         DW    PAD
         DW    COUNT
         DW    LIT
         DW    31
         DW    AND@
         DW    TYPE
         DW    SPACE
         DW    SEMIS
*
         DB    86H              ;  CREATE
         DB   'CREAT'
         DB    'E'+80H
         DW    IDDOT-6
CREAT    DW    DOCOL
         DW    TIB
         DW    HERE
         DW    LIT
         DW    0A0H
         DW    PLUS
         DW    LESS
         DW    TWO
         DW    QERR             ;                PAGE39
         DW    DFIND
         DW    ZBRAN
         DW    CREA1-$
         DW    DROP
         DW    NFA
         DW    IDDOT
         DW    LIT
         DW    4
         DW    MESS
         DW    SPACE            ;  ENDIF
CREA1    DW    HERE
         DW    DUP
         DW    CAT
         DW    WIDTH
         DW    AT
         DW    MIN
         DW    ONEP
         DW    ALLOT
         DW    DP
         DW    CAT
         DW    LIT
         DW    0FDH
         DW    EQUAL
         DW    ALLOT
         DW    DUP
         DW    LIT
         DW    0A0H
         DW    TOGGL
         DW    HERE
         DW    ONE
         DW    SUB@
         DW    LIT
         DW    80H
         DW    TOGGL
         DW    LATEST
         DW    COMMA
         DW    CURR
         DW    AT
         DW    STORE
         DW    HERE
         DW    TWOP
         DW    COMMA
         DW    SEMIS
*
         DB    0C9H             ;  [ COMPILE ]
         DB    5BH              ;  [
         DB   'COMPILE'
         DB    5DH+80H          ;  ]
         DW    CREAT-9
BCOMP    DW    DOCOL
         DW    DFIND
         DW    ZEQU
         DW    ZERO
         DW    QERR
         DW    DROP             ;                PAGE40
         DW    CFA
         DW    COMMA
         DW    SEMIS
*
         DB    0C7H             ;  LITERAL
         DB   'LITERA'
         DB    'L'+80H
         DW    BCOMP-12
LITER    DW    DOCOL
         DW    STATE
         DW    AT
         DW    ZBRAN            ;  IF
         DW    LITE1-$
         DW    COMP
         DW    LIT
         DW    COMMA            ;  ENDIF
LITE1    DW    SEMIS
*
         DB    0C8H             ;  DLITERAL
         DB   'DLITERA'
         DB    'L'+80H
         DW    LITER-10
DLITE    DW    DOCOL
         DW    STATE
         DW    AT
         DW    ZBRAN            ;  IF
         DW    DLIT1-$
         DW    SWAP
         DW    LITER
         DW    LITER            ;  ENDIF
DLIT1    DW    SEMIS
*
         DB    86H              ;  ?STACK
         DB   '?STAC'
         DB    'K'+80H
         DW    DLITE-11
QSTAC    DW    DOCOL
         DW    LIT
         DW    18
         DW    PORIG
         DW    AT
         DW    SPAT
         DW    LESS
         DW    ONE
         DW    QERR
         DW    SPAT
         DW    HERE
         DW    LIT
         DW    80H
         DW    PLUS
         DW    LESS
         DW    LIT              ;                PAGE41
         DW    7
         DW    QERR
         DW    SEMIS
*
         DB    89H              ;  INTERPRET
         DB   'INTERPRE'
         DB    'T'+80H
         DW    QSTAC-9
INTER    DW    DOCOL
INTE1    DW    DFIND            ;  BEGIN
         DW    ZBRAN            ;  IF
         DW    INTE2-$
         DW    STATE
         DW    AT
         DW    LESS
         DW    ZBRAN            ;  IF
         DW    INTE3-$
         DW    CFA
         DW    COMMA
         DW    BRAN             ;  ELSE
         DW    INTE4-$
INTE3    DW    CFA
         DW    EXEC             ;  ENDIF
INTE4    DW    QSTAC
         DW    BRAN             ;  DLSE
         DW    INTE5-$
INTE2    DW    HERE
         DW    NUMB
         DW    DPL
         DW    AT
         DW    ONEP
         DW    ZBRAN            ;  IF
         DW    INTE6-$
         DW    DLITE
         DW    BRAN             ;  ELSE
         DW    INTE7-$
INTE6    DW    DROP
         DW    LITER            ;  ENDIF
INTE7    DW    QSTAC            ;  ENDIF
INTE5    DW    BRAN             ;  AGAIN
         DW    INTE1-$
*
         DB    89H              ;  IMMEDIATE
         DB   'IMMEDIAT'
         DB    'E'+80H
         DW    INTER-12
IMMED    DW    DOCOL
         DW    LATEST
         DW    LIT
         DW    64
         DW    TOGGL
         DW    SEMIS
*                               ;                PAGE42
         DB    8AH              ;  VOCABULARY
         DB   'VOCABULAR'
         DB    'Y'+80H
         DW    IMMED-12
VOCAB    DW    DOCOL
         DW    BUILD
         DW    LIT
         DW    0A081H
         DW    COMMA
         DW    CURR
         DW    AT
         DW    CFA
         DW    COMMA
         DW    HERE
         DW    VOCL
         DW    AT
         DW    COMMA
         DW    VOCL
         DW    STORE
         DW    DOES
DOVOC    DW    TWOP
         DW    CONT
         DW    STORE
         DW    SEMIS
*
         DB    0C5H             ;  FORTH
         DB   'FORT'
         DB    'H'+80H
         DW    VOCAB-13
FORTH    DW    DODOE
         DW    DOVOC
         DW    0A081H
         DW    TASK-7
         DW    0                ;  END OF VOCABULARY LIST
*
         DB    8BH              ;  DEFINITIONS
         DB   'DEFINITION'
         DB    'S'+80H
         DW    FORTH-8
DEFIN    DW    DOCOL
         DW    CONT
         DW    AT
         DW    CURR
         DW    STORE
         DW    SEMIS
*
         DB    0C1H             ;  (
         DB    '('+80H
         DW    DEFIN-14
PAREN    DW    DOCOL
         DW    LIT              ;                PAGE43
         DW    41
         DW    WORD
         DW    SEMIS
*
         DB    84H              ;  QUIT
         DB   'QUI'
         DB    'T'+80H
         DW    PAREN-4
QUIT     DW    DOCOL
         DW    ZERO
         DW    BLK
         DW    STORE
         DW    LBRAC
QUIT1    DW    RPSTO            ;  BEGIN
         DW    CR
         DW    QUERY
         DW    INTER
         DW    STATE
         DW    AT
         DW    ZEQU
         DW    ZBRAN            ;  IF
         DW    QUIT2-$
         DW    PDOTQ
         DB    2
         DB   'OK'              ; ENDIF
QUIT2    DW    BRAN             ;  AGAIN
         DW    QUIT1-$
*
         DB    85H              ;  ABORT
         DB   'ABOR'
         DB    'T'+80H
         DW    QUIT-7
ABORT    DW    DOCOL
         DW    SPSTO
         DW    DEC
         DW    QSTAC
         DW    CR
         DW    PDOTQ
         DB    16
         DB   'FORTH-8080 V 4.0'
         DW    FORTH
         DW    DEFIN
         DW    QUIT
*
         DB    84H              ;  COLD
         DB   'COL'
         DB    'D'+80H
         DW    ABORT-8
COLD     DW    DOCOL
         DW    HEX
         DW    LIT
         DW    ORIG+18          ;                PAGE44
         DW    LIT
         DW    UP
         DW    AT
         DW    LIT
         DW    6
         DW    PLUS
         DW    LIT
         DW    16
         DW    CMOVE
         DW    LIT
         DW    ORIG+12
         DW    AT
         DW    LIT
         DW    FORTH+6
         DW    STORE
         DW    ABORT
*
         DB    84H              ;  S->D
         DB   'S->'
         DB    'D'+80H
         DW    COLD-7
STOD     DW    $+2
         POP   D
         LXI   H,0
         MOV   A,D
         ANI   80H
         JZ    STOD1
         DCX   H
STOD1    JMP   NEXT-2
*
         DB    82H              ;  +-
         DB   '+'
         DB    '-'+80H
         DW    STOD-7
PM       DW    DOCOL
         DW    ZLESS
         DW    ZBRAN            ;  IF
         DW    PM1-$
         DW    MINUS            ;  ENDIF
PM1      DW    SEMIS
*
         DB    83H              ;  D+-
         DB   'D+'
         DB    '-'+80H
         DW    PM-5
DPM      DW    DOCOL
         DW    ZLESS
         DW    ZBRAN            ;  IF
         DW    DPM1-$
         DW    DMINU            ;  ENDIF
DPM1     DW    SEMIS
*
         DB    83H              ;  ABS
         DB   'AB'
         DB    'S'+80H          ;                PAGE45
         DW    DPM-6
ABS      DW    DOCOL
         DW    DUP
         DW    PM
         DW    SEMIS
*
         DB    84H              ;  DABS
         DB   'DAB'
         DB    'S'+80H
         DW    ABS-6
DABS     DW    DOCOL
         DW    DUP
         DW    DPM
         DW    SEMIS
*
         DB    83H              ;  MIN
         DB   'MI'
         DB    'N'+80H
         DW    DABS-7
MIN      DW    DOCOL
         DW    OVER
         DW    OVER
         DW    GREAT
         DW    ZBRAN            ;  IF
         DW    MIN1-$
         DW    SWAP             ;  ENDIF
MIN1     DW    DROP
         DW    SEMIS
*
         DB    83H              ;  MAX
         DB   'MA'
         DB    'X'+80H
         DW    MIN-6
MAX      DW    DOCOL
         DW    OVER
         DW    OVER
         DW    LESS
         DW    ZBRAN            ;  IF
         DW    MAX1-$
         DW    SWAP             ;  ENDIF
MAX1     DW    DROP
         DW    SEMIS
*
         DB    82H              ;  M*
         DB   'M'
         DB    '*'+80H
         DW    MAX-6
MSTAR    DW    DOCOL
         DW    OVER
         DW    OVER
         DW    XOR@
         DW    TOR
         DW    ABS
         DW    SWAP
         DW    ABS              ;                PAGE46
         DW    USTAR
         DW    FROMR
         DW    DPM
         DW    SEMIS
*
         DB    82H              ;  M/
         DB   'M'
         DB    '/'+80H
         DW    MSTAR-5
MSLAS    DW    DOCOL
         DW    OVER
         DW    TOR
         DW    TOR
         DW    DABS
         DW    R
         DW    ABS
         DW    USLAS
         DW    FROMR
         DW    R
         DW    XOR@
         DW    PM
         DW    SWAP
         DW    FROMR
         DW    PM
         DW    SWAP
         DW    SEMIS
*
         DB    81H              ;  *
         DB    '*'+80H
         DW    MSLAS-5
STAR     DW    DOCOL
         DW    MSTAR
         DW    DROP
         DW    SEMIS
*
         DB    84H              ;  /MOD
         DB   '/MO'
         DB    'D'+80H
         DW    STAR-4
SLMOD    DW    DOCOL
         DW    TOR
         DW    STOD
         DW    FROMR
         DW    MSLAS
         DW    SEMIS
*
         DB    81H              ;  /
         DB    '/'+80H
         DW    SLMOD-7
SLASH    DW    DOCOL
         DW    SLMOD
         DW    SWAP
         DW    DROP
         DW    SEMIS
*                               ;                PAGE47
         DB    83H              ;  MOD
         DB   'MO'
         DB    'D'+80H
         DW    SLASH-4
MOD@      DW    DOCOL
         DW    SLMOD
         DW    DROP
         DW    SEMIS
*
         DB    85H              ;  */MOD
         DB   '*/MO'
         DB    'D'+80H
         DW    MOD@-6
SSMOD    DW    DOCOL
         DW    TOR
         DW    MSTAR
	DW	FROMR
	DW	MSLAS
         DW    SEMIS
*
         DB    82H              ;  */
         DB   '*'
         DB    '/'+80H
         DW    SSMOD-8
SSLA     DW    DOCOL
         DW    SSMOD
         DW    SWAP
         DW    DROP
         DW    SEMIS
*
         DB    85H              ;  M/MOD
         DB   'M/MO'
         DB    'D'+80H
         DW    SSLA-5
MSMOD    DW    DOCOL
         DW    TOR
         DW    ZERO
         DW    R
         DW    USLAS
         DW    FROMR
         DW    SWAP
         DW    TOR
         DW    USLAS
         DW    FROMR
         DW    SEMIS
*
         DB    85H         ;  BLOCK  (MINIMUM IMPLEMENTATION)
         DB   'BLOC'
         DB    'K'+80H
         DW    MSMOD-8
BLOCK    DW    DOCOL
         DW    DUP
         DW    FIRST
         DW    AT
         DW    SUB@              ;                PAGE48
         DW    ZBRAN            ;  IF
         DW    BLOC1-$
         DW    DUP
BLOC2    DW    DUP              ;  BEGIN
         DW    LIT
         DW    4                ;  NBR BLKS PER SECTOR
         DW    STAR
         DW    LIT
         DW    10               ;  NBR SECTORS PER TRACK
         DW    ZERO
         DW    SWAP
         DW    MSLAS
         DW    DISKR
         DW    ZEQU
         DW    ZBRAN            ;  UNTIL
         DW    BLOC2-$
         DW    FIRST
         DW    STORE
         DW    FIRST
         DW    LIT
         DW    402H
         DW    PLUS
         DW    ZERO
         DW    SWAP
         DW    STORE            ;  ENDIF
BLOC1    DW    DROP
         DW    FIRST
         DW    TWOP
         DW    SEMIS
*
         DB    89H              ;  DISK-READ
         DB   'DISK-REA'
         DB    'D'+80H
         DW    BLOCK-8
DISKR    DW    $+2
         MOV   H,B
         MOV   L,C
         SHLD  N
         POP   H
         MOV   B,L              ;  TRACK NBR
         MVI   C,1              ;  DRIVE NBR 1
         POP   H
         MOV   D,L              ;  SECTOR NBR
         MVI   E,1
         LXI   H,EM-CO+2        ;  FIRST+2
         PUSH  D
         PUSH  B
         MVI   A,2              ;  READ 2 SECTORS
         DI
         CALL  NSROM
         POP   B
         POP   D
         MOV   A,D
         ADI   2                ;                PAGE49
         CPI   10               ;  SWITCH TRACKS?
         JC    DISK1            ;  IF >= 0A THEN
         INR   B                ;  NEXT TRACK
         XRA   A                ;  AND FIRST SECTOR
DISK1    MOV   D,A
         LXI   H,EM-CO+2+200H   ;  FIRST+202H
         MVI   A,2              ;  READ ANOTHER 2
         CALL  NSROM
         EI
         LHLD  N
         MOV   B,H
         MOV   C,L
         MVI   H,0
         MOV   L,A
         JMP   NEXT-1
*
         DB    86H              ;  (LINE)
         DB   '(LINE'
         DB    ')'+80H
         DW    DISKR-12
PLINE    DW    DOCOL
         DW    TOR
         DW    LIT
         DW    64
         DW    BBUF
         DW    SSMOD
         DW    FROMR
         DW    BSCR
         DW    STAR
         DW    PLUS
         DW    BLOCK
         DW    PLUS
         DW    LIT
         DW    64
         DW    SEMIS
*
         DB    85H              ;  .LINE
         DB   '.LIN'
         DB    'E'+80H
         DW    PLINE-9
DLINE    DW    DOCOL
         DW    PLINE
         DW    DTRAI
         DW    TYPE
         DW    SEMIS
*
         DB    87H              ;  MESSAGE
         DB   'MESSAG'
         DB    'E'+80H
         DW    DLINE-8
MESS     DW    DOCOL
         DW    WARN
         DW    AT               ;                PAGE50
         DW    ZBRAN            ;  IF
         DW    MESS1-$
         DW    DDUP
         DW    ZBRAN            ;  IF
         DW    MESS2-$
         DW    LIT
         DW    4
         DW    OFSET
         DW    AT
         DW    BSCR
         DW    SLASH
         DW    SUB@
         DW    DLINE
         DW    SPACE            ;  ENDIF
MESS2    DW    BRAN             ;  ELSE
         DW    MESS3-$
MESS1    DW    PDOTQ
         DB    6
         DB    'MSG # '
         DW    DOT              ;  ENDIF
MESS3    DW    SEMIS
*
         DB    84H              ;  LOAD
         DB   'LOA'
         DB    'D'+80H
         DW    MESS-10
LOAD     DW    DOCOL
         DW    BLK
         DW    AT
         DW    TOR
         DW    IN
         DW    AT
         DW    TOR
         DW    ZERO
         DW    IN
         DW    STORE
         DW    BSCR
         DW    STAR
         DW    BLK
         DW    STORE
         DW    INTER
         DW    FROMR
         DW    IN
         DW    STORE
         DW    FROMR
         DW    BLK
         DW    STORE
         DW    SEMIS
*
         DB    0C3H             ;  -->
         DB   '--'
         DB    '>'+80H
         DW    LOAD-7
ARROW    DW    DOCOL            ;                PAGE51
         DW    QLOAD
         DW    ZERO
         DW    IN
         DW    STORE
         DW    BSCR
         DW    BLK
         DW    AT
         DW    OVER
         DW    MOD@
         DW    SUB@
         DW    BLK
         DW    PSTOR
         DW    SEMIS
*
PEMIT    POP   H
         MOV   A,L
         CALL  0C24H            ;  POLY 88 MONITOR
         JMP   NEXT
*
PKEY     CALL  0C20H            ;  POLY 88 MONITOR
         MOV   L,A
         MVI   H,0
         JMP   NEXT-1
*
PQTER    LXI   H,0C0CH          ;  POLY KEYBRD STAT FLAG
         MOV   A,M
         ORA   A
         LXI   H,0
         JNZ   PQTE1
         INR   L
PQTE1    JMP   NEXT-1
*
PCR      MVI   A,13
         CALL  0C24H
         JMP   NEXT
*
         DB    0C1H             ;  '
         DB    27H+80H
         DW    ARROW-6
TICK     DW    DOCOL
         DW    DFIND
         DW    ZEQU
         DW    ZERO
         DW    QERR
         DW    DROP
         DW    LITER
         DW    SEMIS
*
         DB    86H              ;  FORGET
         DB   'FORGE'
         DB    'T'+80H
         DW    TICK-4
FORG     DW    DOCOL
         DW    CURR             ;                PAGE52
         DW    AT
         DW    CONT
         DW    AT
         DW    SUB@
         DW    LIT
         DW    24
         DW    QERR
         DW    TICK
         DW    DUP
         DW    FENCE
         DW    AT
         DW    LESS
         DW    LIT
         DW    21
         DW    QERR
         DW    DUP
         DW    NFA
         DW    DP
         DW    STORE
         DW    LFA
         DW    AT
         DW    CONT
         DW    AT
         DW    STORE
         DW    SEMIS
*
         DB    84H              ;  BACK
         DB   'BAC'
         DB    'K'+80H
         DW    FORG-9
BACK     DW    DOCOL
         DW    HERE
         DW    SUB@
         DW    COMMA
         DW    SEMIS
*
         DB    0C5H             ;  BEGIN
         DB   'BEGI'
         DB    'N'+80H
         DW    BACK-7
BEGIN    DW    DOCOL
         DW    QCOMP
         DW    HERE
         DW    ONE
         DW    SEMIS
*
         DB    0C5H             ;  ENDIF
         DB   'ENDI'
         DB    'F'+80H
         DW    BEGIN-8
END@IF    DW    DOCOL
         DW    QCOMP
         DW    TWO
         DW    QPAIRS
         DW    HERE             ;                PAGE53
         DW    OVER
         DW    SUB@
         DW    SWAP
         DW    STORE
         DW    SEMIS
*
         DB    0C4H             ;  THEN
         DB   'THE'
         DB    'N'+80H
         DW    END@IF-8
THEN     DW    DOCOL
         DW    END@IF
         DW    SEMIS
*
         DB    0C2H             ;  DO
         DB   'D'
         DB    'O'+80H
         DW    THEN-7
DO       DW    DOCOL
         DW    COMP
         DW    XDO
         DW    HERE
         DW    THREE
         DW    SEMIS
*
         DB    0C4H             ;  LOOP
         DB   'LOO'
         DB    'P'+80H
         DW    DO-5
LOOP     DW    DOCOL
         DW    THREE
         DW    QPAIRS
         DW    COMP
         DW    XLOOP
         DW    BACK
         DW    SEMIS
*
         DB    0C5H             ;  +LOOP
         DB   '+LOO'
         DB    'P'+80H
         DW    LOOP-7
PLOOP    DW    DOCOL
         DW    THREE
         DW    QPAIRS
         DW    COMP
         DW    XPLOO
         DW    BACK
         DW    SEMIS
*
         DB    0C5H             ;  UNTIL
         DB   'UNTI'
         DB    'L'+80H
         DW    PLOOP-8
UNTIL    DW    DOCOL
         DW    ONE              ;                PAGE54
         DW    QPAIRS
         DW    COMP
         DW    ZBRAN
         DW    BACK
         DW    SEMIS
*
         DB    0C3H             ;  END
         DB   'EN'
         DB    'D'+80H
         DW    UNTIL-8
END@      DW    DOCOL
         DW    UNTIL
         DW    SEMIS
*
         DB    0C5H             ;  AGAIN
         DB   'AGAI'
         DB    'N'+80H
         DW    END@-6
AGAIN    DW    DOCOL
         DW    ONE
         DW    QPAIRS
         DW    COMP
         DW    BRAN
         DW    BACK
         DW    SEMIS
*
         DB    0C6H             ;  REPEAT
         DB   'REPEA'
         DB    'T'+80H
         DW    AGAIN-8
REPEA    DW    DOCOL
         DW    TOR
         DW    TOR
         DW    AGAIN
         DW    FROMR
         DW    FROMR
         DW    TWO
         DW    SUB@
         DW    END@IF
         DW    SEMIS
*
         DB    0C2H             ;  IF
         DB   'I'
         DB    'F'+80H
         DW    REPEA-9
IF@       DW    DOCOL
         DW    COMP
         DW    ZBRAN
         DW    HERE
         DW    ZERO
         DW    COMMA
         DW    TWO
         DW    SEMIS
*                               ;                PAGE55
         DB    0C4H             ;  ELSE
         DB   'ELS'
         DB    'E'+80H
         DW    IF@-5
ELSE@     DW    DOCOL
         DW    TWO
         DW    QPAIRS
         DW    COMP
         DW    BRAN
         DW    HERE
         DW    ZERO
         DW    SWAP
         DW    TWO
         DW    END@IF
         DW    TWO
         DW    SEMIS
*
         DB    0C5H             ;  WHILE
         DB   'WHIL'
         DB    'E'+80H
         DW    ELSE@-7
WHILE    DW    DOCOL
         DW    IF@
         DW    TWOP
         DW    SEMIS
*
         DB    86H              ;  SPACES
         DB   'SPACE'
         DB    'S'+80H
         DW    WHILE-8
SPACS    DW    DOCOL
         DW    ZERO
         DW    MAX
         DW    DDUP
         DW    ZBRAN            ;  IF
         DW    SPAX1-$
         DW    ZERO
         DW    XDO              ;  DO
SPAX2    DW    SPACE
         DW    XLOOP            ;  LOOP      ENDIF
         DW    SPAX2-$
SPAX1    DW    SEMIS
*
         DB    82H              ;  <#
         DB   '<'
         DB    '#'+80H
         DW    SPACS-9
BDIGS    DW    DOCOL
         DW    PAD
         DW    HLD
         DW    STORE
         DW    SEMIS
*
         DB    82H              ;  #>       ????????     PAGE56
         DB   '#'
         DB    '>'+80H
         DW    BDIGS-5
EDIGS    DW    DOCOL
         DW    DROP
         DW    DROP
         DW    HLD
         DW    AT
         DW    PAD
         DW    OVER
         DW    SUB@
         DW    SEMIS
*
         DB    84H              ;  SIGN
         DB   'SIG'
         DB    'N'+80H
         DW    EDIGS-5
SIGN     DW    DOCOL
         DW    ROT
         DW    ZLESS
         DW    ZBRAN            ;  IF
         DW    SIGN1-$
         DW    LIT
         DW    2DH
         DW    HOLD             ;  ENDIF
SIGN1    DW    SEMIS
*
         DB    81H              ;  #
         DB    '#'+80H
         DW    SIGN-7
DIG      DW    DOCOL
         DW    BASE
         DW    AT
         DW    MSMOD
         DW    ROT
         DW    LIT
         DW    9
         DW    OVER
         DW    LESS
         DW    ZBRAN            ;  IF
         DW    DIG1-$
         DW    LIT
         DW    7
         DW    PLUS             ;  ENDIF
DIG1     DW    LIT
         DW    30H
         DW    PLUS
         DW    HOLD
         DW    SEMIS
*
         DB    82H              ;  #S
         DB   '#'
         DB    'S'+80H
         DW    DIG-4
DIGS     DW    DOCOL            ;                PAGE57
DIGS1    DW    DIG              ;  BEGIN
         DW    OVER
         DW    OVER
         DW    OR@
         DW    ZEQU
         DW    ZBRAN
         DW    DIGS1-$
         DW    SEMIS
*
         DB    83H              ;  D.R
         DB   'D.'
         DB    'R'+80H
         DW    DIGS-5
DDOTR    DW    DOCOL
         DW    TOR
         DW    SWAP
         DW    OVER
         DW    DABS
         DW    BDIGS
         DW    DIGS
         DW    SIGN
         DW    EDIGS
         DW    FROMR
         DW    OVER
         DW    SUB@
         DW    SPACS
         DW    TYPE
         DW    SEMIS
*
         DB    82H              ;  .R
         DB   '.'
         DB    'R'+80H
         DW    DDOTR-6
DOTR     DW    DOCOL
         DW    TOR
         DW    STOD
         DW    FROMR
         DW    DDOTR
         DW    SEMIS
*
         DB    82H              ;  D.
         DB   'D'
         DB    '.'+80H
         DW    DOTR-5
DDOT     DW    DOCOL
         DW    ZERO
         DW    DDOTR
         DW    SPACE
         DW    SEMIS
*
         DB    81H              ;  .
         DB    '.'+80H
         DW    DDOT-5
DOT      DW    DOCOL
         DW    STOD             ;                PAGE58
         DW    DDOT
         DW    SEMIS
*
         DB    81H              ;  ?
         DB    '?'+80H
         DW    DOT-4
QUES     DW    DOCOL
         DW    AT
         DW    DOT
         DW    SEMIS
*
         DB    82H              ;  U.
         DB   'U'
         DB    '.'+80H
         DW    QUES-4
UDOT     DW    DOCOL
         DW    ZERO
         DW    DDOT
         DW    SEMIS
*
         DB    85H              ;  VLIST
         DB   'VLIS'
         DB    'T'+80H
         DW    UDOT-5
VLIST    DW    DOCOL
         DW    LIT
         DW    80H
         DW    OUT
         DW    STORE
         DW    CONT
         DW    AT
         DW    AT
VLIS1    DW    OUT              ;  BEGIN
         DW    LIT
         DW    64
         DW    GREAT
         DW    ZBRAN            ;  IF
         DW    VLIS2-$
         DW    CR
         DW    ZERO
         DW    OUT
         DW    STORE            ;  ENDIF
VLIS2    DW    DUP
         DW    IDDOT
         DW    SPACE
         DW    SPACE
         DW    PFA
         DW    LFA
         DW    AT
         DW    DUP
         DW    ZEQU
         DW    QTERM
         DW    OR@
         DW    ZBRAN            ;  IF
         DW    VLIS3-$          ;                PAGE59
         DW    QUIT             ;  ENDIF
VLIS3    DW    BRAN             ;  AGAIN
         DW    VLIS1-$
         DW    SEMIS
*
         DB    84H              ;  TASK
         DB   'TAS'
         DB    'K'+80H
         DW    VLIST-8
TASK     DW    DOCOL
         DW    SEMIS
*
**********************************************    PAGE60
* SUPPLEMENT TO FIG FORTH-8080
* EXAMPLE OF BLOCK & BUFFER
*
*
         DB    83H              ;  USE
         DB   'US'
         DB    'E'+80H
         DW    DABS-7
USE      DW    DOVAR
         DW    FIRST
*
         DB    84H              ;  PREV
         DB   'PRE'
         DB    'V'+80H
         DW    USE-6
PREV     DW    DOVAR
         DW    FIRST
*
         DB    84H              ;  +BUF
         DB   '+BU'
         DB    'F'+80H
         DW    PREV-7
PBUF     DW    DOCOL
         DW    LIT
         DW    404H
         DW    PLUS
         DW    DUP
         DW    LIMIT
         DW    EQUAL
         DW    ZBRAN
         DW    PBUF1-$          ;  IF
         DW    DROP
         DW    FIRST            ;  ENDIF
PBUF1    DW    DUP
         DW    PREV
         DW    AT
         DW    SUB@
         DW    SEMIS
*                               ;                PAGE61
         DB    86H              ;  UPDATE
         DB   'UPDAT'
         DB    'E'+80H
         DW    PBUF-7
UPDAT    DW    DOCOL
         DW    PREV
         DW    AT
         DW    AT
         DW    LIT
         DW    8000H
         DW    OR@
         DW    PREV
         DW    AT
         DW    STORE
         DW    SEMIS
*
         DB    8DH              ;  EMPTY.BUFFERS
         DB   'EMPTY.BUFFER'
         DB    'S'+80H
         DW    UPDAT-9
MTBUF    DW    FIRST
         DW    LIMIT
         DW    OVER
         DW    SUB@
         DW    ERASE
         DW    SEMIS
*
         DB    83H              ;  DR0
         DB   'DR'
         DB    '0'+80H
         DW    MTBUF-16
DRZER    DW    DOCOL
         DW    ZERO
         DW    OFSET
         DW    STORE
         DW    SEMIS
*
         DB    83H              ;  DR1
         DB   'DR'
         DB    '1'+80H
         DW    DRZER-6
DRONE    DW    DOCOL
         DW    LIT
         DW    7D0H             ;  DEVICE DEPENDENT
         DW    OFSET
         DW    STORE
*
         DB    86H              ;  BUFFER
         DB   'BUFFE'
         DB    'R'+80H
         DW    DRONE-6
BUFFE    DW    DOCOL
         DW    USE
         DW    AT
         DW    DUP
         DW    TOR
BUFF1    DW    PBUF             ;  BEGIN
         DW    ZBRAN            ;  UNTIL
         DW    BUFF1-$
         DW    USE              ;                PAGE62
         DW    STORE
         DW    R
         DW    AT
         DW    ZLESS
         DW    ZBRAN            ;  IF
         DW    BUFF2-$
         DW    R
         DW    TWOP
         DW    R
         DW    AT
         DW    LIT
         DW    7FFFH
         DW    AND@
         DW    ZERO
         DW    QSTAC            ;  (STUB FOR R/W)
BUFF2    DW    R
         DW    STORE
         DW    R
         DW    PREV
         DW    STORE
         DW    FROMR
         DW    TWOP
         DW    SEMIS
*
         DB    85H              ;  BLOCK
         DB   'BLOC'
         DB    'K'+80H
         DW    BUFFE-9
BLOCK    DW    DOCOL
         DW    OFSET
         DW    AT
         DW    TOR
         DW    PREV
         DW    AT
         DW    DUP
         DW    AT
         DW    R
         DW    SUB@
         DW    DUP
         DW    PLUS
         DW    ZBRAN            ;  IF
         DW    BLOC1-$
BLOC2    DW    PBUF             ;  BEGIN
         DW    ZEQU
         DW    ZBRAN            ;  IF
         DW    BLOC3-$
         DW    DROP
         DW    R
         DW    BUFFE
         DW    DUP
         DW    R
         DW    ONE
         DW    QSTAC            ;  (R/W)
         DW    TWO
         DW    SUB@
BLOC3    DW    DUP
         DW    AT
         DW    R                ;                PAGE63
         DW    SUB@
         DW    DUP
         DW    PLUS
         DW    ZEQU
         DW    ZBRAN            ;  UNTIL
         DW    BLOC2-$
         DW    DUP
         DW    PREV
         DW    STORE
BLOC1    DW    FROMR            ;  ENDIF
         DW    DROP
         DW    TWOP
         DW    SEMIS
*
	END
