	TITLE	'8080 TEXT PROCESSING SYSTEM (F)'
	PAGE	54



*=======================================================
*							I
*	TSC 8080 TEXT PROCESSING SYSTEM			I
*							I
*	COPYRIGHT (C) 1978 BY				I
*							I
*	TECHNICAL SYSTEMS CONSULTANTS, INC.		I
*	P.O. BOX 2574					I
*	WEST LAFAYETTE, IN 47906			I
*							I
*=======================================================

* EQUATES

SLECTF	EQU	14
OPENF	EQU	15
CLOSEF	EQU	16
READF	EQU	20
WRITEF	EQU	21
MAKEF	EQU	22
IDNF	EQU	25
SDMAF	EQU	26

BDOS	EQU	0005H
TBUFF	EQU	0080H


	ORG	100H

********************************************************
*	ENTRY POINT FOR STARTUP
*
START	LXI	SP,STACK	;CLEAR FLAGS
	XRA	A
	STA	CRTFLG
	STA	LINVAL
	STA	LOPG
	STA	DISK
	STA	ECHO
	STA	DFEXT
	DCR	A
	STA	HIPG

	CALL	LPINIT		;INITIALIZE THE PRINTER

* INITIALIZATION DIALOG
	CALL	TRMCRL
	LXI	H,COPY1		;PRINT COPYRIGHT MESSAGE
	CALL	CRDATA
	LXI	H,COPY2
	CALL	CRDATA

* PARSE DISK COMMAND LINE

	LXI	D,TXTBUF+1	
	MVI	C,SDMAF		;SET DMA BUFFER
	CALL	BDOS
	MVI	C,IDNF		;FIND LOGGED DRIVE
	CALL	BDOS
	STA	LOGDR		;SAVE IT
	LXI	H,TBUFF		;FIND END OF COMMAND
	MOV	A,M		;LINE AND INSERT AN EOT
	INX	H
	PUSH	H
	CALL	ADAHL
	MVI	M,04
	POP	H
	CALL	SKIP		;SKIP SPACES AND COMMA
	CALL	SFILE		;SETUP FIRST FILE
	JC	SFERR		;JUMP IF AN ERROR
	JMP	GETDT		;GO GET DATE

* SETUP NEXT FILE ON COMMAND LINE

SFILE	MOV	A,M		;GET CHARACTER
	CPI	'*'		;CHANGE DISK SIGNAL ?
	JNZ	SFILE0		;SKIP IF NOT
	PUSH	H
	CALL	TRMCRL
	LXI	H,CHGDSK	;PROMPT FOR DISK CHANGE
	CALL	CRDATA
	CALL	TRMIN		;GET CONTINUE SIGNAL
	CALL	TRMCRL
	POP	H
	INX	H		;POINT TO NEXT CHAR
	SHLD	CMDPT		;SAVE POINTER
	MOV	A,M		;GET NEXT CHARACTER
	CALL	ISTRM1		;A SPC, COMMA OR EOT ?
	JNC	SFILEX		;ERROR IF NOT
	CALL	SKIP		;SKIP SPACES AND COMMA
	JMP	SFILE		;GET NEXT SPECIFICATION
SFILEX	XRA	A		;ELSE, SET ERROR TYPE
	STC			;SET ERROR FLAG
	RET
SFILE0	LXI	D,TXTFCB	;POINT TO FCB
	CALL	GETFN		;GET FILE SPECIFICATION
	SHLD	CMDPT		;SAVE POINTER
	JNC	SFILE1		;SKIP IF NO ERROR
	MVI	A,00		;SET ERROR TYPE
	RET			;(CARRY ALREADY SET)
SFILE1	MVI	A,7FH		;SET BUFFER POINTERS
	STA	TXTBUF
	LXI	D,TXTFCB
	CALL	OPEN		;OPEN THE FILE
	CPI	0FFH
	JNZ	SFILE2
	STC			;SET FILE NOT FOUND ERROR
	RET
SFILE2	XRA	A		;CLEAR CARRY
	STA	TXTFCB+32	;CLEAR NR BYTE
	RET

* ERROR IN SETTING UP FILE

SFERR	LXI	H,FNFERR
	ORA	A		;POINT TO PROPER STRING
	JNZ	ERR1
	LXI	H,IFSERR
ERR1	CALL	CRDATA		;PRINT MESSAGE
	JMP	EXIT2

* READ CHARACTER FROM EXTERNAL DATE FILE

READX	CALL	READD		;READ A CHAR FROM DISK
	CPI	1AH
	RZ			;END OF FILE OK
	CPI	0DH
	RZ			;RETURN OK
	CPI	20H
	JC	READX		;IGNORE OTHER CONTROL CHARS
	RET

READD	PUSH	H		;SAVE HL
	LXI	H,DATBUF	;GET DMA BUFFER
	INR	M
	MOV	A,M
	CPI	80H		;IS BUFFER DEPLETED ?
	JNZ	READC3		;SKIP IF NOT
	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H		;ADJUST BUFFER POINTER
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,DATFCB	;GET FCB ADDRESS
	JMP	RDDSK2		;FINISH UP READ

* READ A CHARACTER FROM DISK

READCH	PUSH	H		;SAVE H-L
	LXI	H,TXTBUF	;GET PROPER DMA BUFFER
	INR	M		;INCR DMA BUFFER PTR
	MOV	A,M
	CPI	80H		;IS BUFFER DEPLETED ?
	JNZ	READC3		;SKIP IF NOT
RDDSK	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H		;ADJUST BUFFER POINTER
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,TXTFCB	;GET PROPER FCB ADDRESS
RDDSK2	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,READF		;READ A SECTOR
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	CPI	00
	JZ	READC2		;SKIP IF NO ERRORS
	CPI	01		;READ PAST EOF ?
	JNZ	RDERR		;SKIP IF NOT
	MVI	M,7FH		;SET BYTES
	MVI	A,1AH
	POP	H		;RESTORE H-L
	STC			;SET ERROR FLAG
	RET
READC2	MOV	M,A		;SET DMA BUFFER POINTER
READC3	INX	H
	CALL	ADAHL		;GET BYTE ADDRESS
	MOV	A,M		;GET THE CHARACTER
	ORA	A		;CLEAR CARRY
	POP	H		;RESTORE H-L
	RET
RDERR	LXI	H,RERR		;REPORT READ ERROR
	JMP	ERR1		;EXIT THE PROCESSOR

* WRITE A CHARACTER TO DISK

WRTCH	PUSH	H
	PUSH	PSW		;SAVE THE CHARACTER
	LXI	H,PRNBUF	;GET PROPER BUFFER ADDRESS
	INR	M		;INCR DMA BUFFER PTR
	MOV	A,M
	CPI	80H		;IS BUFFER FULL ?
	JNZ	WRTCH3		;SKIP IF NOT
WRDSK	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	INX	H
	XCHG
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	LXI	D,PRNFCB	;GET PROPER FCB ADDRESS
	CALL	SELECT		;SELECT PROPER DRIVE
	MVI	C,WRITEF	;WRITE A SECTOR
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	CPI	00		;ANY ERRORS ?
	JZ	WRTCH2		;SKIP IF NOT
	CPI	02		;IS DISK FULL ?
	JNZ	WRDSK2		;SKIP IF NOT
	LXI	H,DFERR		;POINT TO FULL STRING
	JMP	WRDSK3
WRDSK2	LXI	H,WERR		;POINT TO ERROR STRING
WRDSK3	CALL	CRDATA		;PRINT IT
	POP	PSW		;ADJUST STACK
	POP	PSW
	POP	PSW
	JMP	EXIT2		;EXIT THE PROCESSOR
WRTCH2	MOV	M,A		;SET DMA BUFFER PTR
WRTCH3	INX	H
	CALL	ADAHL		;GET CHARACTER ADDRESS
	POP	PSW		;RESTORE THE CHARACTER
	MOV	M,A		;PUT IT IN BUFFER
	POP	H
	RET

* PROMPT FOR FILE NAME

GFILE	PUSH	H
	CALL	CRDATA		;PROMPT FOR FILE NAME
	CALL	TRMLIN		;GET RESPONSE
	LXI	H,GIBUF		;POINT TO RESPONSE
	CALL	SPANC
	CALL	GETFN		;GET FILE SPECIFICATION
	POP	H
	RNC			;RETURN IF NO ERROR
	PUSH	H
	LXI	H,IFSERR	;ELSE REPORT ERROR
	CALL	CRDATA
	POP	H
	JMP	GFILE		;PROMPT AGAIN

* GET FILE SPECIFICATION ROUTINE

GETFN	PUSH	D
	PUSH	H
	XCHG
	SHLD	FCBADR		;SAVE FCB ADDRESS
	MOV	D,H
	MOV	E,L
	MVI	A,33
	CALL	ADAHL		;POINT TO DRIVE NUMBER
	LDA	LOGDR
	MOV	M,A		;SET TO LOGIN DRIVE
	LXI	H,CLRFCB
	CALL	XFR16		;INITIALIZE THE FCB
	POP	H
	POP	D
	INX	D		;POINT TO FCB NAME
	INX	H		;POINT TO 2ND CHAR
	MOV	A,M
	CPI	':'		;IS IT DRIVE SEPARATOR ?
	JZ	SETDRV		;IF SO, SET DRIVE
	DCX	H		;ELSE BACKUP POINTER
GETFN3	MOV	A,M		;GET A CHARACTER
	CALL	VALID2		;A VALID LETTER ?
	JNC	GFNERR		;ERROR IF NOT
	MVI	C,08		;SET MAX LENGTH
	CALL	GETNM		;GET THE NAME
	JC	GFNERR		;JUMP IF ERROR
	CPI	'.'		;WAS DELIMITER A '.' ?
	JNZ	DFTEXT		;DEFAULT EXTENSION IF NOT
	INX	H		;PASS UP PERIOD
GETFN4	XCHG
	LHLD	FCBADR		;GET EXTENSION ADDRESS
	MVI	A,09		;WITHIN THE FCB
	CALL	ADAHL
	XCHG
	MVI	C,03		;SET MAX LENGTH
	CALL	GETNM		;GET EXTENSION
	JC	GFNERR		;SKIP IF ERROR
	CPI	'.'		;CHECK TERMINATOR
	JZ	GFNERR		;PERIOD IS INVALID
	ORA	A		;CLEAR CARRY
GETFN5	XCHG
	LHLD	FCBADR		;RESTORE FCB ADDRESS
	XCHG
	RET
GFNERR	STC			;SET ERROR FLAG
	JMP	GETFN5		;GO RESTORE FCB ADDRESS
DFTEXT	PUSH	H
	LXI	H,EXT		;POINT TO DEFAULT EXT
	LDA	DFEXT		;CHECK WHICH DEFAULT TO USE
	ORA	A
	JZ	DFEXT1		;SKIP IF TXT
	LXI	H,EXT2		;POINT TO PRN DEFAULT
DFEXT1	CALL	GETFN4		;COPY INTO FCB
	POP	H
	RET
SETDRV	DCX	H		;POINT TO DRIVE CHAR
	MOV	A,M
	CALL	VALID2		;ENSURE UPPER CASE
	SUI	'A'		;CHECK FOR A TO D
	JC	GFNERR		;ERROR IF NOT
	CPI	04
	JNC	GFNERR
	PUSH	H
	PUSH	PSW
	LHLD	FCBADR		;PUT IN DRIVE NUMBER
	MVI	A,33		;POSITION OF FCB
	CALL	ADAHL
	POP	PSW
	MOV	M,A
	POP	H
	INX	H
	INX	H
	JMP	GETFN3		;NOW GET NAME

* GET NAME FROM H/L INTO D/E

GETNM	INR	C
GETNM1	MOV	A,M		;GET A CHARACTER
	CALL	VALID		;A VALID NAME CHARACTER ?
	JNC	GETNM2		;EXIT IF NOT
	DCR	C		;DECR MAX COUNT
	JZ	SETCRY		;AN ERROR IF HIT MAX
	STAX	D		;PUT IN FCB
	INX	D
	INX	H
	JMP	GETNM1		;GO GET NEXT CHAR
GETNM2	CALL	ISTERM		;A SPC , . OR EOT ?
	JC	CLRCRY		;RETURN IF ONE OF ABOVE
	STC			;SET ERROR FLAG IF NOT
	RET

* CHECK FOR NAME TERMINATOR

ISTERM	CPI	'.'
	JZ	SETCRY		;PERIOD IS GOOD
ISTRM1	CPI	' '
	JZ	SETCRY		;SPACE IS GOOD
	CPI	','
	JZ	SETCRY		;COMMA IS GOOD
	CPI	04
	JZ	SETCRY		;EOT IS GOOD
CLRCRY	ORA	A		;ELSE NOT A DELIMITER
	RET
SETCRY	STC
	RET

* CHECK FOR A VALID FILE NAME CHARACTER

VALID	CPI	'-'		;HYPHEN (2DH)
	JZ	SETCRY		;A HYPHEN IS VALID
	CPI	5FH		;UNDERSCORE
	JZ	SETCRY		;AN UNDERSCORE IS VALID
VALID1	CPI	'0'		;CHECK FOR A DIGIT
	JC	VALID2
	CPI	'9'+1
	JC	SETCRY		;A VALID DIGIT
VALID2	CPI	61H		;CHECK FOR LOWER CASE
	JC	VALID3
	CPI	7BH
	JNC	VALID3
	SUI	20H		;CONVERT TO UPPER CASE
VALID3	CPI	'A'		;CHECK FOR A LETTER
	JC	CLRCRY
	CPI	'Z'+1
	JC	SETCRY		;A VALID LETTER
	ORA	A
	RET

* SKIP SPACES AND ONE COMMA

SKIP	CALL	SPANC		;SKIP SPACES
	CPI	','		;IS NEXT CHAR A COMMA ?
	RNZ			;RETURN IF NOT
	INX	H		;ELSE, PASS IT UP
	CALL	SPANC		;SKIP SPACES
	RET

* SELECT THE PROPER DRIVE

SELECT	PUSH	D		;SAVE FCB ADDRESS
	XCHG
	MVI	A,33		;GET DRIVE NBR FROM FCB
	CALL	ADAHL
	MOV	E,M		;PUT IN E
	MVI	C,SLECTF	;SELECT THAT DRIVE
	CALL	BDOS
	POP	D		;RESTORE FCB ADDRESS
	RET

* OPEN FILE ROUTINE

OPEN	PUSH	D		;SAVE FCB ADDRESS
	CALL	SELECT		;SELECT THE DRIVE
	MVI	C,OPENF		;OPEN THE FILE
	CALL	BDOS
	POP	D		;RESTORE FCB ADDRESS
	RET

* COPY FROM H/L INTO D/E

XFR16	MVI	B,16		;SETUP FOR 16 BYTE COPY
TRNSFR	MOV	A,M		;COPY CHARACTERS
	INX	H
	STAX	D
	INX	D
	DCR	B
	JNZ	TRNSFR
	RET

* ADD A TO H/L REGISTER PAIR

ADAHL	ADD	L
	MOV	L,A
	RNC
	INR	H
	RET


********************************************************

* GET DATE

GETDT	CALL	TRMCRL		;PRINT CRLF
	LXI	H,ISTR1		;PRINT DATE PROMPT
	CALL	CRDATA
	CALL	TRMLIN

	CALL	SPNDG		;FIND DIGIT
	JC	PRTR		;SKIP IF NONE
	CALL	ATOB		;CONVERT TO BINARY
	STA	NOM

	CALL	SPNDG
	CC	TRMERR		;IF NO NEXT DIGIT, PRINT '??'
	CALL	ATOB
	STA	NOD

	CALL	SPNDG
	CC	TRMERR
	CALL	ATOB
	STA	NOY

* PRINTER / TERMINAL SELECT
PRTR	LXI	H,ISTR2
	CALL	CRDATA
	CALL	TRMIN		;GET CHARACTER
	CALL	UCASE
	CPI	'P'		;IS IT 'PRINTER' ?
	JZ	PRTR3		;SKIP IF SO
	CPI	'D'		;IS IT 'DISK' ?
	JNZ	LPS		;IF NOT, IT'S CONSOLE

* GET PRINT FILE NAME AND OPEN FOR WRITE

	LXI	D,PRNBUF+1
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	MVI	A,01
	STA	DFEXT		;SET DEFAULT EXT = PRN
	LXI	D,PRNFCB
	LXI	H,FLNAM
	CALL	GFILE		;PROMPT FOR FILE NAME
	XRA	A
	STA	DFEXT		;SET BACK TO TXT EXTENSION
	CALL	OPEN		;OPEN IT
	CPI	0FFH
	JZ	PRTR24		;SKIP IF NOT FOUND
	LXI	H,FEERR		;ELSE REPORT ERROR
	JMP	ERR1
PRTR24	MVI	C,MAKEF		;CREATE THE FILE
	CALL	BDOS
	CPI	0FFH
	JNZ	PRTR26		;SKIP IF NO ERROR
	LXI	H,NDSERR	;REPORT ERROR
	JMP	ERR1
PRTR26	XRA	A
	STA	PRNFCB+32	;CLEAR NR BYTE
	CMA
	STA	PRNBUF		;INITIALIZE BUFFER
	STA	DISK		;SET DISK PRINT FILE FLAG

PRTR3	LXI	H,ECHOS		;ASK TO ECHO
	CALL	CRDATA
	CALL	TRMIN		;GET RESPONSE
	CALL	UCASE
	CPI	'Y'		;WAS RESPONSE YES ?
	JNZ	PLIM
	STA	ECHO		;SET ECHO FLAG IF SO
	JMP	PLIM

* NBR OF LINES PER SCREEN ON CRT
LPS	MVI	A,01
	STA	CRTFLG		;ELSE SET FLAG
	LXI	H,ISTR3
	CALL	CRDATA
	CALL	TRMLIN
	CALL	SPNDG
	JC	PLIM
	CALL	ATOB
	STA	LINVAL

* PAGE LIMITS
PLIM	LXI	H,ISTR4		;ASK PAGE LIMITS
	CALL	CRDATA
	CALL	TRMLIN		;GET RESPONSE
	PUSH	H
	CALL	TRMCRL		;DO LINE FEEDS
	CALL	TRMCRL
	POP	H
	CALL	SPNDG
	CC	ENTRY
	CALL	ATOB
	STA	LOPG

	CALL	SPNDG
	JC	ENTRY
	CALL	ATOB
	STA	HIPG

	JMP	ENTRY

* INITIALIZATION NOW COMPLETE
*------------------------------

* TRMLIN
* GET INPUT LINE FROM TERMINAL, PUT IN IBUF
TRMLIN	LXI	H,GIBUF
	XRA	A		;CLEAR GI COUNT
	STA	NOG
TRML1	CALL	TRMIN		;GET CHARACTER
	MOV	M,A		;PUT IN IBUF
	CPI	03		;IS IT EXIT CHAR ?
	JZ	EXIT2		;EXIT PROCESSOR IF SO
	CPI	08		;IS IT BACKSPACE ?
	JZ	BACKS		;JUMP IF SO
	CPI	18H		;IS IT CTRL-X ?
	JZ	TRMERR		;JMP IF SO
	CPI	0DH		;OR WAS IT CR ?
	JZ	LINDUN		;JMP IF SO
	INX	H		;ELSE BUMP PTR FOR NXT CHAR
	LDA	NOG		;INCREMENT GI COUNT
	INR	A
	JM	TRMERR		;ERROR IF TOO LONG
	STA	NOG
	JMP	TRML1

LINDUN	MVI	M,04		;MARK END OF LINE IN IBUF
	LXI	H,GIBUF		;RESET POINTER
	SHLD	GIPTR
	RET

TRMERR	LXI	H,BADEXP	;PRINT '?? '
	CALL	CRDATA
	JMP	TRMLIN		;GET LINE AGAIN

BACKS	LDA	NOG
	DCR	A		;DECREMENT COUNT
	JM	TRMERR		;ERROR IF PAST BEGINNING
	STA	NOG
	DCX	H		;BACKUP POINTER
	JMP	TRML1		;GET ANOTHER CHAR

* SPAN IBUF UNTIL DIGIT FOUND.  RETURN WITH CY SET
* IF 04H FOUND INSTEAD.
SPNDG	MOV	A,M		;GET CHAR
	CPI	04		;END ?
	JZ	SPGR		;JMP IF SO
	CALL	DIGCHK		;ELSE IS IT A DIGIT ?
	RNC			;RETURN IF SO
	INX	H		;ELSE TRY NEXT ONE
	JMP	SPNDG
SPGR	STC			;SET CY TO SHOW NO DIGIT
	RET

********************************************************
*
*	INITIALIZE PROCESSOR VARIABLES AND FLAGS
*
*

ENTRY	LXI	SP,STACK
	LXI	H,GIBUF
	SHLD	GIPTR
	XRA	A
	STA	CURENV
	STA	EXPTYP
	STA	SICNT
	STA	TEMPSI
	STA	DVTFLG
	STA	NOSPC
	STA	NXTPG
	STA	LMARG
	STA	MACTBL
	STA	TTBL
	STA	TRMFLG
	STA	RIFLG
	STA	RICNT
	STA	LINCNT
	STA	RUNFLG
	STA	EXTOPN
	STA	LASTX
	STA	SUPFLG
* SET NUMBER REGISTERS
	STA	NOA
	STA	NOB
	STA	NOC
	STA	NOE
	STA	NOF
	STA	NOG
	STA	NOH
	STA	NOJ
	STA	NOK
	STA	NOO
	STA	NOQ
	STA	NOR
	STA	NOS
	STA	NOOT
	STA	NOU
	STA	NOV
	STA	NOW
	STA	NOX
	STA	NOZ
	STA	TABTBL
	STA	TABCHR
	STA	CEFLG
	STA	PIFLG
	STA	CPON
	STA	CPFLG

	MVI	A,0A0H
	STA	FILCHR

	MVI	A,01
	STA	NPG
	STA	NON
	MVI	A,66
	STA	NOOP

* CLEAR MSPACE
	MVI	C,00
	LXI	H,MSPACE	;GET MSPACE BEGIN ADDRESS
	PUSH	H		;SAVE IT
	XRA	A
	SUB	L		;NEGATE L.S. HALF
	MOV	L,A
	MVI	A,00
	SBB	H		;NEGATE M.S. HALF
	MOV	H,A
	XCHG
	LHLD	BDOS+1		;GET UPPER MEMORY LIMIT
	DCR	H
	DAD	D		;SUBTRACT BEGIN
	XCHG			;PUT SIZE OF SPACE IN DE
	POP	H		;GET MSPACE START ADDRESS
	SHLD	FSTAVL
	CALL	PREST		;CLEAR MACRO SPACE
	MVI	M,0FFH		;PUT IN END MARKER
	SHLD	LSTAVL
	INX	H
	MVI	M,00
	INX	H
	MVI	M,00

	LXI	H,0000
	SHLD	MPTR

* INITIALIZE THE ENVIRONMENTS
	CALL	ENINT
	CALL	TRPCHK
	JMP	NEWLIN

ENINT	CALL	EINT
EINT	MVI	A,01
	STA	FILFLG
	STA	JSTFLG

	MOV	C,A
	LXI	H,EXPBUF
	LXI	D,10
	CALL	PREST

	MVI	A,02
	STA	JUSTYP

	XRA	A
	STA	EXPBUF
	STA	LINSP
	STA	AUINC
	STA	LSTCHR
	STA	CHRCNT
	STA	SPCFLG
	STA	SFLG2
	STA	OSVD
	STA	NOPAD
	STA	NOI
	STA	TEMPIN
	STA	PADCNT
	STA	REMCNT
	STA	SPCNT

	MVI	A,'>'
	STA	ICHAR

	MVI	A,65
	STA	NOL
	STA	TEMPLN
	STA	TLLEN

	LXI	H,PBUF
	SHLD	PBFPTR

	CALL	EVSWAP
	RET



*========
* SET
* USED TO INITIALIZE MEMORY BLOCKS
* ASSUMES STARTING ADRS OF BLOCK IN HL, BYTE TO BE
* STORED IN ALL BYTES OF BLOCK IN 'C',
* NUMBER OF BYTES IN BLOCK IN DE PAIR.
* RETURNS WITH 'A' TRASHED, BC UNCHANGED,
* DE = 0 AND HL POINTING TO 1ST BYTE FOLLOWING BLOCK.
PREST	MOV	M,C		;STORE BYTE
	INX	H		;INCR POINTER
	DCX	D		;DECREMENT COUNTER
	MOV	A,D		;CHECK FOR 0
	ORA	E
	JNZ	PREST
	RET


********************************************************
*
* NEWLIN GETS NEW INPUT LINE AND PROCESSES IT.
*
********************************************************

NEWLIN	XRA	A
	STA	SPECL		;CLEAR FLAGS
	STA	SUPFL2
	CALL	GETLIN		;GET NEXT INPUT LINE
	RC			;RETURN TO MACRO-INVOKING
*				;ROUTINE IF MSPACE EXHAUSTED
*
*
	LXI	H,IBUF
	SHLD	IBFPTR
*
	MOV	A,M
	CPI	'.'		;DOES LINE START WITH '.' ?
	JZ	CMDPRO		;OR A
	CPI	':'		;':' - PROCESS COMMAND
	JZ	CMDPRO

* LINE WASN'T COMMAND
* IF FROM TEXT FILE, EXPAND NBR REGISTERS

	LDA	SUPFLG		;SUPPRESS ON ?
	ORA	A
	JZ	NEWL2		;SKIP IF NOT
	STA	SUPFL2		;ELSE SET FLAG
	XRA	A
	STA	SUPFLG
NEWL0	MOV	A,M		;FIND END OF LINE
	INX	H
	CPI	04
	JNZ	NEWL0
	DCX	H		;BACKUP TO LAST CHAR
NEWL1	DCX	H
	MOV	A,M		;GET LAST CHAR
	CPI	' '		;A SPACE ?
	JNZ	NEWL2		;SKIP IF NOT
	MVI	M,04		;GET RID OF SPACE
	SHLD	EMRKR		;SET NEW END MARKER
	JMP	NEWL1		;LOOK FOR MORE SPACES
NEWL2	LXI	H,IBUF		;POINT TO START OF LINE
	SHLD	IBFPTR
	LDA	SPECL		;FROM OTHER THAN TEXT FILE ?
	ORA	A
	CZ	TEXP		;IF NOT EXPAND NBR REGS
*
	LDA	CEFLG		;SEE IF LINE IS TO BE CENTERED
	ORA	A
	JNZ	CELIN		;JMP IF SO

	LDA	FILFLG		;SEE IF FILL IS ON
	ORA	A
	JNZ	NEWL4		;JUMP IF SO
* FILL NOT ON - PRINT CONTENTS OF IBUF AS-IS
* FIRST POINT IBFPTR TO 04 BYTE SINCE ENTIRE LINE WILL
* BE PRINTED
NEWL3	LHLD	EMRKR		;GET END MARKER
	SHLD	IBFPTR
	CALL	FIXWD		;UPDATE LINE WIDTH DATA
	CALL	LFTMG		;PRINT LEFT MARGIN IF ANY
	CALL	PRINDT		;PRINT INDENT IF ANY
	LXI	H,IBUF
	CALL	PDATAP		;PRINT THE LINE
	CALL	LFEED		;SEND CRLF'S
	JMP	NEWLIN
*
* NOW LINE IS JUST TEXT AND FILL IS ON -
* SCAN IBUF FOR '.' OR 'EXCLAM' OR '?' AND INSURE THERE ARE
* AT LEAST 2 SPACES AFTER EACH WHICH IS ALREADY
* FOLLOWED BY AT LEAST 1
NEWL4	PUSH	H		;SAVE POINTER
LED	MOV	A,M		;GET CHARACTER
	CPI	04		;CHECK FOR END
	JNZ	LED2
	POP	H
	JMP	LEDR

LED2	CALL	PUNCT		;A SENTENCE PUNCTUATION ?
	JC	LED3		;JUMP IF SO

* TRY NEXT CHAR
	INX	H
	JMP	LED

* '.' OR 'EXCLAM' OR '?' FOUND
LED3	PUSH	H		;SAVE POINTER
	INX	H		;IS IT FOLLOWED BY BLANK ?
	MOV	A,M
	CPI	' '
	JNZ	LED5		;GO BACK IF NOT

	INX	H		;ANOTHER BLANK
	MOV	A,M
	CPI	' '
	JZ	LED5		;OK IF SO

	PUSH	H		;ELSE MAKE ONE
	CALL	EMUPD
	SHLD	SMRKR
	INX	H
	SHLD	DMRKR
	CALL	MOVE		;MOVE REST OF LINE 1 CHAR
	POP	H
	MVI	M,' '		;INSERT SPACE
LED5	POP	H
	INX	H
	JMP	LED

* LOOK FOR SENTENCE PUNCTUATION, SET CARRY IF SO.
PUNCT	ANI	7FH		;STRIP OFF SPECIAL MEANING
	CPI	'.'		;A PERIOD ?
	JZ	SETCRY
	CPI	21H		;AN EXCLAMATION POINT ?
	JZ	SETCRY
	CPI	'?'		;A QUESTION MARK ?
	JZ	SETCRY
	JMP	CLRCRY

*-------------------------------------------------------

* CONVERT LEADING BLANKS TO UNPADDABLE SPACES
LEDR	MOV	A,M		;GET FIRST CHAR
	ANI	7FH
	CPI	' '		;IS IT BLANK ?
	JNZ	LEDR1		;QUIT WHEN NON-BLANK FOUND
	MVI	M,0A0H		;ELSE MAKE IT NON-BLANK
	INX	H
	JMP	LEDR

LEDR1	LXI	H,IBUF		;RESET POINTER
	MOV	A,M		;GET FIRST CHARACTER
	CPI	0A0H		;IS IT A SPACE ?
	JNZ	NXCHR		;SKIP IF NOT
	INX	H		;IS NEXT CHARACTER
	MOV	A,M		;AN 04H ?
	CPI	04
	JNZ	LEDR2		;IF NOT LINE STARTS WITH SPC
	CALL	FLUSH		;ELSE LINE IS EMPTY
	CALL	LFEED		;FLUSH BUFFER AND DO LF
	JMP	NEWLIN		;GET NEXT LINE
LEDR2	DCX	H		;RESET POINTER
	CALL	FLUSH		;FLUSH BUFFER

* IF THIS POINT REACHED, THEN LINE IS JUST TEXT
*
*
*
*
NXCHR	LHLD	PBFPTR		;GET POINTERS
	XCHG
	LHLD	IBFPTR
	MOV	A,M		;GET CHARACTER FROM IBUF
	CPI	04		;END OF LINE REACHED ?
	JZ	NEWLIN
*
* END OF LINE NOT REACHED
NOTEND	CPI	' '		;IS CHARACTER A ' ' ?
	JNZ	NOTSP
*
* SPACE FOUND
	LDA	LSTCHR		;WAS LAST CHAR A SPACE ALSO ?
	CPI	' '
	MVI	A,' '
	JZ	NOTSP		;JUMP IF SO
*
* IT'S THE FIRST SPACE OF A GROUP - SAVE POINTERS
	XCHG
	SHLD	LSSPP
	XCHG
	PUSH	PSW
	LDA	SPCNT		;INCR PBUF SPACE-COUNT
	INR	A
	STA	SPCNT
	POP	PSW
*
NOTSP	STAX	D		;PUT CHAR IN PBUF
*

	STA	LSTCHR		;SAVE LAST CHAR
	INX	D		;BUMP POINTERS
	INX	H
*
	LDA	CHRCNT		;INCR PBUF CHAR-COUNT
	INR	A
	STA	CHRCNT
	SHLD	IBFPTR		;SAVE POINTERS IN CASE
	XCHG			;END OF PBUF
	SHLD	PBFPTR
	XCHG
*
	CALL	ENDCHK		;SEE IF PBUF FULL - RETURNS
*				;WITH CARRY SET IF NOT
	JC	NXCHR
* IF LINE LENGTH REACHED KEEP FILLING UNTIL END OF
* WORD FOUND
	MOV	A,M		;IF NEXT CHAR IS A SPC OR 04,
	CPI	' '		;THEN END OF WORD FOUND
	JZ	LFUL
	CPI	04
	JNZ	NXCHR

*
* LINE IN PBUF EQ OR GT CURRENT LINE LENGTH
*
LFUL	XRA	A
	STA	PADCNT		;CLEAR PADCOUNT
	STA	REMCNT
	MVI	A,04		;MARK END OF LINE IN PBUF
	STAX	D


* CALCULATE LENGTH OF LINE - INDENT COUNT
	CALL	CALCIN		;GET CURRENT INDENT
	LDA	NOL		;AND LINE LENGTH
	SUB	C		;PUT DIFFERENCE IN HL
	MOV	L,A
	MVI	H,00
	LXI	B,PBUF
	DAD	B
	MOV	D,H
	MOV	E,L
* NOW HL AND DE POINT TO FIRST CHAR IN PBUF WHICH
* OVERRAN THE CURRENT LINE LENGTH
	DCX	H		;SEE IF LAST CHAR WITHIN LINE
	MOV	A,M		;LENGTH WAS A BLANK
	INX	H
	CPI	' '
	JZ	WDBR		;DON'T ALLOW TRAILING BLANKS

	MOV	A,M		;IS 1ST OVERRUN THE END MRKR ?
	CPI	04		;IF SO, WORD WASN'S BROKEN AND
	JZ	WDEND		;NO UNUSED CHARS STAY IN PBUF

* BACKUP EOL MRKR TO LAST SPACE WITHIN LINE LENGTH
WDBR	LDA	SPCNT		;BE SURE THERE WERE SPACES
	ORA	A		;IF NONE, LINE CAN'T BE PADDED
	JZ	WDEND		;AND HAS TO BE PRINTED AS-IS

	LHLD	LSSPP		;GET PTR TO LAST GROUP OF SP'S
	MVI	M,04		;MAKE IT END OF PRINTABLE LINE
	LDA	SPCNT		;UPDATE SPACE COUNT (ONE JUST
	DCR	A		;GOT KILLED)
	STA	SPCNT

	PUSH	H		;SAVE PTR TO NEW EOL
	CALL	COMPR		;PADCOUNT = DE - HL
	MOV	A,L
	STA	PADCNT

	LHLD	PBFPTR		;REMCNT (NBR OF UNPRINTED
	XCHG			;CHARS REMAINING IN PBUF) =
	POP	H		;PBFPTR - HL - 1
	CALL	COMPR
	DCX	H
	MOV	A,L
	STA	REMCNT

*
* NOW READY TO JUSTIFY LINE IN PBUF
*	IBFPTR POINTS TO NEXT CHAR IN IBUF
*	PBFPTR POINTS TO END-OF-LINE MRKR IN PBUF
*	PADCNT = NBR OF PAD SPACES REQUIRED
*
WDEND	CALL	JUST		;JUSTIFY LINE
	CALL	PRLIN		;PRINT LINE AND REINITIALIZE
	LHLD	IBFPTR		;GET BACK INPUT BUFFER POINTER
	CALL	SPANC		;THROW AWAY LEADING BLANKS
	SHLD	IBFPTR
	CALL	LFEED		;SEND CRLF'S, EXECUTE TRAPS
	JMP	NXCHR
*
*
*
* ROUTINE TO PRINT THE LINE (NOW JUSTIFIED) IN PBUF,
* MOVE ANY UNPRINTED PART TO FRONT, RESET POINTERS,
* ETC.

PRLIN	CALL	LFTMG		;PRINT LEFT MARGIN IF ANY
	MVI	A,01		;SET RUN FLAG
	STA	RUNFLG
	CALL	PRINDT		;PRINT INDENT IF ANY

	LXI	H,PBUF		;THEN PRINT THE LINE
	CALL	PDATAP		;ON THE PRINTER

*
* MOVE ANY UNPRINTED PART OF PBUF TO FRONT OF PBUF
	LXI	H,PBUF		;FIRST FIND THE 04 BYTE
RST1	MOV	A,M		;AT END OF PRINTED PART
	INX	H
	CPI	04
	JNZ	RST1
*
	XRA	A
	STA	CHRCNT
	STA	SPCNT
*
	CALL	FIXWD		;UPDATE LINE WIDTH DATA
*
	LXI	D,PBUF
	LDA	REMCNT
	ORA	A		;IF NO CHARS TO BE MOVED, RET
	JZ	RST5
*
	MOV	C,A		;ELSE, PUT NBR TO MOVE IN C
	MVI	B,00		;SAVE HOW MANY CHARS GET MOVED
RST3	MOV	A,M		;GET CHAR TO BE MOVED
	CPI	' '		;DON'T MOVE LEADING BLANKS
	JZ	RST4
	STAX	D		;OTHERWISE, MOVE THE CHAR
	INX	D		;AND BUMP ITS POINTER
	INR	B
*
	LDA	CHRCNT		;INCREMENT CHRCNT
	INR	A
	STA	CHRCNT
*
RST4	INX	H		;INCREMENT SOURCE POINTER
	DCR	C		;DONE YET ?
	JNZ	RST3
* NOW APPEND A BLANK ON THE MOVED WORD
	MOV	A,B		;DON'T APPEND IF NOTHING
	ORA	A		;GOT MOVED
	JZ	RST5
	LHLD	IBFPTR
	MOV	A,M		;AT END OF INPUT LINE ?
	CPI	04
	JNZ	RST42		;SKIP IF NOT
	LDA	SUPFL2		;CHECK SUPPRESS FLAG
	ORA	A
	JNZ	RST5		;SKIP IF ON
RST42	XCHG
	SHLD	LSSPP		;SET LAST SPACE POINTER
	XCHG
	LXI	H,SPCNT
	INR	M		;UPDATE SPACE COUNT
	LXI	H,CHRCNT
	DCX	D
	LDAX	D		;GET LAST CHARACTER
	INX	D
	CALL	PUNCT		;PERIOD, EXCLAM OR QUESTION ?
	MVI	A,' '
	JNC	RST45
	STAX	D		;ADD A BLANK
	INX	D
	INR	M		;INCREMENT CHAR COUNT
RST45	STAX	D		;ADD A BLANK
	INX	D
	INR	M		;INCREMENT CHAR COUNT

RST5	XCHG			;REPLACE POINTER
	SHLD	PBFPTR
	RET


*************************************************
*
* PRINT INDENT FIELD IF INDENT IS NON-ZERO.  IF
* PIFLG IS SET, THE STRING IS PUT IN THE INDENT
* FIELD, ELSE IT IS FILLED WITH SPACES.
*
PRINDT	CALL	CALCIN		;CALCULATE CURRENT INDENT
	MOV	A,C
	ORA	A
	JZ	PRI4		;EXIT IF NO INDENT
	LDA	PIFLG		;SEE IF SOMETHING TO PUT IN
	ORA	A		;INDENT FIELD
	JZ	PRI2		;IF NOT, PUT BLANKS IN INDENT FIELD
*				;FIELD

* PUT STRING IN INDENT FIELD
	LXI	H,PIBUF		;POINT TO STRING
PRI1	MOV	A,M		;GET CHARACTER FROM STRING
	CPI	04		;CHECK FOR END
	JZ	PRI2		;JUMP IF FOUND
	CALL	POUT		;ELSE SEND CHAR
	DCR	C		;DCR INDENT COUNT
	INX	H
	JNZ	PRI1		;GO BACK IF MORE TO COME
	JMP	PRI4		;ELSE REST OF STRING (IF ANY)
*				;GETS TRUNCATED
* PUT BLANKS IN INDENT FIELD
PRI2	MVI	A,0A0H
PRI3	CALL	POUT		;SEND A BLANK
	DCR	C		;DCR INDENT COUNT
	JNZ	PRI3		;GO BACK IF NOT DONE

PRI4	XRA	A		;CLEAR INDENT STRING FLAG
	STA	PIFLG
	STA	SICNT		;CLEAR SINGLE INDENT
	STA	TEMPSI		;CLEAR TEMPORARY SI
	RET

*
******************************************************
*
* GET NEXT INPUT LINE, PUT IN IBUF
* REMOVE SPECIAL MEANING OF CHARS BY SETTING 8TH BIT
*
GETLIN	LXI	H,IBUF
	XRA	A		;CLEAR COLUMN NBR
	STA	COLNO

GL4	XRA	A
	STA	SPCFLG		;CLEAR SPECIAL-CHAR FLAG
GL1	CALL	GETCHR		;GET CHAR FROM INPUT FILE
	RC			;IF GETCHR TRIED TO GET FROM
*				;MSPACE BUT IT WAS EMPTY, RET
	CPI	0DH		;CR ?
	JZ	GLR
*
	CPI	20H		;IGNORE ALL OTHER CTL CHARS
	JC	GL1
*
	PUSH	PSW
	LDA	SPCFLG		;IS CHAR'S SPECIAL MEANING
	ORA	A		;TO BE IGNORED ?
	JZ	GL2		;JUMP IF NOT
*
	POP	PSW		;ELSE SET 8TH BIT
	ORI	80H

GL3	PUSH	B		;CHECK FOR TAB CHARACTER
	MOV	B,A
	LDA	TABCHR
	CMP	B		;IS THIS IT ?
	MOV	A,B
	POP	B
	JNZ	GL5		;JUMP IF NOT

* TAB TO NEXT TAB STOP
* FIRST FIND NEXT STOP IN TAB TABLE
	PUSH	B
	PUSH	H
	LDA	COLNO		;GET CURRENT COLUMN NBR
	MOV	B,A		;INTO B
	LXI	H,TABTBL
GL6	MOV	A,M		;GET STOP FROM TABLE
	INX	H
	ORA	A		;IS IT END OF TABLE ?
	JZ	NOTAB		;JUMP IF SO
	CMP	B		;ELSE, IS IT 1ST STOP GT COLNO ?
	JC	GL6		;IF NOT, GET THE NEXT ONE
	JZ	GL6

	POP	H		;ELSE READY TO DO TAB
	MOV	B,A		;B HAS COLUMN NBR TO TAB TO
	LDA	FILCHR
	MOV	C,A		;C HAS FILL CHARACTER
	LDA	COLNO		;A ALWAYS HAS CURRENT COL NBR
GL7	CMP	B		;AT THAT COLUMN YET ?
	JZ	NTB2		;IF SO THEN WE'RE DONE
	MOV	M,C		;IF NOT, PUT TAB CHAR IN IBUF
	INX	H
	INR	A		;INCREMENT COL NBR
	STA	COLNO
	JMP	GL7		;THEN TRY AGAIN

NOTAB	POP	H
NTB2	POP	B
	JMP	GL4		;GET NEXT CHARACTER

GL5	MOV	M,A		;PUT IN IBUF
	INX	H
	LDA	COLNO		;INCREMENT COLUMN NBR
	INR	A
	STA	COLNO
	JMP	GL4		;GO BACK, RSET FLAG, GET NEXT
*
GL2	POP	PSW
	CPI	5CH		;IS IT '\' ?
	JNZ	GL3		;JMP IF NO
	STA	SPCFLG		;ELSE SET FLAG AND IGNORE
	JMP	GL1
*
* END OF INPUT LINE FOUND
GLR	MVI	M,' '		;APPEND BLANK TO END OF LINE
	INX	H
	MVI	M,04		;MARK END-OF-LINE
	SHLD	EMRKR
	RET
*
*
******************************************************
*
* MOVE BLOCK OF MEMORY
*
* SMRKR = FIRST LOC OF BLOCK TO BE MOVED
* EMRKR = LAST  LOC
* DMRKR = FIRST LOC OF DESTINATION
*
MOVE	LHLD	EMRKR		;GET ADDRESSES
	PUSH	H
	POP	B
	LHLD	DMRKR
	XCHG
	LHLD	SMRKR
*
* SEE WHAT DIRECTION BLOCK HAS TO BE SCANNED
	PUSH	H
	CALL	COMPR		;SET CY IF DE LT HL
	POP	H
* EXCHANGE BC AND DE
	PUSH	D
	PUSH	B
	POP	D
	POP	B
*
	JNC	MV2
*
MV1	MOV	A,M
	STAX	B
	INX	B
	INX	H
	PUSH	H
	CALL	COMPR
	POP	H
	JNC	MV1
	RET
*
MV2	PUSH	H		;BC = BC + DE - HL
	CALL	COMPR
	DAD	B
	PUSH	H
	POP	B
	POP	H
*
MV21	LDAX	D
	STAX	B
	DCX	D
	DCX	B
	PUSH	H
	CALL	COMPR
	POP	H
	JNC	MV21
	RET
*
*
* ROUTINE TO EXECUTE HL = DE - HL
COMPR	MOV	A,E
	SUB	L
	MOV	L,A
	MOV	A,D
	SBB	H
	MOV	H,A
	RET
*
*
******************************************************
*
* ENDCHK
* SEE IF LINE IN PBUF HAS MET OR EXCEEDED CURRENT
* LINE LENGTH.  RETURN WITH CY SET IF NOT
* ALSO UPDATE NBR REG C (NOC)
ENDCHK	CALL	CALCIN
	LDA	CHRCNT		;ADD PBUF CHAR COUNT TO
	ADD	C		;CURRENT INDENT
	STA	NOC		;PUT IN NBR REG C
*
	PUSH	PSW
	LDA	NOL		;GET LINE LENGTH
	MOV	B,A
	POP	PSW
	SUB	B
	RET
*
******************************************************
*
* CALCIN
* CALCULATE CURRENT INDENT
CALCIN	PUSH	PSW
	LDA	SICNT		;GET TEMP INDENT COUNT
	MOV	B,A
	LDA	NOI		;GET INDENT
	ADD	B		;ADD THEM
	JP	CAC1
	XRA	A		;SET INDENT = 0 IF NEG RESULT
CAC1	MOV	C,A		;RETURN VALUE IN C REG
	POP	PSW
	RET
*
*
******************************************************
*
* JUSTIFICATION ROUTINE
*
JUST	LDA	FILFLG		;BE SURE FILL IS ON
	ORA	A
	RZ
	LDA	JSTFLG		;BE SURE JUST. IS ENABLED
	ORA	A
	RZ
	LDA	PADCNT		;IF PBUF EXACTLY RIGHT
	ORA	A		;LENGTH, RETURN
	RZ
*
* PROCEED TO JUSTIFY - FIRST SEE WHICH TYPE
	LDA	JUSTYP
	RAR
	JC	RJST
	RAR
	JC	NJST
*
CJST	LDA	PADCNT		;*** CENTER JUSTIFY ***
	RRC			;DIVIDE PADCNT BY 2
	ANI	7FH
	RZ
	STA	PADCNT
*
RJST	LXI	H,PBUF
	SHLD	SMRKR		;MOVE PBUF CONTENTS TO RIGHT
	LDA	PADCNT
	MOV	C,A
	MVI	B,00
	DAD	B
	SHLD	DMRKR
	LHLD	PBFPTR
	SHLD	EMRKR
	DAD	B
	SHLD	PBFPTR
	CALL	MOVE
*
	LDA	PADCNT		;NOW PUT BLANKS AT LINE
	MOV	C,A		;BEGINNING
	LXI	H,PBUF
RJS1	MVI	M,0A0H
	INX	H
	DCR	C
	JNZ	RJS1
	RET
*
*
* LEFT AND RIGHT JUSTIFY
NJST	LDA	NOPAD		;DON'T PAD IF NOPAD FLAG SET
	ORA	A
	RNZ
	LDA	SPCNT		;CAN'T PAD IF NO SPACES
	ORA	A		;ON LINE
	RZ
	MVI	C,00
	LDA	SPCNT		;GET NBR OF SPACE GROUPS
	MOV	B,A		;IN PBUF
	LDA	PADCNT
* CALCULATE (PADCNT/SPCNT)
NJS1	SUB	B
	JC	NJS2
	INR	C
	JMP	NJS1
NJS2	ADD	B
	MOV	B,A
* INTEGER QUOTIENT IN C, REMAINDER IN B
*
	LDA	ODDLIN		;DECIDE WHETHER TO PAD FROM
	INR	A		;LEFT OR RIGHT
	STA	ODDLIN
	ANI	01
	JZ	RPAD
*
LPAD	LXI	H,PBUF
LP0	CALL	SPANC		;FIND FIRST CHAR
	CALL	SPANB		;THEN FIRST BLANK
	MOV	A,B
	ORA	A
	JZ	LP1
	DCR	B
	MVI	A,01
LP1	ADD	C		;GET NBR OF BLANKS TO INSERT
*
	CALL	INSRT
	RZ
	JMP	LP0
*
*
RPAD	LXI	H,PBUF
	LDA	SPCNT
	SUB	B
	MOV	B,A
RP0	CALL	SPANC		;SPAN TO 1ST CHAR
	CALL	SPANB		;THEN 1ST BLANK
	MOV	A,B
	ORA	A
	MVI	A,01
	JZ	RP1
	DCR	B
	XRA	A
RP1	ADD	C
	CALL	INSRT
	RZ
	JMP	RP0
*
*

* INSRT
* ROUTINE TO INSERT SPACES IN PBUF WHERE HL POINTS
* NBR OF SPACES TO BE INSERTED IS IN A REG
INSRT	ORA	A		;JUST RETURN IF NO SPACES
	JNZ	INS0
	ADI	01
	RET			;RETURN WITH ZERO FLAG CLEARED
INS0	PUSH	B
	SHLD	SMRKR
	MOV	E,A
	MVI	D,00		;SET UP POINTER FOR MOVE
	DAD	D		;ROUTINE
	SHLD	DMRKR
*
	LHLD	PBFPTR
	DAD	D
	SHLD	PBFPTR
	SHLD	EMRKR
	PUSH	PSW
	CALL	MOVE
	POP	PSW
*
	LHLD	SMRKR
	MOV	C,A		;PUT SPACE NBR IN C
	MOV	B,A		; AND B
INS1	MVI	M,0A0H		;PUT SPACES IN PBUF
	INX	H
	DCR	C
	JNZ	INS1
*
* SUBTRACT SPACES FROM PADCNT
	LDA	PADCNT
	SUB	B
	STA	PADCNT
	POP	B
	RET			;ZERO FLAG SET IF PADCNT=0
*
* SPANC - INCREMENT HL TO POINT TO NEXT NON-BLANK
*
SPANC	MOV	A,M
	CPI	' '
	RNZ
	INX	H
	JMP	SPANC
*
* SPANB - INCREMENT HL TO POINT TO NEXT BLANK
*
SPANB	MOV	A,M
	CPI	' '
	RZ
	INX	H
	JMP	SPANB
*
* FLUSH
FLUSH	LHLD	PBFPTR		;GET POINTER
	XCHG
	CALL	CALCIN		;CALCULATE CURRENT INDENT
	LDA	CHRCNT		;ADD TO CHAR COUNT IN PBUF
	ORA	A		;(DON'T FLUSH IF PBUF EMPTY)
	JZ	FLH3
	ADD	C
	MOV	B,A
	LDA	NOL		;SUBTRACT FROM LINE LENGTH
	SUB	B
	STA	PADCNT		;STORE IN PAD COUNT
*
* SEE IF LINE HAD TRAILING BLANKS - REMOVE ANY
*
	DCX	D
FLH1	LDAX	D		;GET CHARACTER FROM PBUF
	CPI	' '		;IS IT A BLANK ?
	JNZ	FLH2		;JUMP IF NO
*
	DCX	D		;ELSE BACK UP ONE
	LDA	PADCNT		;AND INCREMENT PADCOUNT
	INR	A
	STA	PADCNT
	JMP	FLH1
*
* NOW MARK END OF LINE IN PBUF, SET PBFPTR
*
FLH2	INX	D
	MVI	A,04
	STAX	D
	XCHG
	SHLD	PBFPTR
*
* JUSTIFY LINE WITH PADDING PROHIBITED
*
	MVI	A,01
	STA	NOPAD
	CALL	JUST
	XRA	A
	STA	NOPAD		;ZERO NO-PAD FLG FOR NEXT LINE
	STA	REMCNT		;NBR UNUSED CHARS LEFT IN PBUF
*
	CALL	PRLIN		;PRINT THE JUSTIFIED LINE
	LHLD	IBFPTR
	CALL	SPANC
	SHLD	IBFPTR
	CALL	LFEED
	RET

FLH3	LHLD	IBFPTR		;RE-LOAD INPUT BUFFER POINTER
	CALL	SPANC		;SKIP LEADING BLANKS
	SHLD	IBFPTR
	RET

*==========
* PDATAP
* ROUTINE FOR SENDING THE STRING POINTED TO BY HL
* (TERMINATED WITH A 04 BYTE) EITHER TO THE PRINTER,
* OR INTO MSPACE IF 'DVTFLG' SAYS THAT DIVERSION IS
* IN PROGRESS.  ALL REGISTERS TRASHED
PDATAP	PUSH	H		;SAVE POINTER
PDA1	MOV	A,M		;FIRST SCAN LINE TO SEE IF ANY
	ANI	7FH		;THING BUT BLANKS IN IT
	CPI	' '		;IF SO THEN CLEAR 'NOSPC'
	JNZ	PDA2
	CPI	04
	JZ	PDA3
	INX	H
	JMP	PDA1
PDA2	XRA	A
	STA	NOSPC
PDA3	POP	H

	MOV	A,M		;GET CHAR FROM PBUF
	CPI	04		;IS END OF LINE ?
	RZ			;RETURN IF SO
	CALL	POUT		;ELSE SEND TO PROPER DEST
	INX	H		;BUMP POINTER
	JMP	PDATAP		;AND DO NEXT CHAR

POUT	PUSH	PSW		;SAVE CHAR
	LDA	DVTFLG		;CHECK DIVERT FLAG
	ORA	A
	JZ	PDPR		;JUMP IF GOING TO PRINTER

	POP	PSW		;ELSE GET CHAR BACK
	PUSH	PSW
	CALL	MPUT		;PUT IN MSPACE
	JC	SYSERR		;CHECK FOR MSPACE OVERFLOW
	POP	PSW
	RET

* ROUTINE TO SEND CHAR TO PROCESSED-OUTPUT DEVICE IF
* CURRENT PAGE IS BETWEEN THE SPECIFIED PAGE LIMITS
PDOUT	PUSH	PSW
PDPR	LDA	LOPG		;GET LOWER PAGE LIMIT
	MOV	B,A
	LDA	NPG		;AND CURRENT PAGE NBR
	CMP	B		;COMPARE THEM
	JC	PDP1		;JUMP IF NOT TO BE OUTPUTTED
	MOV	B,A
	LDA	HIPG		;GET UPPER PAGE LIMIT
	CMP	B
	JC	EXIT		;EXIT PROCESSOR IF BEYOND

* SEND CHAR
	POP	PSW		;GET BACK CHAR
	PUSH	PSW
	CALL	PRCHR		;SEND IT
PDP1	POP	PSW
	RET


*
*========
* LFEED
* SENDS CRLF'S (USUALLY CALLED AFTER THE PRINTING
* OF A LINE).  AFTER EACH CRLF A CHECK IS MADE TO SEE
* IF TRAP EXISTS ON THE NEW LINE.  IF SO THE TRAP IS
* EXECUTED AND SPACING IS TERMINATED.  OTHERWISE, THE
* NBR OF BLANK LINES SPECIFIED BY 'LINSP' IS SENT.
* ALL REGISTERS TRASHED
LFEED	LDA	DVTFLG		;USE PROVER ROUTINE
	ORA	A		;DEPENDING ON DESTINATION
	JNZ	DVTFD		;(JUMP IF BEING DIVERTED)

* SEND CRLF'S TO PRINTER
PTRFDD	CALL	CRLF		;UNCONDITIONALLY SEND 1ST CRLF
	RC			;RETURN IF TRAP EXECUTED

	LDA	LINSP		;THEN SEE IF MORE TO SEND
	ORA	A
	RZ			;RETURN IF NOT
	MOV	C,A		;ELSE PUT NBR IN C

PTF1	LDA	NOSPC		;ONLY SEND MORE IF
	ORA	A		;NOSPC FLAG = 0
	RNZ

* OK TO SEND CRLF
PTF2	CALL	CRLF		;SEND CRLF
	RC			;RETURN IF TRAP EXECUTED
	DCR	C		;DECREMENT COUNT
	JNZ	PTF1		;DO AGAIN IF NOT DONE YET
	RET			;ELSE RETURN

* CR'S GOING TO MSPACE
DVTFD	CALL	MCR		;PUT CR IN MSPACE
	JC	SYSERR		;CHECK FOR MSPACE OVERFLOW

	LDA	NOSPC		;DON'T SEND MORE UNLESS
	ORA	A		;NOSPACE MODE OFF
	RNZ

* OK TO PUT CR'S IN MSPACE
	LDA	LINSP		;GET NBR OF CR'S TO ADD TO 1ST
	ORA	A		;JUST RETURN IF NONE
	RZ
	MOV	C,A		;ELSE PUT IN C
DTF1	CALL	MCR		;PUT CR IN MSPACE
	JC	SYSERR		;CHECK FOR MSPACE OVERFLOW
	DCR	C		;DECREMENT COUNTER
	JNZ	DTF1		;DO AGAIN IS NOT DONE
	RET

* CODE TO PUT A CR IN MSPACE, INCREMENT DIVERSION LINE
* COUNT, RETURN WITH CY SET IF MSPACE OVERFLOWS
MCR	MVI	A,0DH
	CALL	MPUT
	LDA	NOV
	INR	A
	STA	NOV
	RET

* ROUTINE TO SEND CRLF TO PRINTER, INCREMENT CURRENT
* LINE NBR, (OR RESET TO 1 IF APPROPRIATE) AND CHECK
* FOR TRAPS AT THE NEW LINE, EXECUTING ANY FOUND.
* IF TRAP EXECUTED, RETURNS WITH CY SET
* ONLY 'A' AND FLAGS AFFECTED
CRLF	PUSH	B
	MVI	A,0DH		;FIRST SEND CR
	CALL	PDOUT
	MVI	A,0AH		;THEN SEND LF
	CALL	PDOUT

	CALL	BREAK		;CHECK FOR TERMINAL BREAK

* NOW UPDATE CURRENT LINE NBR ('NON')
	LDA	NOOP		;GET PAGE LENGTH
	MOV	B,A		;PUT IN B
	LDA	NON		;NOW INCREMENT AND REPLACE
	INR	A		;THE LINE NUMBER
	STA	NON
	SUB	B		;SEE IF PAST END OF PAGE
	CPI	01		;RESET LINE NBR TO 1 IF SO
	JNZ	CLF2
	STA	NON

	LDA	NXTPG		;IF 'NXTPG' NON-0 THEN USE
	ORA	A		;IT TO SET NEW PAGE NUMBER
	JZ	CLF3
	STA	NPG
	XRA	A		;THEN CLEAR NXTPG
	STA	NXTPG
	JMP	CLF2

CLF3	LDA	NPG		;INCREMENT PAGE NBR
	INR	A
	STA	NPG


CLF2	CALL	TRPCHK		;CHECK FOR TRAPS - EXECUTE ANY
*				;FOUND
	POP	B
	RET


* BREAK
* ROUTINE TO ALLOW USER TO PAUSE OR HALT PRINTING.
* A 'CTRL C' WILL HALT WHILE AN 'ESC' WILL PAUSE
* UNTIL ANOTHER 'ESC' OR 'CTRL C' IS HIT.
BREAK	CALL	CHKIN		;CHECK FOR INPUT CHARACTER
	RNC			;RETURN IF NONE
	CPI	03		;ELSE IS IT A 'CTRL C' ?
	JZ	EXIT2		;HALT IF SO
	CPI	1BH		;IS IT AN 'ESCAPE' ?
	RNZ
BREAK1	CALL	TRMIN		;GET ANOTHER CHARACTER
	CPI	03		;IS IT A 'CTRL C' ?
	JZ	EXIT2		;HALT IF SO
	CPI	1BH		;IS IT AN 'ESCAPE' ?
	JNZ	BREAK1		;IF NOT, WAIT FOR ONE
	RET


* PRCHR
* ROUTINE TO SEND CHARACTER EITHER TO PRINTER OR
* TERMINAL DEPENDING UPON THE STATE OF CRTFLG
PRCHR	PUSH	PSW		;SAVE CHAR
	LDA	CRTFLG		;SEE WHERE IT'S TO GO
	ORA	A
	JNZ	PRC2		;JUMP IF FOR TERMINAL

* SEND TO PRINTER
	POP	PSW		;GET BACK CHAR
	CALL	LPOUT		;SEND IT
	RET

* SEND TO TERMINAL
PRC2	POP	PSW		;GET BACK CHARACTER
	CALL	TRMOUT		;SEND IT
	RET

*========================
* GETCHR
* GETS CHARACTERS TO BE PLACED IN IBUF FOR PROCESSING.
* CHARACTERS ARE OBTAINED EITHER FROM THE SOURCE FILE
* OR FROM THE MACRO FILE, DEPENDING ON THE VALUE OF
* MPTR (THE PTR TO THE LOCATION FROM WHICH THE NEXT
* CHARACTER IS TO BE OBTAINED).  IF MPTR IS 0 THEN THE
* CHAR IS OBTAINED FROM THE SOURCE (INPUT) FILE.  IF
* NON-ZERO, THEN 'MGET' IS CALLED TO GET THE NEXT CHAR
* FROM THE LOCATION IN MACROSPACE POINTED TO BY MPTR.
* VALUES OF MPTR FOR NESTED MACRO CALLS ARE KEPT
* ON THE STACK.
* IF MGET RETURNS WITH CY SET THEN THE CURRENT ACTIVE
* MACRO FILE IS EXHAUSTED AND THE NEW VALUE OF MPTR IS
* OBTAINED.  THE FIRST ENTRY IN MPTR IS 0 SO
* POPPING THIS INTO MPTR WILL CAUSE INPUT TO SOURCE
* FROM THE SOURCE FILE.
* ONLY 'A' AND FLAGS ARE AFFECTED BY GETCHR.
GETCHR	PUSH	B
	PUSH	D
	PUSH	H

	LHLD	MPTR		;GET CURRENT SOURCE POINTER
GTC2	MOV	A,H		;IF = 0 THEN CHAR WILL COME
	ORA	L		;FROM SOURCE FILE
	JZ	FCHAR

* GET CHAR FROM MACROSPACE
	CALL	MGET
	JNC	GTC1
	POP	H		;IF CARRY SET, CURRENT MACRO
	POP	D		;SPACE EXHAUSTED - RETURN TO
	POP	B		;ROUTINE WHICH ORIGINALLY
	RET			;INVOKED MACRO

* GET CHARACTER FROM SOURCE FILE
* REMOVE SPECIAL MEANING FROM CHARS PRECEEDED BY '\',
* DO CASE MAPPING IF ENABLED BEFORE RETURNING CHAR.
GTC0	CALL	FILINP		;CALL FILE INPUT
	CPI	7FH		;DON'T ALLOW RUBOUTS
	JZ	GTC0
	RET


FCHAR	CALL	GTC0		;GET CHARACTER
* CAPITALIZATION ROUTINE
CP1	PUSH	PSW		;SAVE CHARACTER
	LDA	SFLG2		;SEE IF THIS CHAR'S SPCL MEANING
	ORA	A		;TO BE REMOVED
	JZ	CP2

	XRA	A		;CLEAR FLAG
	STA	SFLG2
	POP	PSW		;ELSE SET 8TH BIT
	ORI	80H
	JMP	GTC1

CP2	POP	PSW		;GET BACK CHAR
	CPI	5CH		;CHECK FOR '\'
	JNZ	CP3

	STA	SFLG2		;ELSE MAKE SFLG2 NON-ZERO
	JMP	FCHAR		;AND GET NEXT CHARACTER

CP3	CPI	5EH		;CHECK FOR '^' (UPARROW)
	JNZ	CP4		;JMP IF NOT

	LDA	CPFLG		;IF CPFLG GT 1, LET CPFLG = 0
	ORA	A		;ELSE IF CPFLG = 0 THEN LET
	JZ	CP3A		;CPFLG GT 1
	MVI	A,0FFH
CP3A	CMA
	STA	CPFLG
	JMP	FCHAR

CP4	CPI	'@'		;CHECK FOR '@' (ATSIGN)
	JNZ	CP5		;JMP IF NOT

	MVI	A,01		;ELSE MAKE CPFLG = 1
	STA	CPFLG
	JMP	FCHAR		;AND GET NEXT CHAR

CP5	PUSH	PSW		;SAVE CHAR
	LDA	CPON		;SEE IF CAPITALIZATION ENABLED
	ORA	A
	JZ	GTC5		;RETURN CHAR AS IS IF NOT
	POP	PSW		;CONVERT TO LOWER CASE
	CALL	LCASE
	PUSH	PSW		;AND RE-SAVE
	LDA	CPFLG		;SEE IF IT SHOULD BE CAPITAL
	ORA	A
	JZ	GTC5		;SEND AS-IS IF NOT
	DCR	A		;OTHERWISE SEE IF IT'S JUST
	JZ	CP6		;FOR 1 CHAR - CLEAR FLG IF SO
	INR	A
CP6	STA	CPFLG
	POP	PSW		;GET BACK CHAR
	CALL	UCASE		;CHANGE TO UPPER CASE
	JMP	GTC1		;THEN SEND IT


GTC5	POP	PSW
GTC1	ORA	A		;CLEAR CY
	POP	H
	POP	D
	POP	B
	RET


* FILINP
* ROUTINE TO GET NEXT CHARACTER EITHER FROM THE SOURCE
* FILE OR TERMINAL, DEPENDING ON THE STATE OF TRMFLG
FILINP	LDA	TRMFLG		;CHECK ON SOURCE
	ORA	A
	JNZ	TRMCHR		;JUMP IF FROM TERMINAL
	LDA	RIFLG		;FROM DISK DATE FILE ?
	ORA	A
	JNZ	RICHR		;GO READ DISK DATA

* GET CHAR FROM SOURCE FILE
*=====================================================
* IF SOURCE IS TO BE OBTAINED WITH A USER-SUPPLIED
* ROUTINE (SUCH AS FROM CASSETTE, PAPER TAPE, ETC) INSTEAD
* OF FROM MEMORY, REPLACE THE NEXT 'JMP' INSTRUCTION
* WITH A CALL TO THE USER-SUPPLIED ROUTINE.  THE CHAR
* MUST BE RETURNED IN THE 'A' REG WITH THE 8TH BIT
* CLEARED.  ANY OTHER REGISTER EXCEPT B MAY BE DESTROYED.
	JMP	FLIN1
	RET

FLIN1	CALL	READCH		;GET A CHAR FROM DISK
	JC	EOF		;AT END OF FILE ?
	CPI	1AH
	JZ	EOF
	CPI	0DH		;A RETURN ?
	RZ
	CPI	20H		;A CONTROL CHARACTER ?
	JC	FLIN1		;IGNORE IF SO
	RET			;ELSE A GOOD CHAR
EOF	LHLD	CMDPT		;GET COMMAND LINE POINTER
	CALL	SKIP		;PASS SPACES AND COMMA
	MOV	A,M
	CPI	04		;AT END OF LINE ?
	JZ	FLIN2		;EXIT PROCESSOR IF SO
	PUSH	B
	CALL	SFILE		;SETUP NEXT FILE
	POP	B
	JC	SFERR		;JUMP IF AN ERROR
	JMP	FLIN1		;GO GET CHARACTER
FLIN2	CALL	FLUSH		;FLUSH THE BUFFER
	JMP	EXIT2		;EXIT THE PROCESSOR



* GET CHARACTER FROM GIBUF
TRMCHR	MVI	A,01
	STA	SPECL		;SET SPECIAL INPUT FLAG
	LHLD	GIPTR		;GET POINTER
	MOV	A,M		;GET CHARACTER FROM GIBUF
	CPI	04		;REPLACE ANY 04 WITH CR
	JNZ	TMCH1
	XRA	A
	STA	TRMFLG		;TURN OFF TERMINAL INPUT
	MVI	A,0DH
TMCH1	INX	H		;BUMP POINTER
	SHLD	GIPTR
	RET

*=========
* TRPCHK
* ROUTINE TO CHECK FOR A TRAP AT THE CURRENT LINE NBR
* IF NONE FOUND, RETURNS WITH CY CLEARED.  IF ONE FOUND
* THE MACRO IS EXECUTED, THEN TRPCHK
* RETURNS WITH CY SET
* ONLY A AND FLAGS ALTERED
TRPCHK	PUSH	B
	PUSH	D
	PUSH	H
	LDA	NON		;GET CURRENT LINE NBR
	MOV	B,A		;PUT IN B
	CALL	TSRCH1		;SEARCH TRAP TABLE ACCORDING
*				;TO LINE NBR
	JNC	TRC1		;JMP IF NO TRAP HERE

* TRAP TO BE EXECUTED - NAME IS IN BC
	CALL	MINVOK		;CALL ROUTINE TO INVOKE MACRO
*				;WHOSE NAME IS IN BC
	STC			;SHOW TRAP WAS EXECUTED
TRC1	POP	H
	POP	D
	POP	B
	RET

*=========
* TSRCH1
* SEARCHES THE TRAP TABLE FOR A TRAP LOCATED AT THE
* LINE NBR PASSED IN THE 'B' REG.
* IF ONE FOUND, NAME IS RETURNED IN BC PAIR, CY IS SET
* HL POINTS TO 1ST BYTE OF THAT ENTRY.
* IF NOT FOUND, RETURNS WITH CY CLEARED, HL POINTING
* TO 0 BYTE AT END OF TABLE.
* ALL REGS TRASHED
TSRCH1	LXI	H,TTBL		;POINT TO TABLE
	LXI	D,0003
TSR1	MOV	A,M		;GET 1ST BYTE OF ENTRY
	ORA	A		;LOOK FOR 0 AT END
	JZ	TSR3		;JMP IF FOUND
	CMP	B		;ELSE DOES LINE NBR MATCH
	JZ	TSR2

* NO MATCH - TRY NEXT ENTRY
	DAD	D
	JMP	TSR1

* MATCH - GET NAME
TSR2	PUSH	H		;SAVE PTR TO 1ST BYTE
	INX	H
	MOV	C,M		;1ST CHAR
	INX	H
	MOV	B,M		;2ND CHAR
	POP	H
	STC			;SET CARRY
	RET

TSR3	ORA	A
	RET

*=========
* T2SRC
* SEARCHES THE TRAP TABLE FOR A TRAP WHOSE NAME
* MATCHES THAT IN BC PAIR.  IF FOUND, RETURNS WITH HL
* POINTING TO 1ST BYTE OF THAT ENTRY, CY SET.
* IF NOT FOUND, RETURNS WITH HL POINTING TO 0 BYTE
* AT END, CY CLEARED.
* ALL REGISTERS EXCEPT BC TRASHED
T2SRC	LXI	H,TTBL		;POINT TO TRAP TABLE
	LXI	D,0003

TS21	PUSH	H		;SAVE POINTER
	MOV	A,M		;GET 1ST BYTE
	ORA	A		;LOOK FOR END OF TABLE
	JZ	TS23		;JMP IF FOUND

	INX	H		;ELSE CHECK NAME
	MOV	A,M
	CMP	C
	JNZ	TS22		;JMP IF 1ST CHAR DOESN'T MATCH
	INX	H
	MOV	A,M
	CMP	B
	JZ	TS24		;JMP IF BOTH DO MATCH
* NAMES DON'T MATCH
TS22	POP	H
	DAD	D		;TRY NEXT ENTRY
	JMP	TS21

* TRAP NOT FOUND
TS23	POP	H
	ORA	A		;CLEAR CY
	RET

* TRAP FOUND
TS24	POP	H
	STC			;SET CY
	RET


*=========
* MGET
* GETS A CHAR FROM MACROSPACE USING POINTER 'MPTR'.
* IF END OF THIS MACRO (OR DIVERSION) FOUND INSTEAD,
* MGET RETURNS WITH CY SET.
* ONLY 'A' AND FLAGS AFFECTED
MGET	PUSH	D
	PUSH	H
	LHLD	MPTR		;GET POINTER
MGT1	MOV	A,M		;GET CHARACTER
	ORI	01		;MAKE 'FF' OUT OF 'FE'
	INR	A		;CHECK FOR 0FFH BYTE MARKER
	JNZ	MGT2

* FF MARKR FOUND - GET POINTER FROM NEXT TWO BYTES
	INX	H
	MOV	E,M
	MOV	A,E
	INX	H
	MOV	D,M
	ORA	D		;NEXT 2 BYTES=0 MEANS SPACE
	JZ	MEND		;IS EXHAUSTED
	XCHG			;ELSE PUT POINTER IN HL
	JMP	MGT1		;TRY TO GET NEXT CHAR THERE

* HL NOW POINTS TO NEXT CHAR TO BE RETURNED
MGT2	XRA	A		;CLEAR CY
	MOV	A,M		;GET CHAR
	INX	H		;BUMP POINTER
	SHLD	MPTR		;UPDATE MPTR
	POP	H
	POP	D
	RET

* THIS MACRO FILE EXHAUSTED
MEND	LHLD	MPTR		;PUT FF OR FE IN A BEFORE
	MOV	A,M		;RETURNING
	POP	H
	POP	D
	STC			;SET CY
	RET


*=========
* CELIN
* PLACES CORRECT NBR OF UNPADDABLE SPACES AT THE
* BEGINNING OF THE LINE IN IBUF SO THAT WHEN PRINTED,
* THE LINE IS CENTERED.
CELIN	DCR	A		;DECREMENT LINE COUNT
	STA	CEFLG

* FIND LENGTH OF LINE IN IBUF BY FINDING 04 BYTE,
* THEN BACKING OVER ANY TRAILING BLANKS.
	MVI	B,00		;CLEAR LENGTH COUNT
CEL1	MOV	A,M
	CPI	04
	JZ	CEL2
	INX	H
	INR	B
	JMP	CEL1

CEL2	SHLD	IBFPTR		;HL NOW POINTS TO 04 BYTE
	SHLD	EMRKR
CEL2A	DCX	H
	DCR	B
	MOV	A,M
	CPI	' '
	JZ	CEL2A

* B NOW CONTAINS THE LINE LENGTH
* DETERMINE NBR OF SPACES TO INSERT
	LDA	NOL		;GET CURRENT LINE LENGTH
	SUB	B		;SUB LENGTH OF IBUF CONTENTS
	JNC	CEL3
	XRA	A		;LEFT JUSTIFY IF TOO LONG
CEL3	RAR			;DIVIDE DIFFERENCE BY 2
	ORA	A		;CLEAR ANY CARRY
* A NOW CONTAINS THE NUMBER OF SPACES TO MOVE LINE
	LXI	H,IBUF
	SHLD	SMRKR		;SET UP POINTERS TO MOVE LINE
	MVI	D,00
	MOV	E,A
	DAD	D
	SHLD	DMRKR
	LHLD	IBFPTR		;RE-POINT IBFPTR TO 04 BYTE
	DAD	D
	SHLD	IBFPTR
	PUSH	PSW		;SAVE NBR OF SPACES TO INSERT
	CALL	MOVE		;MOVE THE LINE
	POP	PSW
* NOW PUT SPACES IN FRONT END OF IBUF
	MVI	B,' '
	LXI	H,IBUF
	ORA	A		;SEE IF ANY TO BE INSERTED
	JZ	CEPR
CEL4	MOV	M,B		;INSERT A SPACE
	INX	H		;BUMP POINTER
	DCR	A		;DECREMENT COUNT
	JNZ	CEL4
* SPACES NOT INSERTED - PRINT THE LINE
CEPR	LXI	H,IBUF
* *** WARNING ***
* REST OF CODE USED TO PRINT BUFFER PRODUCED BY .TL
TLPR	CALL	LFTMG		;PRINT LEFT MARGIN IF ANY
	CALL	PDATAP
	CALL	LFEED
	JMP	NEWLIN

* ROUTINE TO CONVERT UPPER CASE TO LOWER
LCASE	PUSH	B
	MOV	B,A
	SUI	41H
	JC	LCA1
	CPI	1AH
	JNC	LCA1
	ADI	61H
	JMP	LCA2
LCA1	MOV	A,B
LCA2	POP	B
	RET

* ROUTINE TO CONVERT LOWER CASE TO UPPER
UCASE	PUSH	B
	MOV	B,A
	SUI	61H
	JC	UCA1
	CPI	1AH
	JNC	UCA1
	ADI	41H
	JMP	UCA2
UCA1	MOV	A,B
UCA2	POP	B
	RET

*
* PDATT
* ROUTINE TO SEND STRING POINTED TO BY HL TO TERMINAL.
* STRING MUST BE TERMINATED BY 04 BYTE.
PDATT	MOV	A,M		;GET CHARACTER
	CPI	04		;END OF STRING ?
	RZ			;RETURN IF SO
	CALL	TRMOUT		;ELSE SEND IT
	INX	H
	JMP	PDATT		;THEN DO NEXT CHAR

* TRMCRL
* ROUTINE TO SEND CRLF TO TERMINAL
TRMCRL	MVI	A,8DH
	CALL	TRMOUT
	MVI	A,8AH
	CALL	TRMOUT
	RET

* CRDATA
* ROUTINE TO DO A CRLF THEN PRINT DATA AT HL
CRDATA	PUSH	H
	CALL	TRMCRL		;DO LINE FEED
	POP	H
	JMP	PDATT		;GO PRINT DATA
* LPOUT
* SEND CHAR IN 'A' TO PRINTER.  IF CHAR IS LF, SEND
* N=NULLS NULLS TO PRINTER.
LPOUT	PUSH	PSW		;SAVE CHAR
	CALL	LPRINT		;CALL USER PRINTER ROUTINE****
	POP	PSW		;NOW SEE IF CHAR WAS LF
	CPI	0AH
	RNZ			;RETURN IF NOT

* SEND 'NULLS' NULLS
	LDA	NULLS
	ORA	A
	RZ
	MOV	C,A
LPO1	XRA	A
	CALL	LPOUT		;SEND A NULL
	DCR	C		;DCR NULL COUNT
	JNZ	LPO1		;DO AGAIN IF NOT DONE
	RET

* TRMOUT
* ROUTINE TO SEND CHAR TO TERMINAL.  WHEN A LF IS
* ISSUED A CHECK IS MADE TO SEE IF MAX NBR OF LINES
* PER SCREEN HAVE BEEN SENT - PROCESSOR STOPS IF SO.
TRMOUT	PUSH	PSW		;SAVE CHARACTER
	CALL	CRTOUT		;CALL USER TERM OUT ROUTINE***
	POP	PSW		;GET BACK CHARACTER
	CPI	0DH		;CR ?
	RNZ			;RETURN IF NOT

	LDA	LINVAL		;GET NBR OF LINES PER SCREEN
	MOV	B,A
	ORA	A		;0 MEANS UNLIMITED OUTPUT
	RZ
	LDA	LINCNT		;ELSE GET CURRENT LINE COUNT
	INR	A		;BUMP IT
	STA	LINCNT
	SUB	B		;SEE IF MAX REACHED
	RNZ			;RETURN IF NOT
	STA	LINCNT		;ELSE CLEAR CURRENT LINE COUNT
	CALL	TRMIN		;WAIT FOR CHAR FROM TERMINAL
	CPI	03		;EXIT IF A 'CTRL C'
	CZ	EXIT
	RET			;ELSE CONTINUE PROCESSING


* TRMIN
* ROUTINE TO GET CHARACTER FROM TERMINAL
TRMIN	CALL	CRTIN		;CALL USER TERM INPUT *******
	ANI	7FH		;KILL 8TH BIT
	RET

	CALL	TRMOUT		;ECHO FOR FULL DUPLEX ********
	POP	PSW
	RET

*===========
* PRINT LEFT MARGIN
LFTMG	PUSH	H
	PUSH	D
	PUSH	B
	PUSH	PSW
	LDA	DVTFLG		;DON'T OFFSET IF DIVERSION ON
	ORA	A
	JNZ	LFTDN
	LDA	LMARG		;OR IF LEFT MARGIN = 0
	ORA	A
	JZ	LFTDN

* OFFSET
	MOV	C,A		;PUT COUNT IN C
LFTM1	MVI	A,' '		;SEND SPACE
	CALL	POUT
	DCR	C
	JNZ	LFTM1		;LOOP TILL DONE
LFTDN	POP	PSW
	POP	B
	POP	D
	POP	H
	RET

*
* CEXP
* USED BY COMMAND ROUTINES TO DO ARABIC EXPANSIONS OF
* NUMBER REGISTERS APPEARING BETWEEN WHERE HL POINTS
* AND THE NEXT '.' OR ':' OR 04.  NO REGISTERS
* ARE AFFECTED.
CEXP	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	B,0000		;ARABIC EXPANSION TO END
	CALL	NUMEXP		;OF COMMAND
	CALL	IBFPNT		;RE-POINT IBFPTR TO 04 BYTE
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET


* TEXP
* EXPANDS ALL NUMBER REGS BETWEEN HL POINTS AND
* THE NEXT 04 BYTE WITH THE CURRENT EXPANSION TYPE.
* NO REGISTERS ARE AFFECTED.
TEXP	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	LDA	EXPTYP		;GET CURRENT EXPANSION TYPE
	MOV	C,A
	MVI	B,04		;STOP ON 04 BYTE
	CALL	NUMEXP
	POP	H
	POP	D
	POP	B
	POP	PSW
	RET


* NUMBER EXPANSION ROUTINE
* EVALUATES AND REPLACES ANY NUMBER REGS APPEARING
* IN IBUF FROM WHERE HL POINTS TILL THE BYTE CONTAINED
* IN B REG IS FOUND.  IF B REG = 0 THEN STOP IF '.' OR
* ' ' OR 04 IS FOUND.  (USED TO DO ARABIC EXPANSIONS
* OF ONE COMMAND AT A TIME FOR 'IF' COMMANDS)
* C REG SPECIFIES WHAT TYPE EXPANSION TO MAKE -
*	00 = ARABIC
*	01 = SMALL ROMAN
*	10 = LARGE ROMAN
NUMEXP	PUSH	B		;SAVE EXP. TYPE AND STOP BYTE
	XRA	A
	STA	INCFLG		;CLEAR INCREMENT FLAG
*
NE2	MOV	A,M		;GET CHAR FROM IBUF
	CMP	B		;TIME TO STOP ?
	JZ	NER
	DCR	B
	INR	B		;IF B=0, ALSO CHECK FOR
	JNZ	NE3		;END-OF-COMMAND
	CALL	EOCCHK
	JC	NER
*
NE3	CPI	'#'		;'#' SEARCH IBUF FOR # OR _
	JZ	EXP
	CPI	25H		;PERCENT SIGN ?? HIS UNDERSCORE ????
	JZ	EXP2
	INX	H
	JMP	NE2
*
EXP2	SHLD	HMRKR		;'_' FOUND (REALLY PERCENT SIGN)
	INX	H
	SHLD	SMRKR
	MVI	A,40H		;40H ('@')
	JMP	EXP3
*
* # FOUND
EXP	SHLD	HMRKR		;SAVE POINTER TO #
	INX	H
	MOV	A,M		;GET NEXT CHAR
	CPI	'+'		;CHECK FOR PLUS SIGN
	JNZ	EXP1
	STA	INCFLG		;MAKE INCFLG NON-ZERO IF FOUND
	INX	H		;POINT TO NEXT CHAR
*
EXP1	MOV	A,M		;GET REGISTER DESIGNATOR
	INX	H
	SHLD	SMRKR		;SAVE POINTER TO NEXT CHAR
	CALL	UCASE		;BE SURE DESIGNATOR IS CAPITAL
EXP3	CALL	NUMVAL		;EVALUATE SPECIFIED REGISTER
	CALL	EMUPD		;GET POINTER TO END OF LINE
	LHLD	HMRKR		;FIND HOW FAR TO MOVE IBUF
	PUSH	B
	PUSH	D
	MVI	B,00
	DAD	B
	SHLD	DMRKR
	CALL	MOVE		;MOVE LINE SO STRING WILL FIT
	POP	D
	POP	B
	LHLD	HMRKR		;GET PTR TO WHERE STRING GOES
EXP4	LDAX	D		;PUT DIGIT STRING INTO IBUF
	MOV	M,A
	INX	H
	INX	D
	DCR	C
	JNZ	EXP4
	POP	B		;GET PARAMS BACK
	JMP	NUMEXP		;GO BACK TO EXPAND OTHERS
*
NER	POP	B
	RET
*
*
*
* NUMVAL
* ACCEPTS UPPER CASE ASCII LETTER (OR 40H FOR _) AS
* NUMBER REGISTER DESIGNATOR IN 'A' REG AND 00, 01, OR 10
* IN LOWER TWO BITS OF 'C' REG TO SPECIFY TYPE OF
* EXPANSION TO MAKE; AND RETURNS A POINTER IN DE PAIR
* TO THE ASCII STRING EXPANSION OF THE VALUE CONTAINED
* IN THE SPECIFIED REGISTER.  THE NUMBER OF CHARACTERS
* IN THE STRING IS RETURNED IN 'C'.
* B REG IS NOT AFFECTED.
NUMVAL	PUSH	B
	SUI	40H		;MAKE INDEX OUT OF ASCII
	JC	NVERR		;CHECK VALIDITY
	CPI	1BH
	JNC	NVERR

* POINT HL PROVER NUMBER REG
	LXI	H,NPG		;FIRST REG
	MVI	D,00
	MOV	E,A
	DAD	D

	LDA	INCFLG		;PERFORM AUTO-INCREMENT IF
	ORA	A		;SPECIFIED
	JZ	NMV1
	LDA	AUINC		;GET INCREMENT VALUE
	ADD	M		;ADD TO REG
	MOV	M,A		;AND REPLACE

NMV1	MOV	A,M		;GET UPDATED REG VALUE
	DCR	C		;JUMP TO PROVER EXPAND ROUTINE
	JZ	SROM		;SMALL ROMAN
	DCR	C
	JZ	LROM		;LARGE ROMAN

* ARABIC CONVERSION
	MVI	C,00
	MOV	B,A		;PUT BINARY NBR IN B
	LXI	H,EXPBUF	;POINT TO ASCII STRING BUFFER
	MVI	M,00		;CLEAR 1ST BYTE

	MVI	D,100		;GET HUNDREDS DIGIT
	CALL	ARB
	MVI	D,10		;GET TENS DIGIT
	CALL	ARB
	MOV	E,B		;GET UNITS DIGIT
	CALL	ARB2

* SEE IF BUF STILL EMPTY
	MOV	A,M
	ORA	A
	JNZ	ARB3		;IF NOT STILL POINTING TO
*				;NULL BYTE, THEN OK
	MVI	M,'0'		;ELSE PUT ZERO IN BUF
	MVI	C,01

ARB3	MOV	A,C
	LXI	D,EXPBUF	;POINT DE TO STRING
	POP	B
	MOV	C,A
	RET

ARB	MVI	E,00
ARB1	MOV	A,B		;GET BINARY VALUE
	SUB	D		;SUBTRACT PLACE VALUE
	JC	ARB2		;JMP IF IT GOES NEG
	MOV	B,A		;ELSE UPDATE BINARY VALUE
	INR	E		;INCREMENT DIGIT
	JMP	ARB1		;TRY AGAIN
ARB2	MOV	A,E		;GET BIN VALUE FOR THIS DIGIT
	PUSH	PSW
	ORA	M		;SUPPRESS LEADING 0'S
	JZ	ARBR
	POP	PSW
	ORI	'0'		;ELSE ASCII-IZE
	MOV	M,A		;PUT IN BUF
	INX	H		;BUMP POINTER
	INR	C		;AND CHARACTER COUNT
	RET
ARBR	POP	PSW
	RET


* CONVERT TO CAPITAL ROMAN NUMERALS
LROM	POP	B
	JMP	ROMAN

* CONVERT TO SMALL ROMAN NUMERALS
SROM	POP	B
	CALL	ROMAN

* NOW MAP CHARACTERS IN EXPBUF TO LOWER CASE
	PUSH	B
	LXI	H,EXPBUF
	MVI	C,10
SROM1	MOV	A,M		;GET CHARACTER
	CALL	LCASE		;CONVERT TO LOWER CASE
	MOV	M,A		;REPLACE IT
	INX	H
	DCR	C
	JNZ	SROM1
	POP	B
	RET

* ROUTINE TO CONVERT BINARY NBR IN 'A' TO ASCII STRING
* OF CAP. ROMAN NUMERALS IN EXPBUF POINTED TO BY DE.
* RETURNS WITH 'C' INDICATING LENGTH OF STRING.
ROMAN	PUSH	B		;DON'T TRASH B REG
	MVI	C,00		;CLEAR STRING LENGTH
	MOV	B,A		;PUT BINARY VALUE IN B
	LXI	H,EXPBUF

* 100
	LXI	D,100 SHL 8 + 'C' ;PUT 100 IN 'D' "C" IN 'E'
	CALL	ROMC
* 90
	LXI	D,90 SHL 8 + 'C' ;PUT 90 IN 'D', "C" IN 'E'
	MVI	A,'X'		 ;AND "X" IN 'A'
	CALL	ROMD
* 50
	LXI	D,50 SHL 8 + 'L' ;PUT 50 IN 'D', "L" IN 'E'
	CALL	ROMC
* 40
	LXI	D,40 SHL 8 + 'L' ;PUT 40 IN 'D', "L" IN 'E'
	MVI	A,'X'		 ;AND "X" IN 'A'
	CALL	ROMD
* 10
	LXI	D,10 SHL 8 + 'X' ;PUT 10 IN 'D', "X" IN 'A'
	CALL	ROMC
* 9
	LXI	D,9 SHL 8 + 'X'	;PUT 9 IN 'D', "X" IN 'A'
	MVI	A,'I'		;"I" IN 'A'
	CALL	ROMD
* 5
	LXI	D,5 SHL 8 + 'V'	;PUT 5 IN 'D', "V" IN 'E'
	CALL	ROMC
* 4
	LXI	D,4 SHL 8 + 'V'	;PUT 4 IN 'D', "V" IN 'E'
	MVI	A,'I'		;"I" IN 'A'
	CALL	ROMD
* 1
	LXI	D,1 SHL 8 + 'I'	;PUT 1 IN 'D', "I" IN 'E'
	CALL	ROMC

	MOV	A,C
	LXI	D,EXPBUF
	POP	B
	MOV	C,A
	RET


ROMC	MOV	A,B		;PUT BINARY VALUE IN A
	SUB	D		;COMPARE TO MOD
	JC	ROMC2		;JMP IF LESS
	MOV	B,A		;ELSE UPDATE BINARY VALUE
	MOV	M,E		;PUT ROMAN CHAR IN EXPBUF
	INX	H		;BUMP POINTER AND CHAR COUNT
	INR	C
	JMP	ROMC		;TRY TO DO IT AGAIN
ROMC2	CMC
	RET


ROMD	PUSH	PSW		;SAVE ROMAN CHAR
ROMD1	MOV	A,B		;GET BINARY VALUE
	SUB	D		;COMPARE TO MOD
	JC	ROMD2		;JMP IF LESS
	MOV	B,A		;ELSE UPDATE BINARY VALUES
	POP	PSW		;GET 1ST ROMAN CHAR
	MOV	M,A		;PUT IN EXPBUF
	INX	H
	INR	C
	MOV	M,E		;PUT 2ND CHAR IN
	INX	H
	INR	C
	RET			;DONE
ROMD2	POP	PSW
	RET



NVERR	LXI	D,BADEXP	;INVALID REGISTER SPECIFIED
	POP	B
	MVI	C,02		;REPLACE WITH '??'
	RET



*
*
* EMUPD - SEARCHES IBUF FOR THE 04 END MARKER AND
* SETS EMRKR TO ITS ADRS.
EMUPD	PUSH	PSW		;SAVE A REG
	PUSH	H
	LXI	H,IBUF
EM1	MOV	A,M		;GET CHAR
	CPI	04
	JZ	EM2
	INX	H
	JMP	EM1
* FOUND
EM2	SHLD	EMRKR		;PUT POINTER IN EMRKR
	POP	H
	POP	PSW
	RET
*
*
*
*********** EXPRESSION EVALUATION ROUTINE *********
* EVALUATES EXPR IN COMMANDS INCLUDING ANY LEADING
* SIGNS.  HL MUST POINT TO OR AHEAD OF EXPR STRING.
* EVAL RETURNS WITH VALUE OF EXPR (EXCLUDING LEADING
* SIGNS) IN A REG.  IF EXPR IS INVALID OR NOT PRESENT
* EVAL RETURNS WITH CY SET.  BYTE 'SGNFLG' INDICATES
* ANY SIGN PRECEDING EXPR - BITS 0 AND 1 ARE:
*	00 - NO PRECEDING SIGN
*	01 - PRECEDING '-' SIGN
*	11 - PRECEDING '+' SIGN
* RETURNED VALUE IS 8-BIT 2'S COMP REPRESENTATION.
* RETURNS WITH HL POINTING WITHIN INVALID EXPR'S,
* JUST AFTER VALID EXPR'S, OR TO NEXT '.', ':' OR
* 04 BYTE IF NO EXPRESSION.
EVAL	PUSH	B		;SAVE BC PAIR
	MVI	B,00		;CLEAR RUNNING SUM
	MVI	C,00
	CALL	SPANS		;LOOK FOR PRECEDING SIGN,
	JC	EVR		;BUT STOP ON DIGIT, OR SET CY
*				;IF '.' OR ':' OR 04 BYTE.
EV1	CALL	SPAND		;FIND FIRST DIGIT
	JC	EVR		;SKIP IF NONE FOUND
	CALL	ATOB		;CNVRT DIGITS AT HL TO BIN
	DCR	C
	DCR	C		;WERE THEY PRECEDED BY '+' ?
	JNZ	EADD		;JUMP IF SO
	CMA			;ELSE TAKE 2'S COMP OF NEW VAL
	ADI	01
EADD	ADD	B		;THEN ADD RUNNING SUM
	MOV	B,A		;PUT BACK

	MOV	A,M		;CHECK NEXT CHAR FOR + OR -
	SUI	'+'		;MAKE 'C'=0 IF +
	MOV	C,A		;OR 2 IF -
	JZ	EV1		;GO FOR NEXT DIGIT IF +
	CPI	02		;OR ALSO IF -
	JZ	EV1
	XRA	A		;CLEAR CARRY
* NEITHER + OR - FOUND:  END OF EXPRESSION
EVR	MOV	A,B		;PUT SUM IN A
	POP	B		;RESTORE BC
	RET



* ATOB
* ROUTINE TO CONVERT STRING OF ASCII DIGITS POINTED TO
* BY HL TO BINARY RESULT RETURNED IN 'A' REG UNTIL
* FIRST NON-DIGIT FOUND.  CONVERSION IS MOD 256.
ATOB	PUSH	B		;SAVE REG
	MVI	B,00		;CLEAR RUNNING SUM
ATB1	MOV	A,M		;GET DIGIT
	CALL	DIGCHK		;CHECK IT
	JC	ATR		;RETURN IF NOT DIGIT
	ANI	0FH		;GET VALUE PART
	MOV	C,A		;SAVE IT
* MULTIPLY CURRENT RUNNING SUM BY 10
	MOV	A,B
	RLC			;MULTIPLY BY 8
	RLC
	RLC
	ANI	0F8H
	ADD	B		;THEN ADD TWICE
	ADD	B
* ADD IN NEW VALUE
	ADD	C
	MOV	B,A		;PUT SUM BACK
	INX	H		;GO FOR NEXT DIGIT
	JMP	ATB1
ATR	MOV	A,B		;PUT SUM IN A
	POP	B
	RET
*
* SPANS
* SCAN UNTIL + OR - FOUND, SET 'SGNFLG' TO SHOW WHICH.
* IF DIGIT FOUND FIRST RETURN.  IF END OF COMMAND FOUND
* ('.' OR ':' OR 04) RETURN WITH CY SET.
SPANS	XRA	A		;CLEAR SGNFLG
	STA	SGNFLG
SPS0	MOV	A,M		;GET CHAR
	CPI	'+'		;PLUS
	JZ	SPS1
	CPI	'-'		;HYPHEN (2DH)
	JZ	SPS1
* NOT SIGN - CHECK FOR DIGIT
	CALL	DIGCHK
	RNC			;RETURN IF FOUND
	CALL	EOCCHK		;RETURN WITH CY=1 IF END
	RC
	INX	H
	JMP	SPS0		;IF ALL FAILS TRY NEXT CHAR
SPS1	ANI	03		;SAVE BITS 0 AND 1
	STA	SGNFLG
	RET


* SPAND
* SCAN UNTIL DIGIT FOUND.  IF END OF COMMAND FOUND
* FIRST, RETURN WITH CY SET.
SPAND	MOV	A,M		;GET CHAR
	CALL	DIGCHK		;IS DIGIT ?
	RNC			;RETURN IF SO
	CALL	EOCCHK		;END ?
	RC
	INX	H
	JMP	SPAND		;TRY NEXT CHAR


* DIGCHK
* CHECK CONTENTS OF 'A' FOR ASCII DIGIT.  RETURN
* WITH CY SET IF NOT.
DIGCHK	CPI	'0'
	RC
	CPI	'9'+1
	CMC
	RET

* EOCCHK
* CHECK CONTENTS OF 'A' FOR '.' OR ':' OR 04.
* RETURN WITH CY SET IF TRUE.
EOCCHK	CPI	04
	JZ	ED1
	CPI	'.'
	JZ	ED1
	CPI	':'
	JZ	ED1
	ORA	A
	RET
ED1	STC
	RET
*
IBFPNT	PUSH	H
	PUSH	PSW
	LXI	H,IBUF
* FIND THE 04 BYTE AT END OF LINE - POINT IBFPTR TO IT
CR01	MOV	A,M
	CPI	04
	JZ	CR02
	INX	H
	JMP	CR01
CR02	SHLD	IBFPTR
	POP	PSW
	POP	H
	RET
CMDPRO	CALL	IBFPNT
	SUI	':'		;IF COLON, THEN BRCHK
	STA	BRFLG		;BECOMES ZERO
*
	INX	H
	MOV	A,M
	CALL	UCASE		;CONVERT CHARACTERS OF COMMAND
	MOV	C,A		;TO UPPER CASE
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A
	INX	H
	PUSH	H		;SAVE IBUF POINTER ON STACK
	LXI	H,CMDTBL	;POINT TO TABLE
	CALL	SRCH		;LOOK FOR COMMAND IN CMDTBL
	POP	H		;GET BACK IBUF POINTER
	JC	TRYMAC		;IF NOT COMMAND, TRY
*				;MACRO TABLE
	PUSH	D		;ELSE JUMP TO COMMAND ROUTINE
	RET

* SEE IF THE NAME IS THAT OF A MACRO OR DIVERSION
TRYMAC	CALL	MINVOK
	ORA	A		;CLEAR CY
	JMP	NEWLIN

*========
* MINVOK
MINVOK	LXI	H,MACTBL	;FIND NAME IN TABLE
	CALL	SRCH
	RC			;RET WITY CY SET IF NOT FOUND

* ROUTINE TO INVOKE MACRO WHOSE 1ST BYTE IS POINTED TO
* BY DE PAIR
INVOK	LHLD	IBFPTR		;SEE IF ANY REMAINING IN IBUF
	CALL	SPANC
	MOV	A,M		;(IBFPTR POINTING TO 04 ?)
	CPI	04
	JZ	INK2

* PUT UNUSED PART OF IBUF IN MSPACE
	PUSH	D		;SAVE NAMED-MACRO'S POINTER
	XCHG			;KEEP IBFPTR
	LHLD	FSTAVL		;GET AVAIL. PTR
	XCHG			;INTO DE
	ORI	80H		;REMOVE ANY SPECIAL MEANING
*				;FROM 1ST CHAR
INK1	CALL	MPUT		;PUT IN MSPACE
	JC	SYSERR		;JMP IF FULL
	INX	H
	MOV	A,M		;GET NEXT CHAR
	CPI	04		;DONE YET ?
	JNZ	INK1		;PUT IN MSPACE IF NOT
	SHLD	IBFPTR		;ELSE MAKE IBFPTR POINT TO END
	MVI	A,0DH		;END LINE IN MSPACE WITH CR
	CALL	MPUT
	JC	SYSERR
	MVI	A,0FEH		;PUT MARKER AT END OF MACRO
	PUSH	H
	PUSH	D
	CALL	CLSMAC
	POP	D
	POP	H
	JC	SYSERR
	XCHG			;NOW SWAP PSEUDO-MACRO'S PTR
	XTHL			;(IN DE) WITH NAMED-MACRO'S
	XCHG			;PTR ON STACK
	CALL	INVOK		;TRY RE-INVOKING NAMED MACRO
	POP	D		;THEN GET BACK THE PTR TO THE
*				;PSEUDO-MACRO AND INVOK IT

INK2	LHLD	MPTR		;GET CURRENT VALUE OF MPTR
	PUSH	H		;SAVE ON STACK
	XCHG			;SAVE PTR TO INVOKED MACRO
	PUSH	H
	SHLD	MPTR		;PUT NEW PTR IN MPTR

	CALL	NEWLIN		;RECURSIVELY CALL PROCESSOR

	POP	D		;GET PTR TO JUST-FINISHED MAC
	LHLD	MPTR		;WAS IT PSEUDO ?
	MOV	A,M
	ADI	02
	CZ	MFREE		;DELETE IT IF SO
	POP	H		;RESTORE OLD MPTR
	SHLD	MPTR
	ORA	A		;CLEAR CY
	RET



******** SRCH ********
* ENTRY OF TABLE TO BE SEARCHED.  2-CHAR. NAME MUST BE
* IN BC, 1ST CHAR IN 'C', 2ND IN 'B'.  IF NAME FOUND,
* RETURNS WITH TWO BYTES AFTER NAME IN TABLE IN DE
* PAIR, 1ST BYTE IN 'E'+ 2ND IN 'D'.  HL POINTS TO 1ST
* BYTE OF THAT ENTRY.  IF NAME NOT FOUND, RETURNS WITH
* CY SET, AND HL POINTING TO '00' BYTE WHICH FOLLOWS
* LAST BYTE OF LAST ENTRY IN TABLE.
SRCH	PUSH	H		;SAVE POINTER TO ENTRY
	LXI	D,0004		;USE DE TO INCREMENT HL BY 4
SRCH1	MOV	A,M		;GET CHAR FROM TABLE
	ORA	A		;CHECK FOR 0 AT END
	JZ	SRCH3
	CMP	C		;IF NOT END, COMPARE NAMES
	JNZ	SRCH2		;JMP IF NO MATCH
	INX	H		;IF 1ST CHARS MATCH, TRY 2ND
	MOV	A,M
	CMP	B
	JNZ	SRCH2

* NAMES MATCH
	INX	H		;PUT NEXT TWO BYTES IN DE
	MOV	E,M
	INX	H
	MOV	D,M
	POP	H		;PUT PTR TO THIS ENTRY BACK IN
	ORA	A
	RET			;HL THEN RETURN

* THIS ENTRY DOESN'T MATCH
SRCH2	POP	H		;GET POINTER TO THIS ENTRY
	DAD	D		;INCREMENT IT BY 4
	PUSH	H		;THEN SAVE IT
	JMP	SRCH1		;AND TRY NEXT ENTRY

* NAME NOT IN TABLE
SRCH3	XTHL			;THROW AWAY ENTRY POINTER
	POP	H		;LEAVE HL POINTING TO 00 BYTE
	STC			;SET CY FLAG TO SHOW NAME
	RET			;NOT FOUND


*===========
* NAMPUT
* USED TO PUT A TWO CHAR. NAME (ASSUMED TO BE IN BC AS
* IN 'SRCH') INTO THE MACRO NAME TABLE 'MACTBL'
* IF NAME ALREADY THERE, NEW ONE REPLACES IT.  IF NOT,
* NEW ONE IS ADDED AT END OF TABLE.  IN BOTH CASES THE
* CURRENT VALUE OF 'FSTAVL' IS STORED IN TABLE JUST
* AFTER THE NAME.  (ASSUMING THAT AFTER NAME IS PUT IN
* TABLE EITHER A DIVERSION OR MACRO WILL BE PUT IN
* 'MSPACE' STARTING AT FSTAVL)
* PSW, DE, AND HL TRASHED.
NAMPUT	LXI	H,MACTBL	;POINT TO MACRO NAME TABLE
	CALL	SRCH		;LOOK FOR THIS NAME THERE
	CNC	MFREE		;FREE MSPACE
	PUSH	PSW		;SAVE CARRY FLAG
	MOV	M,C		;PUT 1ST CHAR OF NAME IN ENTRY
	INX	H
	MOV	M,B		;THEN 2ND
	INX	H

	XCHG
	LHLD	FSTAVL		;PUT FSTAVL IN DE
	XCHG

	MOV	M,E		;STORE IN ENTRY AFTER NAME
	INX	H
	MOV	M,D
	INX	H

	POP	PSW		;SEE IF LAST ENTRY IN TABLE
	RNC			;RETURN IF NOT
	MVI	M,00		;ELSE PUT END MRKR AFTER ENTRY
	XRA	A		;CLEAR CY
	RET



*
*
* BRCHK - CHECKS BREAK-FLAG (BRFLG) AND FLUSHES BUFFER
* IF NON-ZERO.  NO REGISTERS AFFECTED.
*
BRCHK	PUSH	PSW
	PUSH	B
	PUSH	D
	PUSH	H
	LDA	BRFLG		;GET FLAG
	ORA	A
	JZ	BRC1		;RETURN IF NOT SED
	CALL	FLUSH
BRC1	POP	H
	POP	D
	POP	B
	POP	PSW
	RET
*
*
* TYPE1
* USED TO DO PARAMETER UPDATES WITH ARGUMENTS OF TYPE
* +-N.  ASSUMES VALUE RETURNED BY EVAL IS IN 'B', REG
* TO BE UPDATED IS IN 'A'.  UPDATES BY INCREMENTING
* A BY B, DECREMENTING A BY B, OR REPLACING A BY B,
* ACCORDING TO 'SGNFLG'.  NEW VALUE RETURNED IN 'A'.
TYPE1	PUSH	PSW
	LDA	SGNFLG		;GET SIGN FLAG
	ORA	A		;IF ZERO THEN B REPLACES A
	JZ	T1ABS
	DCR	A		;IF 01 THEN A BECOMES A-B
	JZ	T1DEC
T1INC	POP	PSW		;ELSE A BECOMES A+B
	ADD	B
	RET
T1DEC	POP	PSW
	SUB	B
	RET
T1ABS	POP	PSW
	MOV	A,B
	RET
*=============================================

* BR
*
BR	CALL	BRCHK
	LDA	RUNFLG		;HAS NO OUTPUT BEEN SENT ?
	ORA	A
	MVI	A,01
	STA	RUNFLG		;SET THE (SET THE FLAG)
	JNZ	NEWLIN
	LDA	NON
	CPI	01		;IS IT LINE 1 ?
	JNZ	NEWLIN
	CALL	TRPCHK		;IF ALL THE ABOVE SPRING TRAP
	XRA	A		;CLEAR CARRY
	JMP	NEWLIN
*
* FI - TURN FILL MODE ON
*
FI	CALL	BRCHK
	LXI	H,FILFLG
	MVI	M,01
	JMP	NEWLIN
*
* NF - TURN FILL OFF
NF	CALL	BRCHK
	LXI	H,FILFLG
	MVI	M,00
	JMP	NEWLIN
*
* JU C - JUSTIFICATION TYPE
*
JU	MVI	A,01		;TURN ON JUSTIFICATION
	STA	JSTFLG
*
	CALL	SPANC		;FIND FIRST CHARACTER
	MOV	A,M		;GET IT
	CALL	UCASE		;CNVT TO UPPER CASE
	LXI	H,JUSTYP
	CPI	'R'		;'R' ?
	JNZ	JU1
	MVI	M,01
	JMP	NEWLIN
JU1	CPI	'N'		;'N' ?
	JNZ	JU2
	MVI	M,02
	JMP	NEWLIN
JU2	CPI	'C'		;'C' ?
	JNZ	NEWLIN
	MVI	M,04
	JMP	NEWLIN
*
* NJ - TURN JUSTIFICATION OFF
*
NJ	LXI	H,JSTFLG	;CLEAR 'JUST' FLAG
	MVI	M,00
	JMP	NEWLIN
*
* EV N - CHANGE ENVIRONMENT
*
EV	CALL	CEXP		;EXPAND ANY NBR REGS
	CALL	EVAL		;EVALUATE EXPRESSION
	JNC	EVN1
	XRA	A
EVN1	ANI	01		;LOOK AT BIT ZERO
	MOV	B,A
	LDA	CURENV		;SAME AS CURRENT ENVIRONMENT ?
	XRA	B
	JZ	NEWLIN		;RETURN IF SO
	CALL	EVSWAP		;ELSE, SWAP ENVIRONMENT BLOCK
	JMP	NEWLIN		;AND QUIT
*
*
* CHANGE ENVIRONMENT
EVSWAP	LDA	CURENV		;CHANGE CURRENT ENV. FLAG
	XRI	01
	STA	CURENV
*
* SWAP TWO ENVIRONMENT DEPENDENT NBR REGS
	LDA	NOI
	MOV	B,A
	LDA	NOI2
	STA	NOI
	MOV	A,B
	STA	NOI2

	LDA	NOL
	MOV	B,A
	LDA	NOL2
	STA	NOL
	MOV	A,B
	STA	NOL2

* EXCHANGE PARAMETER BLOCK
	LXI	D,FILFLG	;1ST POINTER
	LXI	H,EVSTOR	;2ND POINTER
ENV1	CALL	EVCHK		;JUMP IF LAST BYTE MOVED
	RC
	LDAX	D
	MOV	B,A		;GET BYTE FROM CURRENT BLOCK
	MOV	A,M		;GET BYTE FROM NEW BLOCK
	STAX	D		;SWAP THE TWO
	MOV	A,B
	MOV	M,A
	INX	H		;INCR POINTERS
	INX	D
	JMP	ENV1		;GO FOR NEXT
*
EVCHK	PUSH	H		;CHECK IF PTR HAS REACHED END
	PUSH	D
	LXI	H,NOPAD
	XCHG
	CALL	COMPR
	XCHG
	POP	D
	POP	H		;SET CARRY IF PAST END
	RET
*
*

* IN +-N UPDATE INDENT
*
IDNT	CALL	BRCHK		;DO BREAK
	CALL	CEXP		;EXPAND ANY NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPRESSION
	JC	NEWLIN		;IF NO EXPR USE PREV VALUE
	MOV	B,A
	LDA	TEMPIN		;GET CURRENT INDENT
	CALL	TYPE1		;UPDATE IT FOR TYPE1 ARGUMENT
	STA	TEMPIN
	JMP	CHKWD		;CHECK LINE WIDTH

* SI +-N    SET SINGLE-INDENT VALUE
*
SI	CALL	BRCHK
	CALL	CEXP
	CALL	EVAL
	MOV	B,A
	MVI	A,01
	JC	SI1		;IF NO EXPR SET SI TO 1
	LDA	TEMPSI		;GET CURRENT SI COUNT
	CALL	TYPE1		;UPDATE IT
SI1	STA	TEMPSI		;SAVE BACK OUT
	JMP	CHKWD		;CHECK LINE WIDTH

* LN +-N	  PREST LINE LENGTH
*
LN	CALL	CEXP
	CALL	EVAL
	JC	NEWLIN		;USE PREV IF NO EXPR
	MOV	B,A
	LDA	TEMPLN		;GET CURRENT LINE LENGTH
	CALL	TYPE1
	CPI	0FH
	JNC	LN1		;DON'T ALLOW LINE LENGTH LT 15
	MVI	A,0FH
LN1	CPI	151		;NOR LINE LENGTH GT 150
	JC	LN2
	MVI	A,150
LN2	STA	TEMPLN

CHKWD	LDA	CHRCNT		;IS PROCESS BUFFER EMPTY ?
	ORA	A
	CZ	FIXWD		;IF SO UPDATE WIDTH
	JMP	NEWLIN


* FIXWD
* UPDATES THE LINE LENGTH AND INDENT NUMBER
* REGISTERS AND THE SINGLE INDENT COUNT.
*
FIXWD	LDA	TEMPSI
	STA	SICNT
	LDA	TEMPIN
	STA	NOI
	LDA	TEMPLN
	STA	NOL
	RET


* DM XX	  DEFINE MACRO XX
*
DM	CALL	SPANC		;FIND FIRST CHARACTER
	MOV	A,M		;GET IT
	CPI	04		;NAME MISSING ?
	JZ	NEWLIN		;IGNOR IF SO

	CALL	UCASE		;CONVERT CHAR TO UPPER

	MOV	C,A		;ELSE PUT NAME IN BC
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A
DM4	CALL	NAMPUT		;PUT NAME IN MACRO TABLE

* PUT NEXT INPUT LINE IN IBUF IN 'RAW' FORM
* (SPECIAL CHARS ARE NOT REMOVED UNLESS COMING
* DIRECTLY FROM THE SOURCE FILE.  NO OTHER PROCESSING
* TAKES PLACE IN EITHER CASE)
DM0	LXI	H,IBUF
DM1	CALL	GETCHR		;GET NEXT CHARACTER
	MOV	M,A		;PUT IN IBUF
	INX	H		;INR POINTER
	CPI	0DH		;WAS LAST CHAR CR ?
	JNZ	DM1		;GO FOR ANOTHER IF NOT

* FULL LINE IN IBUF - SEE IF '..' IN FIRST TWO COLUMNS
	LXI	H,IBUF
	MOV	A,M		;GET FIRST CHAR
	CPI	'.'		;IS IT '.' ?
	JNZ	DM2
	INX	H
	CMP	M		;IS NEXT ALSO ?
	JNZ	DM2
	MVI	A,0FFH
	CALL	CLSMAC		;IF SO THEN PUT END MARKER IN
	JC	SYSERR		;JUMP IF MSPACE FULL
	JMP	NEWLIN		;RETURN TO NORM PROCESSING

* PUT LINE NOW IN IBUF IN MSPACE
DM2	LXI	H,IBUF
DM3	MOV	A,M		;GET CHAR FROM IBUF
	INX	H		;INR POINTER
	MOV	B,A		;SAVE CHAR IN B FOR LATER
	CALL	MPUT		;PUT THIS CHAR IN MSPACE
	JC	SYSERR		;MSPACE OVERFLOWED IF CY SET
	MOV	A,B		;GET BACK CHAR
	CPI	0DH		;WAS IT CR ?
	JNZ	DM3		;KEEP GOING IF NOT
	JMP	DM0		;ELSE GET NEXT INPUT LINE

SYSERR	LXI	SP,STACK	;RESET STACK
	LXI	H,OFLO		;PRINT MESSAGE
	CALL	PDATT
	CALL	TRMCRL
	JMP	EXIT2
*

*=============
* .AM XX	  APPEND TO MACRO XX
*
AM	CALL	SPANC		;FIND NAME XX
	MOV	A,M		;PRESENT ?
	CPI	04
	JZ	NEWLIN		;IGNOR IF NOT

	CALL	UCASE
	MOV	C,A		;ELSE PUT IN BC
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A
	LXI	H,MACTBL	;SEE IF MACRO EXISTS
	CALL	SRCH
	JC	DM4		;IF NOT THEN JUMP TO '.DM' TO
*				;CREATE ONE
	LHLD	MPTR		;ELSE SAVE CURRENT MPTR
	PUSH	H
	XCHG
	SHLD	MPTR		;POINT MPTR TO MACRO BEING
*				;APPENDED TO
AM1	CALL	MGET		;LOOP UNTIL END OF MACRO FOUND
	JNC	AM1
	LHLD	FSTAVL		;GET FSTAVL POINTER
	XCHG
	LHLD	MPTR		;MPTR NOW POINTS TO 'FF' BYTE
	INX	H		;STORE FSTAVL AFTER 'FF' BYTE
	MOV	M,E
	INX	H
	MOV	M,D
	POP	H		;RESTORE OLD MPTR
	SHLD	MPTR
	JMP	DM0		;USE PART OF '.DM' ROUTINE TO
*				;PUT MACRO ADDITION IN MSPACE



*============
* .DI XX	  DIVERT OUTPUT INTO MACRO SPACE XX
*
DIT	CALL	SPANC		;FIND 1ST CHAR OF NAME
	MOV	A,M		;SEE IF IT'S REALLY 04
	CPI	04
	JZ	DIEND		;IF SO, NO NAME - STOP DIVERT

	CALL	UCASE
	MOV	C,A		;ELSE PUT NAME IN BC
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A
DI1	CALL	NAMPUT		;PUT NAME IN MACRO TABLE
DI1A	XRA	A		;CLEAR DIVERSION LINE COUNT
	STA	NOV
DI2	MVI	A,01		;SET DIVERT FLAG
	STA	DVTFLG
	JMP	NEWLIN		;ALL FINISHED

DIEND	LDA	DVTFLG
	ORA	A
	JZ	NEWLIN
	MVI	A,0FFH
	CALL	CLSMAC		;PUT MRKR AT END OF DIVERSION
	JC	SYSERR		;SEE IF MSPACE OVERFLOWED
	XRA	A		;CLEAR DIVERSION FLAG
	STA	DVTFLG
	JMP	NEWLIN		;ELSE ALL DONE


*==========
* .RM XX	  REMOVE MACRO OR DIVERSION XX
*
RMOV	CALL	SPANC		;LOOK FOR 'XX'
	MOV	A,M
	CPI	04		;IS IT MISSING ?
	JZ	NEWLIN		;IGNOR COMMAND IF SO

	CALL	UCASE
	MOV	C,A		;ELSE PUT NAME IN BC
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A

	LXI	H,MACTBL
	CALL	SRCH		;FIND NAME IN TABLE
	JC	NEWLIN		;IGNOR COMMAND IF NOT FOUND
	CALL	MFREE		;ELSE FREE THE MSPACE

* PHYSICALLY REMOVE ENTRY FROM MACTBL BY 'SLIDING'
* ALL ENTRIES AFTER IT UP INTO ITS PLACE.
	SHLD	DMRKR		;SET UP POINTERS FOR 'MOVE'
	LXI	D,0004
	DAD	D		;POINT TO 1ST BYTE OF
	SHLD	SMRKR		;NEXT ENTRY
* FIND 00 BYTE AT END OF TABLE
RM1	MOV	A,M		;GET 1ST BYTE OF ENTRY
	ORA	A		;CHECK FOR 0
	JZ	RM2
	DAD	D		;IF NOT TRY NEXT ENTRY
	JMP	RM1
RM2	SHLD	EMRKR
	CALL	MOVE		;SLIDE THE TABLE
	JMP	NEWLIN

*=========
* .AT -N XX			PREST TRAP
*
AT	CALL	CEXP		;EXPAND NUMBER REGISTERS
	CALL	EVAL		;EVALUATE -N ARGUMENT
	JC	NEWLIN		;IGNOR COMMAND IF NO EXPR

	MOV	B,A		;ELSE PUT RESULT IN B
	LDA	NOOP		;AND CURRENT PG LENGTH IN A
	CALL	TYPE2		;RETURN ABSOLUTE LINE NBR
	PUSH	PSW		;SAVE IT
	CALL	SPANC		;FIND MACRO NAME (IF ANY)
	MOV	A,M		;ANY THERE ?
	CPI	04
	JZ	TRMV		;IF NOT, REMOVE THIS TRAP

	CALL	UCASE
	MOV	C,A		;ELSE PUT MACRO NAME IN BE
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A

	POP	PSW		;GET BACK LINE NBR
	PUSH	PSW
	PUSH	B		;SAVE IT AND NAME
	MOV	B,A
	CALL	TSRCH1		;SEE IF TRAP AT THIS LINE NBR
	JC	TRPLC		;REPLACE IT IF SO

* ADD NEW TRAP TO END OF TRAP TABLE
TINSRT	POP	B		;GET NAME
	POP	PSW		;AND LINE NBR
	MOV	M,A		;HL POINTS TO 0 BYTE AT END
	INX	H		;OF TABLE)
	MOV	M,C		;PUT NAME IN AFTER LINE NBR
	INX	H
	MOV	M,B
	INX	H
	MVI	M,00		;PUT 0 AT END OF TABLE
	JMP	NEWLIN		;ALL DONE

* REPLACE TRAP AT THIS LINE WITH NEW ONE
TRPLC	POP	B		;GET NAME
	POP	PSW		;AND LINE NBR
	INX	H		;POINT HL TO 1ST BYTE OF ENTRY
	MOV	M,C		;JUST PUT NEW NAME THERE
	INX	H
	MOV	M,B
	JMP	NEWLIN		;THAT'S ALL

* PHYSICALLY REMOVE TRAP FROM TABLE
TRMV	POP	PSW		;GET LINE NBR
	CALL	TSRCH1		;LOOK FOR A TRAP AT THAT LINE
	JNC	NEWLIN		;DONE IF NONE

	SHLD	DMRKR		;ELSE HL POINTS TO FATED ENTRY
	LXI	D,0003
	DAD	D		;SET UP POINTERS FOR 'MOVE'
	SHLD	SMRKR		;ROUTINE WHICH WILL 'SLIDE'
TRM1	MOV	A,M		;REST OF TABLE UP ABOVE
	ORA	A		;REMOVED ENTRY.  (NOW LOOKING
	JZ	TRM2		;FOR END OF TABLE)
	DAD	D
	JMP	TRM1
TRM2	SHLD	EMRKR
	CALL	MOVE		;SLIDE TABLE
	JMP	NEWLIN		;FINISHED


*=======
* TYPE2
* USED TO CALCULATE THE ABSOLUTE LINE NBR REFERENCED
* IN COMMANDS WITH TYPE -N ARGUMENTS.  ASSUMES VALUE
* RETURNED BY EVAL IS IN 'B' WHILE PAGE LENGTH IS IN
* 'A'.  RETURNS ABSOLUTE LINE NBR IN 'A'.
* ONLY PSW, BC AFFECTED.
TYPE2	PUSH	PSW		;SAVE PAGE LENGTH
	LDA	SGNFLG		;SEE IF '-' PRECEDED NBR
	DCR	A
	JZ	T2BOT		;IF SO, REF. RELATIVE TO BOT.
	MOV	A,B		;IF NOT SEE IF NBR ITSELF IS -
	ORA	A
	JP	T2TOP		;IF NOT, ARG. IS THE LINE NBR
	CMA
	ADI	01		;ELSE COMPLEMENT IT
	MOV	B,A		;AND PUT BACK
	JMP	T2BOT


T2TOP	POP	PSW		;ELSE ARGUMENT IS THE LINE NBR
	MOV	A,B
T2	ORA	A		;IF = 0 CHANGE TO 1
	RNZ
	INR	A
	RET

T2BOT	MOV	A,B		;TAKE 2'S COMP OF NBR
	SUI	01		;LET -0 OR -1 MEAN LAST LINE
	JNC	T2B1
	ADI	01
T2B1	CMA			;TAKE 2'S COMP OF ARG
	ADI	01
	MOV	B,A
	POP	PSW		;THEN ADD PAGE LENGTH
	ADD	B
	JMP	T2		;CHANGE 0'S TO 1'S IF ANY


*=======
* MFREE
* ROUTINE TO 'REMOVE' MACRO OR DIVERSION SPACE IN
* MSPACE BY ADJUSTING PTRS TO MAKE IT PART OF THE
* AVAILABLE MSPACE.  THIS IS DONE IN TWO WAYS.  THE MOST
* EFFICIENT IS TO POINT FSTAVL TO BLOCK BEING FREED,
* AND MAKE THAT BLOCK'S END PTR POINT TO PREVIOUS
* AVAILABLE BLOCK.  IF A TEMPORARY DIVERSION IS CREATED
* AND DELETED, MSPACE IS LEFT UNCHANGED.  IF A
* DIVERSION IS IN PROGRESS THE VALUE OF FSTAVL CANNOT
* BE ALTERED.  IN THIS CASE THE BLOCK IS APPENDED TO
* THE END OF AVAILABLE STORAGE.  UNFORTUNATELY THIS
* SCHEME TENDS TO CLUTTER MSPACE WITH MARKERS.
* DE MUST POINT TO 1ST BYTE OF SPACE TO BE FREED.
* NO REGISTERS AFFECTED.
MFREE	PUSH	PSW
	PUSH	H
	LHLD	MPTR		;SAVE CURRENT VALUE OF MPTR
	PUSH	H		;ON STACK

	LHLD	FSTAVL		;GET PTR TO 1ST AVAILABLE BYTE

* NOW SEE IF DIVERSION IS TAKING PLACE - IF SO, APPEND
* BLOCK BEING FREED TO END OF AVAILABLE MSPACE.
	LDA	DVTFLG		;GET DIVERT FLAG
	ORA	A
	JNZ	FRE2		;JMP IF DIVERSION TAKING PLACE

* NO DIVERSION -
	XCHG			;HL POINTS TO 1ST BYTE OF BLK
	SHLD	FSTAVL		;BEING FREED WHICH WILL NOW BE

FRE2	SHLD	MPTR		;FSTAVL.  SETUP MPTR FOR 'MGET'

FRE1	CALL	MGET		;FIND MRKR AT END OF 1ST BLOCK
	JNC	FRE1

	LHLD	MPTR		;NOW MPTR POINTS TO 'FF' BYTE
	INX	H
	MOV	M,E		;STORE OLD FSTAVL AFTER
	INX	H		;THE 'FF' BYTE
	MOV	M,D
	INX	H

* NOW CHECK TO SEE IF THE 2ND BLOCK HAPPENS TO
* BE IMMEDIATELY AFTER THE POINTER JUST STORED.
* IF SO THEN JUST REMOVE THE WHOLE MARKER.
	MOV	A,H		;CHECK FOR DE = HL
	CMP	D
	JNZ	FRE0
	MOV	A,L
	SUB	E
	JNZ	FRE0

* 2ND BLOCK IS INDEED AFTER MRKR - CLEAR 'FF' BYTE
	LHLD	MPTR		;GET BACK POINTER TO 'FF'
	MOV	M,A		;CLEAR IT
	INX	H
	MOV	M,A
	INX	H
	MOV	M,A
FRE0	POP	H		;REPLACE ORIGINAL VAL OF MPTR
	SHLD	MPTR
	POP	H
	POP	PSW		;RESTORE REGISTERS
	RET


*===========
* CLSMAC
* PUTS 'FF,00,00' FOR 'FE,00,00' END-OF-MACRO MARKER
* AT END OF MACROS AND DIVERSIONS.  (ASSUMES THE 'FF'
* OR 'FE' IS IN THE 'A' REG WHEN CALLED).  CLSMAC
* FIRST CHECKS TO BE SURE
* THERE ARE 3 CONTIGUOUS AVAILABLE BYTES WHERE FSTAVL
* POINTS, THEN PUTS MRKR THERE IF SO.  IF AN 'FF' BYTE
* IS FOUND DURING THE CHECK, THE BYTES LEADING UP TO
* THE 'FF' ARE FILLED WITH NULLS.  THE MARKER FOUND
* IS CHECKED FOR 0'S.  IF 0, MSPACE IS OVERFLOWED AND
* CLSMAC RETURNS WITH CY SET.  ELSE THE POINTER IN THE
* MRKR IS LOADED AND THE ENTIRE PROCEDURE IS REPEATED.
* ALL REGISTERS TRASHED.
CLSMAC	PUSH	PSW		;SAVE 'FF' OR 'FE'
	LHLD	FSTAVL		;GET POINTER

* SEE IF FIRST BYTE IS FF OR FE.  IF SO, MARKER WILL
* JUST FIT
	MOV	A,M		;GET BYTE
	ORI	01		;CHECK FOR FF AND FE
	INR	A
	JZ	EXCT		;JMP IF MARKER WILL JUST FIT

CM2	PUSH	H		;SAVE PTR TO 1ST OF 3 BYTES
	MVI	C,03		;SET COUNTER FOR 3 BYTES
CM3	MOV	A,M		;CHECK CHAR
	ORI	01		;FOR 'FE' OR
	INR	A		;FOR 'FF' MARKER
	JNZ	CM4		;IF NOT THEN TRY NEXT ONE

* 'FF' FOUND - CHECK FOR END OF MSPACE
	INX	H		;PUT POINTER IN DE
	MOV	E,M
	MOV	A,E		;ALSO CHECK FOR PTR = 0
	INX	H
	MOV	D,M
	ORA	D
	JZ	CM5		;JUMP IF = 0 (MSPACE FULL)
	POP	H		;ELSE PUT NEW PTR IN HL
	XCHG
	JMP	CM2

CM4	MVI	M,00		;CLEAR THIS BYTE
	INX	H		;BUMP PTR
	DCR	C		;IS THIS 3RD OK CHAR ?
	JNZ	CM3		;TRY NEXT IF NOT
* DESIRED 3 AVAILABLE BYTES FOUND
	POP	H		;GET POINTER TO 1ST OF THE 3
	POP	PSW		;GET BACK 'FF' OR 'FE'
	MOV	M,A		;PUT IT THERE
	INX	H		;(NEXT 2 BYTES ARE ALREADY
	INX	H		;CLEARED)
	INX	H
CM6	SHLD	FSTAVL		;UPDATE FSTAVL
	ORA	A		;CLR CY
	RET


* MARKER WILL JUST FIT
EXCT	MVI	M,0FFH		;MAKE MARKER FF
	INX	H
	MOV	E,M		;GET PTR FROM MARKER INTO DE
	MVI	M,00
	INX	H
	MOV	D,M
	MVI	M,00
	XCHG
	MOV	A,L		;CHECK FOR ZERO POINTER
	ORA	H		;WHICH MEANS FULL
	PUSH	H
	JZ	CM5

	POP	H		;ELSE PUT POINTER INTO FSTAVL
	POP	PSW
	JMP	CM6

CM5	POP	H		;CLEAN UP STACK
	POP	PSW
	STC			;SET CY
	RET


*===========
* MPUT
* PLACES THE BYTE PASSED IN 'A' INTO MSPACE WHERE
* FSTAVL POINTS.  UPDATES FSTAVL TO POINT TO NEXT
* BYTE.  IF END OF MSPACE REACHED, THEN MPUT
* RETURNS WITH CY SET.
* ONLY 'A' AND FLAGS CHANGED.
MPUT	PUSH	D
	PUSH	H
	PUSH	PSW		;SAVE CHAR TO BE PLACED
	LHLD	FSTAVL		;GET POINTER
MPT1	MOV	A,M		;FIRST CHECK FOR 'FF' MRKR
	ORI	01		;OR 'FE' MRKR
	INR	A
	JNZ	MPT2

* FF MARKER FOUND
	INX	H
	MOV	E,M		;PUT POINTER IN DE
	MOV	A,E		;ALSO CHECK FOR PTR = 0
	INX	H
	MOV	D,M
	ORA	D
	JZ	MPTF		;JUMP IF END OF MSPACE REACHED
	XCHG			;ELSE PUT PTR IN HL
	JMP	MPT1

* HL NOW POINTS TO AN AVAILABLE BYTE
MPT2	POP	PSW		;GET CHAR BACK
	MOV	M,A		;PUT IN MSPACE
	INX	H
	SHLD	FSTAVL		;UPDATE FSTAVL
	POP	H		;GET BACK REGS
	POP	D
	XRA	A		;CLEAR CARRY
	RET

* MSPACE FULL
MPTF	POP	PSW
	POP	H
	POP	D
	STC			;SET CARRY
	RET




*===========
* .MS N	  PREST FOR MULTIPLE SPACING
*
MS	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPRESSION
	JNC	MS1		;IF NO EXPRESSION, DEFAULT TO
	MVI	A,02		;DOUBLE SPACING
MS1	DCR	A
	STA	LINSP
	XRA	A		;CLEAR CY
	JMP	NEWLIN

*===========
* .SS		  PREST TO SINGLE SPACING
*
SS	XRA	A		;CLEAR LINSP
	STA	LINSP
	JMP	NEWLIN

*===========
* .NS		  TURN ON NO-SPACE MODE
*
NS	MVI	A,01
	STA	NOSPC		;SET NOSPACE FLAG
	JMP	NEWLIN

*===========
* .RS		  RESTORE SPACE MODE
*
RS	XRA	A
	STA	NOSPC		;CLEAR NOSPACE FLAG
	JMP	NEWLIN



*===========
* DA XX	  APPEND DIVERSION
*
DA	CALL	SPANC		;FIND NAME XX
	MOV	A,M		;SEE IF IT'S THERE
	CPI	04
	JZ	DIEND		;IF NOT, TERMINATE DIVERSION

	CALL	UCASE
	MOV	C,A		;ELSE PUT NAME IN BC
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A
	LXI	H,MACTBL	;SEE IF DIVERSION EXISTS
	CALL	SRCH
	JC	DI1		;IF NOT, USE .DI TO CREATE IT

	LHLD	MPTR		;ELSE SAVE CURRENT MPTR
	PUSH	H
	XCHG
	SHLD	MPTR		;MAKE MPTR POINT TO DIVERSION
DA1	CALL	MGET		;FIND END OF IT
	JNC	DA1
	LHLD	FSTAVL		;STORE FSTAVL AFTER THE
	XCHG			;'FF' BYTE
	LHLD	MPTR
	INX	H
	MOV	M,E
	INX	H
	MOV	M,D
	POP	H		;RESTORE OLD MPTR
	SHLD	MPTR
	JMP	DI1A		;USE '.DI' TO DO THE REST

*
*
*===========
* .SP N	  SPACE N LINES
*
SPN	CALL	BRCHK		;BREAK
	LDA	NOSPC		;DON'T SPACE IF NOSPACE IS SET
	ORA	A
	JNZ	NEWLIN

	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPR
	JNC	SP1		;DEFAULT TO 1
	MVI	A,01
** WARNING ** REST OF COMMAND CODE ALSO USED BY '.OS'
SP1	MOV	B,A
	ORA	A		;IF ARG = 0 RETURN
	JZ	NEWLIN
	CALL	REMLIN		;GET DISTANCE TO NEXT TRAP
	SUB	B		;PUT LEAST OF A OR B IN A
	JC	SP2
	XRA	A
SP2	ADD	B

* 'A' NOW CONTAINS EITHER N OR LINES REMAINING ON
* PAGE, WHICHEVER IS LEAST.
	MOV	C,A		;DO THAT MANY CRLF'S UNLESS
SP3	CALL	EOL		;A TRAP OCCURS IN THE PROCESS
	JC	NEWLIN		;'CRLF' WILL SET CY IF SO
	DCR	C
	JNZ	SP3
	JMP	NEWLIN


EOL	LDA	DVTFLG		;SEE WHERE CRLF IS TO GO
	ORA	A
	JNZ	EOL1

	CALL	CRLF		;GOES TO PRINTER
	RET

EOL1	CALL	MCR		;GOES TO MSPACE
	JC	SYSERR
	RET

*===========
* .PL +-N	  PREST PAGE LENGTH
*
PL	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE NBR EXPRESSIONS
	JC	PL1		;DEFAULT TO 66 IF NO ARG
	MOV	B,A
	LDA	NOOP		;GET CURRENT LENGTH
	CALL	TYPE1		;UPDATE IT AS +-N TYPE ARG
	STA	NOOP
	JMP	NEWLIN

PL1	MVI	A,'B'
	STA	NOOP
	JMP	NEWLIN

*===========
* .PG +-N	  EJECT TO NEW PAGE
*
PG	CALL	BRCHK		;BREAK
	CALL	CEXP		;EXPAND REGISTERS
	CALL	EVAL		;EVALUATE EXPR
	JC	PG1		;JMP IF NONE

	MOV	B,A
	LDA	NPG		;UPDATE NEXT PAGE NBR
	INR	A
	CALL	TYPE1
	STA	NXTPG		;PUT IN NEXT-PAGE BYTE
	JMP	PG2

PG1	LDA	NOSPC		;BE SURE NOSPACE IS CLEARED
	ORA	A
	JNZ	NEWLIN

PG2	LDA	NPG		;PUT CURRENT PAGE NBR IN C
	MOV	C,A
PG3	CALL	EOL		;LOOP UNTIL PAGE NBR CHANGES
	LDA	NPG
	CMP	C
	JZ	PG3
	JMP	NEWLIN


*========
* .PN +-N	  PREST PAGE NUMBER
*
PN	CALL	CEXP		;EXPAND REGISTERS
	CALL	EVAL		;EVALUATE EXPR
	JC	NEWLIN		;IGNOR IF NO EXPR
	MOV	B,A
	LDA	NPG		;ELSE UPDATE CURRENT PAGE NBR
	CALL	TYPE1
	STA	NPG
	JMP	NEWLIN


*==========
* .LM +-N	  PREST LEFT MARGIN
*
LM	CALL	CEXP
	CALL	EVAL
	JC	NEWLIN
	MOV	B,A
	LDA	LMARG
	CALL	TYPE1
	ORA	A
	JP	LM1		;DON'T ALLOW NEGATIVE MARGIN
	XRA	A
LM1	STA	LMARG
	JMP	NEWLIN


*==========
* REMLIN
* RETURNS THE NBR OF LINES (INCLUDING THE ONE NOW
* BEING PROCESSED IN PBUF) TO THE NEXT TRAP OR
* BOTTOM OF PAGE IN 'A' REGISTER.
* ALWAYS RETURNS VALUE GT 0.
* ONLY 'A' AND FLAGS AFFECTED.
REMLIN	PUSH	B
	PUSH	D
	PUSH	H

	MVI	C,01		;SET LINE COUNTER
	LDA	NON		;GET CURRENT LINE NBR
	INR	A		;START CHECKING WITH NEXT LINE
	MOV	B,A		;KEEP LINE NBR IN B

RML1	PUSH	B		;SAVE DATA ('TSRCH1' KILLS IT)
	LDA	NOOP		;SEE IF BOTTOM OF PAGE FOUND
	SUB	B
	JM	RSTP

	MOV	A,B		;PUT LINE NBR IN A
	CALL	TSRCH1		;SEE IF TRAP THERE
	JC	RSTP		;JUMP IF SO

	POP	B		;ELSE INCR LINE AND COUNT
	INR	B
	INR	C
	JMP	RML1		;TRY NEXT LINE

* TRAP OR BOTTOM OF PAGE NOW FOUND
RSTP	POP	B		;GET DATA
	MOV	A,C		;RETURN COUNT IN C
	POP	H
	POP	D
	POP	B
	RET


*==========
* NL N		  NEED N LINES
*
NL	CALL	CEXP		;EXPAND REGISTERS
	CALL	EVAL		;EVALUATE EXPRESSION
	JNC	NL1		;DEFAULT IS 1
	MVI	A,01
NL1	MOV	B,A
	CALL	REMLIN		;GET DISTANCE TO NEXT TRAP
	MOV	C,A
	SUB	B		;SEE IF ENOUGH LINES
	JP	NEWLIN		;RETURN IF SO
* SPACE TO NEXT TRAP OR BOTTOM
* *** WARNING *** THIS CODE ALSO USED BY '.SV'
NL2	CALL	EOL
	DCR	C
	JNZ	NL2
	JMP	NEWLIN

*==========
* .SV N	  SAVE N LINES
*
SV	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPR
	JNC	SV1		;DEFAULT TO 1 IF NONE
	MVI	A,01
SV1	MOV	C,A		;SEE IF N LINES REMAINING
	CALL	REMLIN
	SUB	C
	JP	NL2		;IF SO THEN OUTPUT N CRLF'S
	MOV	A,C		;ELSE SAVE COUNT
	STA	OSVD
	JMP	NEWLIN

*==========
* .OS		  OUTPUT SAVED CRLF'S
*
OS	LXI	H,OSVD		;GET REMEMBERED COUNT
	MOV	A,M		;THEN CLEAR BYTE
	MVI	M,00
	JMP	SP1		;USE .SP ROUTINE TO SEND CRLF'S

*==========
* .NR X +-N	  MODIFY NUMBER REGISTER
*
NR	CALL	SPANC		;FIND X
	MOV	A,M		;GET IT
	CALL	UCASE
	CPI	25H	;HE SAYS UNDERSCORE, IT'S PERCENT SIGN (%)
	JNZ	NR1	;IF PERCENT THEN REPLACE WITH AT-SIGN
	MVI	A,'@'	;40H
NR1	SUI	'@'		;VALIDATE CHARACTER
	JC	NEWLIN		;IGNOR COMMAND IF INVALID
	CPI	1BH
	JNC	NEWLIN

* NUMBER REGISTER INDEX NOW IN 'A'
	PUSH	PSW
	CALL	CEXP		;NOW EXPAND ANY NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPRESSION
	JC	NRER		;IGNOR COMMAND IF NONE
	MOV	B,A		;ELSE PUT ARG IN B
	POP	PSW		;GET BACK INDEX
	PUSH	PSW
	LXI	H,NPG		;POINT HL TO PROPER REGISTER
	MVI	D,00
	MOV	E,A
	DAD	D
	MOV	A,M		;GET THAT REGISTER'S CONTENTS
	CALL	TYPE1		;UPDATE IT, THEN REPLACE IT
	MOV	M,A
NRER	POP	PSW
	JMP	NEWLIN

*==========
* .AU +-N	  PREST AUTO-INCREMENT VALUE
*
AU	CALL	CEXP
	CALL	EVAL		;GET ARGUMENT
	JC	NEWLIN		;IGNORE IF NONE
	MOV	B,A
	LDA	AUINC		;ELSE, UPDATE AUTO-INCREMENT
	CALL	TYPE1		;VALUE
	STA	AUINC
	JMP	NEWLIN

*=========
* .IF		  CONDITIONAL
*
IF0	XRA	A		;CLEAR 'NOT' FLAG
	STA	NOTFLG
	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	SPANC		;FIND FIRST CHAR
	MOV	A,M	;CHECK IT FOR EXCLAMATION POINT
	CPI	21H		;EXCLAMATION POINT
	JNZ	IF1

* EXCLAMATION POINT FOUND - SET BIT 0 OF NOTFLG
	ANI	01
	STA	NOTFLG
	INX	H

IF1	MOV	A,M		;GET NEXT CHAR
	CALL	UCASE
	CPI	'O'		;LOOK FOR 'O' (ODD PAGE)
	JZ	IF2
	CPI	'E'		;LOOK FOR 'E' (EVEN PAGE)
	JZ	IF2

* MUST BE AN EXPRESSION
	CALL	EVAL		;EVALUATE EXPR
	JC	NEWLIN		;IGNOR IF NONE
	MVI	B,01		;SET BIT 0 OF B
* NEGATE ARGUMENT
	CMA
	ADI	01		;(TWO'S COMPLEMENT)
	JP	IF3		;IF ARG WAS 0 OR NEG, B IS SET
	DCR	B		;ELSE CLEAR IT
	JMP	IF3

* EVALUATE ODD OR EVEN PAGE
* ('O' OR 'E' IS IN A)
IF2	ANI	02		;GET ODD OR EVEN BIT
	INX	H
	RRC
	MOV	B,A
	LDA	NPG		;GET PAGE NBR
	ANI	01		;CHK FOR ODD OR EVEN
	XRA	B
	MOV	B,A
* BIT 0 OF 'B' IS 0=TRUE OR 1=FALSE (EXCLUDING NOTFLG)
IF3	LDA	NOTFLG
	XRA	B

	JNZ	NEWLIN		;IF B=1 THEN ARGUMENT IS FALSE

* FIND NEXT COMMAND ON LINE AND GO TO COMMAND PROCESSOR
	CALL	SPANC		;FIND NEXT CHAR
	MOV	A,M
	CPI	'.'		;LOOK FOR '.' OR ':' AND
	JZ	CMDPRO		;GO BACK TO CMDPRO IF FOUND
	CPI	':'
	JZ	CMDPRO
	CPI	'I'		;ELSE, SEE IF ANOTHER 'IF'
	JNZ	NEWLIN		;IF NOT, NEXT COMMAND MISSING
	MVI	A,'.'		;IF SO FAKE OUT CMDPRO BY
	DCX	H		;PUTTING '.' IN 'A' REG AND
	JMP	CMDPRO		;BACKUP POINTER

*=========
* CH -N -M
* CH XX -M
*
CH	CALL	CEXP
	CALL	SPANC		;FIND CHAR
	MOV	A,M		;GET CHAR
	CPI	'-'		;IS IT HYPHEN ?
	JZ	CH0
	CPI	'+'
	JZ	CH0		;WAS IT PLUS ?
	CALL	DIGCHK		;IS IT DIGIT ? THEN IT'S EXPR
	JC	CH1
CH0	CALL	EVAL		;SEE IF EVAL LIKES IT
	JC	NEWLIN		;JMP IF IT DOESN'T

* EXPR FOUND AND EVALUATED
	XTHL			;SET PTR TO POINT AFTER EXPR
	MOV	B,A		;SAVE ARG
	LDA	NOOP
	CALL	TYPE2		;CALCULATE ABS LINE NBR
	MOV	B,A		;FIND TRAP AT THAT LINE IN
	CALL	TSRCH1		;TRAP TABLE
	JNC	CHBAD		;JMP IF NO TRAP THERE
	JMP	CH2

* TRAP NAME GIVEN INSTEAD OF LINE NBR
CH1	MOV	A,M		;PUT NAME IN BC
	CALL	UCASE
	MOV	C,A
	INX	H
	MOV	A,M
	CALL	UCASE
	MOV	B,A
	INX	H
	PUSH	H		;SAVE NEW POINTER
	CALL	T2SRC		;SEE IF TRAP WITH THAT NAME
	JNC	CHBAD		;JMP IF NOT
* NOW HL POINTS TO 1ST BYTE OF ENTRY IN TRAP TABLE
* WHERE CHANGE IS TO BE MADE (STACK CONTAINS PTR TO
* LAST EXPR IN COMMAND)
CH2	XTHL			;EXCHANGE POINTERS
	CALL	EVAL		;EVALUATE LAST EXPR
	JC	CHBAD		;JMP IF NOT THERE
	MOV	B,A		;ELSE GET ABS LINE NBR
	LDA	NOOP
	CALL	TYPE2
	POP	H		;GET BACK PTR TO TRAP ENTRY
	MOV	M,A		;CHANGE ITS LINE NBR BYTE
	JMP	NEWLIN

CHBAD	POP	H
	JMP	NEWLIN

*=========
* .TA N	  PREST TAB STOPS
*
TA	LXI	D,TABTBL	;PUT STOPS IN TAB TABLE

TA1	CALL	EVAL		;GET A STOP AND EVALUATE IT
	JC	TA3		;END TABLE IF INVALID (OR END)
	ORA	A		;DON'T ALLOW COLUMN 0 STOP
	JZ	TA1
	DCR	A		;SET STOP 1 AHEAD OF COLUMN
	JZ	TA1
	STAX	D		;PUT STOP IN TABLE
	INX	D
	JMP	TA1
TA3	XRA	A
	STAX	D		;MARK END OF TABLE
	JMP	NEWLIN

*==========
* .TF		  DEFINE TAB FILL CHARACTER
*
TF	CALL	SPANC		;FIND CHARACTER
	MOV	A,M		;GET IT
	CPI	04		;DEFAULT TO 0A0H IF NONE
	JNZ	TF1
	MVI	A,0A0H
TF1	STA	FILCHR
	JMP	NEWLIN

*=========
* .TC		  DEFINE TAB CHARACTER
*
TC	CALL	SPANC		;ROUTINE SIMILAR TO .TF ABOVE
	MOV	A,M
	CPI	04
	JNZ	TC1
	XRA	A		;DEFAULT TO NULL TAB CHAR
TC1	STA	TABCHR
	JMP	NEWLIN



*=========
* .CE +-N	  CENTER NEXT N LINES
*
CE	CALL	BRCHK		;BREAK LINE
	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPR
	JNC	CE1		;DEFAULT TO 1
	MVI	A,01
CE1	MOV	B,A
	LDA	CEFLG
	CALL	TYPE1		;DO TYPE1 MODIFICATION OF
	STA	CEFLG		;CEFLG
	JMP	NEWLIN

*===========
* .PI		  PUT STRING IN INDENT FIELD
*
PI	CALL	BRCHK		;BREAK
	CALL	TEXP		;EXPAND REGISTERS
	CALL	IBFPNT		;RE-POINT IBFPTR TO END
	CALL	SPANC		;FIND STRING
	LXI	D,PIBUF

PI1	MOV	A,M		;GET CHAR
	STAX	D		;PUT IN BUFFER
	INX	H
	INX	D
	CPI	04		;SEE IF LAST ONE
	JNZ	PI1		;JUMP BACK IF NOT
	STA	PIFLG
	JMP	NEWLIN

*=======
* .TL		  'LEFT'CENTER'RIGHT'
*
TL	CALL	TEXP		;EXPAND NBR REGISTERS
	CALL	IBFPNT		;RE-POINT IBFPTR TO END
	CALL	SPANC		;FIND 1ST CHAR

* FILL TL BUFFER WITH BLANKS
	MVI	C,' '
	LXI	D,150
	PUSH	H
	LXI	H,TLBUF
	CALL	PREST
	POP	H

* TAKE 1ST CHAR TO BE THE DELIMITER
	MOV	A,M		;GET 1ST CHAR
	CPI	04		;BE SURE IT'S NOT END OF LINE
	JZ	NEWLIN
	MOV	B,A		;PUT IT IN B REG
	INX	H

TLLEFT	CALL	FTLEN		;USED TO FIND LEFT FIELD
	JC	NEWLIN		;OR SET CY IF NOT THERE
	LXI	D,TLBUF		;PUT 1ST FIELD IN BUF
	CALL	TLPUT		;STARTING AT FRONT

TLCENT	CALL	FTLEN		;GET LENGTH OF CENTER FIELD
	JC	NEWLIN
	LDA	TLLEN		;SUBTRACT IT FROM CURRENT
	SUB	C		;LENGTH FOR TITLES
	RAR		;DIVIDE DIVVERENCE BY 2
	ORA	A		;CLEAR ANY CY
	MOV	E,A		;INDEX TLBUF POINTER BY RESULT
	MVI	D,00
	PUSH	H
	LXI	H,TLBUF
	DAD	D
	XCHG			;AND PUT RESULTING PTR IN DE
	POP	H
	CALL	TLPUT		;INSERT CENTER FIELD AT PTR

TLRGHT	CALL	FTLEN		;FIND LENGTH OF RIGHT FIELD
	JC	NEWLIN
	MOV	A,C		;SEE IF 0 LENGTH
	ORA	A
	JZ	TLMRK
	LDA	TLLEN		;SUBTRACT FROM CURRENT TITLE
	SUB	C		;LENGTH
	MOV	E,A		;INDEX TLBUF POINTER BY RESULT
	MVI	D,00
	PUSH	H
	LXI	H,TLBUF
	DAD	D
	XCHG
	POP	H
	CALL	TLPUT		;PUT RIGHT FIELD AT DE
TLMRK	MVI	A,04		;MARK END OF STRING IN TLBUF
	STAX	D

	LXI	H,TLBUF
	JMP	TLPR		;JUMP INTO .CE ROUTINE TO
*				;PRINT TLBUF CONTENTS

* ROUTINE TO FIND LENGTH OF FIELD FROM WHERE HL POINTS
* UP TO NEXT DELIMITER (IN B REG).  LENGTH IS PUT IN
* 'C', HL IS NOT AFFECTED.
FTLEN	PUSH	H
	MVI	C,00		;CLEAR FIELD LENGTH
FTL1	MOV	A,M		;GET CHARACTER
	CPI	04		;ERROR IF 04 FOUND
	JZ	FTLER
	CMP	B		;NEXT DELIMITER FOUND ?
	JZ	FTR
	INX	H		;IF NOT BUMP POINTER,
	INR	C		;AND INCREMENT COUNT
	JMP	FTL1
FTLER	STC
FTR	POP	H
	RET

* ROUTINE TO MOVE STRING POINTED TO BY HL FROM IBUF
* TO TLBUF STARTING WHERE DE POINTS WHEN CALLED.
* TRANSFER CONTINUES UNTIL NEXT DELIMITER FOUND.
TLPUT	MOV	A,M		;GET CHAR FROM IBUF
	INX	H		;BUMP POINTER
	CMP	B		;IS IT NEXT DELIMITER ?
	RZ			;RETURN IF SO
	STAX	D		;ELSE PUT IT IN TLBUF
	INX	D
	JMP	TLPUT

*============
* .RP COMMAND
* REWINDS INPUT TEXT FILE
*
RPEAT	CALL	BRCHK		;DO BREAK
	LXI	D,TXTBUF+1
	MVI	C,SDMAF		;SET DMA ADDRESS
	CALL	BDOS
	XRA	A		;PREPARE FOR REWIND (RE-OPEN)
	STA	TXTFCB+12
	STA	TXTFCB+15
	STA	TXTFCB+32
	LXI	D,TXTFCB	;POINT TO FCB
	CALL	OPEN		;RE-OPEN IT
	CPI	0FFH
	JZ	SFERR		;JUMP IF AN ERROR
	MVI	A,7FH		;RESET BUFFER POINTER
	STA	TXTBUF
	JMP	NEWLIN

*=========
* .LT +-N	  PREST TITLE LENGTH
*
LT0	CALL	CEXP
	CALL	EVAL
	JC	NEWLIN
	MOV	B,A
	LDA	TLLEN
	CALL	TYPE1
	STA	TLLEN
	JMP	NEWLIN

*===========
* .CP
*
CAPM	MVI	A,01		;TURN ON CAPITALIZATION MODE
	STA	CPON		;BY SETTING CPON
	JMP	NEWLIN


*=========
* .NC
*
NC	XRA	A
	STA	CPON		;CLEAR CPON TO SHUT OF CAPS
	JMP	NEWLIN


*=============
* .EX		  EXIT PROCESSOR
EX	JMP	EXIT


*==========
* .TM ST	  SEND MESSAGE TO TERMINAL
*
TM	CALL	TEXP		;EXPAND ANY NBR REGS
	CALL	SPANC		;FIND FIRST CHARACTER
	MOV	A,M		;SEE IF STRING THERE
	CPI	04
	JZ	NEWLIN
	CALL	CRDATA		;IF SO THEN PRINT STRING
	CALL	TRMCRL		;THEN CRLF
	JMP	NEWLIN


*=========
* .SU COMMAND
* SUPPRESSES THE ADDITION OF A BLANK TO NEXT INPUT
* LINE WHICH IS NOT A COMMAND.
*
SU	MVI	A,01
	STA	SUPFLG		;SET SUPPRESS FLAG
	JMP	NEWLIN


*==========
* .GI ST	  GET INPUT STRING FROM TERMINAL
*
GI	CALL	TEXP		;EXPAND NBR REGISTERS
	CALL	SPANC		;FIND 1ST CHAR
	MOV	A,M		;SEE IF STRING THERE
	CPI	04
	JZ	GI1		;JMP IF NOT
	CALL	CRDATA		;ELSE PRINT IT

* SET FLAG SO NEXT INPUT LINE COMES FROM TERMINAL
GI1	CALL	TRMLIN		;GET INPUT LINE
	CALL	TRMCRL
	MVI	A,01		;SET FLAG FOR INPUT
	STA	TRMFLG
	JMP	NEWLIN


*=============
* .ST		  STOP
*
ST	CALL	BRCHK
	LXI	H,STOP
	CALL	PDATT
	CALL	TRMCRL
	CALL	TRMIN		;GET CHAR FROM TERMINAL
	CALL	UCASE
	CPI	'S'		;CHECK FOR 'S' (STOP)
	JZ	EXIT
	JMP	NEWLIN


*============
* PASS INPUT FILE TO OUTPUT
PS	CALL	GTC0		;GET INPUT CHARACTER
	PUSH	PSW
	CALL	PDOUT
	POP	PSW
	CPI	0DH		;WAS IT A CR ?
	JNZ	PS		;GO FOR NEXT IF NOT
	MVI	A,0AH		;ELSE INSERT A LINE FEED
	CALL	PDOUT
	JMP	PS

*=================
* EXIT FROM PROCESSOR
*
EXIT	CALL	BRCHK
EXIT2	LXI	SP,STACK		;RESET STACK POINTER
	LDA	LOGDR		;GET DRIVE WHICH WAS
	MOV	E,A		;LOGGED IN ON ENTRY
	MVI	C,SLECTF	;SELECT IT
	CALL	BDOS
	LDA	DISK
	ORA	A		;DISK PRINT FILE OPEN ?
	JZ	MON		;EXIT IF NOT

CLOSE	LXI	H,PRNBUF
CLOSE1	MVI	A,1AH		;EOF
	CALL	WRTCH		;WRITE AN END OF FILE
	MOV	A,M		;BUFFER FULL ?
	ORA	A
	JNZ	CLOSE1		;LOOP IF NOT
CLOSE2	LXI	D,PRNFCB
	CALL	SELECT		;SELECT DRIVE
	MVI	C,CLOSEF	;CLOSE FILE FUNCTION
	CALL	BDOS
	CPI	0FFH
	JNZ	MON		;EXIT IF NO ERROR
	LXI	H,CERR		;ELSE REPORT ERROR
	CALL	CRDATA
	JMP	MON		;EXIT THE PROCESSOR


*===============
* SET NUMBER REGISTER EXPANSION TYPE

AR	MVI	A,00
	STA	EXPTYP
	JMP	NEWLIN

CR	MVI	A,02
	STA	EXPTYP
	JMP	NEWLIN

SR	MVI	A,01
	STA	EXPTYP
	JMP	NEWLIN


*============================================
* DISK DATA FILE COMMANDS START HERE
*============================================


* RICHR
* READ AN INPUT CHARACTERR FROM EXTERNAL DATA FILE

RICHR	LDA	EOB
	ORA	A		;AT END OF BLOCK ?
	JNZ	RICHR9		;EXIT IF SO
	LDA	EOXF		;AT END OF FILE ?
	ORA	A
	JNZ	RICHR9		;EXIT IF SO
	MVI	A,01
	STA	SPECL		;SET SPECIAL INPUT FLAG
	LDA	ICHAR
	MOV	B,A		;GET ITEM CHARACTER INTO B
RICHR0	CALL	READX		;READ A CHAR FROM DISK
	CPI	1AH		;EOF ?
	JZ	RICHR7		;JUMP IF END OF FILE
	CMP	B		;IS IT AN ITEM CHAR ?
	JZ	RICHR3		;SKIP IF SO
	CPI	0DH		;A RETURN ?
	JNZ	RICHR1
	LDA	LASTX
	CMP	B		;WAS LAST AN ITEM CHAR ?
	JZ	RICHR0		;IGNORE CR IF SO
	MVI	A,0DH		;ELSE RESTORE CR
RICHR1	LXI	H,RICNT
	INR	M		;INCREMENT RI CHAR COUNT
	STA	LASTX		;SET LAST CHARACTER
	RET
RICHR3	LXI	H,LASTX		;POINT TO LAST CHAR READ
	CMP	M		;WAS IT ICHAR TOO ?
	JZ	RICHR8		;END OF BLOCK IF SO
	STA	LASTX		;ELSE SET LAST CHAR
	LDA	RICNT
	STA	NOG		;PUT RI COUNT IN #G
	XRA	A
	STA	RIFLG		;TURN OFF DATA FILE READ
	STA	RICNT		;ZERO RI COUNTER
	MVI	A,0DH		;REPLACE ICHAR WITH CR
	RET

RICHR7	MVI	A,01
	STA	EOXF		;SET END OF DATA FILE FLAG
RICHR8	MVI	A,01
	STA	EOB		;SET END OF BLOCK FLAG
RICHR9	LDA	RICNT
	STA	NOG		;PUT RI COUNT IN #G
	XRA	A
	STA	RICNT		;CLEAR RI COUNTER
	STA	RIFLG		;TURN OFF DATA FILE READ
	POP	PSW		;FIX STACK
	POP	PSW
	POP	PSW
	POP	PSW
	POP	PSW
	POP	PSW
	POP	PSW
	JMP	SETEOF		;GO TO NEW LINE


* .IC COMMAND
* SETS ITEM CHARACTER AS SPECIFIED

IC	CALL	SPANC		;PASS UP SPACES
	MOV	A,M		;GET CHARACTER
	CPI	04		;WAS CHARACTER SPECIFIED
	JNZ	IC1		;JUMP IF SO
	MVI	A,'>'		;ELSE DEFAULT TO '>'
IC1	STA	ICHAR		;SAVE IT
	JMP	NEWLIN


* .OF <FILENAME>	OPEN DATA FILE COMMAND
* OPENS DISK DATA FILE IF NONE PRESENTLY OPEN.
* IF NO FILE SPECIFIED IN COMMAND, PROMPTS TERMINAL
* FOR FILE NAME.

OF	LDA	EXTOPN
	ORA	A		;IS A FILE ALREADY OPEN ?
	JNZ	NEWLIN		;EXIT IF SO
	STA	LASTX
	STA	EOB		;INITIALIZE FLAGS
	STA	EOXF
	PUSH	H
	LXI	D,DATBUF+1
	MVI	C,SDMAF		;SET DMA BUFFER ADDRESS
	CALL	BDOS
	POP	H
	LXI	D,DATFCB	;POINT TO DATA FILE FCB
	CALL	SPANC		;SKIP SPACES
	MOV	A,M		;GET A CHARACTER
	CPI	04		;WAS FILENAME SPECIFIED ?
	JNZ	OF1		;SKIP IF SO
OF0	LXI	H,DFLNM		;POINT TO PROMPT
	CALL	GFILE		;PROMPT AND GET FILENAME
	CALL	OPEN		;OPEN THE FILE
	CPI	0FFH
	JNZ	OF3		;JUMP IF NO ERROR
	LXI	H,DFNFER
	CALL	CRDATA		;ELSE REPORT ERROR
	JMP	OF0		;GET ANOTHER NAME
OF1	CALL	GETFN		;GET FILE SPECIFICATION
	JNC	OF2		;JUMP IF NO ERROR
	LXI	H,IDFSER	;ELSE REPORT ERROR
	JMP	ERR1		;AND EXIT
OF2	CALL	OPEN		;OPEN THE FILE
	CPI	0FFH
	JNZ	OF3		;SKIP IF NO ERROR
	LXI	H,DFNFER	;ELSE REPORT ERROR
	JMP	ERR1
OF3	MVI	A,7FH
	STA	DATBUF		;INITIALIZE BUFFER
	STA	EXTOPN		;SET DATA FILE OPEN FLAG
	XRA	A
	STA	DATFCB+32	;CLEAR NR BYTE
	JMP	NEWLIN


* .CF COMMAND
* CLOSE FILE COMMAND FOR EXTERNAL DISK DATA FILES.

CF	XRA	A
	STA	EXTOPN		;CLEAR OPEN FLAG
	STA	EOXF		;CLEAR END OF FILE FLAG
	JMP	NEWLIN


* .RI COMMAND
* READ ITEM FROM DISK DATA FILE.  IGNORED IF NO
* DATA FILE IS PRESENTLY OPEN.

RI	LDA	EXTOPN
	ORA	A		;IS A FILE OPEN ?
	JZ	NEWLIN		;EXIT IF NOT
	XRA	A
	STA	NOG		;CLEAR RI COUNT IN #G
	LDA	EOXF
	ORA	A		;PAST END OF FILE ?
	JNZ	SETEOF		;EXIT IF SO
	LDA	EOB
	ORA	A		;AT END OF BLOCK ?
	JNZ	NEWLIN		;EXIT IF SO
	CALL	SPANC		;SKIP SPACES
	MOV	A,M		;GET A CHARACTER
	CALL	UCASE		;ENSURE UPPER CASE
	CPI	'S'
	JNZ	RI2		;SKIP IF NO 'S'
	STA	SUPFLG		;ELSE SET SUPPRESS FLAG
RI2	MVI	A,01
	STA	RIFLG		;SET READ ITEM FLAG
	JMP	NEWLIN


* .NI N	  NEXT ITEM COMMAND
* SKIPS NEXT N ITEM(S) IN PRESENT BLOCK OF DISK DATA
* FILE.  WILL NOT SKIP PAST END OF BLOCK.  DEFAULTS
* TO ONE ITEM SKIPPED.

NI	LDA	EXTOPN
	ORA	A		;IS A DATA FILE OPEN ?
	JZ	NEWLIN		;EXIT IF NOT
	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPRESSION
	JNC	NI1		;SKIP IF NO ERROR
	MVI	A,01		;ELSE DEFAULT TO ONE ITEM
NI1	ORA	A		;IS N EQUAL TO 0 ?
	JZ	SETEOF		;EXIT IF SO
	MOV	C,A
NI2	CALL	NEXTR		;SKIP AN ITEM
	JC	SETEOF		;EXIT IF EOB OR EOF
	DCR	C
	JNZ	NI2		;LOOP IF NOT DONE
	JMP	SETEOF


* .NB N	  NEXT BLOCK COMMAND
* MOVES N BLOCKS AHEAD IN THE DISK DATA FILE.
* N DEFAULTS TO ONE.  WILL NOT SKIP PAST END OF FILE.

NB	LDA	EXTOPN
	ORA	A		;IS DATA FILE OPEN ?
	JZ	NEWLIN		;EXIT IF NOT
	CALL	CEXP		;EXPAND NBR REGISTERS
	CALL	EVAL		;EVALUATE EXPRESSION
	JNC	NB1		;SKIP IF NO ERROR
	MVI	A,01		;ELSE DEFAULT TO ONE
NB1	ORA	A		;IS N EQUAL TO 0 ?
	JZ	SETEOF		;EXIT IF SO
	MOV	C,A
NB2	CALL	NEXTR		;SKIP AN ITEM
	JNC	NB2		;LOOP TIL END OF BLOCK
	XRA	A
	STA	EOB		;CLEAR END OF BLOCK FLAG
	LDA	EOXF
	ORA	A		;AT END OF DATA FILE ?
	JNZ	SETEOF		;EXIT IF SO
	DCR	C
	JNZ	NB2		;LOOP TIL DONE

SETEOF	LDA	EOXF		;GET END OF FILE INDICATOR
	STA	NOE		;SET NBR REG E ACCORDINGLY
	JMP	NEWLIN


* NEXTR
* SKIPS ONE ITEM IN A DISK DATA FILE.  RETURNS WITH
* CARRY SET IF END OF BLOCK OR END OF FILE HIT.

NEXTR	LDA	EOXF		;ALREADY AT END OF FILE ?
	ORA	A
	JNZ	NEXTR4		;EXIT IF SO
	LDA	EOB		;ALREADY AT END OF BLOCK ?
	ORA	A
	JNZ	NEXTR4		;EXIT IF SO
	LDA	ICHAR		;GET ITEM CHARACTER
	STA	LASTX		;SET LAST CHARACTER
	MOV	B,A
NEXTR0	CALL	READX		;READ A CHAR FROM DISK
	CPI	1AH		;AT END OF FILE ?
	JZ	NEXTR2		;SET FLAGS IF SO
	CMP	B		;END OF BLOCK ?
	JZ	NEXTR3		;SET FLAGS IF SO
	CPI	0DH		;A CARRIAGE RETURN ?
	JZ	NEXTR0		;IGNORE IF SO
NEXTR1	CALL	READX		;READ A DISK CHARACTER
	CPI	1AH		;AT END OF FILE ?
	JZ	NEXTR2		;SET FLAGS IF SO
	CMP	B		;AT END OF ITEM ?
	JNZ	NEXTR1		;LOOP IF NOT
	ORA	A		;CLEAR CARRY
	RET
NEXTR2	MVI	A,01
	STA	EOXF		;SET END OF FILE FLAG
NEXTR3	MVI	A,01
	STA	EOB		;SET END OF BLOCK FLAG
NEXTR4	STC			;SET CARRY
	RET


*===================================
* USER-DEFINABLE COMMANDS

* FIRST USER ROUTINE
* .U1
U1	NOP		;PLACE CALL TO BRCHK HERE
	NOP		;IF DESIRED
	NOP

	NOP		;PLACE CALL TO USER ROUTINE
	NOP		;HERE.  ANY REGISTER MAY BE
	NOP		;TRASHED.

	JMP	NEWLIN

* SECOND USER ROUTINE
U2	NOP		;CALL BREAK IF DESIRED
	NOP
	NOP

	NOP		;CALL USER ROUTINE
	NOP
	NOP

	JMP	NEWLIN

* THIRD USER ROUTINE
U3	NOP		;CALL BREAK IF DESIRED
	NOP
	NOP

	NOP
	NOP
	NOP

	JMP	NEWLIN


*----------------------------------------------------
*
SGNFLG	DB	00	;SIGN PRECEDING EXPR FLAG
CPON	DB	00	;NON-ZERO IF CAPS ENABLED
CPFLG	DB	00	; = 0 IF CHAR IS LOWER CASE,
*			; = 1 IF ONLY NEXT CHAR IS UPPER
*			;GT 1 IF FOLLOWING CHARS UPPER
CURENV	DB	00	;CURRENT ENVIRONMENT
EXPTYP	DB	00	;NBR REGISTER EXPANSION TYPE
SICNT	DB	00	;SINGLE-LINE INDENT COUNT
IBFPTR	DW	0000	;LOC OF NEXT CHAR IN IBUF
GIPTR	DW	GIBUF
BRFLG	DB	00	;BREAK FLAG FOR COMMAND PROC
HMRKR	DW	0000	;POINTER TO # - USED BY NUMEMP
INCFLG	DB	00	;INCREMENT FLAG FOR NUMEXP
DVTFLG	DB	00	;NONZERO IF DURING DIVERT
NOSPC	DB	00	;NONZERO IF SPACING PROHIBITED
NXTPG	DB	00	;NEXT PAGE IF NONCONSECUTIVE
LMARG	DB	00	;WIDTH OF LEFT MARGIN
SMRKR	DW	0000
DMRKR	DW	0000
EMRKR	DW	0000
MPTR	DW	0000	;PTR TO NEXT CHAR IN MSPACE
FSTAVL	DW	MSPACE	;POINTER TO 1ST AVAIL BYTE IN
*			;MACROSPACE (MSPACE)
LSTAVL	DW	0000	;PTR TO 0FFH BYTE AT END OF
*			;AVAILABLE BLOCK IN MSPACE


FILCHR	DB	00	;TAB FILL CHARACTER
TABCHR	DB	00	;TAB CHARACTER
COLNO	DB	00	;CURRENT COLUMN IN COLUMN NBR
CEFLG	DB	00	;NBR OF FOLLOWING LINES TO BE
*			;CENTERED
PIFLG	DB	00	;SET IF NEXT LINE HAS STRING
*			;IN INDENT FIELD
TRMFLG	DB	00	;SET IF INPUT COMING FROM TERM
CRTFLG	DB	00	;SET IF OUTPUT GOING TO TERM
NULLS	DB	06	;NBR OF NULLS TO SEND PRINTER
*			;AFTER CRLF
LINCNT	DB	00	;CRT LINE COUNT SINCE STOP
LINVAL	DB	00	;LINES/SCREEN (=0 IF INFINITE)
HIPG	DB	0FFH	;LAST PAGE NBR TO BE PRINTED
LOPG	DB	00	;1ST PAGE NBR TO BE PRINTED
RUNFLG	DB	00	;NONZERO AFTER 1ST BREAK
ODDLIN	DB	00	;COUNTER FOR L OR R PADDING

* PRINT STRINGS

BADEXP	DB	'?? ',4
STOP	DB	'...STOP...',4
OFLO	DB	'MACRO SPACE OVERFLOW',4
COPY1	DB	' TSC TEXT PROCESSOR',4
COPY2	DB	'Copyright (C) 1978 by TSC',4
ISTR1	DB	'Date (MM:DD:YY)? ',4
ISTR2	DB	'Route to printer or disk (P/D)? ',4
ISTR3	DB	'Lines per screen? ',4
ISTR4	DB	'Page limits? ',4
ECHOS	DB	'Echo to console (Y/N)? ',4
CHGDSK	DB	'Change disks & hit any key...',4
DFNFER	DB	'DATA '
FNFERR	DB	'FILE NOT FOUND',4
IDFSER	DB	'DATA '
IFSERR	DB	'FILE SPECIFICATION ERROR',4
DFLNM	DB	'Data '
FLNAM	DB	'File Name? ',4
FEERR	DB	'FILE EXISTS',4
NDSERR	DB	'NO DIRECTORY SPACE',4
WERR	DB	'WRITE ERROR',4
RERR	DB	'READ ERROR',4
DFERR	DB	'DISK FULL',4
CERR	DB	'CLOSE ERROR',4

BSECHO	DB	08,00,00,00,4
CNECHO	DB	07,00,00,00,4
EXT	DB	'TXT '
EXT2	DB	'PRN '
CLRFCB	DB	00,'           ',00,00,00,00

*
*
*************** COMMAND TABLE *****************************
*
CMDTBL	DB	'BR'
	DW	BR
*
	DB	'FI'
	DW	FI
*
	DB	'NF'
	DW	NF
*
	DB	'JU'
	DW	JU
*
	DB	'NJ'
	DW	NJ
*
	DB	'EV'
	DW	EV
*
	DB	'IN'
	DW	IDNT
*
	DB	'SI'
	DW	SI
*
	DB	'LN'
	DW	LN
*
	DB	'DM'
	DW	DM
*
	DB	'MS'
	DW	MS
*
	DB	'SS'
	DW	SS
*
	DB	'DI'
	DW	DIT
*
	DB	'NS'
	DW	NS
*
	DB	'RS'
	DW	RS
*
	DB	'RM'
	DW	RMOV
*
	DB	'AT'
	DW	AT
*
	DB	'AM'
	DW	AM
*
	DB	'DA'
	DW	DA
*
	DB	'SP'
	DW	SPN
*
	DB	'PL'
	DW	PL
*
	DB	'PG'
	DW	PG
*
	DB	'PN'
	DW	PN
*
	DB	'LM'
	DW	LM
*
	DB	'NL'
	DW	NL
*
	DB	'SV'
	DW	SV
*
	DB	'OS'
	DW	OS
*
	DB	'NR'
	DW	NR
*
	DB	'AU'
	DW	AU
*
	DB	'IF'
	DW	IF0
*
	DB	'CH'
	DW	CH
*
	DB	'TA'
	DW	TA
*
	DB	'TF'
	DW	TF
*
	DB	'TC'
	DW	TC
*
	DB	'CE'
	DW	CE
*
	DB	'PI'
	DW	PI
*
	DB	'TL'
	DW	TL
*
	DB	'LT'
	DW	LT0
*
	DB	'RP'
	DW	RPEAT
*
	DB	'CP'
	DW	CAPM
*
	DB	'NC'
	DW	NC
*
	DB	'EX'
	DW	EX
*
	DB	'TM'
	DW	TM
*
	DB	'GI'
	DW	GI
*
	DB	'SU'
	DW	SU
*
	DB	'ST'
	DW	ST
*
	DB	'AR'
	DW	AR
*
	DB	'CR'
	DW	CR
*
	DB	'SR'
	DW	SR
*
	DB	'U1'
	DW	U1
*
	DB	'U2'
	DW	U2
*
	DB	'U3'
	DW	U3
*
	DB	'PS'
	DW	PS
*
	DB	'IC'
	DW	IC
*
	DB	'OF'
	DW	OF
*
	DB	'CF'
	DW	CF
*
	DB	'RI'
	DW	RI
*
	DB	'NI'
	DW	NI
*
	DB	'NB'
	DW	NB
*
	DB	00		;END OF TABLE MARKER
*
	DW	0000,0000,0000,0000	;ROOM FOR EXTRA COMMANDS
	DW	0000,0000,0000,0000
*
*
************************************************************
*
* I/O ROUTINES
*
************************************************************
*
CRTIN	PUSH	H		;TERMINAL INPUT ROUTINE
	PUSH	D
	PUSH	B
	MVI	C,01		;READ CONSOLE FUNCTION
	CALL	BDOS
	PUSH	PSW
	CPI	08		;A BACKSPACE ?
	JZ	EBCKSP		;ECHO IF SO
	CPI	18H		;A CANCEL ?
	JNZ	CRTIN1		;SKIP IF NOT
	LXI	H,CNECHO	;ECHO CANCEL
	JMP	CECHO
EBCKSP	LXI	H,BSECHO	;BACKSPACE ECHO
CECHO	CALL	PDATT
CRTIN1	POP	PSW		;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET
*
CRTOUT	PUSH	H		;TERMINAL OUTPUT ROUTINE
	PUSH	D
	PUSH	B
	PUSH	PSW
	MOV	E,A		;GET CHARACTER FOR PRINTING
	MVI	C,02		;WRITE CONSOLE FUNCTION
	CALL	BDOS
	POP	PSW		;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET
*
MON	JMP	0		;EXIT ADDRESS FROM PROGRAM
*
LPINIT	RET		;PRINTER INITIALIZE ROUTINE
	DS	31
*
LPRINT	PUSH	H		;PRINTER OUTPUT ROUTINE
	PUSH	D
	PUSH	B
	PUSH	PSW
	LDA	DISK
	ORA	A		;TO DISK OR PRINTER ?
	JNZ	LPRNT1		;SKIP IF TO DISK
	POP	PSW
	PUSH	PSW
	MOV	E,A		;GET CHARACTER FOR PRINTING
	MVI	C,05		;WRITE LIST FUNCTION
	CALL	BDOS
	JMP	LPRNT2
LPRNT1	POP	PSW
	PUSH	PSW
	CALL	WRTCH		;WRITE CHAR TO DISK
LPRNT2	LDA	ECHO
	ORA	A		;IS ECHO ENABLED ?
	JZ	LPRNT3		;SKIP IF NOT
	POP	PSW
	PUSH	PSW
	MOV	E,A		;GET CHARACTER FOR PRINTING
	MVI	C,02		;WRITE CONSOLE FUNCTION
	CALL	BDOS
LPRNT3	POP	PSW		;RESTORE REGISTERS
	POP	B
	POP	D
	POP	H
	RET
*
* CHECK FOR INPUT
* THIS ROUTINE SHOULD CHECK THE INPUT TERMINAL
* FOR A CHARACTER.  IF NONE IS THERE IT RETURNS
* WITH THE CARRY BIT CLEARED.  IF THERE IS A 
* CHARACTER, IT IS PLACED IN THE A REGISTER
* WITH ITS PARITY BIT CLEARED AND THE CARRY BIT
* SET.  IN EITHER CASE, THE A REGISTER MAY BE
* ALTERED BUT NO OTHER REGISTERS MAY BE AFFECTED.
CHKIN	PUSH	H		;SAVE REGISTERS
	PUSH	D
	PUSH	B
	MVI	C,11		;CONSOLE READY FUNCTION
	CALL	BDOS
	POP	B		;RESTORE REGISTERS
	POP	D
	POP	H
	RAR			;GET STATUS INTO CARRY
	RNC			;RETURN IF NOT READY
	CALL	TRMIN		;ELSE, GET CHARACTER
	STC
	RET


*
*==========================================================
*
* ENVIRONMENT-DEPENDENT PARAMETERS
*
FILFLG	DS	1	;NONZERO IF FILL ON
JSTFLG	DS	1	;NONZERO IF JUSTIFICATION OFF
JUSTYP	DS	1	;JUSTIFICATION TYPE
EXPBUF	DS	10	;NBR REGISTERS EXPANSION BUFFER
TLLEN	DS	1	;TITLE LENGTH
LINSP	DS	1	;LINE SPACING (0=SINGLE SPACE)
AUINC	DS	1	;AUTO-INCREMENT VALUE
PBFPTR	DS	2	;LOC FOR NEXT CHAR IN PBUF
LSSPP	DS	2	;LAST GROUP OF SPACES IN PBUF
LSTCHR	DS	1	;PREVIOUS CHAR STORAGE
CHRCNT	DS	1	;NBR OF CHARS NOW IN PBUF
PADCNT	DS	1	;SPACES REQUIRED TO PAD PBUF
REMCNT	DS	1	;NBR OF UNUSED CHARS IN PBUF
SPCNT	DS	1	;NBR OF GRPS OF BLANKS IN PBUF
SPCFLG	DS	1	;SPECIAL-CHARACTER FLAG
SFLG2	DS	1	;SPECIAL CHAR FLAG FOR INPUT
TEMPIN	DS	1	;TEMPORARY INDENT AMOUNT
TEMPLN	DS	1	;TEMPORARY LINE LENGTH
OSVD	DS	1	;SAVED COUNT FROM .SV COMMAND
NOTFLG	DS	1	;FLAG USED BY '.IF'

PBUF	DS	256	;PROCESS BUFFER

****** WARNING ******
*'NOPAD' MUST BE THE LAST BYTE OF THE ENVIRONMENT
* DEPENDENT BLOCK.  ANY STORAGE AFTER 'NOPAD' WILL
* NOT BE SWAPPED DURING ENVIRONMENT SWITCH.
NOPAD	DS	1	;PREVENT PADDING IN FLUSH FLAG
*
*====================================================
*
* STORAGE AREA FOR INACTIVE-ENVIRONMENT PARAMETERS
EVSTOR	DS	290
*
*
* STORAGE FOR ENVIRONMENT-DEPENDENT NUMBER REGISTERS
NOI2	DS	1		;INDENT
NOL2	DS	1		;LINE LENGTH
*
*====================================================
* ****** NUMBER REGISTERS ******
*
NPG	DS	1		;PAGE NUMBER
NOA	DS	1
NOB	DS	1
NOC	DS	1		;CURRENT COLUMN COUNT
NOD	DS	1		;DAY OF THE MONTH
NOE	DS	1
NOF	DS	1
NOG	DS	1		;GET INPUT CHARACTER COUNT
NOH	DS	1
NOI	DS	1		;CURRENT INDENT
NOJ	DS	1
NOK	DS	1
NOL	DS	1		;CURRENT LINE LENGTH
NOM	DS	1		;MONTH
NON	DS	1
NOO	DS	1		;LEFT MARGIN
NOOP	DS	1		;PAGE LENGTH
NOQ	DS	1
NOR	DS	1
NOS	DS	1
NOOT	DS	1
NOU	DS	1
NOV	DS	1		;LAST DIVERSION LINE COUNT
NOW	DS	1
NOX	DS	1
NOY	DS	1		;YEAR
NOZ	DS	1
*
*
*====================================================


* TEMPORARY STORAGE SPACE

MACTBL	DS	129		;MACRO NAME TABLE
*				;FOR 32 NAMES
IBUF	DS	256		;INPUT BUFFER
GIBUF	DS	128		;GI INPUT BUFFER
TTBL	DS	97		;TRAP TABLE FOR 32 TRAPS
PIBUF	DS	80		;INDENT STRING BUFFER
TLBUF	DS	150		;BUFFER FOR 3-PART TITLES
TABTBL	DS	21		;TAB STOP TABLE (20 STOPS)

CMDPT	DS	2
FCBADR	DS	2
LOGDR	DS	1
DFEXT	DS	1
DISK	DS	1
ECHO	DS	1
LASTX	DS	1
EOXF	DS	1
EOB	DS	1
EXTOPN	DS	1
RIFLG	DS	1
RICNT	DS	1
SPECL	DS	1
SUPFLG	DS	1
SUPFL2	DS	1
ICHAR	DS	1
TEMPSI	DS	1

* TEMPORARY DISK STORAGE

TXTFCB	DS	34
DATFCB	DS	34
PRNFCB	DS	34
TXTBUF	DS	129
DATBUF	DS	129
PRNBUF	DS	129


******* PROGRAM STACK *****

	DS	211		;RESERVED PROGRAM STACK AREA
STACK	DS	1


*************************************************************
*
* SPACE FOR MACROS
*
MSPACE	EQU	$		;MACRO SPACE STARTS HERE

*------------------------------------------------------------



	END
