
    MEMTEST2 -- 04:24.PM Thursday 14 April 83

    maclib sal80
    INITIALIZE?
    maclib frzscrn
    maclib get8hex
    maclib blockmov
;   maclib compare
;   maclib cmpstrs
;   maclib divide
;   maclib multiply
;   maclib findstr
;   maclib response
;   maclib parms
;   maclib pic-optn
;   maclib <your macro-files>
;   Z80?
    RMAC?

;;;;;;;;    most EQUs are in the header files

    maclib standard
    maclib memtest

    if ?RMAC ! CSEG ! endif

;;;;;;;;    set up ORG

    if ?RMAC
      org 0
    else
      org 100h
    endif

code:

    GOTO? start;    This the MAIN module

;;;;;;;;    local (non-LIB) macro definitions and subroutines go here


***************************************************
*
*    Compare this with the MACRO of the same
*    name in MT1.
*
***************************************************

define$flag:
;
;   Parameter on stack (under return addr)
;   is the ADDRESS of FLAG;
;
;        FLAG <-- ([HL] < [DE])
;
;   Clobbers PSW, DE and HL.
;
    IF? HL,LT?,DE
      mvi A,TRUE
    ELSE?
      mvi A,FALSE
    ENDELSE?
    ; get parm from stack
    pop B ! pop H ! push B
    mov M,A
    RETURN?


check$space:
;
;   checks to see whether there is space for the
;   save-regions associated with PRG and CP/M.
;   defines flags ?PRG$SPACE and/or ?CPM$SPACE.
;
;   Clobbers double registers.
;
    ; ?prg$space <-- (prg$top  < lo$sav$base)
    LOAD? HL,@prg$top
    LOAD? DE,@lo$sav$base
    ; [?prg$space] <-- ([HL] < [DE])
    lxi B,?prg$space ! push B;    {pass parameter}
    CALL? define$flag
    ; ?cpm$space <-- (hi$sav$top < CPM$BASE)
    LOAD? HL,@hi$sav$top
    lxi D,CPM$BASE
    ; [?cpm$space] <-- ([HL] < [DE])
    lxi B,?cpm$space ! push B;    {pass parameter}
    CALL? define$flag
    RETURN?


test$hi$memory:
;
;   {If address-extension is installed, set it up here.}
;
;   Gets begin$addr = [HL], end$addr = [DE]
;
;   Clobbers double registers
;
    SAVE$DUBLS?
    IF? ?timing;    initialize the restart location
      CALL? init$rst
    ENDIF?
    ; save the QUICK and PATTERN masks
    LOAD? A,?bit$shift
    SAVE? PSW
    LOAD? A,?pass$counter
    SAVE? PSW
    CALL? write$memory
    CALL? conditional$delay
    ; restore the QUICK and PATTERN masks
    RESTORE? PSW
    STORE? A,?pass$counter
    RESTORE? PSW
    STORE? A,?bit$shift
    RESTORE$DUBLS?
    CALL? read$memory; low,high
    RETURN?


init$rst:
;
;   put a POP PSW,JMP REPORT$ERROR at location @TSTRST 
;
;   Preserves double registers
;
    SAVE$DUBLS?
    mvi A,POPSW;        {don't want to return to there}
    STORE? A,@TSTRST
    mvi A,JUMP
    STORE? A,@TSTRST+1
    lxi H,report$error
    STORE? HL,@TSTRST+2
    RESTORE$DUBLS?
    RETURN?


write$memory:
;
;   {If address-extension is installed, set it up here.}
;   Gets LOW = [HL], HIGH = [DE]
;
;   Clobbers double registers
;
    IF? ?timing;   fill it with TSTRSTs
      ; adjust @lowr$bndry if necessary
      SAVE? DE,HL
      LOAD? HL,@lowr$bndry
      lxi D,TOP$OF$RST$AREA
      IF? HL,LT?,DE
        xchg
        STORE? HL,@lowr$bndry
        NEWLINE?
        STRING$TO$CONS? 'Dynamic Timing test resets bottom-of-memory to '
        mvi A,TOP$OF$RST$AREA
        BYT$HEX$TO$CONS?
        NEWLINE?
      ENDIF?      
      RESTORE? HL,DE
      REPEAT?
        mvi M,TSTRST
        inx H
      ENDREPEAT? HL,GE?,DE,inline
    ELSE?;         fill it with patterns
      ;;
      ;; original version was:
      ;;
      ;; REPEAT?
      ;;  [M] <-- pattern(HL,MASK)
      ;;  CALL? A$gets$pattern
      ;;  mov M,A
      ;;  inx H
      ;; ENDREPEAT? HL,GE?,DE,inline
      ;;
      ;; This was replaced by the following for
      ;; faster execution:    
      ;;
      IF? ?pattern
        REPEAT?
          LOAD? A,?pass$counter;
          xra H ! xra L
           mov M,A
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ELSE?
        REPEAT?
          LOAD? A,?bit$shift
          xra H ! xra L
          mov M,A
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ENDELSE?
    ENDELSE?
    RETURN?


;;A$gets$pattern:
;;
;;  PATTERN has 3 components: MASK, [H] and [L];
;;  XORing the high and low bytes of the address
;;  guarantees that no two pages will have the same
;;  pattern occurring at the same intra-page location.
;;  This detects address faults.
;;
;;  Preserves double registers
;;
;;  CALL? mask
;;   xra H ! xra L
;;   RETURN?


;;mask:
;;
;;  MASK is either the value of a 1-byte pass-counter
;;  (taken over a range of 256 passes)
;;  or takes on each of the following values:
;;  1,2,4,8,10,20,40,80 (all values in hex).
;;  (Either one tests for stuck bits and data line faults.)
;;  
;;  Preserves double registers
;;
;;  IF? ?pattern
;;    LOAD? A,?pass$counter
;;  ELSE?
;;    LOAD? A,?bit$shift
;;  ENDELSE?
;;  RETURN?


adjust$mask:
;
;   'MASK' is used ambiguously to refer EITHER to the
;   byte which is to be XORed with the hi and lo bytes
;   of the address OR to the result of that operation.
;   Here the former usage obtains, and the adjustment
;   consists of generating the next of 256 (in the case
;   of the pattern-sensitive option) or the next of 8
;   (quick option) such component bytes.  In either case,
;   the last byte of the sequence must set the CARRY FLAG
;   in order to exit the ENDREPEAT? at the bottom of BODY.
;
;   Preserves double registers
;
    IF? ?timing
      stc;    {to exit the ENDREPEAT? CRYSET? at end of body}
    ENDIF?
    IFRETURN? CRYSET?
    IF? ?pattern
      LOAD? A,?pass$counter
      inr A
      STORE? A,?pass$counter
      IF? ,ZERSET?
        stc
      ENDIF?
    ELSE?
      LOAD? A,?bit$shift
      ral
      STORE? A,?bit$shift
    ENDELSE?
    RETURN?


conditional$delay:
;
;   ?DELAY may contain one of  0,1,2,3,4
;   If not zero then call WAIT (2**(?delay-1))
;   times.  The length of the delay may be adjusted
;   by assigning different values to the constant
;   WAIT$FACTOR defined in MEMTEST.LIB
;
;   Clobbers everything.
;
    IF? ?delay
    ; Set ?dcounter to (2**(?delay - 1))
      mov B,A;     {[A] = ?delay, from the IF?-test}
      mvi A,1
      STORE? A,?dcounter
      dcr B
      WHILE? B,NE?,0
        LOAD? A,?dcounter
        rlc
        STORE? A,?dcounter
        dcr B
      ENDWHILE?
    ; execute the delay
      DO? ?dcounter
        SAVE? BC
        CALL? wait
        RESTORE? BC
      ENDDO?
    ENDIF?
    RETURN?


wait:
;
;   Clobbers PSW, BC
;
    lxi B,WAIT$FACTOR
    DO? BC
      xra A
      DO? A;    {256 times}
        xthl
        xthl
      ENDDO?
    ENDDO?
    RETURN?


compare$mask    MACRO
;
;   This is the only MACRO in this module.  It
;   is used instead of a subroutine because it
;   occurs within a deeply nested loop, and the
;   CALL/RET overhead becomes noticeable.  It
;   is defined PRIOR to its invocation in
;   READ$MEMORY because invocation of an undefined
;   macro will hang MAC/RMAC in an endless loop.
;
;   Clobbers PSW
;
     cmp M
    IF? ,ZERCLR?
      CALL? sav$err$regs
      CALL? report$error
    ENDIF?
    ENDM


sav$err$regs:
;
;   This might have been dispensed with,
;   but would have necessitated some rather
;   intricate register-save juggelry in
;   REPORT$ERROR.
;
;   Clobbers PSW
;
    STORE? A,?mask
    mov A,M
    STORE? A,?byte
    STORE? HL,@err$addr
    RETURN?


report$error:
;
;   Preserves double registers
;
    SAVE$DUBLS?
    IF? ?timing;    {has to go somewhere, doesn't fit ...
      mvi A,RTRN;    ... in the TSTRST slot, so ...
      CALL? sav$err$regs;    ... put it here}
    ENDIF?
    IF? ?need$restore$cpm;    {toggle set by SAVE$CPM}
      CALL? restore$cpm;    {which will turn off ?NEED$RESTORE$CPM}
      mvi A,TRUE
      STORE? A,?did$restore$cpm;    {so must RE-save$cpm ...}
    ENDIF?
    ; put out error address, correct pattern, contents of byte
    STRING$TO$CONS? 'Memory error at  '
    LOAD? HL,@err$addr
    WRD$HEX$TO$CONS?;            the address
    STRING$TO$CONS? '  '
    LOAD? A,?mask;                the pattern
    BYT$HEX$TO$CONS?
    STRING$TO$CONS? '  '
    LOAD? A,?byte;                the byte
    BYT$HEX$TO$CONS?
    NEWLINE?
    FREEZE$SCREEN?
    IF? ?errors$to$disk
      CALL write$to$bufr
    ENDIF?
    IF? ?did$restore$cpm;    { ... here}
      CALL? save$cpm;    {which also restores area under test}
      mvi A,FALSE
      STORE? A,?did$restore$cpm
    ENDIF?
    RESTORE$DUBLS?
    RETURN?


read$memory:
;
;   {If address-extension is installed, set it up here.}
;   Gets begin$addr = [HL], end$addr = [DE]
;
;   Preserves double registers
;
    IF? ?timing
      REPEAT?
        ;;
        ;; A "CALL? test$M1" was replaced by
        ;; the inline code to improve performance
        ;;
        SAVE? DE,HL
        ;
        ; Insert a RET instruction at M,
        ; push a return address on stack
        ; and branch to M.
        ;
        mvi M,RTRN
        call $+3
        xthl
        lxi D,(continue-$+1)
        dad D
        xthl
        pchl
continue:
        RESTORE? HL,DE
        mvi M,TSTRST
        inx H
      ENDREPEAT? HL,GE?,DE,inline
    ELSE?;         fill it with patterns
      ;;
      ;; original version was:
      ;;
      ;; REPEAT?
      ;;   CALL? A$gets$pattern
      ;;   cmp M
      ;;   IFCALL? ZERCLR?,report$error
      ;;   inx H
      ;; ENDREPEAT? HL,GE?,DE,inline
      ;;
      ;; This was replaced the following, for
      ;; faster execution:    
      ;;
      IF? ?pattern
        REPEAT?
          LOAD? A,?pass$counter;
          xra H ! xra L
          compare$mask
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ELSE?
        REPEAT?
          LOAD? A,?bit$shift
          xra H ! xra L
          compare$mask
          inx H
        ENDREPEAT? HL,GE?,DE,inline
      ENDELSE?
    ENDELSE?
    RETURN?


;;test$M1:
;;
;;  write [A] (= RET instruction) into M and CALL it
;;
;;  Preserves double registers
;;
;;  SAVE? DE,HL   
;;  mov M,A
;;  call $+3
;;  xthl
;;  lxi D,(continue-$)
;;  dad D
;;  xthl
;;  pchl
;;continue:
;;  RESTORE? HL,DE
;;  RETURN?


write$to$bufr:
;
;   Write ERR$ADDR, MASK and BYTE to DMA$BUFR.
;   First convert to hex, then separate with
;   ' - ' (space$dash$space), end with CRLF.
;   That makes a record of 10h bytes and the buffer
;   holds  10h  such records.  When buffer is full,
;   write it to file MEMTEST.ERR, reset pointer and
;   reinitialize dma$bufr to EOF.
;
;   Preserves double registers
;
    SAVE$DUBLS?
    ; stuff into DMA buffer
    LOAD? HL,@dma$ptr
    LOAD? DE,@err$addr
    mov A,D
    CALL? write$hex$to$MM;    1,2
    mov A,E
    CALL? write$hex$to$MM;    3,4
    CALL? space$dash$space;    5,6,7    
    LOAD? A,?mask
    CALL? write$hex$to$MM;    8,9
    CALL? space$dash$space;    A,B,C
    LOAD? A,?byte
    CALL? write$hex$to$MM;    D,E
    mvi M,cr;                F
    inx H
    mvi M,lf;                10h
    inx H
    STORE? HL,@dma$ptr
    ; compare [HL] with (actual value of) end$dma$bufr
    lxi D,end$dma$bufr
    IF? HL,GE?,DE;        write dma$bufr to disk
      lxi D,dma$bufr
      lxi H,fcb$record
      CALL? write$to$disk
      lxi D,dma$bufr
      lxi H,fcb$record+80h
      CALL? write$to$disk
      ; reset @dma$ptr
      lxi H,dma$bufr
      STORE? HL,@dma$ptr
      ; reinitialize buffer
      CALL? init$bufr$to$EOFs
    ENDIF?
    RESTORE$DUBLS?
    RETURN?


write$hex$to$MM:
;
;   [M] <-- (hex(hi$byte(A));  bump HL
;   [M] <-- (hex(lo$byte(A));  bump HL
;
;   Clobbers PSW, HL and M
;
    push PSW
    rlc ! rlc ! rlc ! rlc
    BIN$TO$HEX?
    mov M,A
    inx H
    pop PSW
    BIN$TO$HEX?
    mov M,A
    inx H
    RETURN?


space$dash$space:
;
;   Clobbers HL and M
;
    mvi M,' '
    inx H
    mvi M,'-'
    inx H
    mvi M,' '
    inx H
    RETURN?


write$to$disk:
;
;   Write contents of dma$bufr to disk.
;
;   Gets addr of DMA$BUFR in DE and
;        addr of FCB$RECORD in HL
;
;   Clobbers PSW
;
    SAVE$DUBLS?
    push H
    mvi C,SET$DMA$ADDR
    CALL? bdos
    mvi C,WRITE$SEQNTIAL
    pop D
    CALL? bdos
    mvi C,SET$DMA$ADDR
    RESTORE$DUBLS?
    RETURN?


init$bufr$to$EOFs:
;
;   Clobbers HL
;
    lxi H,dma$bufr
    DO? %DMA$SIZE
      mvi M,EOF
      inx H
    ENDDO?
    RETURN?


save$lo$stkptr:
;
;   Clobbers HL
;
    lxi H,2
    dad SP
    STORE? HL,@stkptr$low
    RETURN?


move$prg:
;
;   MOVE$PRG/RESTORE$PRG are swapping routines:
;   The AREA that PRG lives in must be saved and
;   restored even when PRG is "out".  That's because,
;   when PRG is "out", the AREA is under test(and the
;   image created by the WRITE$MEMORY phase must
;   be preserved in between error messages.  There
;   is a HI$PRG region which holds the image of
;   PRG and an AREA$SAVE region which holds the
;   image of the AREA when PRG is restored to write
;   out an error message.  When PRG is restored,
;   the area under test is first saved, then the
;   message is reported and then the area is restored.
;   Unfortunately for the clarity of this exposition,
;   the saving and restoration of the area is less
;   symmetric than in the SAVE$CPM/RESTORE$CPM case,
;   and the RESTORE$PRG$AREA code appears in two
;   places in the MT3 module.
;
;   Such ugliness often breeds bugs, but I don't 
;   see a cleaner way to do it.
;
;
;   [HL] <-- TBASE
;   [DE] <-- hi$base;    {= (TBASE + (test$lo$memory - end$data))}
;   [BC] <-- prg$size
;
;   Clobbers all registers
;
    LOAD? HL,@hi$base
    xchg
    lxi H,TBASE
    LOAD? BC,@prg$size
    BLOCK$MOVE?
    RETURN?


move$stack$up:
;
;   Clobbers HL {and SP}
;
    LOAD? HL,@stkptr$high
    RETURN?;    {and SPHL}


move$stack$down:
;
;   Clobbers HL {and SP}
;
    LOAD? HL,@stkptr$low
    RETURN?;    {and SPHL}


save$cpm:
;
;   SAVE$CPM/RESTORE$CPM are swapping routines:
;   The AREA that CP/M lives in must be saved and
;   restored even when CP/M is "out".  That's because,
;   when CP/M is out, the AREA is under test and the
;   image created by the LO$WRITE$MEMORY phase must
;   be preserved in between error messages.  There
;   is a CPM$SAVE region which holds the image of
;   CP/M and an AREA$SAVE region which holds the
;   image of the AREA when CP/M is restored to write
;   out an error message.  When CP/M is saved, the
;   AREA is restored, and vice versa.
;
;   Clobbers double registers
;
;   save CP/M
    lxi H,CPM$BASE
    LOAD? DE,@prg$top
    LOAD? BC,@cpm$size
    BLOCK$MOVE?
    mvi A,TRUE
    STORE? A,?need$restore$cpm
;   restore AREA
    LOAD? HL,@top$cpm$save
    inx H
    lxi D,CPM$BASE
    LOAD? BC,@cpm$size
    BLOCK$MOVE?
    RETURN?


restore$cpm:
;
;   Clobbers double registers
;
;   save AREA
    LOAD? DE,@top$cpm$save
    inx D
    lxi H,CPM$BASE
    LOAD? BC,@cpm$size
    BLOCK$MOVE?
;   restore CP/M
    LOAD? HL,@prg$top
    lxi D,CPM$BASE
    LOAD? BC,@cpm$size
    BLOCK$MOVE?
    mvi A,FALSE
    STORE? A,?need$restore$cpm
    RETURN?


space$error:
;
;   Clobbers everything
;
    STRING$TO$CONS?  space$err$msg,$
    pop PSW;    {balance stack}
    GOTO? err2;      repeat prompt
    RETURN?


setup$diskfile:
;
;   Set up file named by FCB$RECORD,
;   where gets [DE] = addr(FCB$RECORD).
;
;   Clobbers everything.
;
    ; delete pre-existing file if such there be
    mvi C,DELETE
    push D
    CALL? bdos
    ; create and open the error message file
    mvi C,MAKE$FILE
    pop D
    CALL? bdos
    cpi 0FFh;    BDOS error code
    IF? ,ZERSET?
      NEWLINE?
      STRING$TO$CONS? 'No disk space for MEMTEST.ERR'
      NEWLINE?
      pop PSW;    {balance stack}
      GOTO? err1
    ENDIF?
    RETURN?


*************************************************
*
*   End of locally declared macros and subroutines
*
*************************************************

main:
start:
;;;;;;;;    establish the ground-rules, set stackpointer

    MAIN?
    lxi H,0
    dad SP
    STORE? HL,@prior$stkptr
    lxi SP,stkptr
                   ;
                   ;   MEMTST signs on with title and copyright notice
                   ;
    CALL? user$intrface
                   ;
                   ;   Gets options, asks if OK to proceed,
                   ;   if affirmative, then execute:
                   ;
    IF? ?errors$to$disk
      lxi D,fcb$record
      CALL? setup$diskfile
    ENDIF?
    ;
    ;    Set up memory-map parameters
    ;
    CALL? initialize$memory$map$parms;    lives down in DMA$BUFR 

    IF? ?errors$to$disk;    Initialize dma$bufr to EOFs
      CALL? init$bufr$to$EOFs
    ENDIF?

body:
;
;   The body of the program is a four-way CASE statement
;   embedded in several layers of loops.  It probably
;   could be simplified to a two-way CASE (IF/ELSE)
;   without too much difficulty.
;
  REPEAT?;        {implements the INFINITE loop option}
    DO? @iterations;  {ditto the FINITE loop option}
      SAVE? BC
      REPEAT?;        {ditto the QUICK and PATTERN options}
        ; 'IF NOT (?sav$cpm or ?mov$prg)' is equivalent to
        ; 'IF (NOT ?sav$cpm AND NOT ?mov$prg)', which
        ; is implemented as
        LOAD? A,?mov$prg
        mov B,A;    {save it for later}
        LOAD? A,?sav$cpm
        IF? A,EQ?,0;    {not ?SAVCPM ...
          mov A,B;        {[A] <-- [?mov$prg]}
          IF? A,EQ?,0;  ... and not ?MOVPRG}    CASE 0
          ;
          ; test in place
          ;
            LOAD? HL,@lowr$bndry
            LOAD? DE,@uppr$bndry
            CALL? test$hi$memory
          ELSE?;        {?MOVPRG is high}       CASE 1
          ;
          ; check that there is space just below CP/M
          ; from which a copy of MEMTEST can be 
          ; executed to test low memory; if so, set
          ; ?prg$space, test high memory, move MEMTEST to
          ; its high location and test low memory.
          ; If not enough space, tell us about it.
          ;
            CALL? check$space
            IF? ?prg$space
            ; if (lo$sav$base < uppr$bndry) 
            ;    CALL? test$hi$memory(lo$sav$base,uppr$bndry)
            ;    [uppr$bndry] <-- ([@lo$sav$base] - 1)
            ; endif
              LOAD? HL,@lo$sav$base
              LOAD? DE,@uppr$bndry
              IF? HL,LT?,DE
                CALL? test$hi$memory
                LOAD? HL,@lo$sav$base
                dcx H
                STORE? HL,@uppr$bndry
              ENDIF?
            ; move up to high memory and test low memory from there
              CALL? save$lo$stkptr
              CALL? move$prg
              CALL? move$stack$up
              sphl;        {can't do that until after the return}
              LOAD? HL,@lowr$bndry
              LOAD? DE,@uppr$bndry
              CALL? test$lo$memory
            ; {restore$prg    gets CALL?ed by TEST$LO$MEMORY}
              CALL? move$stack$down
              sphl;        {can't do that until after the return}
            ELSE?
              CALL? space$error
            ENDELSE?
          ENDELSE?
        ELSE?;          {?SAVCPM is high}       CASE 2
          IF? B,EQ?,0;  {and not ?MOVPRG}
          ;
          ; check that there is space just above 
          ; MEMTEST from which a copy of CP/M can be
          ; saved/restored to high memory; if so, set
          ; ?cpm$space, test low memory, move CP/M to
          ; its low save-space and test high memory.
          ; Restore CP/M as necessary to output error
          ; messages.  If not enough space, tell us.
          ;
            CALL? check$space
            IF? ?cpm$space
            ; if (lowr$bndry < hi$sav$top)
            ;    CALL test$hi$memory(lowr$bndry,hi$sav$top) 
            ;    [lowr$bndry] <-- ([hi$sav$top] + 1)
            ; endif
              LOAD? HL,@lowr$bndry
              LOAD? DE,@hi$sav$top
              IF? HL,LT?,DE
                CALL? test$hi$memory
                LOAD? HL,@hi$sav$top
                inx H
                STORE? HL,@lowr$bndry
              ENDIF?
            ; pull down CP/M and test high memory
              CALL? save$cpm
              LOAD? HL,@lowr$bndry
              LOAD? DE,@uppr$bndry
              CALL? test$hi$memory
              CALL? restore$cpm
            ELSE?
              CALL? space$error
            ENDELSE?
          ELSE?;          {BOTH are high}          CASE 3
          ;
          ; check that there is space as in each of the 
          ; two preceding cases, if so, set BOTH 
          ; ?prg$space and ?cpm$space, check that HI$SAV$TOP
          ; lies below LO$SAV$BASE and move CP/M to its low 
          ; save-space and test high memory; then restore
          ; CP/M and move MEMTEST to its high location 
          ; and test low memory.  If not enough space, tell us.
          ;
            CALL? check$space
            IF? ?prg$space;        {and}
            IF? ?cpm$space;     {and}
            LOAD? HL,@hi$sav$top
            LOAD? DE,@lo$sav$base
            IF? HL,LT?,DE
            ; move up to high memory and test low memory from there
              CALL? save$lo$stkptr
              CALL? move$prg
              CALL? move$stack$up
              sphl;        {can't do that until after the return}
              LOAD? HL,@lowr$bndry
              LOAD? DE,@lo$sav$$base
              dcx D
              CALL? test$lo$memory
            ; {restore$prg    gets CALL?ed by TEST$LO$MEMORY}
              CALL? move$stack$down
              sphl;        {can't do that until after the return}
            ; pull down CP/M and test high memory
              CALL? save$cpm
              LOAD? HL,@lo$sav$base
              LOAD? DE,@uppr$bndry
              CALL? test$hi$memory
              CALL? restore$cpm
            ELSE?
              CALL? space$error
            ENDELSE?
            ELSE?
              CALL? space$error
            ENDELSE?
            ELSE?
              CALL? space$error
            ENDELSE?
          ENDELSE?
        ENDELSE?
        CALL? adjust$mask
      ENDREPEAT? ,CRYSET?
      ora A;        clear carry
      RESTORE? BC
    ENDDO?                  
  ENDREPEAT? ?terminates
                   ;
                   ;   Exit gracefully to CP/M.
                   ;
exit:
;
;   If open, close the error-message file
;   and in any case jump to [@coldboot].
;
    IF? ?errors$to$disk; close MEMTEST.ERR
      CALL? write$to$disk
      mvi C,CLOSE$FILE
      lxi D,fcb$record
      CALL? bdos
    ENDIF?
    LOAD? HL,@coldboot
    pchl

end$code:

;;;;;;;    data segment

data:

dma$bufr:;        this overlays the initialization code
initialize$memory$map$parms:
;
;   First, the "normal" program initialization code:
;
;   Provide for reboot when tests completed
;
    LOAD? HL,REBOOT+1
    dcx H ! dcx H ! dcx H;    {get address of COLDBOOT}
    STORE? HL,@coldboot;  {where it won't get clobbered}
;
;   Define and initialize some parameters
;
;   Toggle ?SAV$CPM tells us whether to save CP/M
;   ?sav$cpm <-- (uppr$bndry > CPM$BASE-1)
;
    LOAD? DE,@uppr$bndry
    lxi H,CPM$BASE-1
    lxi B,?sav$cpm ! push B
    CALL? define$flag


**********************************************************
*
*    MAINTAINER BEWARE:  HI$CODE$SIZE contains garbage until
*    BUFR$COMFILE$CODE$SEGMENT (below) has executed.  This
*    happens when the comfile is put together by executing
*    (just once) the file MT1.COM as generated by LINK.  That
*    first execution initializes HI$CODE$SIZE and @PRG$TOP,
*    as well as moving the MT3 code segment down as outlined
*    in the memory-map documentation below.  The PRG$TOP
*    initializing code that you see here is redundant
*    since the value was assigned on that first pass.
*
**********************************************************
;;
;;  PRG$TOP is the top of the program when it is sitting
;;  in low memory.  It may be calculated as
;;  @prg$top <-- (end$intrface + main$size + hi$code$size)
;;
;   lxi H,end$intrface
;   LOAD? BC,@main$size
;   dad B
;   LOAD? BC,@hi$code$size
;   dad B
;   STORE? HL,@prg$top
;
;   ?MOV$PRG tells us whether to use the high-memory code
;   ?mov$prg <-- (lowr$bndry < prg$top+1)
;
    LOAD? HL,@lowr$bndry
    LOAD? DE,@prg$top
    inx H
    lxi B,?mov$prg ! push B
    CALL? define$flag
;
;   @PRG$SIZE is the offset from TBASE to PRG$TOP
;   @prg$size <-- (prg$top - TBASE)
;
    LOAD? HL,@prg$top
    lxi B,TBASE
    SUBTRACT? BC
    STORE? HL,@prg$size
;
;   @CPM$SIZE is the offset from CPM$BASE to TOP$OF$RAM
;   @cpm$size <-- (TOP$OF$RAM - CPM$BASE)
;
    lxi H,TOP$OF$RAM
    lxi B,CPM$BASE
    SUBTRACT? BC
    STORE? HL,@cpm$size
;
;   @TOP$CPM$SAVE is the top of CP/M when it has been
;   saved to low memory.  It may be calculated as
;   @top$cpm$save <-- (prg$top + cpm$size)
;
    LOAD? HL,@prg$top
    LOAD? DE,@cpm$size
    dad D
    STORE? HL,@top$cpm$save
;
;   HI$BASE is the bottom of the program when it has
;   been saved to high memory.  It may be calculated as
;   @hi$base <-- (TBASE + (test$lo$memory - end$data))
;
    lxi H,TBASE
    xchg
    lxi H,test$lo$memory
    lxi B,end$data
    SUBTRACT? BC
    dad D
    STORE? HL,@hi$base
;
;   When an AREA normally occupied by either PRG or CP/M is
;   under test, provision must be made for saving the image
;   of the AREA while error messages are being outputted
;   (since both PRG and CP/M will have to be restored in
;   order to handle the I/O).  The save region for the
;   CP/M area lies just on top of TOP$CPM$SAVE and extends
;   for CPM$SIZE many bytes.  Define the top of this region as
;   hi$sav$top <-- (top$cpm$save + cpm$size)
;
    LOAD? HL,@top$cpm$save
    LOAD? BC,@cpm$size
    dad B
    STORE? HL,@hisav$top
;
;   The save region for the PRG area lies just below HI$BASE
;   and extends (downward) for PRG$TOP many bytes.  Define the
;   base of this area as @lo$sav$base <-- (hi$base - prg$top)
;
    LOAD? HL,@hi$base
    LOAD? BC,@prg$top
    SUBTRACT? BC
    STORE? HL,@lo$sav$base
;
;   **********END OF INITIALIZERS**************
;
;   Set up RETURN to BODY
;
dirty$code:
    nop;    {room for RETURN to BODY}
;
;   Insert RTRN to BODY in the NOP {pornographic code}
;
    mvi A,RTRN
    STORE? A,dirty$code
;
;   This ensures that the code below gets executed only once
;   when the COMfile is first put together.  This jiggery-pokery
;   should not be necessary, but LINK has very inflexible notions
;   about what it should and should not be called upon to do.
;
;
bufr$comfile$code$segment:
;
;   *************THIS HELPS TO BUILD THE COM FILE**************
;
;   Execute self-modifying code to set up the final COM file;
;   this pulls down the code block of the high-memory module,
;   places it on top of the low-memory modules (effectively
;   overlaying the data-segment) and writes to console the
;   size of the total package to be SAVEd as a COM file.
;
;   The transformation of the memory map is:
;
;   Before execution of            After execution of
;   BUFR$COMFILE$CODE$SEG        BUFR$COMFILE$CODE$SEG
;   ______________________        ______________________
;   |TOP$OF$RAM:         |        |TOP$OF$RAM:         |
;   |  CP/M sits here    |        | CP/M sits here     |
;   |CPM$BASE:           |        |CPM$BASE:           |
;   |--------------------|        |--------------------|
;   | MT3 code executes  |        | MT3 code executes  |
;   |        from here   |        |         from here  |
;   |test$lo$memory:     |        |test$lo$memory:     |
;   |hi$code:            |        |hi$code:            |
;   |--------------------|        |--------------------|
;   |end$overlay$data:   |        |end$overlay$data:   |
;   |  {data table here} |        |  {data table here} |
;   |overlay$data:       |        |overlay$data:       |
;   |program (MT1,MT2)   |        |program (MT1,MT2)   |
;   |    saved to here   |        |    saved to here   |
;   |[@hi$base]:         |        |[@hi$base]:         |
;   |--------------------|        |--------------------|
;   |low area-under-test |        |low area-under-test |
;   |    save space      |        |    save space      |
;   |[@lo$sav$base]:     |        |[@lo$sav$base]:     |
;   |--------------------|        |--------------------|
;   | Unoccupied         |        | Unoccupied         |
;   |     RAM            |        |     RAM            |
;   |         sits       |        |         sits       |
;   |              here  |        |              here  |
;   |--------------------|        |--------------------|
;   |[@hi$sav$top]:      |        |[@hi$save$top]:     |
;   |high area-under-test|        |high area-under-test|
;   |    save space      |        |    save space      |
;   |--------------------|        |--------------------|
;   |[@top$cpm$save]:    |        |[@top$cpm$save]:    |
;   | CP/M saved to here |        | CP/M saved to here |
;   |--------------------|        |--------------------|
;   |[@prg$top]:         |********|[@prg$top]:         |
;   | {unoccupied        |********| MT1 CODE saved here|
;   |              RAM}  |********|{test$lo$memory:}   |
;   |--------------------|        |--------------------|
;   |end$data:           |        |end$data:           |
;   |  {data table here} |        |  {data table here} |
;   |data:               |        |data:               |
;   |--------------------|        |--------------------|
;   |end$lo$code:        |        |end$lo$code:        |
;   | {MT2 code is here} |        | {MT2 code is here} |
;   |lo$code:            |        |lo$code:            |
;   |--------------------|        |--------------------|
;   |end$interface:      |        |end$interface:      |
;   | {MT1 code and data}|        | {MT1 code and data}|
;   |begin$code:         |        |begin$code:         |
;   |TBASE:              |        |TBASE:              |
;   |--------------------|        |--------------------|
;   | P A G E   Z E R O  |        | P A G E   Z E R O  |
;   ----------------------        ----------------------
;
;   Move the value of @code$size (found in the OVERLAY
;   DATA area in MT3) down to @hi$code$size (in MT2).
;
    LOAD? HL,@code$size
    STORE? HL,@hi$code$size
;
;   Move the code down
;
    lxi H,hi$code
    lxi D,end$data
    LOAD? BC,@hi$code$size
    BLOCK$MOVE?
;
;   PRG$TOP is the top of the program when it is sitting
;   in low memory (AS IT IS NOW).  It may be calculated as
;   @prg$top <-- (end$intrface + main$size + hi$code$size)
;
    lxi H,end$intrface
    LOAD? BC,@main$size
    dad B
    LOAD? BC,@hi$code$size
    dad B
    STORE? HL,@prg$top
;
;   tell us how much to SAVE
;
    LOAD? HL,@prg$top
    WRD$HEX$TO$CONS?;    writes out '17' (and change) ...
    GOTO? reboot;    ... so we "SAVE 23 MEMTEST.COM"
tmp1                set dma$bufr
tmp2                set $
end$bufr$code$seg:    ds (DMA$SIZE - (tmp2 - tmp1))
end$dma$bufr:        ds 0
;
;   the DSEG has been removed in order to 
;   force LINK to load the data table here
;
;;;;;;;    PUBLICs and EXTRNs go here
;
;   These get used in MT1
;
    PUBLIC ?pattern,?delay,?dcounter,?terminates,?timing
    PUBLIC ?errors$to$disk,@lowr$bndry,@uppr$bndry,main
    PUBLIC @lo$addr$extnsn,@hi$addr$extnsn,@iterations
;
;   These get used in MT3
;
    PUBLIC end$stack,report$error,@hi$base
;
;   These are obtained from MT1 and MT3
;
    EXTRN user$intrface,err1,err2,end$intrface,hi$code,end$hi$code
    EXTRN end$hi$stack,test$lo$memory,@code$size

;;;;;;;    (DBs, DWs, DSs go here)

fcb$record
                    db    0    
                    db    'MEMTEST '    
                    db    'ERR'
                    db    0,0,0,0
                    ds    20

;;;;;;;;common$data            db '####################################'
;;;;;;;;    {the line of '#'s is for visual verification of overlay placement}
;
;   1-byte toggles and counters
;
?cpm$space          db FALSE
?prg$space          db FALSE
?sav$cpm            db FALSE
?mov$prg            db FALSE
?need$restore$cpm   db FALSE
?did$restore$cpm    db FALSE
?delay              db FALSE
?dcounter           db 0
?bit$shift          db 1
?pass$counter       db 0
?timing             db 0
?pattern            db FALSE
?mask               ds 1
?byte               ds 1
?terminates         db TRUE
?errors$to$disk     db FALSE
;
;   2-byte addresses and offsets
;
@dma$ptr            dw dma$bufr
@lo$sav$base        ds 2
@hi$sav$top         ds 2
@top$cpm$save       ds 2
@prior$stkptr       ds 2
@hi$base            ds 2
;;@code$size        dw (end$hi$code - hi$code)
@hi$code$size       ds 2
@prg$top            ds 2
@main$size          dw ((end$code-code)+(end$data-data))
@cpm$size           ds 2
@prg$size           ds 2
@stkptr$low         dw end$stack
@stkptr$high        dw (end$hi$stack-8); headroom for stack
@coldboot           ds 2
@iterations         dw 1
@err$addr           ds 2
@lowr$bndry         dw 0
@uppr$bndry         dw TOP$OF$RAM
@lo$addr$extnsn     dw 0
@hi$addr$extnsn     dw 0

space$err$msg       db 'Not enough space to move MEMTEST and/or save CP/M$'

;;;;;;;;    stack goes here {to enable overlay with HI$PRG}

stack:              ds STACK$SIZE
end$stack:
stkptr:
end$data:           ds 0
tmp1                set end$data;    {to avoid RMAC's "E" error}
kloodge:            ds (((CPM$BASE-HI$MODULE$SIZE)-tmp1)-INTRFACE$TOP)

    END

