	page	60,80
TITLE GENERAL PURPOSE I/O INTERFACE VERSION 1.5
SUBTTL	MAILBOX POLLING ROUTINE VERSION 1.5

	.xlist

	include	gifdic.mac
	include	80186.mac
	include options.h
	include equates.h
	include mailboxs.h
	include	data.h

boot_pol	equ	1

	include	boot_lnk.h

	.list
	.xall

domailbox:			; check round the mailboxes

	call	set_mail		; point to mailboxes
	assume	ds:mailbox

	test	MLAB.OTFLG,01h		; any output ?
	jz	no_bytes
	mov	al,MLAB.OTDAT		; get it
	and	al,07fh			; GIFDIC dont like bit 7
	push	ds
	mov	bx,cs:chtab		; get dev. # of console
	gifcall	,write,noopt
	pop	ds
	jc	no_bytes
	and	MLAB.OTFLG,0feh		; clear flag
no_bytes:

	test	MLAB.INFLG,01h		; input
	jnz	no_inbyte
	push	ds
	mov	bx,cs:chtab		; get dev. # of console
	gifcall ,read,noopt
	pop	ds
	jc	no_inbyte
	mov	MLAB.INDAT,al
	or	MLAB.INFLG,01
no_inbyte:


	mov	di,offset cs:con_fifo
	mov	bx,kvddev		; do console fifo
	call	fifo_out

	mov	di,offset cs:prn_fifo
	mov	bx,prtdev		; do printer fifo
	call	fifo_out

	mov	di,offset cs:dte_fifo
	mov	bx,dtedev		; do dte fifo
	call	fifo_out

	mov	di,offset cs:dce_fifo
	mov	bx,dcedev		; do dce fifo
	call	fifo_out

;***************************************************
;
;	NOW DO REAL MAILBOXES
;
;****************************************************

	mov	si,offset mailbox:MFLAGS.START1
	mov	di,offset cs:pending.PEND1
	mov	dx,offset mailbox:MCRB1
	call	mail_check

	mov	si,offset mailbox:MFLAGS.START2
	mov	di,offset cs:pending.PEND2
	mov	dx,offset mailbox:MCRB17
	call	mail_check

	mov	si,offset mailbox:MFLAGS.START3
	mov	di,offset cs:pending.PEND3
	mov	dx,offset mailbox:MCRB33
	call	mail_check

	mov	si,offset mailbox:MFLAGS.START4
	mov	di,offset cs:pending.PEND4
	mov	dx,offset mailbox:MCRB49
	call	mail_check

	jmp	domailbox

mail_check:

	mov	ax,[si].READY1			; 0 if 	no activity
	and	[si].DONE1,ax			; then clear any at idle

	mov	ax,[si].STACK1
	and	[si].STATS1,AX

	mov	ax,[si].START1		; get any
	mov	bx,cs:[di].PEND1	; waiting for no start
	and	cs:[di].PEND1,ax	; update pending if no start
	xor	bx,cs:[di].PEND1	; whats new

	mov	cx,[si].STATS1		; status
	not	cx
	and	bx,cx			; wait for status


	xor	[si].BUSY1,bx		; clear busy
	xor	[si].DONE1,bx		; set done

	not	ax
	and	[si].BUSY1,ax		; force busy if start

	mov	ax,[si].BUSY1		; get it
	or	ax,cs:[di].PEND1	; action required

	or	ax,[si].STATS1		; ignore if waiting for status

	swap	ax
	xor	ax,0ffffh		; invert logic
	jnz	do_some

	ret

bit_mess:	db	'SYSCON: Setting the DONE bit for the disk',CR,LF,etx

do_some:
	mov	si,dx			; crb address in si
	mov	bx,8000h

check_crb:
	test	ax,bx			; this crb ?
	jz	not_this
	pusha				; save the state
	call	do_crb			; do the crb
	pushf
	call	set_mail		; point to mailbox again
	popf
	popa				; restore all
	jc	not_this		; not finished
	swap	bx
	or	cs:[di],bx		; flag it done
	swap	bx
	xor	ax,bx			; clear this bit
	jnz	not_this
	ret				; done all bits

not_this:
	add	si,crb_size		; point to next
	shr	bx,1			; next bit
	jnc	check_crb		; do all crbs
	ret				; done 16

crbmes:	db	'CRB : ',etx

do_crb:

	cmp	[si].DEVTP,CTTYS		; tty ??
	jnz	notcon
	test	byte ptr cs:sys_flag,01h
	jz	no_print_console
	call	print_crb
no_print_console: 
	jmp	console
notcon:
	cmp	[si].DEVTP,CDISK		; disk ??
	jnz	notdisk
	test	byte ptr cs:sys_flag,02h
	jz	no_print_disk
	call	print_crb
no_print_disk: 
	jmp	is_disk
notdisk:
	cmp	[si].DEVTP,CSYST		; system ??
	jnz	notsys
	test	byte ptr cs:sys_flag,04h
	jz	no_print_system
	call	print_crb
no_print_system: 
	jmp	system
notsys:
	cmp	[si].DEVTP,CRTCS		; rtc
	jnz	notrtc
	test	byte ptr cs:sys_flag,08h
	jz	no_print_rtc
	call	print_crb
no_print_rtc: 
	jmp	do_rtc
notrtc:
	jmp	badcrb
	
if	low_debug

print_crb:
	push	si
	mov	di,offset cs:crbmes
	call	ptext
	mov	di,si
	mov	cx,13
pcrb_loop:
	mov	ax,[di]
	inc	di
	inc	di
	push	di
	push	cx
	push	ax
	call	phex
	pop	ax
	swap	ax
	call	phex
	call	pspace
	pop	cx
	pop	di
	loop	pcrb_loop
	mov	di,offset cs:eom
	call	ptext
	pop	si
	ret
	endif

prog	ends
	end
