TITLE	ASCII/Binary Conversion

pgroup	group prog

maxcnt	equ 64
adjust	equ 'A'-'0'-0ah

pusha	macro
	db 60h
endm

popa	macro
	db 61h
endm

shlah	macro cnt
	db 0c0h, 0e4h, cnt
endm

rolax	macro cnt
	db 0c1h, 0c0h, cnt
endm

rorax	macro cnt
	db 0c1h, 0c8h, cnt
endm

rorah	macro cnt
	db 0c0h, 0cch, cnt
endm

procedure	macro procnme
public procnme
procnme	proc near
endm


prog	segment byte public 'prog'
	assume cs:prog

; ASCII to Binary : Convert the ASCII digits pair by pair into hex bytes
;			"123456" will be converted to 56H, 34H, 12H
;			 "789AB" will be converted to ABH, 89H, 07H
;	In :	DS:SI - Source ASCII string
;		ES:DI - Destination Binary String
;		CX    - Number of digits
;	Destroyed : None
procedure ascbin
	jcxz	abexit
	pusha
	add	si, cx

ab4:
	mov	dl, 55h		; Shift counter
ablp:
	dec	si
	mov	ah, [si]
; ASCII convertion
	sub	ah, '0'
	cmp	ah, 'A'-'0'
	jl	ab1
	sub	ah, adjust
ab1:
;
	xchg	al, ah
	rol	dl, 1
	jnc	ablpend
; Byte AL(+)AH
	shlah	4
	rolax	4
	stosb
ablpend:
	loop	ablp

	rol	dl, 1
	jnc	abok
	stosb
abok:
	popa
abexit:
	ret
ascbin	endp




; Binary to ASCII : Convert the Hex bytes into ASCII digits
;			56H, 34H, 12H will be converted to "123456" if CL=6
;			56H, 34H, 12H will be converted to  "23456" if CL=5
;	In :	DS:SI - Source Binary string
;		ES:DI - Destination ASCII String
;		CX    - Number of digits
;	Destroyed : None
procedure binasc
	jcxz	baexit
	pusha
	add	di, cx
balp:
	mov	ah, 33h		; '0' or ('0' shr 4)
	lodsb
	rorax	4
	rorah	4
; Byte AL(+)AH
	cmp	al, '9'
	jle	ba1
	add	al, adjust
ba1:
	cmp	ah, '9'
	jle	ba2
	add	ah, adjust
ba2:
	mov	es:[di-1], ah
	dec	cx
	jz	balpend
	sub	di, 2
	mov	es:[di], al
	loop	balp

balpend:
	popa
baexit:
	ret

binasc	endp

prog	ends


end
:

