TITLE --- THIS MODULE CONTAINS BUFFER MANIPULATING ROUTINES


include xinstr.mac
include texin.equ
include ledtor.equ

blkdev equ 0
pgroup group prog

prog segment byte public 'prog'

	assume cs:pgroup

	extrn dispchr:near, dispchrb:near

; function : to shift the content of the user buffer, starting 
;	    from position pointed by si and up to end of buffer,
;     	     cx characters to the right
; input parameter: ds:si pointing the start position in
;		   the user buffer
;		   bx is the number of columns to advance
; output parameter: nil, but the buffer is updated
; remarks : CY if unsuccessfully shift
; destroyed : nil

nprocedure shbufr

	push cx
	push ax
	push si
	cmp si, [bp.usrbufirst] ; check whether si exceeds user buffer
				; left limit
	jge shrcont1
	mov si, [bp.usrbufirst]
shrcont1:
	mov cx, [bp.usrbufirst]	; get number of chars to move
	add cx, linlen
	sub cx, si
	jle shrret
	sub cx, bx
	jg  shrcont	; if # of chars to mov <= 0, exit with CY
	add cx, bx
	jmp short lpfspr
shrcont:
	mov si, [bp.usrbufirst]  ; start from the tail of buffer
	add si, linlen
	sub si, bx
	dec si
	mov al, [si]
lpshr:				; use a loop to transfer the chars
	mov [si+bx], al
	dec si
	mov al, [si]
	loop lpshr
	inc si
	mov cx, bx
lpfspr:
	mov byte ptr [si], sp_c
	inc si
	loop lpfspr
	clc
shrret:
	pop si
	pop ax
	pop cx
	ret

shbufr  endp



; function : to shift the content of the user buffer, starting 
;	    from position pointed by si and up to end of buffer,
;     	     cx characters to the left
; input parameter: ds:si pointing the start position in
;		   the user buffer
;		   bx is the number of columns to retreat
; output parameter: nil, but the buffer is updated
; remarks : CY if unsuccessfully shift
; destroyed : nil

nprocedure shbufl

	push cx
	push ax
	push si		; save si, cx, ax
	cmp si, [bp.usrbufirst] ; check whether si exceeds left limit
	jge shlcont2
	mov si, [bp.usrbufirst]
shlcont2:
	mov cx, [bp.usrbufirst]	; calculate # of chars to move
	add cx, linlen
	sub cx, si
	jg shlcont1		; if si exceeds user buffer size
	add cx, si		; then only clear the right most
	mov si, cx		; bx characters
	mov cx, bx
	sub si, bx
	jmp lpfroom
shlcont1:
	mov ax, si
	sub ax, bx
	sub ax, [bp.usrbufirst]
	jge shlcont
	sub si, ax
	add cx, ax
	jnl shlcont
	mov cx, [bp.usrbufirst] ; if cx <0 , that means the buffer is clear
	mov si, cx		; after shifting. Then only clear the buffer
	add cx, linlen
	dec cx
	jmp short lpfroom
shlcont:
	mov al, [si]
	neg bx
lpshl:				; use a loop to shift chars left
	mov [si+bx], al
	inc si
	mov al, [si]
	loop lpshl
	neg bx
	mov si, [bp.usrbufirst]
	add si, linlen
	sub si, bx
	mov cx, bx
lpfroom:
	mov byte ptr [si], sp_c
	inc si
	loop lpfroom
	clc
shlret:
	pop si
	pop ax
	pop cx
	ret

shbufl  endp


; function : to display the content of user buffer
; input parameter : cx -- number of bytes to display
;		    ds:si -- pointing starting buffer char
; output parameter : nil
; destroyed: nil


nprocedure dispubuf

	push cx
	push bx
	mov bx, [bp.gifdev]
if blkdev
	push es
	push di
	mov di, ds
	mov es, di
	mov di, si
	call dispchrb
	pop di
	pop es
else
	push ax
lpdis1chr:
	mov al, [si]
	call dispchr
	inc si
	loop lpdis1chr
	pop ax
endif
	pop bx
	pop cx
	ret
dispubuf endp
prog ends
end

i                   
