	page	60,80
TITLE INITIAL I/O INTERFACE FOR UNIX

	include	src\gifdic.mac
	include	src\80186.mac
	.xall

csb_main	struc

devno	db ?		; device number
devtyp	db ?		; major device type ( 0 = tty, 1 = disc, 2 = rtc
device	dw ?		; device description
maxrq	db ?		; max simultanious requests
nowrq	db ?		; current request count

csb_main	ends

csb_disk	struc

secsize	dw ?		; physical sector size
sizmsw	dw ?		; msb of last sector
sizlsw	dw ?		; last sector number
sectrk	dw ?		; sectors per track
headno	dw ?		; number of heads
	dw 2 dup (?)
errcod	dw ?		; error status code
	dw ?		; spare error status

	dw 4 dup (?)

csb_disk	ends


csb_tty	struc

	dw 7 dup (?)
conerr	dw ?
	dw ?

	dw 4 dup (?)

csb_tty	ends


crb_main	struc

rdevno	db ?		; request on device number
rdevtyp	db ?		; request on major device type
comand	dw ?		; operation code
rqcount	dw ?		; request count
com1	dw ?		; 1st parameter
com2	dw ?		; 2nd parameter
com3	dw ?		; 3rd parameter
com4	dw ?		; 4th parameter
com5	dw ?		; 5th parameter
com6	dw ?		; 6th parameter
	dw ?
	dw ?

crb_main	ends


PGROUP	GROUP	PROG

debug	equ	0			; option unix/debug io
				; 0 = unix ??

stmmcpu segment at 4000h
stmrf	equ	5			; register file access
	org	0
stmmcpu0 dw ?
stmmcpu ends

mmcpu	segment at 4000h
mmcrf	equ	03
	org	0
ssp0	dw ?
ssp1	dw ?
pc0	dw ?
pc1	dw ?
mmcpu ends

mailbox segment at 4000h
mailrf	equ	03h			; register file access

		; CRB progress flags
	org	0400h
mailstart	db ?
	db ?
	db ?
start	db ?		; unix, active = 1, start request

	db ?
	db ?
	db ?
busy	db ?		; syscon, active = 0, request in progress

	db ?
	db ?
	db ?
done	db ?		; syscon, active = 1, request complete

	db ?
	db ?
	db ?
ready	db ?		; unix, active = 0, acknowledge completion

	db ?
	db ?
	db ?
status	db ?		; syscon, active = 1, status report on task

	db ?
	db ?
	db ?
gotst	db ?		; unix, active = 0, status received

	db ?
	db ?
	db ?
abort	db ?		; unix, active = 1, abort task

	db ?
	db ?
	db ?
aborted	db ?		; syscon, active = 0, aborted task


		; CSB starts
	org	0420h

csb1	csb_main	<>
	csb_disk	<>	; csb1.device 1 = disk drive

csb2	csb_main	<>
	csb_tty		<>	; device 2 = console tty

csb3	csb_main	<>
	csb_tty		<>	; device 3 = dte

csb4	csb_main	<>
	csb_tty		<>	; device 4 = dce





	org	0500h
			; start of CRBs

crb1	crb_main	<>	; initially the disk crb

crb2	crb_main	<>	; initially the console out

crb3	crb_main	<>	; initially the console in

crb4	crb_main	<>	; initially the dte out

crb5	crb_main	<>	; initially the dte in

crb6	crb_main	<>	; initially the dce out

crb7	crb_main	<>	; initially the dce in

	org	06e0h
	db ?
inptr	db ?
	db ?
outptr	db ?

	org	06f0h
fifo	db 256 dup(?)




	org	07f0h
			; byte space for simple io
charin	db ?
charout db ?

	org	07fch
bytein	db ?
flagin	db ?
bytout	db ?		; output byte
flagout	db ?		; bit 0 = output

mailbox	ends


		; my equates for the interface

unix_drive	equ	3		; use drive D:

unix_upper	equ	0005h		; upper start address

unix_start	equ	0000h		; starting address
unix_stack	equ	0800h		; initial stack pointer

rfport	equ	0e204h			; access to register file
rfdma	equ	0e206h			; access to dma r file

cr	equ	0dh
lf	equ	0ah
etx	equ	04h

exit	equ	4c00h

crb_size	equ	32		; size of one crb
crbmax	equ	7
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	assume cs:pgroup

begin:			; set up stack
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke
;

	mov	dx,05ch
	mov	ah,0fh			; open file
	int	21h
	cmp	al,0
	jz	fileopen

	mov	di,05ch			; fcb
	push	ds
	pop	es
	push	cs
	pop	ds			; swap segments around
	mov	si,offset cs:bootname
	mov	cx,37			; no of bytes
	rep	movsb			; copy it
	push	es
	pop	ds			; restore ds

	mov	dx,05ch
	mov	ah,0fh			; open file
	int	21h
	cmp	al,0
	jz	fileopen
	mov	dx,offset pgroup:errmes
	add	dx,100h
	mov	ah,9			; print string
	int	21h
	mov	ah,4ch			; terminate
	int	21h			; quit
fileopen:
	mov	dx,rfport
	mov	al,mmcrf		; 50000h on 68k is destination
	out	dx,al
	mov	dx,rfdma
	out	dx,al			; set both rfs for transfer
	mov	ax,9000h
	mov	bx,0ff80h		; 0-80h
	push	ax
	push	bx
	push	ds			; saveit
getblock:
	pop	ax			; really ds
	pop	dx
	pop	ds			; destination ds:dx
	add	dx,80h			; one block
	push	ds
	push	dx			; save for next time
	push	ax			; save it again
	mov	ah,1ah
	int	21h			; set dma

	pop	ds
	push	ds			; get and save ds
	mov	dx,5ch			; point to fcb
	mov	ah,14h			; read
	int	21h
	cmp	al,00
	jz	getblock		; repeat till done

okread:
;
	pop	ax
	pop	ax
	pop	ax			; clear stack

	xor	cx,cx
	int	99h			; link up to gifdic
	mov	ax,es:[di.ghndlr]
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
;
	mov	al,unix_drive

	mov	bx,dskdev
	gifcall ,reset,0		; reset the disk
;
;
	mov	dx,rfport		; register file port
	mov	al,mmcrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mmcpu		; access address
	mov	ds,ax
	assume	ds:mmcpu

	mov	cl,8			; for swap
	mov	ssp0,0			; initial stack pointer upper
	mov	ssp1,unix_stack		; initial stack
	ror	ssp1,cl			; swap
	mov	pc0,unix_upper		; start for boot
	mov	pc1,unix_start		; initial code start
	ror	pc0,cl			; swap


	call	set_mail		; point to mailboxes
	assume	ds:mailbox

	xor	ax,ax			; zero ax
	mov	di,offset mailbox:mailstart
	mov	cx,200h			; 400h - 7ffh / 2
	push	ds
	pop	es
	rep	stosw			; clear mailboxes

	mov	bx,0ffh
	mov	busy,bl
	mov	gotst,bl
	mov	aborted,bl

	mov	cl,8

	mov	csb1.devno,1
	mov	csb1.devtyp,1
	mov	csb1.device,0
	mov	csb1.maxrq,1
	mov	csb1.nowrq,0
	mov	csb1.secsize,512
	ror	csb1.secsize,cl		; swap
	mov	csb1.sizmsw,0
	mov	csb1.sizlsw,088aah
	ror	csb1.sizlsw,cl		; swap
	mov	csb1.sectrk,11
	ror	csb1.sectrk,cl
	mov	csb1.headno,6
	ror	csb1.headno,cl		; swap
	mov	csb1.errcod,0

	mov	csb2.devno,2
;	mov	csb2.devtyp,0
;	mov	csb2.device,0
	mov	csb2.maxrq,2
;	mov	csb2.nowrq,0

	mov	csb3.devno,3
;	mov	csb3.devtyp,0
;	mov	csb3.device,0
	mov	csb3.maxrq,2
;	mov	csb3.nowrq,0

	mov	csb4.devno,4
;	mov	csb4.devtyp,0
;	mov	csb4.device,0
	mov	csb4.maxrq,2
;	mov	csb4.nowrq,0

	mov	crb1.rqcount,0
	mov	crb2.rqcount,0
	mov	crb3.rqcount,0
	mov	crb3.rqcount,0
	mov	crb4.rqcount,0


	mov	flagin,01		; no input
					; all mailbox set up.


	push	cs
	pop	es
	mov	di,offset signon	; say hello to the folks
	call	ptext


	mov	dx,rfport		; start up the 68k cpu
	mov 	al,stmrf
	out	dx,al
	mov	ax,seg stmmcpu
	mov	ds,ax
	assume	ds:stmmcpu
	mov	ax,stmmcpu0

	mov	cs:pending,0		; no done pending

domailbox:			; check round the mailboxes

	call	set_mail		; point to mailboxes
	assume	ds:mailbox

	test	flagout,01h		; any output ?
	jz	no_bytes
	mov	al,bytout		; get it
	push	ds
	gifcall	kvddev,write,waitnr	; print it
	pop	ds
	and	flagout,0feh		; clear flag
no_bytes:

	test	flagin,01h		; input
	jnz	no_inbyte
	push	ds
	gifcall	kvddev,read,noopt	; read it
	pop	ds
	jc	no_inbyte
	mov	ds:bytein,al
	or	ds:flagin,01
no_inbyte:

	mov	si,cs:concnt		; get pointer
reconout:
	cmp	si,cs:consiz		; anything ??
	jz	noconout
	mov	al,cs:[si]
	gifcall	kvddev,write,noopt	; try to output it
	jc	noconout

	inc	cs:concnt
	inc	si			; point to next
	jmp	reconout

noconout:

	mov	si,cs:dtecnt		; get pointer
redteout:
	cmp	si,cs:dtesiz		; anything ??
	jz	nodteout
	mov	al,cs:[si]
	gifcall	dtedev,write,noopt	; try to output it
	jc	nodteout

	inc	cs:dtecnt
	inc	si			; point to next
	jmp	redteout

nodteout:

	mov	si,cs:dcecnt		; get pointer
redceout:
	cmp	si,cs:dcesiz		; anything ??
	jz	nodceout
	mov	al,cs:[si]
	gifcall	dcedev,write,noopt	; try to output it
	jc	nodceout

	inc	cs:dcecnt
	inc	si			; point to next
	jmp	redceout

nodceout:

	mov	ah,0

	mov	al,ready		; 0 if no activity
	and	done,al			; then clear any at idle

	mov	al,start		; get any
	mov	bl,cs:pending		; waiting for no start
	and	cs:pending,al		; update pending if no start
	xor	bl,cs:pending		; whats new ?
	xor	busy,bl			; clear busy
	xor	done,bl			; set done

	not	al
	and	busy,al			; force busy if start

	mov	al,busy			; get it
	or	al,cs:pending		; pick out actions required

	xor	al,0ffh			; inverse logic
	jnz	do_this_bit
	jmp	domailbox
do_this_bit:
	mov	cx,crbmax		; how many matter

	mov	si,offset mailbox:crb1	; point to first crb

	mov	bx,1

check_crb:
	test	ax,bx			; this crb ?
	jz	not_this
	pusha				; save the state
	call	do_crb			; do the crb
	pushf
	call	set_mail		; point to mailbox again
	popf
	popa				; restore all
	jc	not_this		; not finished
	or	cs:pending,bl		; flag it done
	xor	ax,bx			; clear this bit
	jnz	not_this
	jmp	domailbox		; any more bits ??
not_this:
	shl	bx,1			; next bit
	add	si,crb_size		; point to next
	loop	check_crb		; do all crbs
	jmp	domailbox		; repeat


do_crb:
	cmp	[si].rdevtyp,00		; tty ??
	jnz	notcon
	jmp	console
notcon:
	cmp	[si].rdevtyp,01		; disk ??
	jz	is_disk
	call	badcrb
	clc
	ret				; clear request and exit

is_disk:
	cmp	[si].devno,01		; disk csb
	jz	gooddev
	cmp	[si].devno,02
	jz	gooddev
	call	badcrb
	clc
	ret				; error exit
gooddev:
	mov	al,[si].devno
	mov	cs:drvno,al		; save number
	mov	ax,[si].comand		; get command\
	cmp	al,01			; disk command ?
	jnz	baddisk
	and	ah,7fh			; mask flush bit
	cmp	ah,01			; read
	jz	disk_wrap
	cmp	ah,02
	jz	disk_wrap
baddisk:
	call	badcomand
	clc
	ret


;***********************************************************
;
;	first hack at page wrap
;
;***********************************************************

disk_wrap:

	cmp	[si].com3,0		; done all ??
	jnz	dosome
	clc
	ret				; good return
dosome:
	mov	bx,[si].com4		; upper address
	swap	bx			; byte swap
	and	bx,07			; bits below 1/2 mb
	mov	dx,[si].com5		; lower address
	swap	dx			; byte swap
	mov	cx,0			; sectors done
	mov	ax,511			; sector size - 1
loopsec:
	add	dx,ax			; address of end of block
	mov	ax,512
	jc	iscarry			; carry into bx
nextsec:
	inc	cx
	swap	cx			; byte swap
	cmp	cx,[si].com3		; done all sectors
	pushf
	swap	cx			; byte swap
	popf
	jnz	loopsec			; no, go back
	jmp	diskex			; execute disk

iscarry:
	inc	bx			; do carry
	test	bx,07			; over a boundary ??
	jnz	nextsec			; go onward till done
	cmp	cx,0			; any to do ??
	jz	goodisk			; no, skip
	push	[si].com3		; save total sector count
	push	dx			; lower address
	push	bx			; upper address
	push	cx			; good sectors
	swap	cx
	mov	[si].com3,cx		; do this number
	push	si
	call	diskex			; do so far
	mov	bp,ax			; save error code
	pop	si			; point to crb again
	pop	cx
	pop	bx
	pop	dx
	pop	ax
	swap	ax			; get it our way round
	cmp	bp,0			; no errors ??
	jz	goodisk
	clc				; quiting, flag done
	ret
goodisk:
	sub	ax,cx			; sectors left
	mov	bx,[si].com2		; get start sector
	swap	bx
	add	bx,cx			; increase the start sector
	pushf
	swap	bx
	popf
	mov	[si].com2,bx		; store it away
	jnc	noextra
	mov	bx,[si].com1		; do upper byte
	swap	bx
	inc	bx
	swap	bx
	mov	[si].com1,bx		; store it back
noextra:
	swap	ax
	mov	[si].com3,ax		; new sector count
	mov	ax,[si].com4		; upper address
	swap	ax
	and	ax,0fff8h		; mask lower bits to zero
	add	ax,0008h		; next boundary
	swap	ax
	mov	[si].com4,ax		; store it back
	inc	dx			; start of next sector
	swap	dx
	mov	[si].com5,dx		; new lower boundary
	swap	dx
	cmp	dx,512			; if exact sector
	jnz	dobitwise		; here is trouble
	mov	[si].com5,0		; back to start
	mov	ax,[si].com3		; get sector count
	swap	ax
	inc	ax			; one extra
	swap	ax
	mov	[si].com3,ax		; store away
	jmp	disk_wrap		; proceed

dobitwise:
	test	[si].comand,0100h	; read bit
	jnz	skip_move		; if its a read
	call	move_data		; copy over before write
skip_move:
	call	disk_bit		; do the physical i/o
	jnc	good_bit		; no errors
	jmp	disk_exit		; else report and end
good_bit:
	test	[si].comand,0100h	; read bit
	jnz	move_data		; if its a write
	jmp	disk_wrap		; done

move_data:
	push	ds
	push	si			; save these

	mov	bx,[si].com5		; get lower address
	push	bx			; and save lower address
	mov	ax,[si].com4		; get upper address
	push	ax			; save upper address

	swap	ax
	dec	ax			; down one
	swap	ax
	mov	[si].com4,ax		; reduced upper address

	swap	bx
	push	bx			; save second count
	mov	ax,512			; sector size
	sub	ax,bx			; first size
	sub	bx,512			; reduce lower address
	swap	bx
	mov	[si].com5,bx		; put it away
	call	real_move
	call	set_mail		; back to mailboxes
	pop	ax			; next count
	mov	[si].com5,00		; lower address start at 0
	pop	bx			; new upper address
	mov	[si].com4,bx		; set it up
	call	real_move
	call	set_mail		; boxes again
	pop	bx
	mov	[si].com5,bx		; new lower address
	pop	si
	pop	ds			; restore
	ret


real_move:
	push	ds
	push	si
	push	ax			; save count
	lea	si,[si].com4		; point to address
	call	get_addr		; get address makeup
	pop	cx			; count
	mov	dx,rfport		; get register file
	push	cs
	pop	ds
	pop	bx			; use as pointer
	push	bx
	mov	si,offset pgroup:dbuffer	; buffer
	test	[bx].comand,0100h	; read ??
	out	dx,al			; do vme access
	jnz	no_swap
	push	es
	push	ds
	xchg	di,si			; swap these
	pop	es
	pop	ds
no_swap:
	cld
	rep	movsb			; move it
	pop	si
	pop	ds
	ret

disk_bit:
	mov	dx,[si].com2		; start number
	swap	dx
	dec	dx
	mov	cx,1			; one sector
	push	si
	push	ds
	push	cs
	pop	es			; destination segment
	mov	di,offset pgroup:dbuffer
	mov	ax,[si].com1		; upper sector
	shri	ax,5			; semiswap
	add	al,1			; disk b:
	cmp	cs:drvno,02		; drive 2 ??
	jz	isdrv2
	add	al,2			; drive d:
isdrv2:
	test	[si].comand,0100h	; read bit
	jz	bit_write
	gifcall	dskdev,read,noopt
	jmp	was_read
bit_write:
	gifcall	dskdev,write,noopt
;
was_read:
	pop	ds
	pop	si
	ret				; done physical disk

			; now do block transfers !




;**************************************************************
;
;	end of experimental code
;
;**************************************************************

diskex:
	test	[si].comand,0100h	; read bit
	jz	disk_write


disk_read:
	call	set_disk		; test & set parameters
	mov	dx,rfdma		; own rf
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	cmp	cs:drvno,01
	jz	isdrva
	mov	al,1			; drive b:
isdrva:
	gifcall	dskdev,read,noopt	; do it
	jmp	disk_exit

disk_write:
	call	set_disk		; test & set parameters
	mov	dx,rfport		; share port with mbox
	out	dx,al			; set it up
	mov	dx,bx			; get start
	mov	al,3			; drive 3 (d:)
	cmp	cs:drvno,01
	jz	isdrv1
	mov	al,01
isdrv1:
	gifcall	dskdev,write,noopt	; do it
;
	jmp	disk_exit

console:
	cmp	[si].rdevno,02		; console device ??
	jz	ok_con
	cmp	[si].rdevno,03		; dte
	jz	ok_dte
	cmp	[si].rdevno,04		; dce
	jz	ok_dce
	call	badcrb
	clc
	ret
ok_con:
	mov	bx,kvddev
	cmp	[si].comand,0302h	; fifo mode
	jnz	notconfin
	jmp	dtefin
notconfin:
	cmp	[si].comand,0102h	; input ?
	jz	conin
	cmp	[si].comand,0202h	; output ??
	jnz	notconout
	jmp	conout
notconout:
	call	badcomand
	clc
	ret

ok_dte:
	mov	bx,dtedev
	cmp	[si].comand,0302h	; fifo mode
	jz	dtefin
	cmp	[si].comand,0102h	; input ?
	jz	dtein
	cmp	[si].comand,0202h	; output ??
	jnz	baddte
	jmp	dteout
baddte:
	call	badcomand
	clc
	ret

ok_dce:
	mov	bx,dtedev
	cmp	[si].comand,0302h	; fifo mode
	jnz	notdcefin
	jmp	dtefin
notdcefin:
	cmp	[si].comand,0102h	; input ?
	jnz	tryother
	jmp	dcein
tryother:
	cmp	[si].comand,0202h	; output ??
	jnz	baddce
	jmp	dceout
baddce:
	call	badcomand
	clc
	ret

conin:
	push	ds
	gifcall	kvddev,read,noopt	; try it
	pop	ds
	jc	no_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
no_input:
	ret

dtein:
	push	ds
	gifcall	dtedev,read,noopt	; try it
	pop	ds
	jc	dte_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
dte_input:
	ret


dtefin:			; input to fifo

	mov	ax,[si].com1		; in pointer
	mov	cx,[si].com2		; out pointer
	mov	dx,[si].com3		; fifo size
	swap	ax
	swap	cx
	swap	dx
	push	ax			; old pointer
	inc	ax			; next
	cmp	ax,dx			; wrap round ?
	jnz	nowrap
	xor	ax,ax			; restart
nowrap:
	push	ax			; next pointer
	cmp	ax,cx			; pointers same ??
	jnz	tryinput
fifexit:
	pop	ax
	pop	ax			; clear stack
	stc				; not finished
	ret

tryinput:
	push	ds
	gifcall	,read,noopt		; bx is channel
	pop	ds
	jc	fifexit			; no data
	push	ax
	push	si			; save pointer to crb
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	si			; recover crb
	pop	ax			; recover data
	pop	dx			; new pointer
	pop	bx			; old pointer
	mov	es:[bx.di],al		; set it up
	mov	bl,dh			; save pointer
	mov	bh,dl			; with swap
	call	set_mail		; restore mailboxes
	mov	[si].com1,bx		; new pointer
	stc
	ret				; not finished

dcein:
	push	ds
	gifcall	dcedev,read,noopt	; try it
	pop	ds
	jc	dce_input
	push	ax
	lea	si,[si].com4		; point to address
	call	set_addr		; point to it
	pop	ax
	mov	es:[di],al		; set it up
	clc
dce_input:
	ret


conout:
	mov	ax,cs:concnt		; pointer
	cmp	ax,cs:consiz		; busy ?
	jnz	con_busy

	mov	cx,[si].com3		; data count
	swap	cx
	push	cx
	add	cx,offset pgroup:conbuf
	mov	cs:consiz,cx
	mov	cs:concnt,offset pgroup:conbuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:conbuf
	pop	cx
	rep	movsb
	clc
	ret

con_busy:
	stc
	ret				; return busy

dteout:
	mov	ax,cs:dtecnt		; pointer
	cmp	ax,cs:dtesiz		; busy ?
	jnz	dte_busy

	mov	cx,[si].com3		; data count
	swap	cx
	push	cx
	add	cx,offset pgroup:dtebuf
	mov	cs:dtesiz,cx
	mov	cs:dtecnt,offset pgroup:dtebuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:dtebuf
	pop	cx
	rep	movsb
	clc
	ret

dte_busy:
	stc
	ret				; return busy

dceout:
	mov	ax,cs:dcecnt		; pointer
	cmp	ax,cs:dcesiz		; busy ?
	jnz	dce_busy

	mov	cx,[si].com3		; data count
	swap	cx
	push	cx
	add	cx,offset pgroup:dcebuf
	mov	cs:dcesiz,cx
	mov	cs:dcecnt,offset pgroup:dcebuf

	lea	si,[si].com4
	call	set_addr		; point to data
	push	es
	pop	ds
	push	cs
	pop	es
	mov	si,di			; point to data
	mov	di,offset pgroup:dcebuf
	pop	cx
	rep	movsb
	clc
	ret

dce_busy:
	stc
	ret				; return busy


set_addr:				; point to vme address
	call	get_addr		; calculate
	mov	dx,rfport		; rf port address
	out	dx,al			; set up rf
	ret				; done

get_addr:				; calculate vme address

	mov	ax,[si]			; upper address
	swap	ax
	add	ax,40h			; start address offset on vme
	and	ax,00f8h		; upper 5 bits
	mov	bx,[si+4]		; vme access code
	swap	bx
	and	bx,0007h		; valid bits
	or	ax,bx			; data for rf in al
	mov	bx,[si]			; upper address
	swap	bx
	mov	dx,[si+2]		; lower address
	swap	dx
	mov	cx,4
	shr	dx,cl			; reduce to segment size
	shl	bx,cl			; bits up in bl
	or	dh,bl
	and	dx,7fffh		; clear msb
	add	dx,4000h		; last move
	mov	es,dx			; got it in seg reg
	mov	di,[si+2]		; lower address
	swap	di
	and	di,0fh			; offset
	ret



set_disk:
	push	si			; save our pointer
	lea	si,[si].com4		; address data
	call	get_addr		; get vme data
	pop	si
	mov	cx,[si].com3		; sector count
	swap	cx
	mov	bx,[si].com2		; start sector number
	swap	bx
	ret

disk_exit:
	push	ax
	call	set_mail		; point to mail boxes
	pop	ax
	mov	al,0			; not valid status in al
	cmp	cs:drvno,01		; first disk ??
	jnz	issecondisk
	mov	csb1.errcod,ax		; send it
	clc
	ret

issecondisk:
	mov	csb2.errcod,ax		; send it to second csb
	clc
	ret

set_mail:				; access mailboxes
	mov	dx,rfport		; register file port
	mov	al,mailrf		; mailbox access
	out	dx,al			; set it up
	mov	ax,seg mailbox		; access address
	mov	ds,ax
	ret
errfull:
	mov	di,offset fifoflow
	jmp	perr

pwrite:
	mov	di,offset writer
	call	perr
	xor	ax,ax
	ret


badcrb:
	mov	di,offset crberr
	jmp	perr
badcomand:
	mov	di,offset comerr
	jmp	perr
badsect:
	mov	di,offset secerr
	jmp	perr
baddev:
	mov	di,offset deverr
	jmp	perr
badtype:
	mov	di,offset typerr

perr:
ptext:		; print all characters from es:di to 04h ( etx )
	push	cs
	pop	es			; messages are in cs
	jmp	ptext1			; starting point
printone:
	push	es
	push	di
	gifcall	kvddev,write,waitnr	; print 1, no return till done
	pop	di
	pop	es
ptext1:
	mov	al,es:[di]		; get character
	inc	di			; next
	cmp	al,etx
	jne	printone		; output one
	ret


signon:	db	lf,lf,cr,'1st level UNIX I/O System',cr,lf
	db	'Starting UNIX now.',lf,cr,etx

crberr:	db	cr,lf,'Illegal CRB requested !',cr,lf,etx

comerr:	db	cr,lf,'Bad command.',cr,lf,etx
secerr:	db	cr,lf,'Bad disc sector.',cr,lf,etx
deverr:	db	cr,lf,'Bad disc device.',cr,lf,etx
typerr:	db	cr,lf,'Bad disc type.',cr,lf,etx


bootname:	db	0,'BOOT    UNX'
	db	22 dup (0)			; default file name

writer:	db	cr,lf,'Disk write request refused !!',cr.lf,etx

errmes:	db	0ah,0dh,'Boot.unx file not found.',0ah,0dh,'$'

fifoflow:	db	'.',etx

;
gifdic	label	dword
gifl	dw	?
gifh	dw	?
;
;
drvno	db	?
	db ?
	db ?
	db ?
pending db ?

dbuffer	db 512 dup (?)		; disk buffer for wrap


conbuf	db	400h dup (?)	; output buffer
concnt	dw	?
consiz	dw	?

dtebuf:	db	400h dup (?)	; output buffer
dtecnt	dw	?
dtesiz	dw	?

dcebuf:	db	400h dup (?)	; output buffer
dcecnt	dw	?
dcesiz	dw	?

		; space for system stack

	dw	80h dup (?)
STACKE:

PROG	ENDS

	end	begin		; program start address
4

e


