	PAGE	60,80
TITLE	INITIAL	I/O INTERFACE FOR UNIX

	INCLUDE	SRC\GIFDIC.MAC
	INCLUDE	SRC\80186.MAC
	.XALL
SCONDEV EQU	11*64

CSB_MAIN STRUC

DEVNO	DB	?			; DEVICE NUMBER
DEVTYP	DB	?			; MAJOR DEVICE TYPE ( 0 = TTY, 1 = DISC, 2 = RTC
DEVICE	DW	?			; DEVICE DESCRIPTION
MAXRQ	DB	?			; MAX SIMULTANIOUS REQUESTS
NOWRQ	DB	?			; CURRENT REQUEST COUNT

CSB_MAIN ENDS

CSB_DISK STRUC

SECSIZE	DW	?			; PHYSICAL SECTOR SIZE
SIZMSW	DW	?			; MSB OF LAST SECTOR
SIZLSW	DW	?			; LAST SECTOR NUMBER
SECTRK	DW	?			; SECTORS PER TRACK
HEADNO	DW	?			; NUMBER OF HEADS
	DW	2 DUP (?)
ERRCOD	DW	?			; ERROR STATUS CODE
	DW	?			; SPARE ERROR STATUS

	DW	4 DUP (?)

CSB_DISK ENDS


CSB_TTY	STRUC

	DW	7 DUP (?)
CONERR	DW	?
	DW	?

	DW	4 DUP (?)

CSB_TTY	ENDS


CRB_MAIN STRUC

RDEVNO	DB	?			; REQUEST ON DEVICE NUMBER
RDEVTYP	DB	?			; REQUEST ON MAJOR DEVICE TYPE
COMAND	DW	?			; OPERATION CODE
RQCOUNT	DW	?			; REQUEST COUNT
COM1	DW	?			; 1ST PARAMETER
COM2	DW	?			; 2ND PARAMETER
COM3	DW	?			; 3RD PARAMETER
COM4	DW	?			; 4TH PARAMETER
COM5	DW	?			; 5TH PARAMETER
COM6	DW	?			; 6TH PARAMETER
	DW	?
	DW	?

CRB_MAIN ENDS


PGROUP	GROUP	PROG
VSTART	EQU	0

DEBUG	EQU	0			; OPTION UNIX/DEBUG IO
; 0 = UNIX ??

MMCPU1	EQU	1			;NEW MMCPU BOARD
	IF	MMCPU1
STMMCPU	SEGMENT	AT 4000H
STMRF	EQU	VSTART+5
STMMCPU0 DW	?
STMMCPU	ENDS

	ELSE

STMMCPU	SEGMENT	AT 0B000H
STMRF	EQU	0BBH			; REGISTER FILE ACCESS
	ORG	0FFFEH
STMMCPU0 DW	?
STMMCPU	ENDS
	ENDIF

MMCPU	SEGMENT	AT 4000H
MMCRF	EQU	VSTART+3
	ORG	0
SSP0	DW	?
SSP1	DW	?
PC0	DW	?
PC1	DW	?
MMCPU	ENDS

MAILBOX	SEGMENT	AT 4000H
MAILRF	EQU	VSTART+3

; CRB PROGRESS FLAGS
	ORG	0400H
MAILSTART DB	?
	DB	?
	DB	?
START	DB	?			; UNIX, ACTIVE = 1, START REQUEST

	DB	?
	DB	?
	DB	?
BUSY	DB	?			; SYSCON, ACTIVE = 0, REQUEST IN PROGRESS

	DB	?
	DB	?
	DB	?
DONE	DB	?			; SYSCON, ACTIVE = 1, REQUEST COMPLETE

	DB	?
	DB	?
	DB	?
READY	DB	?			; UNIX, ACTIVE = 0, ACKNOWLEDGE COMPLETION

	DB	?
	DB	?
	DB	?
STATUS	DB	?			; SYSCON, ACTIVE = 1, STATUS REPORT ON TASK

	DB	?
	DB	?
	DB	?
GOTST	DB	?			; UNIX, ACTIVE = 0, STATUS RECEIVED

	DB	?
	DB	?
	DB	?
ABORT	DB	?			; UNIX, ACTIVE = 1, ABORT TASK

	DB	?
	DB	?
	DB	?
ABORTED	DB	?			; SYSCON, ACTIVE = 0, ABORTED TASK


; CSB STARTS
	ORG	0420H

CSB1	CSB_MAIN <>
	CSB_DISK <>			; CSB1.DEVICE 1 = DISK DRIVE

CSB2	CSB_MAIN <>
	CSB_TTY	<>			; DEVICE 2 = CONSOLE TTY

CSB3	CSB_MAIN <>
	CSB_TTY	<>			; DEVICE 3 = DTE

CSB4	CSB_MAIN <>
	CSB_TTY	<>			; DEVICE 4 = DCE





	ORG	0500H
; START OF CRBS

CRB1	CRB_MAIN <>			; INITIALLY THE DISK CRB

CRB2	CRB_MAIN <>			; INITIALLY THE CONSOLE OUT

CRB3	CRB_MAIN <>			; INITIALLY THE CONSOLE IN

CRB4	CRB_MAIN <>			; INITIALLY THE DTE OUT

CRB5	CRB_MAIN <>			; INITIALLY THE DTE IN

CRB6	CRB_MAIN <>			; INITIALLY THE DCE OUT

CRB7	CRB_MAIN <>			; INITIALLY THE DCE IN

	ORG	06E0H
	DB	?
INPTR	DB	?
	DB	?
OUTPTR	DB	?

	ORG	06F0H
FIFO	DB	256 DUP(?)




	ORG	07F0H
; BYTE SPACE FOR SIMPLE IO
CHARIN	DB	?
CHAROUT	DB	?

	ORG	07FCH
BYTEIN	DB	?
FLAGIN	DB	?
BYTOUT	DB	?			; OUTPUT BYTE
FLAGOUT	DB	?			; BIT 0 = OUTPUT

MAILBOX	ENDS


; MY EQUATES FOR THE INTERFACE

UNIX_DRIVE EQU	3			; USE DRIVE D:

UNIX_UPPER EQU	0005H			; UPPER START ADDRESS

UNIX_START EQU	0000H			; STARTING ADDRESS
UNIX_STACK EQU	0800H			; INITIAL STACK POINTER

RFPORT	EQU	0E204H			; ACCESS TO REGISTER FILE
RFDMA	EQU	0E206H			; ACCESS TO DMA R FILE

CR	EQU	0DH
LF	EQU	0AH
ETX	EQU	04H

EXIT	EQU	4C00H

CRB_SIZE EQU	32			; SIZE OF ONE CRB
CRBMAX	EQU	7
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	CS:PGROUP

BEGIN:					; SET UP STACK
	PUSH	CS
	POP	SS
	MOV	SP,OFFSET PGROUP:STACKE
;

	MOV	DX,05CH
	MOV	AH,0FH			; OPEN FILE
	INT	21H
	CMP	AL,0
	JZ	FILEOPEN

	MOV	DI,05CH			; FCB
	PUSH	DS
	POP	ES
	PUSH	CS
	POP	DS			; SWAP SEGMENTS AROUND
	MOV	SI,OFFSET CS:BOOTNAME
	MOV	CX,37			; NO OF BYTES
	REP	MOVSB			; COPY IT
	PUSH	ES
	POP	DS			; RESTORE DS

	MOV	DX,05CH
	MOV	AH,0FH			; OPEN FILE
	INT	21H
	CMP	AL,0
	JZ	FILEOPEN
	MOV	DX,OFFSET PGROUP:ERRMES
	ADD	DX,100H
	MOV	AH,9			; PRINT STRING
	INT	21H
	MOV	AH,4CH			; TERMINATE
	INT	21H			; QUIT
FILEOPEN:
	MOV	DX,RFPORT
	MOV	AL,MMCRF		; 50000H ON 68K IS DESTINATION
	OUT	DX,AL
	MOV	DX,RFDMA
	OUT	DX,AL			; SET BOTH RFS FOR TRANSFER
	MOV	AX,9000H
	MOV	BX,0FF80H		; 0-80H
	PUSH	AX
	PUSH	BX
	PUSH	DS			; SAVEIT
GETBLOCK:
	POP	AX			; REALLY DS
	POP	DX
	POP	DS			; DESTINATION DS:DX
	ADD	DX,80H			; ONE BLOCK
	PUSH	DS
	PUSH	DX			; SAVE FOR NEXT TIME
	PUSH	AX			; SAVE IT AGAIN
	MOV	AH,1AH
	INT	21H			; SET DMA

	POP	DS
	PUSH	DS			; GET AND SAVE DS
	MOV	DX,5CH			; POINT TO FCB
	MOV	AH,14H			; READ
	INT	21H
	CMP	AL,00
	JZ	GETBLOCK		; REPEAT TILL DONE

OKREAD:
;
	POP	AX
	POP	AX
	POP	AX			; CLEAR STACK

	XOR	CX,CX
	INT	99H			; LINK UP TO GIFDIC
	MOV	AX,ES:[DI.GHNDLR]
	MOV	CS:GIFL,AX
	MOV	AX,ES:[DI.SPGROUP]
	MOV	CS:GIFH,AX
;
;
;
;
	MOV	AL,1
	MOV	CH,1
	MOV	CL,0
	MOV	DH,40H
	MOV	DL,2
	GIFCALL	DSKDEV,SSTATUS,0
	MOV	AL,3
	MOV	CH,1
	MOV	CL,0
	MOV	DH,40H
	MOV	DL,2
	GIFCALL	DSKDEV,SSTATUS,0
	XOR	AX,AX
	MOV	ES,AX
	MOV	AL,1
	MOV	DI,66H
	MOV	CX,22AAH
	MOV	DX,6
	GIFCALL	DSKDEV,SSTATUS,0
	MOV	AL,3
	MOV	DI,2310H
	MOV	CX,83AAH
	GIFCALL	DSKDEV,SSTATUS,0
	MOV	AL,UNIX_DRIVE

	MOV	BX,DSKDEV
	GIFCALL	,RESET,0		; RESET THE DISK
;
;
	MOV	DX,RFPORT		; REGISTER FILE PORT
	MOV	AL,MMCRF		; MAILBOX ACCESS
	OUT	DX,AL			; SET IT UP
	MOV	AX,SEG MMCPU		; ACCESS ADDRESS
	MOV	DS,AX
	ASSUME	DS:MMCPU

	MOV	CL,8			; FOR SWAP
	MOV	SSP0,0			; INITIAL STACK POINTER UPPER
	MOV	SSP1,UNIX_STACK		; INITIAL STACK
	ROR	SSP1,CL			; SWAP
	MOV	PC0,UNIX_UPPER		; START FOR BOOT
	MOV	PC1,UNIX_START		; INITIAL CODE START
	ROR	PC0,CL			; SWAP


	CALL	SET_MAIL		; POINT TO MAILBOXES
	ASSUME	DS:MAILBOX

	XOR	AX,AX			; ZERO AX
	MOV	DI,OFFSET MAILBOX:MAILSTART
	MOV	CX,200H			; 400H - 7FFH / 2
	PUSH	DS
	POP	ES
	REP	STOSW			; CLEAR MAILBOXES

	MOV	BX,0FFH
	MOV	BUSY,BL
	MOV	GOTST,BL
	MOV	ABORTED,BL

	MOV	CL,8

	MOV	CSB1.DEVNO,1
	MOV	CSB1.DEVTYP,1
	MOV	CSB1.DEVICE,0
	MOV	CSB1.MAXRQ,1
	MOV	CSB1.NOWRQ,0
	MOV	CSB1.SECSIZE,512
	ROR	CSB1.SECSIZE,CL		; SWAP
	MOV	CSB1.SIZMSW,0
	MOV	CSB1.SIZLSW,088AAH
	ROR	CSB1.SIZLSW,CL		; SWAP
	MOV	CSB1.SECTRK,11
	ROR	CSB1.SECTRK,CL
	MOV	CSB1.HEADNO,6
	ROR	CSB1.HEADNO,CL		; SWAP
	MOV	CSB1.ERRCOD,0

	MOV	CSB2.DEVNO,2
;	MOV	CSB2.DEVTYP,0
;	MOV	CSB2.DEVICE,0
	MOV	CSB2.MAXRQ,2
;	MOV	CSB2.NOWRQ,0

	MOV	CSB3.DEVNO,3
;	MOV	CSB3.DEVTYP,0
;	MOV	CSB3.DEVICE,0
	MOV	CSB3.MAXRQ,2
;	MOV	CSB3.NOWRQ,0

	MOV	CSB4.DEVNO,4
;	MOV	CSB4.DEVTYP,0
;	MOV	CSB4.DEVICE,0
	MOV	CSB4.MAXRQ,2
;	MOV	CSB4.NOWRQ,0

	MOV	CRB1.RQCOUNT,0
	MOV	CRB2.RQCOUNT,0
	MOV	CRB3.RQCOUNT,0
	MOV	CRB3.RQCOUNT,0
	MOV	CRB4.RQCOUNT,0


	MOV	FLAGIN,01		; NO INPUT
; ALL MAILBOX SET UP.


	PUSH	CS
	POP	ES
	MOV	DI,OFFSET SIGNON	; SAY HELLO TO THE FOLKS
	CALL	PTEXT


	MOV	DX,RFPORT		; START UP THE 68K CPU
	MOV	AL,STMRF
	OUT	DX,AL
	MOV	AX,SEG STMMCPU
	MOV	DS,AX
	ASSUME	DS:STMMCPU
	MOV	AX,STMMCPU0

	MOV	CS:PENDING,0		; NO DONE PENDING

DOMAILBOX:				; CHECK ROUND THE MAILBOXES

	CALL	SET_MAIL		; POINT TO MAILBOXES
	ASSUME	DS:MAILBOX

	TEST	FLAGOUT,01H		; ANY OUTPUT ?
	JZ	NO_BYTES
	MOV	AL,BYTOUT		; GET IT
	PUSH	DS
	GIFCALL	SCONDEV,WRITE,WAITNR	; PRINT IT
	POP	DS
	AND	FLAGOUT,0FEH		; CLEAR FLAG
NO_BYTES:

	TEST	FLAGIN,01H		; INPUT
	JNZ	NO_INBYTE
	PUSH	DS
	GIFCALL	SCONDEV,READ,NOOPT	; READ IT
	POP	DS
	JC	NO_INBYTE
	MOV	DS:BYTEIN,AL
	OR	DS:FLAGIN,01
NO_INBYTE:

	MOV	SI,CS:CONCNT		; GET POINTER
RECONOUT:
	CMP	SI,CS:CONSIZ		; ANYTHING ??
	JZ	NOCONOUT
	MOV	AL,CS:[SI]
	GIFCALL	SCONDEV,WRITE,NOOPT	; TRY TO OUTPUT IT
	JC	NOCONOUT

	INC	CS:CONCNT
	INC	SI			; POINT TO NEXT
	JMP	RECONOUT

NOCONOUT:

	MOV	SI,CS:DTECNT		; GET POINTER
REDTEOUT:
	CMP	SI,CS:DTESIZ		; ANYTHING ??
	JZ	NODTEOUT
	MOV	AL,CS:[SI]
	GIFCALL	DTEDEV,WRITE,NOOPT	; TRY TO OUTPUT IT
	JC	NODTEOUT

	INC	CS:DTECNT
	INC	SI			; POINT TO NEXT
	JMP	REDTEOUT

NODTEOUT:

	MOV	SI,CS:DCECNT		; GET POINTER
REDCEOUT:
	CMP	SI,CS:DCESIZ		; ANYTHING ??
	JZ	NODCEOUT
	MOV	AL,CS:[SI]
	GIFCALL	KVDDEV,WRITE,NOOPT	; TRY TO OUTPUT IT
	JC	NODCEOUT

	INC	CS:DCECNT
	INC	SI			; POINT TO NEXT
	JMP	REDCEOUT

NODCEOUT:

	MOV	AH,0

	MOV	AL,READY		; 0 IF NO ACTIVITY
	AND	DONE,AL			; THEN CLEAR ANY AT IDLE

	MOV	AL,START		; GET ANY
	MOV	BL,CS:PENDING		; WAITING FOR NO START
	AND	CS:PENDING,AL		; UPDATE PENDING IF NO START
	XOR	BL,CS:PENDING		; WHATS NEW ?
	XOR	BUSY,BL			; CLEAR BUSY
	XOR	DONE,BL			; SET DONE

	NOT	AL
	AND	BUSY,AL			; FORCE BUSY IF START

	MOV	AL,BUSY			; GET IT
	OR	AL,CS:PENDING		; PICK OUT ACTIONS REQUIRED

	XOR	AL,0FFH			; INVERSE LOGIC
	JNZ	DO_THIS_BIT
	JMP	DOMAILBOX
DO_THIS_BIT:
	MOV	CX,CRBMAX		; HOW MANY MATTER

	MOV	SI,OFFSET MAILBOX:CRB1	; POINT TO FIRST CRB

	MOV	BX,1

CHECK_CRB:
	TEST	AX,BX			; THIS CRB ?
	JZ	NOT_THIS
	PUSHA				; SAVE THE STATE
	CALL	DO_CRB			; DO THE CRB
	PUSHF
	CALL	SET_MAIL		; POINT TO MAILBOX AGAIN
	POPF
	POPA				; RESTORE ALL
	JC	NOT_THIS		; NOT FINISHED
	OR	CS:PENDING,BL		; FLAG IT DONE
	XOR	AX,BX			; CLEAR THIS BIT
	JNZ	NOT_THIS
	JMP	DOMAILBOX		; ANY MORE BITS ??
NOT_THIS:
	SHL	BX,1			; NEXT BIT
	ADD	SI,CRB_SIZE		; POINT TO NEXT
	LOOP	CHECK_CRB		; DO ALL CRBS
	JMP	DOMAILBOX		; REPEAT


DO_CRB:
	CMP	[SI].RDEVTYP,00		; TTY ??
	JNZ	NOTCON
	JMP	CONSOLE
NOTCON:
	CMP	[SI].RDEVTYP,01		; DISK ??
	JZ	IS_DISK
	CALL	BADCRB
	CLC
	RET				; CLEAR REQUEST AND EXIT

IS_DISK:
	CMP	[SI].DEVNO,01		; DISK CSB
	JZ	GOODDEV
	CMP	[SI].DEVNO,02
	JZ	GOODDEV
	CALL	BADCRB
	CLC
	RET				; ERROR EXIT
GOODDEV:
	MOV	AL,[SI].DEVNO
	MOV	CS:DRVNO,AL		; SAVE NUMBER
	MOV	AX,[SI].COMAND		; GET COMMAND\
	CMP	AL,01			; DISK COMMAND ?
	JNZ	BADDISK
	AND	AH,7FH			; MASK FLUSH BIT
	CMP	AH,01			; READ
	JZ	DISK_WRAP
	CMP	AH,02
	JZ	DISK_WRAP
BADDISK:
	CALL	BADCOMAND
	CLC
	RET


;***********************************************************
;
;	FIRST HACK AT PAGE WRAP
;
;***********************************************************

DISK_WRAP:

	CMP	[SI].COM3,0		; DONE ALL ??
	JNZ	DOSOME
	CLC
	RET				; GOOD RETURN
DOSOME:
	MOV	BX,[SI].COM4		; UPPER ADDRESS
	SWAP	BX			; BYTE SWAP
	AND	BX,07			; BITS BELOW 1/2 MB
	MOV	DX,[SI].COM5		; LOWER ADDRESS
	SWAP	DX			; BYTE SWAP
	MOV	CX,0			; SECTORS DONE
	MOV	AX,511			; SECTOR SIZE - 1
LOOPSEC:
	ADD	DX,AX			; ADDRESS OF END OF BLOCK
	MOV	AX,512
	JC	ISCARRY			; CARRY INTO BX
NEXTSEC:
	INC	CX
	SWAP	CX			; BYTE SWAP
	CMP	CX,[SI].COM3		; DONE ALL SECTORS
	PUSHF
	SWAP	CX			; BYTE SWAP
	POPF
	JNZ	LOOPSEC			; NO, GO BACK
	JMP	DISKEX			; EXECUTE DISK

ISCARRY:
	INC	BX			; DO CARRY
	TEST	BX,07			; OVER A BOUNDARY ??
	JNZ	NEXTSEC			; GO ONWARD TILL DONE
	CMP	CX,0			; ANY TO DO ??
	JZ	GOODISK			; NO, SKIP
	PUSH	[SI].COM3		; SAVE TOTAL SECTOR COUNT
	PUSH	DX			; LOWER ADDRESS
	PUSH	BX			; UPPER ADDRESS
	PUSH	CX			; GOOD SECTORS
	SWAP	CX
	MOV	[SI].COM3,CX		; DO THIS NUMBER
	PUSH	SI
	CALL	DISKEX			; DO SO FAR
	MOV	BP,AX			; SAVE ERROR CODE
	POP	SI			; POINT TO CRB AGAIN
	POP	CX
	POP	BX
	POP	DX
	POP	AX
	SWAP	AX			; GET IT OUR WAY ROUND
	CMP	BP,0			; NO ERRORS ??
	JZ	GOODISK
	CLC				; QUITING, FLAG DONE
	RET
GOODISK:
	SUB	AX,CX			; SECTORS LEFT
	MOV	BX,[SI].COM2		; GET START SECTOR
	SWAP	BX
	ADD	BX,CX			; INCREASE THE START SECTOR
	PUSHF
	SWAP	BX
	POPF
	MOV	[SI].COM2,BX		; STORE IT AWAY
	JNC	NOEXTRA
	MOV	BX,[SI].COM1		; DO UPPER BYTE
	SWAP	BX
	INC	BX
	SWAP	BX
	MOV	[SI].COM1,BX		; STORE IT BACK
NOEXTRA:
	SWAP	AX
	MOV	[SI].COM3,AX		; NEW SECTOR COUNT
	MOV	AX,[SI].COM4		; UPPER ADDRESS
	SWAP	AX
	AND	AX,0FFF8H		; MASK LOWER BITS TO ZERO
	ADD	AX,0008H		; NEXT BOUNDARY
	SWAP	AX
	MOV	[SI].COM4,AX		; STORE IT BACK
	INC	DX			; START OF NEXT SECTOR
	SWAP	DX
	MOV	[SI].COM5,DX		; NEW LOWER BOUNDARY
	SWAP	DX
	CMP	DX,512			; IF EXACT SECTOR
	JNZ	DOBITWISE		; HERE IS TROUBLE
	MOV	[SI].COM5,0		; BACK TO START
	MOV	AX,[SI].COM3		; GET SECTOR COUNT
	SWAP	AX
	INC	AX			; ONE EXTRA
	SWAP	AX
	MOV	[SI].COM3,AX		; STORE AWAY
	JMP	DISK_WRAP		; PROCEED

DOBITWISE:
	TEST	[SI].COMAND,0100H	; READ BIT
	JNZ	SKIP_MOVE		; IF ITS A READ
	CALL	MOVE_DATA		; COPY OVER BEFORE WRITE
SKIP_MOVE:
	CALL	DISK_BIT		; DO THE PHYSICAL I/O
	JNC	GOOD_BIT		; NO ERRORS
	JMP	DISK_EXIT		; ELSE REPORT AND END
GOOD_BIT:
	TEST	[SI].COMAND,0100H	; READ BIT
	JNZ	MOVE_DATA		; IF ITS A WRITE
	JMP	DISK_WRAP		; DONE

MOVE_DATA:
	PUSH	DS
	PUSH	SI			; SAVE THESE

	MOV	BX,[SI].COM5		; GET LOWER ADDRESS
	PUSH	BX			; AND SAVE LOWER ADDRESS
	MOV	AX,[SI].COM4		; GET UPPER ADDRESS
	PUSH	AX			; SAVE UPPER ADDRESS

	SWAP	AX
	DEC	AX			; DOWN ONE
	SWAP	AX
	MOV	[SI].COM4,AX		; REDUCED UPPER ADDRESS

	SWAP	BX
	PUSH	BX			; SAVE SECOND COUNT
	MOV	AX,512			; SECTOR SIZE
	SUB	AX,BX			; FIRST SIZE
	SUB	BX,512			; REDUCE LOWER ADDRESS
	SWAP	BX
	MOV	[SI].COM5,BX		; PUT IT AWAY
	CALL	REAL_MOVE
	CALL	SET_MAIL		; BACK TO MAILBOXES
	POP	AX			; NEXT COUNT
	MOV	[SI].COM5,00		; LOWER ADDRESS START AT 0
	POP	BX			; NEW UPPER ADDRESS
	MOV	[SI].COM4,BX		; SET IT UP
	CALL	REAL_MOVE
	CALL	SET_MAIL		; BOXES AGAIN
	POP	BX
	MOV	[SI].COM5,BX		; NEW LOWER ADDRESS
	POP	SI
	POP	DS			; RESTORE
	RET


REAL_MOVE:
	PUSH	DS
	PUSH	SI
	PUSH	AX			; SAVE COUNT
	LEA	SI,[SI].COM4		; POINT TO ADDRESS
	CALL	GET_ADDR		; GET ADDRESS MAKEUP
	POP	CX			; COUNT
	MOV	DX,RFPORT		; GET REGISTER FILE
	PUSH	CS
	POP	DS
	POP	BX			; USE AS POINTER
	PUSH	BX
	MOV	SI,OFFSET PGROUP:DBUFFER; BUFFER
	TEST	[BX].COMAND,0100H	; READ ??
	OUT	DX,AL			; DO VME ACCESS
	JNZ	NO_SWAP
	PUSH	ES
	PUSH	DS
	XCHG	DI,SI			; SWAP THESE
	POP	ES
	POP	DS
NO_SWAP:
	CLD
	REP	MOVSB			; MOVE IT
	POP	SI
	POP	DS
	RET

DISK_BIT:
	MOV	DX,[SI].COM2		; START NUMBER
	SWAP	DX
	DEC	DX
	MOV	CX,1			; ONE SECTOR
	PUSH	SI
	PUSH	DS
	PUSH	CS
	POP	ES			; DESTINATION SEGMENT
	MOV	DI,OFFSET PGROUP:DBUFFER
	MOV	AX,[SI].COM1		; UPPER SECTOR
	SHRI	AX,5			; SEMISWAP
	ADD	AL,1			; DISK B:
	CMP	CS:DRVNO,02		; DRIVE 2 ??
	JZ	ISDRV2
	ADD	AL,2			; DRIVE D:
ISDRV2:
	TEST	[SI].COMAND,0100H	; READ BIT
	JZ	BIT_WRITE
	GIFCALL	DSKDEV,READ,NOOPT
	JMP	WAS_READ
BIT_WRITE:
	GIFCALL	DSKDEV,WRITE,NOOPT
;
WAS_READ:
	POP	DS
	POP	SI
	RET				; DONE PHYSICAL DISK

; NOW DO BLOCK TRANSFERS !




;**************************************************************
;
;	END OF EXPERIMENTAL CODE
;
;**************************************************************

DISKEX:
	TEST	[SI].COMAND,0100H	; READ BIT
	JZ	DISK_WRITE


DISK_READ:
	CALL	SET_DISK		; TEST & SET PARAMETERS
	MOV	DX,RFDMA		; OWN RF
	OUT	DX,AL			; SET IT UP
	MOV	DX,BX			; GET START
	MOV	AL,3			; DRIVE 3 (D:)
	CMP	CS:DRVNO,01
	JZ	ISDRVA
	MOV	AL,1			; DRIVE B:
ISDRVA:
	GIFCALL	DSKDEV,READ,NOOPT	; DO IT
	JMP	DISK_EXIT

DISK_WRITE:
	CALL	SET_DISK		; TEST & SET PARAMETERS
	MOV	DX,RFPORT		; SHARE PORT WITH MBOX
	OUT	DX,AL			; SET IT UP
	MOV	DX,BX			; GET START
	MOV	AL,3			; DRIVE 3 (D:)
	CMP	CS:DRVNO,01
	JZ	ISDRV1
	MOV	AL,01
ISDRV1:
	GIFCALL	DSKDEV,WRITE,NOOPT	; DO IT
;
	JMP	DISK_EXIT

CONSOLE:
	CMP	[SI].RDEVNO,02		; CONSOLE DEVICE ??
	JZ	OK_CON
	CMP	[SI].RDEVNO,03		; DTE
	JZ	OK_DTE
	CMP	[SI].RDEVNO,04		; DCE
	JZ	OK_DCE
	CALL	BADCRB
	CLC
	RET
OK_CON:
	MOV	BX,SCONDEV
	CMP	[SI].COMAND,0302H	; FIFO MODE
	JNZ	NOTCONFIN
	JMP	DTEFIN
NOTCONFIN:
	CMP	[SI].COMAND,0102H	; INPUT ?
	JZ	CONIN
	CMP	[SI].COMAND,0202H	; OUTPUT ??
	JNZ	NOTCONOUT
	JMP	CONOUT
NOTCONOUT:
	CALL	BADCOMAND
	CLC
	RET

OK_DTE:
	MOV	BX,DTEDEV
	CMP	[SI].COMAND,0302H	; FIFO MODE
	JZ	DTEFIN
	CMP	[SI].COMAND,0102H	; INPUT ?
	JZ	DTEIN
	CMP	[SI].COMAND,0202H	; OUTPUT ??
	JNZ	BADDTE
	JMP	DTEOUT
BADDTE:
	CALL	BADCOMAND
	CLC
	RET

OK_DCE:
	MOV	BX,KVDDEV
	CMP	[SI].COMAND,0302H	; FIFO MODE
	JNZ	NOTDCEFIN
	JMP	DTEFIN
NOTDCEFIN:
	CMP	[SI].COMAND,0102H	; INPUT ?
	JNZ	TRYOTHER
	JMP	DCEIN
TRYOTHER:
	CMP	[SI].COMAND,0202H	; OUTPUT ??
	JNZ	BADDCE
	JMP	DCEOUT
BADDCE:
	CALL	BADCOMAND
	CLC
	RET

CONIN:
	PUSH	DS
	GIFCALL	SCONDEV,READ,NOOPT	; TRY IT
	POP	DS
	JC	NO_INPUT
	PUSH	AX
	LEA	SI,[SI].COM4		; POINT TO ADDRESS
	CALL	SET_ADDR		; POINT TO IT
	POP	AX
	MOV	ES:[DI],AL		; SET IT UP
	CLC
NO_INPUT:
	RET

DTEIN:
	PUSH	DS
	GIFCALL	DTEDEV,READ,NOOPT	; TRY IT
	POP	DS
	JC	DTE_INPUT
	PUSH	AX
	LEA	SI,[SI].COM4		; POINT TO ADDRESS
	CALL	SET_ADDR		; POINT TO IT
	POP	AX
	MOV	ES:[DI],AL		; SET IT UP
	CLC
DTE_INPUT:
	RET


DTEFIN:					; INPUT TO FIFO

	MOV	AX,[SI].COM1		; IN POINTER
	MOV	CX,[SI].COM2		; OUT POINTER
	MOV	DX,[SI].COM3		; FIFO SIZE
	SWAP	AX
	SWAP	CX
	SWAP	DX
	PUSH	AX			; OLD POINTER
	INC	AX			; NEXT
	CMP	AX,DX			; WRAP ROUND ?
	JNZ	NOWRAP
	XOR	AX,AX			; RESTART
NOWRAP:
	PUSH	AX			; NEXT POINTER
	CMP	AX,CX			; POINTERS SAME ??
	JNZ	TRYINPUT
FIFEXIT:
	POP	AX
	POP	AX			; CLEAR STACK
	STC				; NOT FINISHED
	RET

TRYINPUT:
	PUSH	DS
	GIFCALL	,READ,NOOPT		; BX IS CHANNEL
	POP	DS
	JC	FIFEXIT			; NO DATA
	PUSH	AX
	PUSH	SI			; SAVE POINTER TO CRB
	LEA	SI,[SI].COM4		; POINT TO ADDRESS
	CALL	SET_ADDR		; POINT TO IT
	POP	SI			; RECOVER CRB
	POP	AX			; RECOVER DATA
	POP	DX			; NEW POINTER
	POP	BX			; OLD POINTER
	MOV	ES:[BX.DI],AL		; SET IT UP
	MOV	BL,DH			; SAVE POINTER
	MOV	BH,DL			; WITH SWAP
	CALL	SET_MAIL		; RESTORE MAILBOXES
	MOV	[SI].COM1,BX		; NEW POINTER
	STC
	RET				; NOT FINISHED

DCEIN:
	PUSH	DS
	GIFCALL	KVDDEV,READ,NOOPT	; TRY IT
	POP	DS
	JC	DCE_INPUT
	PUSH	AX
	LEA	SI,[SI].COM4		; POINT TO ADDRESS
	CALL	SET_ADDR		; POINT TO IT
	POP	AX
	MOV	ES:[DI],AL		; SET IT UP
	CLC
DCE_INPUT:
	RET


CONOUT:
	MOV	AX,CS:CONCNT		; POINTER
	CMP	AX,CS:CONSIZ		; BUSY ?
	JNZ	CON_BUSY

	MOV	CX,[SI].COM3		; DATA COUNT
	SWAP	CX
	PUSH	CX
	ADD	CX,OFFSET PGROUP:CONBUF
	MOV	CS:CONSIZ,CX
	MOV	CS:CONCNT,OFFSET PGROUP:CONBUF

	LEA	SI,[SI].COM4
	CALL	SET_ADDR		; POINT TO DATA
	PUSH	ES
	POP	DS
	PUSH	CS
	POP	ES
	MOV	SI,DI			; POINT TO DATA
	MOV	DI,OFFSET PGROUP:CONBUF
	POP	CX
	REP	MOVSB
	CLC
	RET

CON_BUSY:
	STC
	RET				; RETURN BUSY

DTEOUT:
	MOV	AX,CS:DTECNT		; POINTER
	CMP	AX,CS:DTESIZ		; BUSY ?
	JNZ	DTE_BUSY

	MOV	CX,[SI].COM3		; DATA COUNT
	SWAP	CX
	PUSH	CX
	ADD	CX,OFFSET PGROUP:DTEBUF
	MOV	CS:DTESIZ,CX
	MOV	CS:DTECNT,OFFSET PGROUP:DTEBUF

	LEA	SI,[SI].COM4
	CALL	SET_ADDR		; POINT TO DATA
	PUSH	ES
	POP	DS
	PUSH	CS
	POP	ES
	MOV	SI,DI			; POINT TO DATA
	MOV	DI,OFFSET PGROUP:DTEBUF
	POP	CX
	REP	MOVSB
	CLC
	RET

DTE_BUSY:
	STC
	RET				; RETURN BUSY

DCEOUT:
	MOV	AX,CS:DCECNT		; POINTER
	CMP	AX,CS:DCESIZ		; BUSY ?
	JNZ	DCE_BUSY

	MOV	CX,[SI].COM3		; DATA COUNT
	SWAP	CX
	PUSH	CX
	ADD	CX,OFFSET PGROUP:DCEBUF
	MOV	CS:DCESIZ,CX
	MOV	CS:DCECNT,OFFSET PGROUP:DCEBUF

	LEA	SI,[SI].COM4
	CALL	SET_ADDR		; POINT TO DATA
	PUSH	ES
	POP	DS
	PUSH	CS
	POP	ES
	MOV	SI,DI			; POINT TO DATA
	MOV	DI,OFFSET PGROUP:DCEBUF
	POP	CX
	REP	MOVSB
	CLC
	RET

DCE_BUSY:
	STC
	RET				; RETURN BUSY


SET_ADDR:				; POINT TO VME ADDRESS
	CALL	GET_ADDR		; CALCULATE
	MOV	DX,RFPORT		; RF PORT ADDRESS
	OUT	DX,AL			; SET UP RF
	RET				; DONE

GET_ADDR:				; CALCULATE VME ADDRESS

	MOV	AX,[SI]			; UPPER ADDRESS
	SWAP	AX
	ADD	AX,VSTART		; START ADDRESS OFFSET ON VME
	AND	AX,00F8H		; UPPER 5 BITS
	MOV	BX,[SI+4]		; VME ACCESS CODE
	SWAP	BX
	AND	BX,0007H		; VALID BITS
	OR	AX,BX			; DATA FOR RF IN AL
	MOV	BX,[SI]			; UPPER ADDRESS
	SWAP	BX
	MOV	DX,[SI+2]		; LOWER ADDRESS
	SWAP	DX
	MOV	CX,4
	SHR	DX,CL			; REDUCE TO SEGMENT SIZE
	SHL	BX,CL			; BITS UP IN BL
	OR	DH,BL
	AND	DX,7FFFH		; CLEAR MSB
	ADD	DX,4000H		; LAST MOVE
	MOV	ES,DX			; GOT IT IN SEG REG
	MOV	DI,[SI+2]		; LOWER ADDRESS
	SWAP	DI
	AND	DI,0FH			; OFFSET
	RET



SET_DISK:
	PUSH	SI			; SAVE OUR POINTER
	LEA	SI,[SI].COM4		; ADDRESS DATA
	CALL	GET_ADDR		; GET VME DATA
	POP	SI
	MOV	CX,[SI].COM3		; SECTOR COUNT
	SWAP	CX
	MOV	BX,[SI].COM2		; START SECTOR NUMBER
	SWAP	BX
	RET

DISK_EXIT:
	PUSH	AX
	CALL	SET_MAIL		; POINT TO MAIL BOXES
	POP	AX
	MOV	AL,0			; NOT VALID STATUS IN AL
	CMP	CS:DRVNO,01		; FIRST DISK ??
	JNZ	ISSECONDISK
	MOV	CSB1.ERRCOD,AX		; SEND IT
	CLC
	RET

ISSECONDISK:
	MOV	CSB2.ERRCOD,AX		; SEND IT TO SECOND CSB
	CLC
	RET

SET_MAIL:				; ACCESS MAILBOXES
	MOV	DX,RFPORT		; REGISTER FILE PORT
	MOV	AL,MAILRF		; MAILBOX ACCESS
	OUT	DX,AL			; SET IT UP
	MOV	AX,SEG MAILBOX		; ACCESS ADDRESS
	MOV	DS,AX
	RET
ERRFULL:
	MOV	DI,OFFSET FIFOFLOW
	JMP	PERR

PWRITE:
	MOV	DI,OFFSET WRITER
	CALL	PERR
	XOR	AX,AX
	RET


BADCRB:
	MOV	DI,OFFSET CRBERR
	JMP	PERR
BADCOMAND:
	MOV	DI,OFFSET COMERR
	JMP	PERR
BADSECT:
	MOV	DI,OFFSET SECERR
	JMP	PERR
BADDEV:
	MOV	DI,OFFSET DEVERR
	JMP	PERR
BADTYPE:
	MOV	DI,OFFSET TYPERR

PERR:
PTEXT:					; PRINT ALL CHARACTERS FROM ES:DI TO 04H ( ETX )
	PUSH	CS
	POP	ES			; MESSAGES ARE IN CS
	JMP	PTEXT1			; STARTING POINT
PRINTONE:
	PUSH	ES
	PUSH	DI
	GIFCALL	SCONDEV,WRITE,WAITNR	; PRINT 1, NO RETURN TILL DONE
	POP	DI
	POP	ES
PTEXT1:
	MOV	AL,ES:[DI]		; GET CHARACTER
	INC	DI			; NEXT
	CMP	AL,ETX
	JNE	PRINTONE		; OUTPUT ONE
	RET


SIGNON:	DB	LF,LF,CR,'1st level UNIX I/O System',CR,LF
	DB	'Starting UNIX now.',LF,CR,ETX

CRBERR:	DB	CR,LF,'Illegal CRB requested !',CR,LF,ETX

COMERR:	DB	CR,LF,'Bad command.',CR,LF,ETX
SECERR:	DB	CR,LF,'Bad disc sector.',CR,LF,ETX
DEVERR:	DB	CR,LF,'Bad disc device.',CR,LF,ETX
TYPERR:	DB	CR,LF,'Bad disc type.',CR,LF,ETX


BOOTNAME: DB	0,'BOOT    UNX'
	DB	22 DUP (0)		; DEFAULT FILE NAME

WRITER:	DB	CR,LF,'Disk write request refused !!',CR.LF,ETX

ERRMES:	DB	0AH,0DH,'Boot.unx file not found.',0AH,0DH,'$'

FIFOFLOW: DB	'.',ETX

;
GIFDIC	LABEL	DWORD
GIFL	DW	?
GIFH	DW	?
;
;
DRVNO	DB	?
	DB	?
	DB	?
	DB	?
PENDING	DB	?

DBUFFER	DB	512 DUP (?)		; DISK BUFFER FOR WRAP


CONBUF	DB	400H DUP (?)		; OUTPUT BUFFER
CONCNT	DW	?
CONSIZ	DW	?

DTEBUF:	DB	400H DUP (?)		; OUTPUT BUFFER
DTECNT	DW	?
DTESIZ	DW	?

DCEBUF:	DB	400H DUP (?)		; OUTPUT BUFFER
DCECNT	DW	?
DCESIZ	DW	?

; SPACE FOR SYSTEM STACK

	DW	80H DUP (?)
STACKE:

PROG	ENDS

	END	BEGIN			; PROGRAM START ADDRESS
4

E


