	page	60,132
TITLE CPM68K LOADER AND I/O HANDLER

;	OVERVIEW.
;
;	     This program is loads the CP/M 68K operating system from
;	disk and sends it to the memory of the COLEX MMCPU card. It then
;	loads the reset vectors for the 68000 and releases the MMCPU
;	RESET line. The BIOS for this CP/M 68K implementation is desig-
;	ned to flag the IOP ( I/O processor, in this case the COLEX
;	VME Syscon ) that I/O needs to be performed. Having done this
;	the MMCPU/68000 has no further responsibility for I/O. The
;	BIOS must now wait for the IOP to acknowledge. Then the
;	on board operating system may now schedule another task in the
;	full knowledge that the I/O has been performed.
;	     It is now the responsibility of the IOP to recognise
;	that an I/O function has been requested and to ensure that 
;	the I/O is performed. In reality the IOP transfers the data
;	into or out of MMCPU work area and informs the 68K operating
;	system that the I/O has been performed. The IOP now actually
;	performs the I/O to the I/O devices. This may happen instantly
; 	or it may be delayed until it is more efficient for it to take
;	place, as is often the case with disk I/O.
;	     Disk I/O in this implementation is managed using a disk
;	cashe. The IOP reserves as much memory as is availabe to it
;	for a disk buffer, in which it holds the entire directory for
;	the 68K operating system. This means that any directory
;	reference does not necessitate the physical movement of the 
;	head on the drive. Also as blocks are read in from the disk
;	they are buffered and held in RAM and may be read and written
;	in a quick and easy fashion, also without any physical disk
;	access. A least recently used algorithm is used to determine
;	which currently RAM based block is to be over-written in 
;	order to make room for a new data block to be read into
;	RAM. Directory blocks are never over-written, "dirty blocks"
;	i.e. those which have been written to but not returned to
;	disk are not over-written and are all returned to disk at the
;	same time i.e. when a buffer flush request is initiated by
;	the MMCPU board. Floppy writes are handled slightly 
;	differently so as to avoid confusion with different floppy
;	diskettes. These, along with directory writes are written
;	to the disk/diskette immediately.


;	INCLUDES AND EQUATES.
;	--------------------

	include	mac\gifmac.mac
	include	mac\xinstr.mac
	.LIST
PGROUP	GROUP	PROG

	extrn	baserf:abs
	extrn	baseds:abs
	extrn	loadoff:abs
;	extrn	mailseg:abs
	extrn	startoff:abs
	extrn	filesize:abs
	extrn	cpmsize:abs
	extrn	sign_on:far

cr	equ 0dh
lf	equ 0ah
spool	equ 100h
mailseg	equ 7000h
;
;	CURBLKS is the linked list of pointers to the disk sectors
;	currently held in ram.
;
secnum equ 0	; MSDOS sector number
drvnum equ 2	; MSDOS drive number
blklink	equ 4	; forward link
revlink equ 6	; backward link
blkseg equ 8	; segment of data buffer
dirind equ 0ah	; directory block indicator
flshind equ 0bh	; flush request indicator
sploff equ 0ch

mmcpu segment at baseds
	org	0
ssp0	dw ?
ssp1	dw ?
pc0	dw ?
pc1	dw ?
;
	org	0300h
psize	dw ?
cseg	dw ?
endseg	dw ?
eseg	dw ?
maxbks	dw ?
fbuf	dw ?
;
	org	mailseg
flgcin	db ?
conin	db ?
flgcout	db ?
conout	db ?
flgpun	db ?
punout	db ?
flgrdr	db ?
rdrin	db ?
flglst	db ?
lstout	db ?
iobyte	db ?
flgwbt	db ?
;
	org	mailseg+10h
seldrv	db ?
track	db ?
sector	dw ?
dma0	db ?
dma1	db ?
dma2	db ?
dma3	db ?
flgdisk	db ?
dreqtyp db ?
diskerr	db ?
mmcpu ends

;	DATA AREA USED FOR LOCAL WORK-SPACE

;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	assume cs:pgroup

	dw	offset pgroup:finish
	dw	cpmsize
	jmp start

	dw	?
	dw	?
	dw	?
	dw	?
	dw	?
;
gifdic	label	dword
gifl	dw	?
gifh	dw	?

memend	dw	?

inhand db 0
flop_ok db 0

;	PROGRAM START.
;	-------------
;
start:
	push	cs
	pop	ss
	mov	sp,offset pgroup:stacke		; set up user stack
	xor	cx,cx
	int	99h			; get system paramater table
	mov	ax,es:word ptr[di.meml]
	mov	cx,4
	shr	ax,cl
	mov	cs:memend,ax
	mov	ax,es:word ptr[di.meml+2]
	mov	cx,4
	ror	ax,cl
	or	cs:memend,ax		; memend = end of usable memory
	mov	ax,es:[di.ghndlr]	; get GIFDIC entry point.
	mov	cs:gifl,ax
	mov	ax,es:[di.spgroup]
	mov	cs:gifh,ax
;
;	SIGN ON
;
	lea	di,sign_on		; get message
wrtchar:
	mov	al,byte ptr cs:[di]	; get character
	cmp	al,024h			; end of string ?
	jz	s_on_dun		; yes
	gifcall	scondev,write,0
	inc	di			; next offset
	jmp	wrtchar			; next character
;
;	WRITE 68K O.S. TO THE MMCPU BOARD
;
s_on_dun:
	mov	ax,0
	call	rstdsk			; reset hard disk
	call	setrf
	mov	ax,baseds		; get base address of mmcpu
	mov	es,ax			; to extra segment
	mov	di,loadoff
	push	cs
	pop	ds
	mov	si,offset pgroup:finish
	add	si,0200h
	and	si,0fe00h
	mov	cx,cpmsize
	cld
	rep	movsb
;
;	SET UP 68000 RESET VECTORS
;
	mov	ax,baseds
	mov	ds,ax
	assume ds:mmcpu
	mov	ax,0
	mov	word ptr ssp0,ax
	mov	word ptr pc0,ax
	mov	ax,80h
	mov	word ptr ssp1,ax
	mov	ax,startoff
	mov	cl,8
	ror	ax,cl		; 'cos 80186 stores it up-side-down !
	mov	word ptr pc1,ax
;
;	CLEAR FLAG AREA IN MMCPU MEMORY
;
	mov	cl,8
	mov	cx,10h				; loop count
	mov	ax,0				;zero for initial flags
	mov	di,mailseg
clrloop:
	mov	[di],ax			; output zero
	add	di,2
	loop	clrloop
;
;	RELEASE THE RESET LINE ON THE MMCPU CARD
;
	mov	dx,0e204h
	mov 	ax,5
	out	dx, al
	xor	di,di
	mov	ax,word ptr [di]
	call	setrf
;
;	DETERMINE THE NUMBER OF DISK BUFFERS ARE AVAILABLE 
;
notint:
	lea	ax,progend		; get end of program
	mov	cl,4			; shift count
	shr	ax,cl			; shift
	push	cs
	pop	bx			; get program segment
	mov	ds,bx			; cs = data segment
	assume ds:pgroup
	add	ax,bx			; physical end of program
	add	ax,80h			; plus one buffer size
	and	ax,0ff80h		; first available buffer
	mov	word ptr frstbuf,ax	; store in blkshdr
	mov	bx,word ptr memend	; maximum usable address
	sub	bx,ax			; number of buffer entries.
	mov	cl,7
	shr	bx,cl
	sub	bx,1
	mov	word ptr maxblk,bx	; store in blkshdr
	cmp	bx,30			; min. no of buffers
	jge	readdir			; o.k. get directory
;
;	ONLY COMES HERE IF INSUFFICIENT MEMORY EXISTS FOR 48 DISK
;			BUFFERS.
;
	lea	di,memermsg		; error message
	call	mesloop
	jmp	cpmfail
mesloop:
	mov	al,cs:[di]			; get next char
	cmp	al,24h			; end of message ?
	jz	mesexit
	gifcall scondev,write,0		; n: write character
	inc	di
	jmp	mesloop
mesexit:
	ret
;
cpmfail:
	lea	di,fatalmes
	call	mesloop
endloop:
	jmp	endloop
;
;
;	MEMORY SIZE O.K. READ IN ENTIRE 68K O.S. DIRECTORY
;	 "LABEL" ALL BLOCKS AS DIRECTORIES.
;
readdir:
	mov	cx,16			;sixteen directory blocks
	mov	ax,0			; drive number ******
	mov	dx,0			;initial sector number
gdirlp:
	call	getblk			;read 'em all in
	add	dl,4			;next block
	mov	di,word ptr distore	; used curblk entry
	mov	byte ptr [di+dirind],0ffh  ; label as a directory
	loop	gdirlp
;	jmp	down
;
;
;	LINK FLAG POLLING ROUTINES TO IOP INTERRUPT ROUTINES.
;
	lea	di,bioshnd
	push	cs
	pop	es
	mov	dl,link1
	gifcall sysdev,sstatus,0
	jo	cpmfail			; if error
;
;	DROP INTO PRINTER SPOOLER HANDLER
;
	push	cs
	pop	ds
	assume ds:pgroup
strtsrch:
	lea	si,spoolbuf		; start of spooler buffer
	mov	al,byte ptr splout	; start with zero offset
	and	ax,03fh
	add	si,ax
	push	si			; save si
srchspl:
	cmp	word ptr[si],0		; empty space ?
	jz	srchspl			; y: wait
	inc	al
	inc	al
	mov	byte ptr splout,al
	mov	di,word ptr[si]		; get curblk
	mov	es,word ptr[di+blkseg]	; get block
	mov	bp,di			; save di in bp
	mov	si,0			; first character
	mov	cx,2049			; character count + 1
tabstart:
	mov	bx,0			; tab offset count
tabcont:
	loop	nextchar		; to 2048 chars
	jmp	restart
nextchar:
	mov	al,byte ptr es:[si]	; character to al
	inc	si
	cmp	al,9			; is it a tab ?
	jz	spacfil			; y: space fill
	cmp	al,01ah			; end of file ?
	jz	restart
	call	prtchr
	cmp	al,0dh
	jz	tabstart
	cmp	al,0ah			; l/f ?
	jz	tabcont			; y: no tab count
	inc	bl	
	cmp	bl,8
	jz	tabstart
	jmp	tabcont
spacfil:
	mov	al,20h			; space
	call	prtchr
	inc	bl
	cmp	bl,8
	jz	tabstart
	jmp	spacfil
prtchr:
	push	ds
	push	es
	push	di
	pusha
	gifcall dcedev,write,2
	popa
	pop	di
	pop	es
	pop	ds
	ret
restart:
	pop	si			; restore si
	mov	word ptr[si],0		; zeroise flag
	mov	di,bp			; restore bp
	mov	byte ptr [di+dirind],0	; can now be reused
	jmp	strtsrch

self:	jmp	self
;
;	BIOS HANDLER START.
;
;	THIS SECTION POLLS ALL THE FLAGS ON THE MMCPU BOARD
;	AND INITIATES THE ROUTINES TO SERVCE THE REQUESTS - IF ANY
;
bioshnd proc far
;
	mov	ax,baseds
	mov	ds,ax			;mail boxes = data segment
	assume	ds:mmcpu
	cmp	byte ptr cs:inhand,0ffh	; already in handler ?
	jnz	nintfin
	jmp	intfin
nintfin:
	mov	byte ptr cs:inhand,0ffh
;
;
;	CHECK FOR WARM BOOT
;
tstwbt:
	mov	al,byte ptr flgwbt
	test	al,80h
	jz	tstkbd			; no warm boot
	call	delflop			; flush all floppy blocks
	call	splend			; flag spooler eof
	mov	byte ptr flgwbt,0	; clear warm boot flag
;
;	TEST FOR KEYBOARD INPUT
;
tstkbd:
	mov	al,byte ptr flgcin
	test	al,80h
	jnz	tconout
	push	bx
	gifcall	scondev,read,0		;read system device channel
	pop	bx
	jb	tconout			;test c.out if no char. avail.
	mov	byte ptr conin,al 	; send character
	mov	ah,80h
	mov	byte ptr flgcin,ah	 ; set the flag
;
;	TEST CONSOLE OUTPUT.
;
tconout:
	mov	al,byte ptr flgcout
	test	al,80h
	jz	tdisk			; no request.
	mov	al,byte ptr conout	;get character to send
	push	bx
	gifcall	scondev,write,0		;write char to system device
	pop	bx
	jb	tdisk
	mov	byte ptr flgcout,ah 	;clear flag
;
;	DISK HANDLER.
;
tdisk:
	mov	al,byte ptr flgdisk	 ; flag in al
	test	al,80h			; action ?
	jnz	handl_dsk
	jmp	tlist			; if not, repeat all
handl_dsk:
	mov	al,byte ptr dreqtyp	; get type of request
	cmp	al,4			; flush ?
	jnz	notflush
	call	flush
	jmp	dskexit			; and exit
notflush:
	call	setsd			; set up ax & bx
	call	getblk			; get the block
	jc	dskerr			; error
	cmp	byte ptr dma0,0ffh	; printer block ?
	jz	setspool
	call	moveit			; transfer data to/from mmcpu
	mov	cl,byte ptr dreqtyp	; get type of request
	cmp	cl,0			; read ?
	jz	dskexit			; y; done
	call	dskwrt			; write to disk.
	jc	dskerr			; error
	jmp	dskexit
setspool:
	mov	di,word ptr cs:distore	; get curblk
	lea	si,cs:spoolbuf
	mov	al,byte ptr cs:splin
	and	ax,0ffh
	cmp	ax,0			; zero
	jnz	prev
	mov	ax,03eh
	jmp	cmprev
prev:
	dec	al
	dec	al
cmprev:
	add	si,ax
	cmp	di,cs:[si]
	jz	dskexit
	call	spooler
	jnc	spooled
	jmp	tstaux			; if spooler full, exit.
spooled:
	mov	byte ptr cs:[di+dirind],0ffh ; set dir => no flush !
dskexit:
	mov	al,0
	jmp	dskfin
dskerr:
	call	rstdsk			; restet offending disk
	mov	al,1			;failure flag
dskfin:
	mov 	byte ptr diskerr,al	; send failure flag
	mov	ah,0
	mov	byte ptr flgdisk,ah	; kill flag
;
;	TEST FOR LISTING OUTPUT.
;
tlist:
	mov	al,byte ptr flglst	; flag in al
	test	al,80h			; action ?
	jz	tstaux			; if not, repeat all
	cmp	byte ptr cs:lbufflg,0	; already got a buffer ?
	jnz	gotbuff			; y: use it
getsb:
	mov	ax,0ffh			; to flag spooler request
	call	getblk
	mov	di,word ptr cs:distore	; get curblk
	mov	word ptr cs:splstore,di	; save it
	mov	byte ptr cs:lbufflg,0ffh ; flag it
	mov	word ptr cs:[di+sploff],0 ; initial offset of zero
	mov	word ptr cs:[di+drvnum],0ffh  ; so can re-read.
	mov	byte ptr cs:[di+dirind],0ffh ; set dir => no flush !
	jmp	putbuf
gotbuff:
	mov	di,word ptr cs:splstore
putbuf:
	mov	ax,word ptr cs:[di+sploff]  ; get offset
	mov	es,word ptr cs:[di+blkseg]  ; get segment
	mov	si,ax
	inc	ax
	cmp	ax,2047			; end of block ?
	jnz	blknfl
	call	splend
	jmp	getsb
blknfl:
	mov	word ptr cs:[di+sploff],ax
	mov	al,byte ptr lstout	; get character
	mov	ah,01ah			; terminator
	mov	word ptr es:[si],ax
	mov	byte ptr flglst,0	; clear flag
;
;	TEST AUXILLIARY INPUT
;
;
tstaux:
	mov	al,byte ptr flgrdr	; test for auxilliary i/p
	test	al,80h
	jnz	tpunout
	push	bx
	gifcall	dcedev,read,0		;read dce channel
	pop	bx
	jb	tpunout			;test c.out if no char. avail.
	mov	byte ptr rdrin,al	; send character
	mov	ah,80h
	mov	byte ptr flgrdr,ah	; set the flag
;
;	TEST AUXILLIARY OUTPUT.
;
tpunout:
	mov	al,byte ptr flgpun	; test aux. o/p
	test	al,80h
	jz	intout			; no request.
	mov	al,byte ptr punout	;get character to send
	push	bx
	gifcall	dcedev,write,0		;write char to dce
	pop	bx
	jb	intout
	mov	byte ptr flgpun,ah	;clear flag
intout:
	mov	dx,19eh
	mov	al,1
	out	dx,al
	mov	byte ptr cs:inhand,0	; no longer in handler ?
intfin:
	ret
bioshnd endp
down:		;*********************************
	call	bioshnd
	jmp	down
;
;
;
;	SUBROUTINES.
;	-----------
;
rstdsk:
	pusha
	push	es
	push	ds
	push	ax
	gifcall dskdev,reset,0		; reset the disk
	pop	ax
	cmp	ax,0			; if hard disk exit
	jz	rstdun
	mov	dl,0
	push	ax
	mov	dh,011h
	gifcall dskdev,sstatus,0	; media set for floppy
	pop	ax
	mov	dl,0
	gifcall dskdev,gstatus,0	; media check if floppy
rstdun:
	pop	ds
	pop	es
	popa
	ret
;
;
setrf:
	pusha
	mov	dx,0e204h
	mov	al,baserf		; pre-defined register file
	out	dx, al
	popa
	ret
;
;	MOVEIT TRANSFERS 128 BYTES TO/FROM MMCPU (DEPENDING ON THE
;	STATE OF DREQTYP) FROM/TO THE DATA SEGMENT IN ES:
;
moveit:
	pusha
	push	es
	push	ds
	mov 	ax,0			; zeroise ax
	mov	al,byte ptr sector	; get sector.
	and	al,0fh			; lsb's only
	mov	cl,7			; shift count
	shl	ax,cl			; *128 for offset
	mov	di,ax			; desination index
	mov	dl,byte ptr dma1
	mov	dh,byte ptr dma0
	and	dx,7			;A18 & A17 & A16 only
	mov	cl,0ch			;shift count
	shl	dx,cl
	add	dx,4000h 		;to select VMEbus
	mov	al,byte ptr dma3
	mov	ah,byte ptr dma2
	push	ax
	mov	cl,4
	shr	ax,cl
	add	dx,ax
	pop	ax
	and	ax,0fh
	mov	si,ax			; source index to :si
	mov	cx,64			; count register
	push	ax
	mov	al,byte ptr dreqtyp  ; get type of disk req. (r/w)
	cmp	al,0			; read ?
	pop	ax			; restore ax
	mov	ds,dx			; source segment to ds
	jnz	wrtmov			; if read, swap source & dest.
	push	ds
	push	es
	push	di
	push	si
	pop	di
	pop	si
	pop	ds
	pop	es
wrtmov:
	cld
	rep	movsw			; do the transfer
	pop	ds
	pop	es
	popa
	ret
;
;	Setsd sets up sector & drive numbers for getblk & blkwrt
;
setsd:
	mov	dl,byte ptr sector	;get sector into al
	mov	dh,byte ptr track	;get track into ah
	shr	dx,1
	shr	dx,1
	and	dx,0fffch		; round to nearest four
	mov	al,byte ptr seldrv	; requested drive to al
	cmp	al,0			; hard disk ?
	jz	hdset			; y: ( was jz )
	inc	al			; *** compensate for msdos ***
	cmp	cs:byte ptr flop_ok,0	; floppy already set up ?
	jnz	hdset
	call	rstdsk			; reset floppy
	mov	cs:byte ptr flop_ok,0ffh ; set flag
hdset:
	and	ax,0fh
	ret
;
;	DELFLOP FLUSHES ALL FLOPPY BLOCKS THAT NEED TO BE
;	FLUSHED AND INVALIDATES THE CURBLK ENTRY.
;
delflop:
	push	ds
	push	cs
	pop	ds
	assume ds:pgroup
	lea	di,word ptr blkshdr	; get head of chain
flploop:
	mov	di,word ptr[di+blklink]	; get next entry
	cmp	di,0			; any more in chain ?
	jz	flpend			; n:
	cmp	word ptr[di+drvnum],2  ; floppy ?
	jnz	flploop			; n: continue search
	mov	ax,word ptr [di+drvnum]	; drive number to ax
	cmp	byte ptr [di+flshind],0ffh  ; need to flush ?
	jnz	loopf			; n: continue
	push	di
	mov	dx,word ptr [di+secnum]	; sector number to bx
	mov	es,word ptr [di+blkseg]	; segment to es
	call	flshblk			; flush it
	jc	flpend
	pop	di			; restore di
loopf:
	mov	word ptr[di+drvnum],0ffh ; invalid drive number
	jmp	flploop
flpend:
	pop	ds
	ret
;
;	GETBLK first checks to see if requested block is currently
;	held in the buffer. If not it gets a usable buffer and loads
;	the block into it. The pointer to the start of the block is 
;	returned in ES.
;	On entry; dx contains requested sector number (MSDOS)
;		  ax contains requested drive number (MSDOS)
;
getblk:
	push	ds
	pusha
	push	ax
	push	dx
	push	cs
	pop	ds
	assume ds:pgroup
	lea	di,word ptr blkshdr	; get head of chain
	cmp	byte ptr blknum,0	; first buffer ?
	jnz	lnkloop
	mov	es,word ptr frstbuf	; get first buffer
	mov	word ptr lastbuf,es	; new last alocated buffer 
	mov	byte ptr blknum,1	; initial value
	lea	di,curblks		; get start of buffer area
	mov	word ptr lasthdr,di	; new last allocated header
	jmp	rdblk
lnkloop:
	mov	si,di			; save last header
	mov	di,word ptr[di+blklink]	; get next entry
	cmp	di,0			; any more in chain ?
	jz	lnkend			; n:
	cmp	dx,word ptr[di+secnum]	; requested sector ?
	jnz	lnkloop			; n: continue search
	cmp	ax,word ptr[di+drvnum] ; requested drive ?
	jnz	lnkloop			; n: continue search
	pop	dx
	pop	ax
	mov	es,word ptr[di+blkseg]	; buffer to es
	jmp	linknew			; found buffer; change list
lnkend:
	mov	ax,word ptr blknum	; no. of current blocks
	cmp	ax,word ptr maxblk	; cmp with max
	jz	getlru			; buffer full; get L.R.U.
	mov	di,word ptr lasthdr	; di; last allocated header
	add	di,10h			; next header
	mov	word ptr lasthdr,di	; new last allocated header
	mov	ax,word ptr lastbuf	; last buffer to ax
	add	ax,80h			; new buffer
	mov	es,ax			; new buffer to es
	mov	word ptr lastbuf,es	; new last alocated buffer 
	inc	word ptr blknum		; inc. number of blocks
	jmp	rdblk
getlru:
	mov	di,word ptr lruhdr	; get L.R.U.
chkdir:
	cmp	byte ptr[di+dirind],0ffh	;is it a directory ?
	jne	buffok			; n:
	mov	di,word ptr[di+revlink]		; make reverse link
	jmp	chkdir			; continue checking
buffok:
	mov	si,word ptr[di+revlink]	; set up si for linking up
	mov	es,word ptr[di+blkseg]	; buffer to es
	cmp	byte ptr[di+flshind],0ffh	; need to flush
	jnz	rdblk			; n: read block
	mov	ax,word ptr [di+drvnum]	; drive number to ax
	mov	dx,word ptr [di+secnum]	; sector number to bx
	call	flshblk			; write block first
rdblk:
	pop	dx
	mov	word ptr[di+secnum],dx	; sector number
	pop	ax
	cmp	ax,0ffh			; is it for spooling ?
	jz	splread			; y:
	cmp	ax,0			; *************
	jnz	flpoff
	add	dx,spool
	jmp	setsec
flpoff:
	add	dx,24h
setsec:
	mov	cx,2
re_read:
	pusha
	mov	cx,4			; read four blocks
	mov	di,0			; offset in buffer segment
	push	es
	gifcall	dskdev,read,0		;read one block
	pop	es
	popa
	jnc	splread			; jump if no error
	cmp	ah,012h			; time-out error
	jz	readout			; exit if so
	loop	re_read			; retry if count > 0
	jmp	readout
splread:
	mov	word ptr[di+drvnum],ax	; drive number
	mov	word ptr[di+blkseg],es	; pointer to es
linknew:
	cmp	byte ptr blknum,1	; first buffer ?
	push	di
	jz	norevlnk		; y: link only to blkshdr.
	mov	di,word ptr[di+blklink]	; get current fwd. link
	mov	word ptr [si+blklink],di
	cmp	di,0			; test if zero
	jnz	revlnk			; reverse link if not at end !
	mov	word ptr lruhdr,si	; else make L.R.U.
	jmp	norevlnk
revlnk:
	mov	word ptr[di+revlink],si	; make reverse link
norevlnk:
	pop	di
	mov	word ptr distore,di	; save di for dir labeling
	cmp	di,word ptr mruhdr
	jz	linkdun
	mov	si,word ptr mruhdr	; get current head of chain
	mov	word ptr mruhdr,di	; replace with new header
	mov	word ptr[di+blklink],si	; make link
;	cmp	byte ptr blknum,1	; first buffer ? 
;	jz	linkdun			; y: no reverse link
	mov	word ptr [si+revlink],di ; make new reverse link.
linkdun:
	clc
readout:
	popa
	pop	ds
	ret
;

dskwrt:
	push	ds
	push	cs
	pop	ds
	cmp	dl,2			; directory write ?
	jz	wrtblk			; y: write to directory
	mov	di,word ptr distore	; n: get curblks entry
	mov	byte ptr [di+flshind],0ffh ; set need to flush ind.
	clc
	pop	ds
	ret
flshblk:
	push	ds
wrtblk:
	pusha
	cmp	ax,0			;***************
	jnz	flpofst
	add	dx,spool
	jmp	secset
flpofst:
;	add	dx,0200h
;	call	rstdsk			; reset & media check
	add	dx,24h
secset:
	mov	cx,2
re_write:
	push	cx
	mov	cx,4			; read four blocks
	mov	di,0
	push	bx
	gifcall	dskdev,write,0		;write block
	pop	bx
	pop	cx
	jnc	wrt_out
	cmp	ah,012h			; time out ?
	jz	wrt_out
	loop	re_write
wrt_out:
	popa
	pop	ds
	ret

;
;	FLUSH checks all currently held sectors for writing to disk
;	
flush:
	push	ds
	push	cs
	pop	ds
	lea	di,blkshdr		; get head of chain
flshloop:
	mov	di,word ptr[di+blklink]	; get next entry
	cmp	di,0			; end of chain ?
	jz	flshend 		; y: get out.
	cmp	byte ptr [di+flshind],0ffh  ; need to flush ?
	jnz	flshloop		; n: continue
	mov	ax,word ptr [di+drvnum]	; drive number to ax
	mov	dx,word ptr [di+secnum]	; sector number to bx
	mov	es,word ptr [di+blkseg]	; segment to es
	call	flshblk
	jc	flshend
	mov	byte ptr [di+flshind],0	; clear flush indicator
	jmp	flshloop
flshend:
	pop	ds
	ret
;
;	SPOOLER
;
spooler:
	push	ds
	push	cs
	pop	ds
	lea	si,cs:spoolbuf		; start of spooler buffer
	mov	al,byte ptr splin 	; current offset
	and	ax,03fh
	add	si,ax
splsrch:
	cmp	word ptr[si],0		; empty space ?
	jnz	setsplex		; n: exit
	inc	al
	inc	al
	mov	byte ptr splin,al
	mov	word ptr[si],di		; spool this block.
	clc				; clear carry flag
	jmp	setspout
setsplex:
	stc				; set carry flag
setspout:
	pop	ds
	ret
;
;	SPLEND DESPATCHES THE CURRENT SPOOLER BUFFER
;
splend:
	push	ds
	push	cs
	pop	ds
	cmp	byte ptr cs:lbufflg,0	; anything to send ?
	jz	splendex		; n:
	mov	di,word ptr splstore
	call	spooler
	mov	byte ptr cs:lbufflg,0	; clear flag
splendex:
	pop	ds
	ret
;
;	BLKSHDR is the control header for the sector buffer linked
;	list.
;
blkshdr:
frstbuf:	dw 0	; address of first available sector buffer
lruhdr:		dw 0	; address of least recently used buffer
mruhdr:		dw 0	; address of first hdr in chain
lasthdr		dw 0	; last allocated header
lastbuf		dw 0	; last allocated buffer
maxblk:		dw 0	; no. of blocks allowed (ram size)
blknum:		dw 0	; current no. of sectors in ram
distore		dw 0	; di store for labeling directory entries
splout		db 0	; spooler output pointer
splin		db 0	; spooler input pointer
splstore	dw 0	; spooler buffer for lst device
lbufflg		db 0	; spool buffer in mem ?
;
;	CURBLKS is the linked list of pointers to the disk sectors
;	currentlt held in ram.
;
curblks: db	800h dup (0)
;
spoolbuf: dw	20h dup (0)

	dw	100h dup (?)
STACKE:

progend:
;
;

fatalmes db cr,lf,'FATAL ERROR !!',cr,lf,'$'
memermsg db cr, lf, 'GIVE US A BREAK .... I NEED MORE MEMORY.....$'

finish:

PROG	ENDS

end
