TITLE	Format Floppy Diskette

; WARNING :  This program assume that there is about 38K free RAM
;		space behind it.


NOBP	equ 1
include	\syscon\syscon.equ

tst	equ 0

cr		equ 0dh
lf		equ 0ah

jcm	macro	lbl
	local	goon
	jnc	goon
	jmp	lbl
goon:
endm

tm	macro	msg
if tst
	db 60h
	prtmsg	<msg>
	db 61h
endif
endm

tmcr	macro	msg
if tst
	db 60h
	prtmsg < msg , cr, lf>
	db 61h
endif
endm

include \GIFI\gifMAC.MAC

fmtlnk		equ 0f0h

lead		equ ':'		; Track Indicator
bs		equ 8		; Back Space

maxsec		equ 9		; Change interleave table if changed
imgsize		equ 6300	; Size of Image buffer
fatbufs		equ 8		; Size of FAT buffer in sector
fatbsz		equ fatbufs*bps	; Size of FAT buffer in bytes
datpttn		equ 0e5h	; Data Pattern
fswsft		equ 3		; Format Switch position
bpboff		equ 11		; BPB offset in boot record

; DMA Code for TASK Calling
dmaoff		equ 0
dmaout		equ 82h
wrdma		equ 74a6h	; WRDMA Command

; XFLP Commands
stepin		equ 40h
wrtrk		equ 0f4h

; CBB/SBB
xcmdl		equ 4
xstsl		equ 1
ss1_		equ (1 shl 0)	; Head bit

; Fixed format information
secsft		equ 9		; Sector size shift
bps		equ (1 shl secsft) ; Byte per sector
res_sec		equ 1
num_fat		equ 2
dir_entsz	equ 20h
hid_sec		equ 0

; MSDOS functions
getcurd	equ 19h
opndev	equ 3dh
iodev	equ 2
rdkey	equ 8
clsdev	equ 3eh
rddev	equ 3fh
wrdev	equ 40h

; GIFSYS99 Device
sysinit	equ 0
sysprom	equ 1
sysmap	equ 2
hd	equ (1 shl 7)

fmtgen	macro fmtn, med, gmed, sctk, side, trk, sus, scfat, rtdir
fmtmp&fmtn	label byte
rtdir_start=res_sec+scfat*num_fat
data_start=rtdir_start+rtdir
dw bps
db (1 shl sus)
dw res_sec
db num_fat
dw rtdir*bps/dir_entsz
dw ((scfat*bps*2/3-2) shl sus)+data_start
db med
dw scfat
dw sctk
dw side
dw hid_sec
dw rtdir_start
dw data_start
db sus
dw trk
db gmed
dw sctk*side*trk
org fmtmp&fmtn+size fmts
endm


; Image spec. macro
bytestr	macro len, val, long
ifidn <long>,<>
	db len, val
else
	dw len
	db val
endif
endm

idmark	macro
db -1
endm

secbeg	macro
db -2
endm

secend	macro	trlr
db -3, trlr
endm

; Print message
prtmsg	macro	msg
	local msgbeg, msgend
	mov	dx, offset ds:msgbeg
	mov	ah, 9
	int	21h
	jmp	msgend
msgbeg	db msg, '$'
msgend:
endm

if 0
; Program Macro
echofmt	macro	msg, bt
	mov	dx, offset ds:msg
	mov	ah, 9
	int	21h
	mov	dl, byte ptr bt
	add	dl, '0'
	mov	ah, 2
	int	21h
endm
endif

dcmlb	macro	byte
	mov	al, byte
	call	prdcmlb
endm

dcmlw	macro	word
	mov	ax, word
	call	prdcmlw
endm

; Sequencial write FAT
seqwrtf	macro buffer, count, errexit
	mov	di, buffer
	mov	cx, count
	push	cx
	push	dx
	dwrite	fmtdrv
	pop	dx
	pop	cx
	jcm	errexit
	add	dx, cx
endm

dreset	macro	drive
	mov	al, drive
	mov	bx, dskdev*64+reset*4
	call	gifdic
endm

dwrite	macro	drive
	mov	al, drive
	mov	bx, dskdev*64+write*4
	call	gifdic
endm

dformat	macro	drive
	mov	al, drive
	mov	bx, dskdev*64+format*4
	call	gifdic
endm

dgs	macro	func
	mov	dl, func
	mov	bx, dskdev*64+gstatus*4
	call	gifdic
endm

dss	macro	func
	mov	dl, func
	mov	bx, dskdev*64+sstatus*4
	call	gifdic
endm

; 80186 Instr
roldx	macro cnt
	db 0c1h, 0c2h, cnt
endm

shlah	macro cnt
	db 0c0h, 0e4h, cnt
endm

shlax	macro cnt
	db 0c1h, 0e0h, cnt
endm

shlcx	macro cnt
	db 0c1h, 0e1h, cnt
endm

shrsi	macro cnt
	db 0c1h, 0eeh, cnt
endm

shrax	macro cnt
	db 0c1h, 0e8h, cnt
endm


fmtsft	equ 5
fmts	struc
; Specified by MSDOS
	dw ?	; Byte per Sector
	db ?	; Sector per Unit
nrsc	dw ?	; Reserved Sector
	db ?	; Number of FAT's
nrtd	dw ?	; Number of Root Dir Entries
ldsksze	dw ?	; Number of Sectors in Logical Image
fmed	db ?	; Media byte
sfat	dw ?	; Number of Sectors per FAT
secn	dw ?	; Number of Sectors per track
side	dw ?	; Number of Sides
	dw ?	; Number of hidden sector
; Specified by COLEXFMT
srtd	dw ?	; Start Sector of Root Directory
sdat	dw ?	; Start Sector of Data Area
spusft	db ?	; Sector per Unit Shift
trkn	dw ?	; Number of Tracks
gfdmed	db ?	; GIFDIC Media
; Internal used
dsksze	dw ?	; Number of Sectors per Disk
ddummy	db ((1 shl fmtsft)-ddummy+fmts) dup (?)
fmts	ends
sizefmt	equ dsksze-fmts

code	segment byte public 'code'
	assume cs:code, ds:code, es:code

; PUBLIC and EXTRN required by other modules

	public fatid, startsector, switchlist, freespace
	public init, diskformat, badsector, done, wrtfat
	public fatspace, hardflag
	extrn switchmap:word, drive:byte

ctrl	db ?		; Contoller
fmtdrv	db ?		; Format Drive
trkptr	db ?		; Track Pointer
stcmd	db ?		; Step-in CBB lead byte
wtcmd	db ?		; Write-track CBB lead byte

; ID Field pointer
idptr	dw maxsec dup (?)

; GIAT
syscmd	label byte
gfdtd	label byte
db sysinit	; GIFSYS99 init
gfdcd	label byte
db sysprom	; PROM info.
db giatl	; Word count
dw giat		; Buffer offset
codseg dw ?	; Buffer segment
db sysmap
tgdrv db ?	; Target Drive
db sysmap
curdrv db ?	; Current Drive
giatcnt	equ $-syscmd

giat	label word
	dw ?
	dw ?
prompg	dw ?
	dw ?
gifdicc	dw ?
giatl	equ ($-giat)/2

; GIFSYS99 Device
sysname	db 'GIFSYS99', 0

; GIFDIC Call
gifdic	label dword
gfdloc	dw ?
gfdseg	dw ?

; TASK Call
task	label dword
tskloc	dw ?
tskseg	dw ?

; DMA Reg buffer pointer -- SLP, SUP, DLP, DUP, CNT, CMD
dmabuf	label dword
dmabloc	dw ?
dmabseg	dw ?

; CBB & SBB
cbb	db xcmdl
cbbb	db xcmdl-1 dup (0)
cbcmd	db ?

sbb	db xstsl
sbbb	db xstsl dup (0)

med2fmt	db -1, 0, -1, -1, 3, 1, 4, 2	; MSDOS Media byte to FMTMP #

fmtmps	label byte
fmtgen	0, 0f9h, 11h, 9, 2, 80, 1, 2, 75
fmtgen	1, 0fdh, 15h, 9, 2, 40, 1, 2, 7
fmtgen	2, 0ffh, 17h, 8, 2, 40, 1, 1, 7
fmtgen	3, 0fch, 14h, 9, 1, 40, 0, 2, 4
fmtgen	4, 0feh, 16h, 8, 1, 40, 0, 1, 4
fmtgen	h, 0f8h,   0,17, 4,306, 3, 8, 7

fmap	label word			; Switchmap to fmts
	dw fmtmp0
	dw fmtmp3
	dw fmtmp2
	dw fmtmp4
	dw fmtmp1
	dw fmtmp3
	dw fmtmp2
	dw fmtmp4

; Public area
fmtmp	label byte
	org fmtmp+fmed
fatid		db ?
	org fmtmp+sdat
startsector	dw ?
	org fmtmp+(size fmts)
switchlist	db switchlen
		db 'C481OVS'
switchlen	equ $-switchlist-1
swmsks		equ (1 shl 0)
swmskv		equ (1 shl 1)
swmsko		equ (1 shl 2)
swmsk1		equ (1 shl 3)
swmsk8		equ (1 shl 4)
swmsk4		equ (1 shl 5)
swmskc		equ (1 shl 6)
hardflag	db 0
btrst	equ freeram
fatst	equ btrst+bps
rtdst	equ fatst+bps
imgst	equ rtdst+fatbsz
freest	equ imgst+imgsize
fatspace	dw fatst	; FAT buffer address
freespace	dw freest	; Free Space for GIFSYS99 transferring

; Image Specification
imgspc	label byte
bytestr	60, 4eh
secbeg
bytestr	12, 0
bytestr	3, 0f5h
bytestr	1, 0feh
idmark
bytestr	1, 2
bytestr	1, 0f7h
bytestr	22, 4eh
bytestr	12, 0
bytestr	3, 0f5h
bytestr	1, 0fbh
bytestr	512, datpttn, l
bytestr	1, 0f7h
bytestr	54, 4eh
secend	4eh

; Interleave table
itlvtab	db 1, 4, 7, 2, 5, 8, 3, 6, 9


fmtmend:
	add	di, 3
	push	cs
	pop	es
	rep	stosb
	ret


INIT:
tmcr	"INIT"
prtmsg	<cr,lf,'FORMAT Program for MS-DOS/COLEX-2000  v.1.0+',cr,lf,lf>
; Link the FORMAT mender
	mov	si, fmtlnk
	mov	cs:[si], offset fmtmend

; RAM Size test
	mov	ax, offset freest
	shrax	4
	inc	ax
	mov	bx, cs
	add	ax, bx
	mov	bx, 2		; Offset 2 at segment prefix
	cmp	ax, cs:[bx]	; 	is top of memory
	jle	in2
	jmp	roomerr
in2:

; Get GIAT
	mov	al, drive
	mov	tgdrv, al
	mov	ah, getcurd
	int	21h
	mov	curdrv, al
	mov	codseg, cs
	mov	ah, opndev
	mov	al, iodev
	mov	dx, offset sysname
	int	21h
	jcm	giaterr
	mov	bx, ax

	mov	ah, wrdev
	mov	dx, offset syscmd
	mov	cx, giatcnt
	int	21h
	jcm	giaterr

	mov	ax, gifdicc
	mov	gfdloc, ax
	mov	ax, prompg
	mov	gfdseg, ax

	mov	ah, rddev
	mov	cx, 2
	int	21h
	jcm	giaterr

	mov	ah, clsdev
	int	21h
	jcm	giaterr

	mov	al, gfdtd
	test	al, hd
	jnz	inhard
	jmp	inflp

; Hard Disk
inhard:
	and	al, not hd
	mov	fmtdrv, al
	dec	hardflag
	or	switchmap, swmskc	; Automatic /C
	mov	si, offset fmtmph
	jmp	inboot

; Error messages
giaterr:
	prtmsg	<'GIFSYS99 Device Error', cr, lf>
	jmp	inierr

roomerr:
	prtmsg	<'Not enough room in main memory', cr, lf>
	jmp	inierr

unferr:
	prtmsg	<'Probably Unformatted Diskette', cr, lf>
	jmp	short inierr

ndoserr:
	prtmsg	<'Probably Non-DOS Diskette', cr, lf>
	jmp	short inierr

promerr:
	prtmsg	<cr, lf, 'Not the right PROM', cr, lf>
	jmp	short inierr

booterr:
	prtmsg	<'Boot Sector constructing error', cr, lf>

inierr:
	stc
	jmp	iniexit

; Floppy
inflp:
	mov	fmtdrv, al

; Image Generation
	mov	si, offset imgspc
	mov	di, offset imgst
	mov	cx, imgsize
	call	imgen

; Determine the format
	test	switchmap, swmskc
	jz	innc
; Clear Option
	mov	al, drive
	mov	dx, 1		; FAT sector
	mov	cx, 1
	mov	bx, offset btrst
	int	25h
	pop	ax
	jcm	unferr
	mov	al, btrst
	or	al, 7		; Check Media Valid
	inc	al
	jz	in4
	jmp	ndoserr
in4:
	mov	al, btrst
	and	al, 7		; 3 bits only
	mov	bx, offset med2fmt
	xlat
	cmp	al, -1
	jne	in3
	jmp	ndoserr
in3:
	shl	al, 1
	xor	ah, ah
	mov	si, ax
	jmp	short in1
innc:
	mov	si, switchmap
	shrsi	fswsft-1
	and	si, 0eh	; 3 bits only
in1:
	mov	si, fmap[si]

inboot:
	mov	di, offset fmtmp
	mov	cx, size fmts
	rep	movsb

	test	hardflag, 1
	jz	in8
; Logical Image size
	mov	al, gfdtd	; Get Target Drive Number
	and	al, 7fh
IF NOBP
	PUSH	ES
ENDIF
	dgs	gosmap		; Get image size
IF NOBP
	MOV	BP, ES
	POP	ES
ENDIF
	jcm	booterr
	mov	fmtmp.ldsksze, cx	; 16 bits only
	jmp	short in7
in8:
; Get the image size
	mov	ax, fmtmp.dsksze
	cmp	ax, fmtmp.ldsksze
	jg	in7
	mov	fmtmp.ldsksze, ax
in7:
	test	switchmap, swmsks
	jnz	in6
; Non-System Diskette
	mov	fmtmp.spusft, -1
in6:

; Read the Boot Record
	mov	al, gfdcd	; Get Current Drive Number
	and	al, 7fh
IF NOBP
	PUSH	ES
ENDIF
	dgs	gosmap		; Get image size
IF NOBP
	MOV	BP, ES
	POP	ES
ENDIF
	jcm	booterr
	mov	al, curdrv	; Drive A
	mov	dx, bp		; Boot Sector
	mov	cx, 1
	mov	bx, offset btrst
	int	25h
	pop	ax
	jcm	booterr
; Copy the BPB
	mov	si, offset fmtmp
	mov	di, offset btrst
	add	di, bpboff
	mov	cx, sizefmt
	rep	movsb
; RAM Init
	xor	ax, ax
	mov	di, offset rtdst
	mov	cx, bps/2
	rep	stosw

	clc
iniexit:
	ret


DISKFORMAT:
; Echo Format
	prtmsg	<'Drive '>
	mov	dl, drive
	add	dl, 'A'
	mov	ah, 2
	int	21h
	prtmsg	<cr, lf, 'Media '>
	mov	al, fmtmp.fmed
	call	prbyte
	prtmsg	<cr,lf,			'Disk Size ........ '>
	mov	ax, fmtmp.ldsksze
	call	prword
	prtmsg	<'H sectors',cr,lf,	'Directory Size ... '>
	dcmlw	fmtmp.nrtd
	prtmsg	'  entries'
	test	hardflag, 1
	jnz	fm2
	prtmsg	<cr,lf,			'Sectors/Track .... '>
	dcmlw	fmtmp.secn
	prtmsg	<cr,lf,			'Sides ............ '>
	dcmlw	fmtmp.side
	prtmsg	<cr,lf,			'Tracks ........... '>
	dcmlw	fmtmp.trkn
fm2:

; Drive reset
	dreset	fmtdrv

	test	switchmap, swmskc
	jz	fm1
	jmp	fmtok
fm1:
; Format pointers
	dformat	fmtdrv
	jcm	promerr

	mov	ctrl, cl
	and	ch, 0eh		; CBB DS bytes
	mov	stcmd, ch	; Step-In Command Byte
	or	stcmd, 0f1h	; Type 3; No register updating; Head 0
	mov	wtcmd, ch	; Write-Track Command Byte
	or	wtcmd, 0b1h	; Type 2; No register updating; Head 0
	mov	tskloc, dx
IF NOBP
	MOV	TSKSEG, BX
ELSE
	mov	tskseg, bp
ENDIF
; Pass ES to the DMA Buffer Init

; DMA Buffer init
	mov	ax, offset imgst
	mov	dx, cs
	roldx	4
	mov	cx, dx
	and	cx, 0fh
	and	dx, 0fff0h
	add	ax, dx
	adc	cx, 0
	stosw		; SLP
	mov	ax, cx
	stosw		; SUP
	mov	ax, sasidp
	stosw		; DLP
	xor	ax, ax
	stosw		; DUP
	mov	ax, imgsize
	stosw		; CNT
	mov	ax, wrdma
	stosw		; CMD
	mov	ax, ds
	mov	es, ax

; Write Track (Format)
	mov	trkptr, 0		; Track pointer init
	mov	bx, offset itlvtab
	mov	si, offset cbb
	mov	di, offset sbb
	mov	ch, dmaout
	mov	cl, ctrl

wtlp:
	mov	al, wtcmd
	mov	cbbb, al
	mov	cbcmd, wrtrk
; Side 0
	mov	al, trkptr
	mov	ah, 0
	call	fillid
	call	task
	jcm	fmterr
; Check Single Side
	cmp	fmtmp.side, 1
	jle	wl1
; Side 1
	mov	al, trkptr
	mov	ah, 1
	call	fillid
	xor	cbbb, ss1_
	call	task
	jc	fmterr
wl1:
; Step in
	mov	al, stcmd
	mov	cbbb, al
	mov	cbcmd, stepin
	mov	ch, dmaoff
	call	task
	jc	fmterr
; Display Track
	cmp	fmtmp.trkn, 40
	jg	wl2
	call	task	; 40-track -- One more step
	jc	fmterr
wl2:
	mov	ch, dmaout

	inc	trkptr
	mov	al, lead
	call	wrcon
	dcmlb	trkptr
	mov	al, bs
	call	wrcon
	mov	al, bs
	call	wrcon
	mov	al, bs
	call	wrcon
	mov	al, byte ptr fmtmp.trkn
	cmp	trkptr, al
	jae	fmtend
	jmp	wtlp

; Format Error
fmterr:
	push	ax
	prtmsg	<cr, lf, 'Format operation GIFDIC internal error '>
	pop	ax
	mov	al, ah
	call	prbyte
	dreset	fmtdrv
	stc
	jmp	fmtexit

fmtend:
; Reset after formatting
	dreset	fmtdrv
; Media Check
	mov	al, fmtdrv
	dgs	medchk

fmtok:
; Init FAT buffer
	xor	ax, ax
	mov	di, offset fatst
	mov	cx, fatbsz/2
	rep	stosw
	mov	di, offset fatst
	mov	al, fmtmp.fmed
	stosb
	mov	ax, -1
	stosw
	clc
fmtexit:
	pushf
	prtmsg	<cr, lf>
	popf
	ret


BADSECTOR:
; No Check Right now
	xor	dx, dx
	mov	dh, fmtmp.gfdmed
	dss	medset
	mov	di, offset btrst
	mov	cx, 1
	xor	dx, dx
	dwrite	fmtdrv
	jcm	faterr
tm "BOOT"
; Write root directory
	mov	dx, fmtmp.srtd
	mov	di, offset rtdst
tm ",ROOT"
rtdinlp:
tm "*"
	mov	cx, 1
	dwrite	fmtdrv
	jcm	faterr
	inc	dx
	cmp	dx, startsector
	jl	rtdinlp
	xor	ax, ax
	ret


WRTFAT:
; Write Boot Record
tm "WRTFAT:"
	mov	dx, fmtmp.nrsc
	seqwrtf	<offset fatst>, fmtmp.sfat, faterr	; Write FAT 1
tm ",FAT1"
	seqwrtf	<offset fatst>, fmtmp.sfat, faterr	; Write FAT 2
tm ",FAT2"
	clc

fatexit:
	ret

; Write FAT Error
faterr:
	push	ax
	prtmsg	<cr, lf, "Write Diskette GIFDIC error ">
	pop	ax
	mov	al, ah
	call	prbyte
	prtmsg	<cr, lf>
	dreset	fmtdrv
	stc
	jmp	fatexit


DONE:
	clc
	ret


;
; Image generation : Interprete the image spec. and generate
;			the image buffer for write track function.
;	Input :	[DS:SI] - Image specification
;		[ES:DI] - Image buffer
;			(Suppose DS and ES are equal)
;		CX - Image buffer size (Wrap-around is not considered)
;	Output:	Image buffer; ID pointers
;
;	Function :
;		The Image spec. is passed in for image generation.
;		In each field of this spec., there are the count/control
;		byte, and the content byte following if necessary.
;		If the count/control byte is positive, then it is
;		a count byte, and the content of the following byte
;		will be filled into the image buffer for a number of
;		bytes specified.  Please be noted that zero means this
;		counter is a word, then the next byte is the higher
;		byte of that word.  If the count/control byte
;		is negative, then it means the following:
;			-1 :  ID mark
;			-2 :  Sector body start
;			-3 :  Sector body end
;		Note : The sector body embadded will be automatically
;			repeated for maxsec times.  The pattern
;			following sector-body-end will fill the rest
;			of the buffer.
;		ID mark is a three-byte field containing the track,
;		side, and sector number sequencially.  These bytes
;		will be filled with zero when generating image.  But
;		the location offset from ES will be marked in the
;		ID pointers table.
;
;	Destroyed : AX, BX, CX, DX, SI, DI, BP
imgen	proc near
	add	cx, di	; Boundary
	mov	dx, cx	; Terminating location
iglp:
	xor	ax, ax
	lodsb		; Control or count
	cmp	al, 0
	jg	igcnt	; Positive : Count
; Control (or zero)
	neg	al
	mov	bp, ax
	shl	bp, 1
	jmp	cs:igjptab[bp]
igjptab	label word
dw igwdcnt
dw igid
dw igscbeg
dw igscend

; ID Mark
igid:
	mov	idptr, di
	mov	cx, 3
	xor	al, al
	rep	stosb
	jmp	short iglpend

; Sector Body Begin
igscbeg:
	push	di	; Save sector begin location
	jmp	short iglpend

; Sector Body End
igscend:
	lodsb		; Trailer pattern
	pop	si	; Restore sector begin pattern into DS:SI
	mov	bx, di
	sub	bx, si	; Sector body length
	push	bx

	mov	cx, maxsec
	dec	cx
; Copy sector body
igslp:
	push	si
	push	cx
	mov	cx, bx
	rep	movsb
	pop	cx
	pop	si
	loop	igslp
; Fill with trailer
	mov	cx, dx
	sub	cx, di	; Trailer length
	jle	igntrl
	rep	stosb
igntrl:
; Fill the ID pointers
	pop	bx	; Sector body length
	mov	ax, idptr
	mov	di, 2 + offset idptr
	mov	cx, maxsec
	dec	cx
igilp:
	add	ax, bx
	stosw
	loop	igilp
	jmp	short iglpex


; Controlling routines
igwdcnt:		; Max. Count (100h)
	lodsb
	xchg	ah, al

; Fill image buffer
igcnt:
	mov	cx, ax
	lodsb		; Filler
	rep	stosb
iglpend:
	cmp	di, dx
	jae	iglpex
	jmp	iglp

iglpex:
	ret
imgen	endp


;
; Fill ID Marks :  Fill the ID marks in the image buffer according
;			to the interleave table.
;	Input :	AL - Track number
;		AH - Side number
;		BX - Interleave table
;			(DS & ES is assumed to be in the DATA segment)
;	Destroyed : None
fillid	proc near
	push	bx
	push	cx
	push	si
	push	di
	mov	si, bx
	mov	bx, offset idptr
	mov	cx, maxsec
filp:
	mov	di, [bx]
	add	bx, 2
	stosw
	movsb
	loop	filp
	pop	di
	pop	si
	pop	cx
	pop	bx
	ret
fillid	endp

; Hex and Printing Utilities

;
; Write AL to console
;
wrcon	proc near
	push	dx
	mov	dl, al
	mov	ah, 2
	int	21h
	pop	dx
	ret
wrcon	endp


;
; Print digit in the lower nibble of AL (Destroyed)
;
prdgt	proc near
	and	al, 0fh
	cmp	al, 9
	jle	prd1
	add	al, 'A'-0ah-'0'
prd1:
	add	al, '0'
	call	wrcon
	ret
prdgt	endp

;
; Print AL in decimal
;
prdcmlb	proc near
	aam
	shlah	4
	or	al, ah
	call	prbyte
	ret
prdcmlb	endp

;
; Print AX in decimal
;
prdcmlw	proc near
	push	bx
	push	dx
	xor	dx, dx
	mov	bx, 100
	div	bx
	call	prdcmlb
	mov	ax, dx
	call	prdcmlb
	pop	dx
	pop	bx
	ret
prdcmlw	endp

;
; Print byte in AL (Destroyed)
;
prbyte	proc near
	push	ax
	rol	al, 1
	rol	al, 1
	rol	al, 1
	rol	al, 1
	call	prdgt
	pop	ax
	call	prdgt
	ret
prbyte	endp


;
; Print word in AX (Destroyed)
;
prword	proc near
	push	ax
	mov	al, ah
	call	prbyte
	pop	ax
	call	prbyte
	ret
prword	endp

freeram	label byte	; Must be the last byte

code	ends


end
p

l







