TITLE Monitor Exececute, Break, and Walk Command Recognition
;
name monEBW
;
pgroup group prog
dgroup group data
;
enable_int_sw	equ	1	; Set up the int controller if zero
;
      extrn cr:abs, lf:abs, ill_instr:abs, cmd_tmn:abs, cnt_ind:abs
      extrn seg_ovr:abs, bp_inq:abs, till_ind:abs
      extrn int3:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn brk_pnt_seg:word, brk_pnt_addr:word, brk_pnt_instr:byte
      extrn till_loc:word, till_instr:byte, wr_buf:byte, ip_offset:word
      extrn ax_:word, bx_:word, cx_:word, dx_:word
      extrn ds_:word, si_:word, es_:word, di_:word
      extrn cs_:word, ip_:word, ss_:word, sp_:word
      extrn bp_:word, fcw:word, ss_save:word, sp_save:word
data ends
;
prog segment byte public 'prog'
;
      extrn skip_blank:near, pool_kb:near
      extrn put_char_kb:near, put_str_kb:near, put_msg_kb:near
      extrn fetch_oprn:near, ill_char:near
      extrn hexstr:near, R_disp:near, enable_int:near
      extrn no_bp_msg:byte, bp_is_msg:byte
      extrn show_hex:near, crlf_:near
;     extrn RAM_base:word
      EXTRN DATSEG:WORD
      public E_proc, B_proc, W_proc, O_proc
      public trap, trace, E_no_till
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; E_proc :
;
E_proc proc near
      call     fetch_oprn
      mov      bx, dx  ; Hold IP read, and set only after command OK
      lodsb
      jnc      E_nact_ip
; Set IP
      add      bx, ip_offset
      cmp      al, cmd_tmn
      jne      E_3
      mov      ip_, bx
      jmp      short E_no_till
E_nact_ip:
      cmp      al, cmd_tmn
      je       E_no_till
      mov      bx, ip_
E_3:  ; bx holds to-be-ip now
      cmp      al, till_ind
      jne      E_err
      call     fetch_oprn
      jnc      E_err
      lodsb
      cmp      al, cmd_tmn
      jne      E_err
      mov      ip_, bx
      add      dx, ip_offset
      mov      till_loc, dx
; Set Till-break-point
      mov      es, cs_
      mov      di, dx
      mov      al, es:[di]
      mov      till_instr, al
      mov      byte ptr es:[di], int3
      mov      ax, ds
      mov      es, ax
      jmp      short st_trp
E_no_till:  ; Booting entry point
      mov      till_instr, ill_instr
; Set trap location
st_trp:
      and      fcw, 0feffh  ; Ensure trap bit off
      call     Dispatch
      dec      ip_
      cmp      till_instr, ill_instr
      je       E_disp
; Resume Till-break-point
      mov      ax, cs_
      mov      es, ax
      mov      di, till_loc
      mov      al, till_instr
      mov      es:[di], al
      mov      ax, ds
      mov      es, ax
E_disp:
      call     R_disp
      jmp      short E_end
E_err:
      call     ill_char
E_end:	; Register display is left to the main program
      ret
E_proc endp
;
; B_proc :
;
B_proc proc near
      call     fetch_oprn
      jnc      bp_3
      jmp      B_act
; Inactive
bp_3:
      lodsb
      cmp      al, cmd_tmn
      je       bp_rsm
      cmp      al, bp_inq
      je       bp_1
      jmp      B_err
bp_1:
; Show the break point
      call     skip_blank
      lodsb
      cmp      al, cmd_tmn
      je       bp_2
      jmp      B_err
bp_2:
      cmp      brk_pnt_instr, ill_instr
      jne      bp_addr
; No brk point
      mov      si, offset pgroup:no_bp_msg
      call     put_msg_kb
      jmp      B_end
bp_addr:
      mov      si, offset pgroup:bp_is_msg
      call     put_msg_kb
      mov      dx, brk_pnt_seg
      call     show_hex
      mov      dl, ':'
      call     put_char_kb
      mov      dx, ip_offset
      cmp      dx, 0
      je       bp_4
; Show the offset
      call     show_hex
      mov      ax, dx
      mov      dl, '+'
      call     put_char_kb
      neg      ax
      mov      dx, ax
bp_4:
      add      dx, brk_pnt_addr
      call     show_hex
      call     crlf_
      jmp      short B_end
; Resume the break point
bp_rsm:
      mov      es, brk_pnt_seg
      mov      di, brk_pnt_addr
      mov      al, brk_pnt_instr
      mov      byte ptr es:[di], al
      mov      brk_pnt_instr, ill_instr
      mov      ax, ds
      mov      es, ax
      jmp      short B_end
; Check brk_pnt_engaged
B_act:
      mov      es, cs_  ; Default break segment
      lodsb
      cmp      al, seg_ovr
      jne      bp_5
      mov      es, dx  ; Break Segment
      call     fetch_oprn
      lodsb
      jnc      bp_err_rsm
bp_5:
      cmp      al, cmd_tmn
      je       bp_6
bp_err_rsm:
      mov      ax, ds
      mov      es, ax
      jmp      short B_err
bp_6:
      cmp      brk_pnt_instr, ill_instr
      je       bp_free
; Resume the last one
      push     es
      mov      es, brk_pnt_seg
      mov      di, brk_pnt_addr
      mov      al, brk_pnt_instr
      mov      byte ptr es:[di], al
      pop      es
bp_free:
      mov      brk_pnt_seg, es
      add      dx, ip_offset
      mov      brk_pnt_addr, dx
      mov      di, dx
      mov      al, byte ptr es:[di]
      mov      brk_pnt_instr, al
      mov      byte ptr es:[di], int3
      mov      ax, ds
      mov      es, ax
      jmp      short B_end
B_err:
      call     ill_char
B_end:
      ret
B_proc endp
;
; W_proc
;
W_proc proc near
      call     fetch_oprn
      mov      bx, ip_
      jnc      W_nact
      add      dx, ip_offset
      mov      bx, dx
W_nact:
      mov      cx, 1
      lodsb
      cmp      al, cmd_tmn
      je       W_single
      cmp      al, cnt_ind
      jne      W_err
; Multi-step
      call     fetch_oprn
      lodsb
      cmp      al, cmd_tmn
      jne      W_err
      mov      cx, dx
W_single:
      mov      ip_, bx
W_lp:
      push     cx
      or       fcw, 100h  ; Trap bit
      call     Dispatch
      and      fcw, 0feffh
      call     R_disp
      pop      cx
      call     pool_kb
      cmp      dl, 0ffh
      jne      short W_end
      loop     W_lp
      jmp      short W_end
W_err:
      call     ill_char
W_end:
      ret
W_proc endp
;
; O_proc
;
O_proc proc near
      call     fetch_oprn
      lodsb
      cmp      al, cmd_tmn
      jne      O_err
      mov      ip_offset, dx
      jmp      short O_end
O_err:
      call     ill_char
O_end:
      ret
O_proc endp
;
; Dispatch
;
Dispatch proc near
ife enable_int_sw
      call     enable_int
endif
      call     load_reg
      pushf
      mov      ss_save, ss
      mov      sp_save, sp
      mov      ss, ss_
      mov      sp, sp_
      push     fcw
      push     cs_
      push     ip_
      mov      ds, ds_
      iret  ; Load the flags and far jump
trace:
      push     bp
      mov      bp, sp
      inc      word ptr [bp+2]
      pop      bp
trap:
      push     ds
      push     ax
;     mov      ax, cs:RAM_base
      MOV      AX, CS:DATSEG
      mov      ds, ax
      pop      ax_
      pop      ds_
      pop      ip_
      pop      cs_
      pop      fcw
      mov      ss_, ss
      mov      sp_, sp
      mov      ss, ss_save
      mov      sp, sp_save
      popf
      call     save_reg
      mov      ax, ds
      mov      es, ax
      ret
Dispatch endp
;
; load_reg
;
load_reg proc near
      mov      ax, ax_
      mov      bx, bx_
      mov      cx, cx_
      mov      dx, dx_
      mov      si, si_
      mov      es, es_
      mov      di, di_
      mov      bp, bp_
      ret
load_reg endp
;
; save_reg
;
save_reg proc
      mov      bx_, bx
      mov      cx_, cx
      mov      dx_, dx
      mov      si_, si
      mov      es_, es
      mov      di_, di
      mov      bp_, bp
      ret
save_reg endp
;
prog ends
;
end
