TITLE Monitor Port Command Recognition and advance operation
;
name monP
;
pgroup group prog
dgroup group data
;
      extrn Pin_ind:abs, Pout_ind:abs, cmd_tmn:abs, gh_quit:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn last_port:word, port_addr:word, wr_buf:byte
data ends
;
prog segment byte public 'prog'
;
      extrn pool_kb:near, put_char_kb:near, put_str_kb:near
      extrn cr_:near, crlf_:near, cur_bck:near
      extrn fetch_oprn:near, get_hex:near
      extrn ill_char:near
      extrn P_update:near, paddr_disp:near, port_disp:near
      public P_proc
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; P_proc :
;   Port operations --
;      'P pppp' for input from port and then wait for entry to output
;      'P{[<|>]pppp}+' (except Ppppp) for repetitively input from (<)
;        or output (>) to the ports until exit.
;      Note :  The list can contain at most eight ports.
;
P_proc proc near
      call     fetch_oprn  ; The first operand may be dummy
      jnc      port_list
      lodsb
      cmp      al, cmd_tmn
      je       P_simple
      jmp      P_err
; Simple port operation
P_simple:
      mov      last_port, dx
      call     P_update
      jmp      P_end
; Display the port content
port_list:
      mov      bx, 1  ; BL : Mask for I/O switch; BH : I/O Switch
      xor      cx, cx
      mov      di, offset port_addr
pl_loop:
      lodsb
      cmp      al, cmd_tmn
      je       port_opr
      call     fetch_oprn
      jc       pl_3
      lodsb
      cmp      al, cmd_tmn
      je       pl_4
      jmp      P_err
pl_4:
      sub      si, 2
      lodsb
      jmp      P_err
pl_3:
      mov      [di], dx
      cmp      al, Pin_ind
      je       pl_1
      cmp      al, Pout_ind
      je       pl_2
      cmp      al, ' '
      je       pl_5
      jmp      P_err
pl_5:
; Same as previous
      cmp      ah, 0
      je       pl_2
; In -- set 1
pl_1:
      or       bh, bl
      mov      ah, 0ffh
      jmp      short pl_lpend
pl_2:
; Out -- set 0
      mov      ah, bl
      not      ah
      and      bh, ah
      mov      ah, 0
pl_lpend:
      inc      cx
      add      di, 2
      shl      bl, 1
      jnc      pl_loop
; Margin number of ports
      lodsb
      cmp      al, cmd_tmn
      je       port_opr
      jmp      P_err
port_opr:
      cmp      cx, 0
      jne      po_endless
; No argument -- Last port default
      call     P_update
      jmp      P_end
po_endless:
      mov      si, offset port_addr
      mov      bl, 1
po_loop:
      mov      dx, [si]
      mov      al, bh
      and      al, bl
      jz       P_out
; Input from Port and display
      push     cx
      mov      cx, 2
      call     port_disp
      pop      cx
      mov      dl, ' '
      call     put_char_kb
      call     put_char_kb
      jmp      short po_lpend
P_out:
      call     paddr_disp
      push     cx
      push     si
      mov      word ptr wr_buf+1, '  '
      mov      word ptr wr_buf+3, '  '
      mov      si, offset wr_buf
;========================
; Mind the stack and the write buffer including SI following
      mov      cx, 2
      mov      ax, dx
      call     get_hex
      jc       P_out_act
      cmp      dl, gh_quit
      jne      po_2
      add      sp, 4  ; Dummy popping
      call     crlf_
      jmp      short P_end
po_2:
      cmp      cx, 2
      je       po_1
      mov      dl, 1
      call     cur_bck
po_1:
      mov      wr_buf, 4
      call     put_str_kb
      jmp      short po_stk_rsm
P_out_act:
      xchg     dx, ax
      out      dx, al
      mov      wr_buf, 2
      call     put_str_kb
po_stk_rsm:
      pop      si
      pop      cx
; Stack and write buffer resumed
;========================
po_lpend:
      add      si, 2
      shl      bl, 1
      loop     po_loop
      call     pool_kb
      cmp      dl, 0ffh
      je       po_3
      call     crlf_
      jmp      short P_end
po_3:
      mov      cx, si
      sub      cx, offset port_addr
      shr      cx, 1
      call     crlf_
      jmp      po_endless
P_err:
      call     ill_char
P_end:
      ret
P_proc endp
;
prog ends
;
end
