TITLE Monitor Memory Display
;
name mondsp
;
pgroup group prog
dgroup group data
;
      extrn vc_first:abs, vc_last:abs
;
; data segment (dummy)
data segment word public 'data'
      extrn ssss:word, dsss:word, cccc:word
      extrn mem_buf:byte, mem_buf_end:byte, wr_buf:byte
data ends
;
      public M_display
      assume cs:pgroup, ds:dgroup, es:dgroup
;
;==================================================
;
; Memdisplay
;
prog segment byte public 'prog'
;
; M_display :
;   Display memory locations from ssss for cccc bytes.
;
      extrn put_char_kb:near, put_str_kb:near, hexstr:near
      extrn show_hex:near, crlf_:near
;
M_display proc near
      mov      cx, cccc
      lds      si, dword ptr ssss
      mov      di, offset mem_buf
Md_loop:
      call     fill_buf
      loop     Md_loop
;
      cmp      di, offset mem_buf
      jbe      Md_1
      mov      cx, offset mem_buf_end
      sub      cx, di
      jmp      short Md_loop
Md_1:
      mov      ax, es
      mov      ds, ax
; DS resumed
      ret
M_display endp
;
; fill_buf :
;
fill_buf proc near
      lodsb
      stosb
      cmp      di, offset mem_buf_end
      jae      fb_dump
      jmp      fb_end
fb_dump:
      push     cx
      mov      ax, es
      mov      ds, ax
; DS resumed
; Display Address
      mov      dx, dsss
      call     show_hex
      mov      dl, ':'
      call     put_char_kb
      mov      wr_buf, 6
      mov      dx, ssss
      mov      di, offset wr_buf+1
      call     hexstr
      mov      al, ' '
      stosb
      stosb
      mov      si, offset wr_buf
      call     put_str_kb
; Display in hex
      mov      cx, 8
      mov      wr_buf, 6
      mov      si, offset mem_buf
fb_loop:
      lodsw
      mov      dx, ax
      xchg     dh, dl
      mov      di, offset wr_buf+1
      call     hexstr
      mov      al, wr_buf[4]
      mov      wr_buf[5], al
      mov      al, wr_buf[3]
      mov      wr_buf[4], al
      mov      wr_buf[3], ' '
      mov      ax, si
      mov      si, offset wr_buf
      call     put_str_kb
      mov      si, ax
      cmp      cx, 5
      jne      fb_lpend
      mov      dl, ' '
      call     put_char_kb
fb_lpend:
      loop     fb_loop
; Display in char
      mov      dl, ' '
      call     put_char_kb
      call     put_char_kb
      mov      si, offset mem_buf
      mov      cx, 10h
Md_loop_2:
      lodsb
      and      al, 7fh
      cmp      al, vc_first
      jb       nvc
      cmp      al, vc_last
      jbe      vc
nvc:
      mov      al, '.'
vc:
      mov      dl, al
      call     put_char_kb
      loop Md_loop_2
;
      mov      di, offset mem_buf
      add      ssss, 10h
      call     crlf_
      lds      si, dword ptr ssss
; DS set to segment being displayed
      pop      cx
fb_end:
      ret
fill_buf endp
;
prog ends
;
end
