TITLE SYSCON Monitor Debugger
;
name prog
;
pgroup group prog
dgroup group data
;
      extrn M_code:abs
      extrn R_code:abs
      extrn P_code:abs
      extrn E_code:abs
      extrn B_code:abs
      extrn W_code:abs
      extrn L_code:abs
      extrn O_code:abs
      extrn S_code:abs
      extrn I_code:abs
      extrn Q_code:abs
      extrn prompt:abs, eocmd:abs, cmd_tmn:abs
      extrn cr:abs, lf:abs
      extrn wreg_num:abs
      extrn sng_quote:abs, dbl_quote:abs
      extrn ill_instr:abs, init_seg:abs
      extrn boot_key:abs, boot_seg:abs, boot_loc:abs
      extrn memlog:near, iolog:near
;
; data segment (dummy)
data segment word public 'data'
      extrn cmd_ptr:word, read_buf:byte, reg_set:word, cmd_buf:byte
      extrn brk_pnt_instr:byte, W_flag:byte, ip_offset:word
      extrn cs_:word, ds_:word, es_:word, ss_:word, ip_:word
      extrn last_port:word, ssss:word, dsss:word
      extrn quit_point:dword
data ends
;
prog segment byte public 'prog'
      extrn M_proc:near
      extrn R_proc:near
      extrn P_proc:near
      extrn E_proc:near
      extrn B_proc:near
      extrn W_proc:near
      extrn L_proc:near
      extrn O_proc:near
      extrn get_str_kb:near, put_char_kb:near, put_msg_kb:near
      extrn skip_blank:near, clr_eoln:near, clr_scr:near
      extrn set_trap:near, set_single:near, set_trace:near
      extrn E_no_till:near, trap:near, trace:near
      extrn terminate:near
      extrn header_msg:byte, err_cmd_msg:byte
;     extrn RAM_base:word, stack_seg:word, stack_ptr:word
      EXTRN DATSEG:WORD
      assume cs:pgroup, ds:dgroup, es:dgroup
;
; Main Program
;
public moninit
moninit:
; Initialization
; Segment registers, pointer, and flag
      mov      ax, cs:DATSEG
      mov      ds, ax
      mov      word ptr quit_point+2, 0ffffh  ; Reset segment
      mov      word ptr quit_point, 0  ; Reset location
      jmp      start_user
      org 20h  ; Entry point from the user program
start_user:
      mov      ax, cs:DATSEG
      mov      es, ax
;     add      ax, cs:stack_seg  ; Offset from DS
;     mov      ss, ax
;     mov      sp, cs:stack_ptr
      cld
; Print heading
      call     clr_scr
      mov      si, offset cs:header_msg
      call     put_msg_kb
; Initial value in RAM
      mov      brk_pnt_instr, ill_instr
      mov      W_flag, 0
      mov      last_port, 0
      mov      ssss, 0
      mov      dsss, init_seg
      mov      ip_offset, 0
      xor      ax, ax
      mov      cx, wreg_num+1
      mov      di, offset reg_set
      rep stosw
      mov      cs_, init_seg
      mov      ds_, init_seg
      mov      es_, init_seg
      mov      ss_, init_seg
; Set vectors
      mov      dx, offset cs:trap
      call     set_single
      call     set_trap
      mov      dx, offset cs:trace
      call     set_trace
; Read buffer end-of-command condition
      mov      read_buf, eocmd
      mov      cmd_ptr, offset read_buf
main_loop:
      call     get_cmd
      call     skip_blank
      lodsb
      cmp      al, M_code
      jne      M_jmp
      call     M_proc
      jmp      loop_end
M_jmp:
      cmp      al, R_code
      jne      R_jmp
      call     R_proc
      jmp      short loop_end
R_jmp:
      cmp      al, P_code
      jne      P_jmp
      call     P_proc
      jmp      short loop_end
P_jmp:
      cmp      al, E_code
      jne      E_jmp
      call     E_proc
      jmp      short loop_end_Wf
E_jmp:
      cmp      al, B_code
      jne      B_jmp
      call     B_proc
      jmp      short loop_end
B_jmp:
      cmp      al, W_code
      jne      W_jmp
      call     W_proc
      jmp      short loop_end_Wf
W_jmp:
      cmp      al, L_code
      jne      L_jmp
      call     L_proc
      jmp      short loop_end
L_jmp:
      cmp      al, O_code
      jne      O_jmp
      call     O_proc
      jmp      short loop_end
O_jmp:
      cmp      al, S_code
      jne      S_jmp
      call     memlog
      jmp      short loop_end
S_jmp:
      cmp      al, I_code
      jne      I_jmp
      call     iolog
      jmp      short loop_end
I_jmp:
      cmp      al, boot_key
      jne      boot_jmp
      mov      cs_, boot_seg
      mov      ip_, boot_loc
      call     E_no_till
      jmp      short loop_end_Wf
boot_jmp:
      cmp      al, Q_code
      jne      Q_jmp
      jmp      terminate
Q_jmp:
      cmp      al, cmd_tmn
      jne      Err
      cmp      W_flag, 0
      je       loop_end
      dec      si
      call     W_proc
      jmp      short loop_end_Wf
Err:
      mov      si, offset cs:err_cmd_msg
      call     put_msg_kb
loop_end:
      mov      W_flag, 0
      jmp      main_loop
loop_end_Wf:
      mov      W_flag, 0ffh
      jmp      main_loop
;
; get_cmd :
;   Get a command into the command buffer.  If end-of-input-line
;   detected, another line will be read.
;   All the characters except for those quoted are converted into
;   upper case.  The quotation marks are represented by NULL.
;   After this procedure, SI will point to the command buf (cmd_buf),
;   and the DI will point to the location immediately after the
;   last byte of the command, that is the command seperator (';').
;   AX and BX are destroyed.
;
get_cmd proc near
      mov      si, cmd_ptr
      cmp      byte ptr [si], eocmd
      jne      cp_cmd
      mov      dl, prompt
      call     put_char_kb
      call     clr_eoln
      mov      di, offset read_buf
      call     get_str_kb
      xor      bx, bx
      mov      bl, read_buf
      inc      bx
      mov      byte ptr read_buf[bx], cr
      mov      si, di
cp_cmd:
      inc      si
      mov      di, offset cmd_buf
      xor      dl, dl  ; Buffer and flag of quotes
cp_loop:
      lodsb
      cmp      al, eocmd
      je       cp_end
      cmp      al, cmd_tmn
      je       cp_end
      cmp      dl, 0
      je       gc_2
      cmp      al, dl
      jne      gc_1
      xor      dl, dl  ; string terminated
      xor      al, al  ; zero as quote
      jmp      short gc_1
gc_2:
      cmp      al, sng_quote
      je       gc_3
      cmp      al, dbl_quote
      jne      gc_4
gc_3:
      mov      dl, al
      xor      al, al  ; zero as quote
      jmp      short gc_1
gc_4:
      cmp      al, 'a'
      jb       gc_1
      cmp      al, 'z'
      ja       gc_1
      sub      al, 'a'-'A'
gc_1:
      stosb
      jmp      short cp_loop
cp_end:
      mov      al, cmd_tmn
      stosb
      dec      si
      mov      cmd_ptr, si
      mov      si, offset cmd_buf
      ret
get_cmd endp
;
prog ends
;
end
