Title  -----  BIOS  of GIFDIC standard.  Version 1.05S. 26th Nov., 1984

		; Upgraded to 1.05S by AHMS 16/07/85
		;
		; Only change: AUX device changed from dtedev to sauxdev

		;
		; Added code for extended memory option 08/05/85
.sall

reinitseg   segment at 9090h
	public re_init
	org 9090h
re_init  label far
reinitseg  ends

debuga equ 0
debugp equ 0
debugc equ 0
debugd equ 0
debugt equ 0
conblock equ 0
auxblock equ 0
sprtblock equ 0
simgif	equ 0

include \mac\gifmac.mac
include src\driver.equ

biosizs	equ	300h
extrn	sysinit: far
extrn	current_dos_location : word
extrn   final_dos_location : word
extrn   device_list : word
extrn	memory_size : word
extrn	default_drive : byte
extrn   buffers: byte
code	segment
	org 0
assume  cs:code, ds:code, es:code, ss:code

beginbios = $
init:
	jmp first_init
	org 10h
; gifdic arbitor address in prom, should be set during initialization

gifdic	label dword
gifoff	dw ?
gifseg  dw ?

promaddtab promaddtabstruc <,,,,,>
condev  c_dev_hdr <auxdev,-1,8003h,strategy,con_int,"CON     ",>
 
auxdev  c_dev_hdr <prndev,-1,8001h,strategy,aux_int,"AUX     ",>
  
prndev  c_dev_hdr <timdev,-1,8000h,strategy,sprt_int,"PRN     ",>

timdev  c_dev_hdr <dsk_dev,-1,8008h,strategy,tim_int,"CLOCK   ",>

dsk_dev  b_dev_hdr <sys_dev,-1,2000h,strategy,dsk_int,00H,,>

sys_dev   c_dev_hdr <-1,-1,8000h,strategy,sys_int,"GIFSYS99">


;
; handling routines tables for the three kinds of drivers
;

contbl: 
	dw  	con_init		;0 --- init. (not used)
	dw	exit			;1 --- media check (not used)
	dw	exit			;2 --- get bios parameter block
					;	(not used)
	dw	cmderr			;3 --- reserved. (currently returns
					;		  error)
	dw	con_read		
	dw	con_rdnd
	dw	con_i_stat
	dw	con_i_flsh
	dw	con_writ
	dw	con_writ
	dw	con_o_stat
	dw	con_o_flsh
	dw	cmderr

auxtbl:
	dw	aux_init
	dw	exit
	dw	exit
	dw	cmderr
	dw	aux_read
	dw	aux_rdnd
	dw	aux_i_stat
	dw	aux_i_flsh
	dw	aux_writ
	dw	aux_writ
	dw	aux_o_stat
	dw	aux_o_flsh
	dw	cmderr

sprttbl:
	dw	sprt_init
	dw	exit
	dw	exit
	dw	cmderr
	dw	cmderr
	dw	cmderr
	dw	exit
	dw	exit
	dw	sprt_writ
	dw	sprt_writ
	dw	sprt_o_stat
	dw	sprt_o_flsh
	dw	cmderr

dsktbl:
	dw	dsk_init
	dw	mediac
	dw	get_bpb
	dw	cmderr
	dw	dsk_red
	dw	bus_exit
	dw	exit
	dw	exit
	dw	dsk_wrt
	dw	dsk_wrtv
	dw	exit
	dw	exit
	dw	cmderr

timtbl:
	dw	tim_init
	dw	exit
	dw	exit
	dw	cmderr
	dw	tim_red
	dw	bus_exit
	dw	exit
	dw	exit
	dw	tim_wrt
	dw	tim_wrt
	dw	exit
	dw	exit
	dw	cmderr

systbl:
	dw	sys_init
	dw	exit
	dw	exit
	dw	cmderr
	dw	sys_red
	dw	bus_exit
	dw	exit
	dw	exit
	dw	sys_wrt
	dw	sys_wrt
	dw	exit
	dw	exit
	dw	cmderr
; interrupt entries

con_int:					; console interrupt
	pusha
	mov si, offset contbl
	jmp short entry

;
;

aux_int:					; auxiliary interrupt
	pusha
	mov si, offset auxtbl
	jmp short entry

;
;
sprt_int:					; printer interrupt
	pusha
	mov si, offset sprttbl
	jmp short entry

;
;

dsk_int:					; disk interrupt
	pusha
	mov si, offset dsktbl
	jmp short entry
;
;

tim_int:					; clock interrupt
	pusha
	mov si, offset timtbl
	jmp short entry
;
;

sys_int:					; sysdev interrupt
	pusha
	mov si, offset systbl
	jmp short entry

; common entry point for into  all the handling routines
;
entry:
	mov cs:ss_save, ss		; save original ss
	mov cs:sp_save, sp		; save original sp
	mov bx, cs			; install new ss and sp
	mov ss, bx
	mov sp, offset tows

;	mov al, byte ptr cs:ss_save
;	prbyte
;	mov al, byte ptr cs:ss_save[1]
;	prbyte
;	mov al, byte ptr cs:sp_save
;	prbyte
;	mov al, byte ptr cs:sp_save[1]
;	prbyte

	push ds
	push es
	cld
	les bx, cs:[ptrsav]		; get the request from ptrsav
	mov al, es:[bx.com_code]		; get the command code
	xor  ah, ah
	add  si, ax
	add  si, ax
	cmp  al, 12			; check the code
	jna   nxt_stt
	jmp   cmderr			; above means command error
nxt_stt:
	mov  ax, cs			; set es=ds=cs
	mov  ds, ax
	jmp  [si]





; handling routines for all the character driver


; initialization for the console


bkflg db 00
sprt_chk db 00

con_init:
if debugc
	echo "c"
	echo "o"
	echo "i"
	echo "n"
endif
	jmp exit

; initialization for the auxiliary device

aux_init:
if debuga
	echo "a"
	echo "u"
	echo "i"
	echo "n"
endif
	jmp exit

; initialization for the printer device

sprt_init:
if debugp
	echo "p"
	echo "r"
	echo "i"
	echo "n"
endif
	jmp exit

; get status for console
con_i_stat:
if debugc
	echo "c"
	echo "o"
	echo "s"
	echo "t"
endif
	echo "i"
	gifcall scondev,gstatus,noopt	; try to get status of console channel
	jmp chk_stat_result

; get status for auxiliary IO device
aux_i_stat:
if debuga
	echo "a"
	echo "u"
	echo "s"
endif
	gifcall sauxdev,gstatus,noopt  ; try to get status of auxiliary channel
	jmp chk_stat_result

	
chk_stat_result:
	jnc stat_ready
	cmp ah, notrdy		;if the error returned is not ready 
	je stat_busy		;just busy exit, otherwise error exit
	jmp err_exit
stat_ready: jmp exit
stat_busy:   jmp bus_exit

; nondestructive read for console device
con_rdnd:
if debugc
	echo "R"
	echo "D"
	echo "N"
	echo "D"
endif
	echo "n"
	gifcall scondev,gstatrg,noopt	; get the status register
	jnc just_cont
	jmp con_rdn2
just_cont:
	test ax, breakc
	jnz flsh_con	
	test bkflg, scbreak		; test ready the system con break bit
					; is set in the break flag
	jz con_rdn1			; if it is not, just non-destructive
					; read the first char in the input
					; buffer
flsh_con:
	and bkflg, not scbreak
	mov al, ctrl_c
	gifcall scondev,rdflush,STOAL	; flush input buffer and put in a
					; ctrl_c char
	jc con_rdn2			; carry bit set means error or busy
	mov al, ctrl_c		; pass ctrl_c to MS-DOS
	jmp short rdn_succ
con_rdn1:
	gifcall scondev,gstatus	; non-destructive read the first character
	jc con_rdn2	; carry bit set means error or device busy
rdn_succ:les bx, cs:[ptrsav]	; and return the character
	mov es:[bx.non_des_read], al
if debugc
	echo "x"
endif
dskmesn equ 0
if dskmesn
	cmp al, 04h
	jne rdnd_succ
	push ds
	push di
	mov di, 3800h
	mov ds, di
	xor di, di
	xor byte ptr [di], 80h
	pop di
	pop ds
rdnd_succ:
endif
	jmp exit
con_rdn2:
	cmp ah, notrdy	; if the error code returned is not ready, just busy
	je	con_rdn3; exit
if debugc
	echo "y"
endif
	jmp err_exit	; otherwise error exit
con_rdn3:
if debugc
	echo "z"
endif
	jmp bus_exit

; nondestructive read for auxiliary device
aux_rdnd:
if debuga
	echo "a"
	echo "u"
	echo "r"
	echo "n"
endif
	gifcall sauxdev,gstatrg,noopt	; get the status register
	jc aux_rdnd2			; carry bit set means error or busy
	test ax, breakc
	jnz flsh_aux	
	test bkflg, aubreak		; test ready the aux break bit
					; is set in the break flag
	jz aux_rdnd1			; if it is not, just non-destructive
					; read the first char in the input
					; buffer
flsh_aux:
	and bkflg, not aubreak		; clear the break bit in the break flag
	mov al, ctrl_c
	gifcall sauxdev,rdflush,STOAL	; flush input buffer and put in a
					; ctrl_c char
	jc aux_rdnd2			; carry bit set means error or busy
	mov al, ctrl_c		; pass ctrl_c to MS-DOS
	jmp short ardn_succ
aux_rdnd1:
	gifcall sauxdev,gstatus
	jc aux_rdnd2		;carry bit set means error or busy
ardn_succ:
	les bx, cs:[ptrsav]	;return the character
	mov es:[bx.non_des_read], al
	jmp exit
aux_rdnd2:
	cmp ah, notrdy		;if device not ready, just busy exit
	je	aux_rdnd3
	jmp err_exit
aux_rdnd3:
	jmp bus_exit		;otherwise error exit

; destructive read for the console device
con_read:
if debugc
	echo "R"
	echo "E"
	echo "A"
endif
	echo "r"
	mov cx, es:[bx.count]
	les di, dword ptr es:[bx.transfer_offset]
if conblock
rd_from_dri:
	gifcall scondev,read,(waitrdy)or(block); block read from the driver
	jc con_rd_err
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	jmp exit
con_rd_err:
	les bx, cs:[ptrsav]	;save the number of characters transferred
	sub es:[bx.count], cx	
	cmp ah, notrdy		;if the error code is not ready, just busy exit
	je con_rd_busy		
	jmp err_exit		;otherwise busy exit
con_rd_busy:
	jmp bus_exit

else
loprchar:
	push cx
	gifcall scondev,read,noopt; get a character from the driver
	pop cx
	jc	con_read1	;if there is an error, stop the loop
	stosb
dskmesr  equ 0
if dskmesr
	cmp al, 04h
	jne succ_rd
	push ds
	push di
	mov di, 3800h
	mov ds, di
	xor di, di
	xor byte ptr [di], 80h
	pop di
	pop ds
endif
succ_rd:
	loop loprchar
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	jmp exit
con_read1: 
	les bx, cs:[ptrsav]	;save the number of characters actually transfered
	sub es:[bx.count], cx
	cmp ah, notrdy		;if the error code is not ready, just busy exit
	je con_rd_set_busy
	jmp err_exit		;otherwise error exit
con_rd_set_busy:
	jmp bus_exit
endif

; destructive read for the auxiliary device
aux_read:
if debuga
	echo "a"
	echo "u"
	echo "r"
	echo "d"
endif
	mov cx, es:[bx.count]
	les di, dword ptr es:[bx.transfer_offset]
if auxblock
rd_from_aux:
	gifcall sauxdev,read,(waitrdy)or(block); block read from the driver
	jc aux_rd_err
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	jmp exit
aux_rd_err:
	les bx, cs:[ptrsav]	;save the number of characters transferred
	sub es:[bx.count], cx	
	cmp ah, notrdy		;if the error code is not ready, just busy exit
	je aux_rd_busy		
	jmp err_exit		;otherwise error exit
aux_rd_busy:
	jmp bus_exit

else
loprchraux:
	push cx
	gifcall sauxdev,read,waitrdy	; get a character from the driver
	pop cx
	jc	aux_read1	;if there is an error, stop the loop
aux_tst:
	stosb
aux_succ_rd:
	loop loprchraux
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	jmp exit
aux_read1: 
	les bx, cs:[ptrsav]	;save the number of characters actually transfered
	sub es:[bx.count], cx
	cmp ah, notrdy		;if the error code is not ready, just busy exit
	je aux_rd_set_busy
	jmp err_exit		;otherwise error exit
aux_rd_set_busy:
	jmp bus_exit
endif

;	write characters to console output devices
con_writ:
if debugc
	ECHO "W"
	ECHO "R"
	ECHO "I"
	ECHO "T"
	ECHO "E"
endif
	echo "w"
if conblock
 	mov cx, es:[bx.count]	;get the buffer address and the count
	les di, dword ptr es:[bx.transfer_offset]
	mov	dh, 0ffh	; 0ffh means at current cursor
	gifcall scondev,write,(waitrdy)or(block) ;transfer data from the
							;driver
	jc con_writ_chk_err
	jmp exit
con_writ_chk_err:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	cmp ah, notrdy
	je con_bus
	jmp err_exit
con_bus:
	jmp bus_exit
else
	mov cx, es:[bx.count]	;get the buffer address and the count
	les	si, dword ptr es:[bx.transfer_offset]
lopwchar:
	lods     byte ptr  es:[si]
	push cx
	mov	dh, 0ffh	; 0ffh means at current cursor
	gifcall scondev,write,(waitrdy)
	pop cx
	jc con_writ1
	loop lopwchar
	jmp exit
con_writ1:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	cmp ah, notrdy
	je con_bus
	jmp err_exit
con_bus:
	jmp bus_exit
endif

; write characters to auxiliary output device
aux_writ:
if debuga
	echo "a"
	echo "u"
	echo "w"
	echo "r"
endif
if auxblock
 	mov cx, es:[bx.count]	;get the buffer address and the count
	les di, dword ptr es:[bx.transfer_offset]
	gifcall sauxdev,write,(waitrdy)or(block) ;transfer data from the
							;driver
	jc aux_writ_chk_err
	jmp exit
aux_writ_chk_err:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	cmp ah, notrdy
	je aux_bus
	jmp err_exit
aux_bus:
	jmp bus_exit
else
	mov cx, es:[bx.count]	;get the buffer address and the count
	les	si, dword ptr es:[bx.transfer_offset]
lopwchraux:
	lods     byte ptr  es:[si]
	push cx
	gifcall sauxdev,write,(waitrdy)
	pop cx
	jc aux_writ1
	loop lopwchraux
	jmp exit
aux_writ1:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	cmp ah, notrdy
	je aux_bus
	jmp err_exit
aux_bus:
	jmp bus_exit
endif

; write characters to printer 
sprt_writ:
if debugp
	echo "p"
	echo "r"
	echo "w"
	echo "r"
endif
if sprtblock
 	mov cx, es:[bx.count]	;get the buffer address and the count
	les di, dword ptr es:[bx.transfer_offset]
	gifcall sprtdev,write,noopt
							;driver
	jc sprt_writ_chk_err
	jmp exit
sprt_writ_chk_err:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	cmp ah, notrdy
	je sprt_bus
	jmp err_exit
sprt_bus:
	jmp bus_exit
else
	mov cx, es:[bx.count]	;get the buffer address and the count
	les	si, dword ptr es:[bx.transfer_offset]
lopwchrsprt:
	lods     byte ptr  es:[si]
	push cx
	gifcall sprtdev,write,noopt
	pop cx
	jc sprt_writ1
	loop lopwchrsprt
	mov cs:sprt_chk, 0
	jmp exit
sprt_writ1:
	les bx, cs:[ptrsav]
	cmp ah, notrdy
	je sprt_bus
	sub es:[bx.count], cx
	jmp err_exit
sprt_bus:
	cmp cs:sprt_chk, 1
	je sprt_writ_cont
	jmp sprt_writ
sprt_writ_cont:
	mov cs:sprt_chk, 0
	sub es:[bx.count], cx
	jmp bus_exit
endif


; console input buffer flush

con_i_flsh:
	;echo "f"
	;echo "i"
	gifcall scondev,rdflush,noopt  ; then clear the buffer in the device
	jmp  chk_flsh_result

; auxiliary input buffer flush

aux_i_flsh:
if debuga
	echo "a"
	echo "u"
	echo "i"
	echo "f"
endif
	gifcall sauxdev,rdflush,noopt  ; then clear the buffer in the device
	jmp  chk_flsh_result

; console output buffer flush
con_o_flsh:
	;echo "f"
	;echo "o"
	gifcall scondev,wrflush,noopt
	jmp chk_flsh_result

; auxiliary output buffer flush
aux_o_flsh:
if debuga
	echo "a"
	echo "u"
	echo "o"
	echo "f"
endif
	gifcall sauxdev,wrflush,noopt
	jmp chk_flsh_result

; printer output buffer flush
sprt_o_flsh:
if debugp
	echo "p"
	echo "r"
	echo "o"
	echo "f"
endif
	gifcall sprtdev,wrflush,noopt
	jc chk_flsh_result_prn
	jmp chk_flsh_result

chk_flsh_result_prn:
;	mov al, ah
;	prbyte
	jmp err_bus_flsh

; check the flush result
chk_flsh_result:
	jc   err_bus_flsh
	jmp exit
err_bus_flsh:
	cmp ah, notrdy
	je bus_flsh
	jmp err_exit
bus_flsh:jmp bus_exit

; output status for console, aux and printer

con_o_stat:
	echo "o"
	gifcall scondev, gstatrg, noopt      ; get the system console status
					     ; register
	jnc o_stat_cont; if CY, test the error
	jmp o_stat_err
o_stat_cont:
	test ax, breakc
	jz con_o_cont
	or bkflg, scbreak
con_o_cont:
	test ax, txbrdy		; else test whether the transmittion buffer is
	jnz o_stat_bus_cont
	jmp o_stat_bus
o_stat_bus_cont:
	jmp exit

aux_o_stat:
	gifcall sauxdev,gstatrg,noopt	; get the dte device status register
	jnc aux_o_cont1
	jmp o_stat_err
aux_o_cont1:
	test ax, breakc
	jz aux_o_cont
	or bkflg, aubreak
aux_o_cont:
	test ax, txbrdy		; else test whether the transmittion buffer is
	jnz aux_o_cont2
	jmp o_stat_bus
aux_o_cont2:
	jmp exit

sprt_o_stat:
	mov cs:sprt_chk, 1
	gifcall sprtdev,gstatrg,noopt   ; get the printer status register
	jc o_stat_err_prn	; if CY, test the error
	test ax, txbrdy		; else test whether the transmittion buffer is
	jnz sprt_o_stat_cont
	jmp o_stat_bus
sprt_o_stat_cont:
	jmp exit

o_stat_err_prn:
o_stat_err:
	cmp ah, notrdy		; test whether the error returned is not 
	je o_stat_bus		; ready If it is, just return
				; busy. If it is not, return the error code
	jmp err_exit

o_stat_bus:
	jmp bus_exit

;  disk handling routines 

;  This is the parameter blocks for the hard disks and floppy disks in the
;  system


dpbtab	dpb max_units	dup (<,,,,,,,,>)
inittab dw  max_units dup (?)
num_of_units db 00h
tempbuf	db	512 dup (?)
sbpbptr label word
	dw	s9h1bpb
	dw	s9h2bpb
	dw	s8h1bpb
	dw	s8h2bpb

s9h1bpb	dpb <512,1,1,2,64,0000h,0fch,2,>
s9h2bpb dpb <512,2,1,2,112,0000h,0fdh,2,>
s8h1bpb dpb <512,1,1,2,64,0000h,0feh,1,>
s8h2bpb dpb <512,2,1,2,112,0000h,0ffh,1,>

fpsiz40	label word
	dw	0168h
	dw	02d0h
	dw	0140h
	dw	0280h

fpsiz80	label near
	dw	2b5h
	dw	55ch
	dw	268h
	dw	4d0h

trademark db "COLEX"
prembyteh db 0fah
dsk_init:
if debugd
	echod  "i"
endif
	push	cs		; set es=cs
	pop	es		;
; 	mov si, offset dpbtab
;	mov inittab, si
;	mov num_of_units, 1
;	jmp init_end
	mov dl, ctrlog		; get controller logging information
	push es
	gifcall dskdev,gstatus,(waitrdy)or(dtrim)
	pop es
	jnc init_cont1
	jmp err_exit
init_cont1:
	mov di, offset dpbtab	; si is the index into dpb table
	mov si, offset inittab  ; di is the index into dpb ptr table
	add ch, cl		; unit numbers for floppy disks are just higher
				; than those of hard disks
	cmp al, cl		; check whether boot drive is hard disk or floppy disk
	jge  map_flpy_first	; if it is, map the floppy diskettes drives first
       	mov ah, al
	call map_hard_disk	; otherwise, map hard disks first
	mov al, cl
	mov ah, al
	call map_floppy_disk
	jmp short init_end
map_flpy_first:
	mov ah, al
	call map_floppy_disk
	mov al, 00h
	mov ah, al
	call map_hard_disk
init_end:
	les bx, cs:[ptrsav]	; now, get the request header address
	mov al, num_of_units
	mov es:[bx.unit_count], al	; pass back number of units
	mov es:[bx.ending_offset], offset endbios; the ending address offset
	mov es:[bx.ending_seg], cs	; and the ending address segment
	mov es:[bx.bpb_offset], offset inittab
	mov es:[bx.bpb_seg], cs
if debugd
	echod "i"
	echo "f"
endif
	jmp exit
	

map_hard_disk:
if debugd
	echod "h"
endif
	cmp cl, 00h		; check whether there is no hard disk
	jne  mhd_1
	jmp mhd_ret
mhd_1:
	mov [di.log_unit_map], al ; map from boot unit to largest unit
	or [di.othstatus], hd_dsk
	mov [si], di
	push ax
	push cx
	push di
	push es
	gifcall dskdev,reset,(waitrdy)or(dtrim)
	pop es
	pop di
	pop cx
	pop ax
	jc mhd_3
	call set_par_blk	; set the parameter block of the device
	jmp short mhd_31
mhd_3:
	or [di.othstatus], err_exist
mhd_31:
	inc si
	inc si
	add di, size dpb
	inc al
	cmp al, cl
	jne mhd_1
	mov al, 00h

mhd_2:
	cmp al, ah		; map from unit zero to unit just smaller than
				; boot unit
	je chk_hd_unit
	mov [di.log_unit_map], al
	mov [di.othstatus], hd_dsk
	mov [si], di
	push ax
	push cx
	push di
	push es
	gifcall dskdev,reset,(waitrdy)or(dtrim)
	pop es
	pop di
	pop cx
	pop ax
	jc mhd_4
	call set_par_blk	; set the parameter block of the device
	jmp short mhd_41
mhd_4:
	or [di.othstatus], err_exist
mhd_41:
	inc si
	inc si
	add di, size dpb
	inc al
	jmp short mhd_2
chk_hd_unit:
	cmp cl, min_num_hd	; check whether it is less than the minimum
				; number of hard disk
	jge   add_cl_to		; if it is not, just update number of unit
				; by ch, otherwise by min_num_hd
	add num_of_units, min_num_hd
	push cx
	xor ch, ch
	sub cx, min_num_hd
	neg	cx
set_null_hd_map:
	mov [si], offset dpbtab
	add word ptr [si], ((max_units-1)*(size dpb))
	inc si
	inc si
	loop set_null_hd_map
	pop cx
if debugd
	echod "h"
	echo "f"
endif
	ret
add_cl_to: add num_of_units, cl
mhd_ret:   ret

map_floppy_disk:
if debugd
	echod "f"
endif
	cmp ch, cl		; check whether there is no floppy disks
	jg mfp_1
	jmp mfp_ret
mfp_1:
if debugd
	echod "f"
	echo "c"
endif
	mov [di.log_unit_map], al  ; map from boot unit to largest unit
	mov [si], di
;	push ax
;	push cx
;	push es
;	gifcall dskdev,reset,(waitrdy)or(dtrim)
;	pop es
;	pop cx
;	pop ax
;	jc mfp_3
;	call set_par_blk	; set the parameter block of the device
;	jmp short mfp_31
mfp_3:
	and [di.othstatus], flp_dsk
	or [di.othstatus], err_exist
mfp_31:
	inc si
	inc si
	add di, size dpb
	inc al
	cmp al, ch
	jne mfp_1
	mov al, cl
mfp_2:
	cmp al, ah		; map from unit just following hard disks
				; to unit just smaller than that in ah
	je chk_flpy_disk
	mov [di.log_unit_map], al
	mov [si], di
;	push ax
;	push cx
;	push es
;	gifcall dskdev,reset,(waitrdy)or(dtrim)
;	pop es
;	pop cx
;	pop ax
;	jc mfp_4
;	call set_par_blk	; set the parameter block of the device
;	jmp short mfp_41
mfp_4:
	and [di.othstatus], flp_dsk
	or [di.othstatus], err_exist
mfp_41:
	inc si
	inc si
	add di, size dpb
	inc al
	jmp short mfp_2
chk_flpy_disk:
	sub ch, cl		; resume the number of floppy disks
	cmp ch, min_num_fp	; check whether it is less than the minimum
				; number of floppy disks. If it is not less,
				; update number of units by ch, otherwise by
				; min_num_flpy
	jge add_ch_to
	add num_of_units, min_num_fp
	mov cl, ch
	push cx
	xor ch, ch
	sub cx, min_num_fp
	neg cx
null_dev_set:
	mov [si], offset dpbtab
	add word ptr [si], ((max_units-1)*(size dpb))
	inc si
	inc si
	loop null_dev_set
	pop cx
if debugd
	echod "f"
	echo "f"
endif
	ret
add_ch_to:
	add num_of_units, ch
mfp_ret:
if debugd
	echod "f"
	echo "c"
	echo "f"
endif
	ret

set_par_blk:
if debugd
	echod "s"
endif
	push cx		; save cx and ax
	push ax
	call medchkopt
;;;	mov dl, medchk
;;;	gifcall dskdev,gstatus,(dtrim)
	jnc	set_cont	; carry bit clear means no error
				; if there is error, just leave the block
				; filled with 0ffh
	or [di.othstatus], err_exist
	pop ax
set_ret:
	pop cx
if debugd
	echod "s"
	echo "f"
endif
	ret

set_cont:
;	after media check, dl will contain the following information :
;
;	b0: 1 -- 2 head otherwise 1
;	b1: 1 -- 8 sector/track otherwise 9
;	b2: 1 -- 40 tracks otherwise 80
;	b3: 1 -- SD otherwise DD
;	b4: 1 -- floppy disk otherwise XEBEC
;
	pop  ax			; the unit number
	push ax
	push si			; save the value of si and di
	push di
;	mov [di.medchk_rep], medchk_rep_set
; if it is XEBEC, handle in another way
	test dl, remove_or_not
	jz	set_blk_hd
	test dl, forty_or_not	; check whether it is forty tracks
	jz	its_eighty
	mov [di.num_tracks], 40
;	or	dl, 04h
	jmp short set_cont2
its_eighty:
	mov [di.num_tracks], 80
;	and	dl, 0fbh
set_cont2:
	or	dl, 0f8h		; set the fourth and higher bits
	mov [di.med_des], dl
	call build_fp_dpb	; build dpb of floppy disk
	jmp short set_resume_ret
set_blk_hd:
	mov [di.med_des], 0f8h
	call build_hd_dpb	; build dpb of hard disk
set_resume_ret:
	pop di
	pop si
	pop ax
	jmp short set_ret
				
	
mediac:
if debugd
	echod "m"
endif
	mov al, es:[bx.unit_code]	; get the unit code first
if debugd
	prbyte
endif
	push	cs
	pop	es
	xor ah, ah
	mov di, ax
	shl di, 1
	add di, offset inittab
	mov di, [di]
if debugd
	mov ax, [di.sector_size]
	prbyte
	mov al, ah
	prbyte
	mov al, [di.med_des]
	prbyte
endif
	mov al, [di.log_unit_map]
if debugd
	prbyte
endif
	cmp al, 0ffh
	jne unit_exist		; al not= 0ffh means that there is a logical
				; unit mapped to this unit
	mov ah, notrdy		; set device not ready
	jmp err_exit
unit_exist:
	push ax
	test [di.othstatus], err_exist
	jz medchk_proceed
	push di
	push es
	gifcall dskdev,reset,(dtrim)	;if error exist,reset
	pop es
	pop di
;	mov [di.medchk_rep], medchk_rep_clr
	jnc mediac_no_err
	pop bx
	jmp err_exit
mediac_no_err:
	and  [di.othstatus], no_err
	pop ax
	push ax
medchk_proceed:
;	cmp [di.medchk_rep], medchk_rep_clr
;	je do_medchk
;	mov dl, [di.med_des]
;	mov dh, 01
;	jmp mediac_set_inf
do_medchk:
	call medchkopt
;	mov dl, medchk
;	gifcall dskdev,gstatus,(dtrim) ; check the unit
	jnc mediac_cont		; if there is an error, exit. Otherwise
	pop bx
	or [di.othstatus], err_exist
	jmp err_exit		; continue
mediac_cont:
	pop ax
if debugd
	mov al, dh
	prbyte
	mov al, dl
	prbyte
endif
	test dl, remove_or_not	; check whether it is XEBEC or not
	jz its_XEBEC
	test dl, forty_or_not	; check whether it is forty or not
	jz media_eighty
	mov [di.num_tracks], 40
;	or	dl, 04h
	jmp short mediac_cont2
media_eighty:
	mov [di.num_tracks], 80
;	and	dl, 0fbh
mediac_cont2:
	or	dl, 0f8h		; otherwise it is floppy (removable), therefore
				; set the fourth and higher bits to 1
;	cmp [di.med_des], 00h  ; check whether the block has never been built
;	jne mediac_ret		; if it is not, return
;	mov dh, -1		; set dh to -1 to force OS to build a BPB
	jmp short mediac_ret
its_XEBEC:
	mov dl, 0f8h		; media byte for XEBEC is 0f8h
;	cmp [di.med_des], 00h  ; check whether the block has never been built
;	jne mediac_ret		; if it is not, return
;	mov dh, -1		; set dh to -1 to force OS to build BPB
mediac_ret:
;	mov [di.medchk_rep], medchk_rep_set
mediac_set_inf:
	mov [di.med_des], dl	; save the new media descriptor byte
	les bx, [ptrsav]	; save the return information
;	mov es:[bx.med_descriptor], dl
	mov es:[bx.ret_inf], dh
if debugd
	mov al, dl
	prbyte
	mov al, dh
	prbyte
	echod "m"
	echo "f"
endif
	jmp exit

get_bpb:
if debugd
	echod "g"
	mov al, es:[bx.med_descriptor]
	prbyte
endif
	mov al, es:[bx.unit_code]	; get the media byte and unit code
	push cs
	pop es
	xor ah, ah
	mov di, ax
	shl di, 1
	add di, offset inittab
	mov di, [di]		; get the dpb pointer from inittab
	mov dl, [di.med_des]
	cmp [di.log_unit_map], 0ffh
	jne get_cont		; if it is not 0ffh, it means that it has a
				; logical map unit
	mov ah, notrdy		; set device not ready
	jmp err_exit
get_cont:
	mov al, [di.log_unit_map]
	test [di.othstatus], err_exist	;check whether there is an error in the
	jz do_get_bpb			;device
	push di
	push es
	gifcall dskdev,reset,(dtrim)or(waitrdy);error exist,reset
	pop es
	pop di
;	mov [di.medchk_rep], medchk_rep_clr
	jnc get_no_err
	jmp err_exit
get_no_err:
;	mov al, [di.log_unit_map]
	call medchkopt
;	mov dl, medchk
;	gifcall dskdev,gstatus,(dtrim)
	jnc get_med_no_err
	jmp err_exit
get_med_no_err:
;	mov [di.medchk_rep], medchk_rep_set
	and [di.othstatus], no_err
	cmp dh, -1
	jne get_noerr_cont
	test dl, remove_or_not
	jz get_hd_med_set
	test dl, forty_or_not
	jz get_its_eighty
	mov  [di.num_tracks], 40
;	or	dl, 04h
	jmp short get_chk_build_dpb
get_its_eighty:
	mov [di.num_tracks], 80
;	and	dl, 0fbh
get_chk_build_dpb:
	or	dl, 0f8h
	mov [di.med_des], dl
	jmp short get_noerr_cont
get_hd_med_set:
	mov [di.med_des], 0f8h
get_noerr_cont:
	mov dl, [di.med_des]	
do_get_bpb:
	push di
	cmp [di.med_des], 0f8h		; check whether it is removable or not
	je get_not_remov	; the way to handle removable and unremovable
				; unit is different
	call build_fp_dpb	
	pop di
	jnc get_ret
	jmp err_exit
get_not_remov:
	call build_hd_dpb
	pop di
	jnc get_ret
	jmp err_exit
get_ret:
	les bx, [ptrsav]
	mov es:[bx.bpb_offset], di ; return necessary information to MSDOS
	mov es:[bx.bpb_seg], cs	; 
if debugd
	echod "g"
	echo "f"
endif
	jmp exit


build_fp_dpb:
if debugd
	echod "b"
	echod "f"
endif
	cmp [di.num_tracks], 80
	je b_80_fp_dpb
	mov si, dx		; create offset into the sample block table
	and si, 03h		; clear bits higher than 2nd bit
	shl si, 1		; each unit in the table is a word
	mov ax,di
	mov bx,si
	mov si, cs:[si.sbpbptr]  ; get the offset into the correct entry of
				; the sample bpb table
	mov cx, (size dpb) -8   ; set the number of bytes to be transfer
	cld			; to make si and di to increase after each transferring
   rep	movsb			; mov the sample bpb to the dpb
	mov di, ax
	mov si, bx
;	cmp [di.num_tracks], 80
;	je eighty_tracks_size
	mov ax, [si.fpsiz40]
;	jmp short build_fp_cont
;eighty_tracks_size:
;	mov ax, fpsiz80[si]
;	and [di.med_des], 0fbh
;build_fp_cont:
	add [di.num_sector], ax
	ret
b_80_fp_dpb:
	xchg si, di		; save di into si
	mov di, offset tempbuf	; read the boot record
	mov dx, 0
	mov cx, 01h
	mov al, [si.log_unit_map]
	push di
	push es
	gifcall dskdev, read, (waitrdy)
	pop es
	pop di
	jnc b_80_cont
	or [si.othstatus], err_exist
	mov [si.med_des], 00h
	stc
	jmp b_80_fp_ret
b_80_cont:
	mov bp, si
	add di, 11		; copy necessary information from the
	xchg si, di		; boot record into the reserved data area
	mov cx, (size dpb) - 8
	cld
	rep movsb
	cmp ds:[bp.root_dir_ent], 0070h
	jne b_80_cont1
	mov ds:[bp.med_des], 0fah
	jmp b_80_fp_ret
b_80_cont1:
	mov ds:[bp.med_des], 0f9h
b_80_fp_ret:
	ret


build_hd_dpb:
if debugd
	echod "b"
	echod "h"
endif
	xchg si, di		; save di in si
	mov di, offset tempbuf  ; set di to point to the temporary buffer
	mov dx, [si.bsector]	; starting to read boot sector
	mov cx, 01h		
	mov al, [si.log_unit_map]
	push di
	push es
	gifcall dskdev,read,(waitrdy)
	pop es
	pop di
	jnc build_hd_cont	; if there is an error, just left the dpb filled
				; with 0ffh
	or [si.othstatus], err_exist
hd_dpb_err_reset:
	xor prembyteh, 02h
	stc
	jmp build_hd_ret
build_hd_cont:
	push si			; save dpb pointer
	add di, 3		; set di pointing starting of trade mark in the
				; temporary buffer
	mov si, offset cs:trademark ; set si pointing to the trademark string
	mov cx, 5		; length of trade mark is 5
repe	cmpsb
	pop si
	je build_hd_cont2
	mov ah, notrdy		; if not equal, it means that the disk is not
				; in COLEX format
	or [si.othstatus], err_exist
	xor prembyteh, 02h
	stc			
	jmp build_hd_ret
build_hd_cont2:
	add di, 3		; set di point to the bpb in the boot sector
	xchg si, di		; make di pointing to the base of dpb and si
				; pointing the base of bpb in the boot sector
	mov bp, di
	mov cx, ( size dpb) -8  ; set the number of bytes to be transferred
	cld			; make si and di to be increased after each transferring
  rep	movsb			; repeat transfer
	mov cl, prembyteh
	mov cs:[bp.med_des], cl
	clc
build_hd_ret:
	ret

red_wrt_ind db ?

dsk_red:
if debugd
	echod "r"
endif
	mov red_wrt_ind, 00h	; 00h means to read
	jmp short dsk_opt

dsk_wrt:
dsk_wrtv:
if debugd
	echod "w"
endif
	mov red_wrt_ind, 01h

dsk_opt:
if debugd
	echod "o"
endif
	mov di, es:[bx.transfer_offset] ; pass the information to register for
				     ; gifdic call
	mov cx, es:[bx.count]
;	mov al, ch
;	prbyte
;	mov al, cl
;	prbyte
	mov dx, es:[bx.start_sector]
	mov al, es:[bx.unit_code]
	mov es, es:[bx.transfer_seg]
	xor ah, ah
	mov si, ax
	shl si, 1
	add si, offset inittab
	mov si, [si]
	mov al, [si.log_unit_map]
	cmp [si.log_unit_map], 0ffh
	jne dsk_cont1
	mov ah, notrdy
	jmp err_exit
dsk_cont1:
	mov al, [si.log_unit_map]
	push cx
	test [si.othstatus], err_exist
	jnz dsk_cont3
	jmp do_dsk_opt
dsk_cont3:
	push dx
	push di
	push es
	gifcall dskdev,reset,(waitrdy)or(dtrim)
	pop es
;	mov [si.medchk_rep], medchk_rep_clr
	jnc dsk_opt_no_err
	pop di
	pop dx
	pop cx
	les bx, [ptrsav]
	mov es:[bx.count], 00h
	jmp err_exit
dsk_opt_no_err:
	mov al, [si.log_unit_map]
	mov di, si
	call medchkopt
	pop di
;	mov dl, medchk
;	push es
;	gifcall dskdev,gstatus,(waitrdy)
;	pop es
	jnc dsk_opt_medchk_noerr
	pop dx
	pop cx
	les bx, [ptrsav]
	mov es:[bx.count], 00h
	jmp err_exit
dsk_opt_medchk_noerr:
;	mov [si.medchk_rep], medchk_rep_set
	and [si.othstatus], no_err
	test dh, -1
	jne noerr_cont
	test dl, remove_or_not
	jz dsk_bhdsk_dpb
	test dl, forty_or_not
	jz dsk_its_eighty
	mov  [si.num_tracks], 40
;	or	dl, 04h
	jmp short chk_build_dpb
dsk_its_eighty:
	mov [si.num_tracks], 80
;	and	dl, 0fbh
chk_build_dpb:
	or	dl, 0f8h
	mov [si.med_des], dl
	push si
	push di
	mov di, si
	call build_fp_dpb
	pop di
	pop si
	jnc noerr_cont
	pop dx
	pop cx
	les bx, [ptrsav]
	mov es:[bx.count], 00h
	jmp err_exit
dsk_bhdsk_dpb:
	mov [si.med_des], 0f8h
	push si
	push di
	mov di, si
	call build_hd_dpb
	pop di
	pop si
	jnc noerr_cont
	pop dx
	pop cx
	les bx, [ptrsav]
	mov es:[bx.count], 00h
	jmp err_exit
noerr_cont:
	mov al, [si.log_unit_map]	
	pop dx
	pop cx
	push cx
do_dsk_opt:
	cmp	red_wrt_ind, 00h
	jnz its_to_wrt
	push es
	gifcall dskdev,read,(waitrdy)
	pop es
	jmp short dsk_cont2
its_to_wrt:
	cmp 	[si.med_des], 0f8h  ; check whether it is hard disk
	je	do_wrt
	cmp	dx, 01h		;check whether it is sector 1
	jne	do_wrt
	mov	bx, cx		;save cx and di
	mov	bp, di
	xor	ah, ah		;clear ah
	mov	cx, sectorlen
newchksum:			;calculate new checksum
	add	ah, es:[di]
	inc	di
	loop 	newchksum
	mov	[si.checksum], ah ;store new checksum
	mov	di, bp		  ;resume cx and di
	mov	cx, bx
do_wrt:
	push es
	gifcall dskdev,write,(waitrdy)
	pop es
dsk_cont2:
;	mov [si.medchk_rep], medchk_rep_clr
	jc  test_err
if debugd
	echod "o"
	echo "f"
endif
	pop cx
	jmp exit	
test_err:
	les bx, [ptrsav]
	sub es:[bx.count], cx
	pop cx
	or [si.othstatus], err_exist
	jmp err_exit

medchkopt:
	push di
	push si
	push ds
	push es
	push cs
	pop es
	mov al, [di.log_unit_map]
	mov dl, tdchk
	push di
	push es
	gifcall dskdev, gstatus, (dtrim)
	pop es
	pop  di
	jc tdcfail
	and  dl, 04h
	xor  al, al
	or   al, dl
	push ax
	push di
	mov al, [di.log_unit_map]
	mov di, offset tempbuf
	mov cx, 1
	mov dx, medbytesect
	push es
	gifcall dskdev,read,(waitrdy)
	pop es
	pop di
	jnc setmedcont1
	jmp medchkret1
setmedcont1:
	pop ax
	mov  dh, 01h
	mov  si, offset tempbuf
	mov  ah, [si]
	cmp  [di.med_des], ah
	je   setmedcont
	mov  dh, -1h
setmedcont:
	and  ah, 03h
	or   ah, 10h
	or   al, ah
	xor  ah, ah
	mov  cx, sectorlen
calchecksum:
	add  ah, [si]
	inc  si
	loop calchecksum
	cmp [di.checksum], ah
	je  setfpmed
	mov dh, -1h
setfpmed:
	mov [di.checksum], ah
	mov dl, al
	push dx
	mov dh, dl
	mov al, [di.log_unit_map]
	mov dl, medset
	push es
	gifcall  dskdev, sstatus,(dtrim)
	pop es
	jc medchkret
	pop dx
	mov ah, noerr
	clc
	jmp short medchkret
tdcfail:
	cmp ah, illopc
	jne tdcfpfail
	mov al, [di.log_unit_map]
	mov dl, gosmap
	push es
	push di
	gifcall dskdev, gstatus, (dtrim)
	mov ax, di			; save absolute start sector
	pop di
	jnc nxt_stat
	pop es
	jmp tdcfpfail
nxt_stat:
	cmp cx, 0			; test whether the size is zero
	jne nxt_stat1
	pop es
	mov ah, notrdy
	jmp tdcfpfail
nxt_stat1:
	mov [di.bsector], es		; save boot sector number
	pop es
	cmp [di.ssector], ax
	jne nxt_stat3
	mov dh, 01h
	jmp short nxt_stat4
nxt_stat3:
	mov dh, -1h
	mov [di.ssector], ax
	xor prembyteh, 02h
nxt_stat4:
	mov dl, 00h
	clc
	jmp short medchkret
tdcfpfail:
	stc
medchkret:
	pop es
	pop ds
	pop si
	pop di
	ret
		
medchkret1:
	pop	bx
	stc
	jmp	short medchkret

;	clock device handlin routines


tim_init:
	jmp exit

TIM_DAYS  DB    2 DUP (?)       ;Number of days since 1-1-80.
TIM_MINS  DB    ?               ;Minutes.
TIM_HRS   DB    ?               ;Hours.
TIM_HSEC  DB    ?               ;Hundreths of a second.
TIM_SECS  DB    ?               ;Seconds.

WATCH_TIME:
WATCH_SC  DB	?		;Seconds
WATCH_MN  DB	?		;Minutes
WATCH_HR  DB	?		;Hours
WATCH_DT  DB	?		;Date
WATCH_MT  DB	?		;Month
WATCH_YR  DB	?		;Year

MONTH_TABLE LABEL WORD
	DW 0	;Jan
	DW 31	;Feb
	DW 59	;Mar
	DW 90	;Apr
	DW 120	;May
	DW 151	;Jun
	DW 181	;Jul
	DW 212	;Aug
	DW 243	;Sep
	DW 273	;Oct
	DW 304	;Nov
	DW 334	;Dec

;
; Time write routine.
;
BIN2BCD:
	XOR	AH, AH
	DIV	CS:CONST10
	SHL	AL, 1
	SHL	AL, 1
	SHL	AL, 1
	SHL	AL, 1
	OR	AL, AH
	RET
CONST10	DB 10

MOVTBCD	MACRO	DST, SRC
	MOV	AL, SRC
	CALL	BIN2BCD
	MOV	DST, AL
ENDM

TIM_WRT:
if debugt
	echo "T"
	echo "W"
endif
	mov 	di, offset tim_days
	lds	si, dword ptr es:[bx.transfer_offset]
	MOV	AX,CS
        MOV     ES,AX
        MOV     CX,6
        REP     MOVSB		; move information about date and time to buffer
	MOV	DS, AX
	MOVTBCD	WATCH_SC, TIM_SECS
	MOVTBCD	WATCH_MN, TIM_MINS
	MOVTBCD	WATCH_HR, TIM_HRS
;Reconverting
	MOV	AX, WORD PTR TIM_DAYS
	XOR	DX, DX
	MOV	BX, 1461	; Number of days in four years
	DIV	BX
	MOV	TIM_HSEC, AL	; # 4 year group (as temp buf)
	CMP	DX, 365
	JA	TW1
;Leap year
	XOR	CX, CX
	JMP	SHORT TW2
TW1:
	MOV	AX, DX
	DEC	AX
	XOR	DX, DX
	MOV	BX, 365
	DIV	BX
	MOV	CX, AX
TW2:	; DX contains the # days in a year
	MOV	TIM_MINS, 1	; Month offset buffer
	CMP	DX, 59		; Check 29-Feb
	JB	TW3
	ADD	DX, 2
	CMP	CX, 0
	JA	TW4
; Leap year
	CMP	DX, 59
	JE	TW3
	DEC	DX
TW4:
	CMP	DX, 244		; Check 31-Aug
	JB	TW3
	SUB	DX, 31
	MOV	TIM_MINS, 2
TW3:	; DX contains the adjusted date
	MOV	AX, DX
	MOV	BL, 61
	DIV	BL
	CMP	AH, 31
	JB	TW5
	INC	TIM_MINS
	SUB	AH, 31
TW5:
	PUSH	AX
	SHL	AL, 1
	ADD	AL, TIM_MINS
	CALL	BIN2BCD
	MOV	WATCH_MT, AL
	POP	AX
	MOV	AL, AH
	INC	AL
	CALL	BIN2BCD
	MOV	WATCH_DT, AL
	MOV	AL, TIM_HSEC
	SHL	AL, 1
	SHL	AL, 1
	ADD	AL, CL
	ADD	AL, 80	; Since 1980
	CALL	BIN2BCD
	MOV	WATCH_YR, AL
; All are OK now
	mov	cx, 05
lp_wrt:
	call	wr_clk
	jnc	tim_wrt_exit
	loop	lp_wrt
	jmp	err_exit
;
tim_wrt_exit:
       MOV     AL,0
        JMP     EXIT

;
; Time read routine.
;
BCD2BIN:
	MOV	AH, AL
	AND	AL, 0FH
	AND	AH, 0F0H
	SHR	AH, 1
	ADD	AL, AH
	SHR	AH, 1
	SHR	AH, 1
 	ADD	AL, AH
	RET

MOVFBCD	MACRO	DST, SRC
	MOV	AL, SRC
	CALL	BCD2BIN
	MOV	DST, AL
ENDM

TIM_RED:
if debugt
	echo "T"
	echo "R"
endif
	PUSH	DS
	POP	ES
	mov 	cx, 05
lp_rd_clk:
	call  rd_clk
	jnc	tim_rd_cont
	loop	lp_rd_clk
	jmp	err_exit
tim_rd_cont:
	MOVFBCD	TIM_SECS, WATCH_SC
	MOVFBCD	TIM_MINS, WATCH_MN
	MOVFBCD	TIM_HRS, WATCH_HR
	MOV	AL, WATCH_YR
	CALL	BCD2BIN
	SUB	AL, 80		; Start from 1980
	MOV	TIM_HSEC, 0
	XOR	AH, AH
	PUSH	BP
	MOV	BP, AX
	ADD	AX, 3
	MOV	BL, 4
	DIV	BL		; Remainder in AH.
	MOV	CX, AX		; CH=3 means leap year
	MOV	AX, BP
	POP	BP
	MOV	BX, 365
	MUL	BX
	XOR	DH, DH		; For Buffer
	MOV	DL, CL
	ADD	AX, DX
	PUSH	AX
	MOVFBCD	BL, WATCH_MT
	POP	AX
	XOR	BH, BH
	SHL	BX, 1
	ADD	AX, [BX.MONTH_TABLE-2]
	PUSH	AX
	MOVFBCD	DL, WATCH_DT
	POP	AX
	DEC	DX
	ADD	AX, DX
	CMP	CH, 3
	JNE	TR1
; Leap year
	CMP	BX, 6		; After Feb?
	JB	TR1
	INC	AX
TR1:
	MOV	WORD PTR TIM_DAYS, AX
	les	bx, ptrsav
	les	di, dword ptr es:[bx.transfer_offset]
        MOV     SI,OFFSET TIM_DAYS
        MOV     CX,6
        REP     MOVSB
        MOV     AL,0
if debugt
	echo	"e"
endif
        JMP     EXIT


rd_clk:
if debugt
	echo "t"
	echo "r"
endif
	push	cx
	xor	cx,cx
	mov	cl, 06
	xor	dx, dx
	mov	di, offset cs:watch_time
	mov	ax, cs
	mov	es, ax
	gifcall rtcdev, read,dtrim
if debugt
	echo "f"
endif
	pop	cx
	ret

wr_clk:
	push	cx
	xor	cx, cx
	mov	cl, 06
	xor	dx, dx
	mov	di, offset cs:watch_time
	mov	ax, cs
	mov	es, ax
	gifcall rtcdev, write,dtrim
	pop     cx
	ret

;; SYS device

syswrtbuf  db  10h dup (?)	; buffer for the write function parameter
syswbfptr  dw  syswrtbuf	; the write buffer pointer
sysredbuf  db  10h dup (?)	; buffer to store characters for read function
sysrbfhd   dw  sysredbuf	; head ptr of read buffer
sysrbftl   dw  sysredbuf	; tail ptr of read buffer
syswrthdlr  dw  catswitch	; handler routine ptr, point to handler
				; for current catageory

cathdlrtbl  dw  sysinfhdl
	    dw  blkmaphdl

sys_init:
	 mov cs:[syswbfptr], offset cs:syswrtbuf
	 mov cs:[sysrbfhd], offset cs:sysredbuf
	 mov cs:[sysrbftl], offset cs:sysredbuf
	 mov cs:[syswrthdlr], offset cs:catswitch
	 jmp exit

sys_red:
	mov cx, es:[bx.count]
	les di, dword ptr es:[bx.transfer_offset]
lpsysrd:
	push cx
	push di
	call sysgrdbuf
	pop di
	pop cx
	jc sysrd1
	stosb
	loop lpsysrd
	jmp exit
sysrd1:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	cmp ah, notrdy
	je  sysrd2
	jmp err_exit
sysrd2:
	jmp bus_exit


sysgrdbuf:				; to get a char from the read buffer
	mov dx, offset cs:sysredbuf	; first get the end of the read buffer
	add dx, 10h
	mov di, cs:[sysrbfhd]		; head points to the current char,
	cmp di, cs:[sysrbftl]		; if head = tail, it means that the
	jne  sysgrdcont			; buffer is empty, then busy exit
	mov ah, notrdy
	stc
	ret
sysgrdcont:
	mov al, cs:[di]
	cmp cs:[sysrbftl], 0ffffh	; tail =0ffffh means buffer has been
					; full
	jne grdcont1
	mov cs:[sysrbftl], di
grdcont1:
	inc di				; advance the head ptr, if it exceeds
	cmp di, dx			; end of buffer, set it to head of 
	jne sysredexit			; buffer
	sub dx, 10h
	mov di, dx
sysredexit:
	mov cs:[sysrbfhd], di
	clc
	ret

sysprdbuf:				; to put a char into the read buffer
	mov dx, offset cs:sysredbuf	; first get the end of the
	add dx, 10h
	cmp cs:[sysrbftl], 0ffffh	; test whether the buffer is full
	je  sysprderr
	mov di, cs:[sysrbftl]
	mov  cs:[di], al
	inc di
	cmp di, dx
	jne prdbufcont
	sub dx, 10h
	mov di, dx
prdbufcont:
	cmp di, cs:[sysrbfhd]
	je prdbufcont1
	mov cs:[sysrbftl], di
	jmp short prdbufret
prdbufcont1:
	mov cs:[sysrbftl], 0ffffh
prdbufret:
	clc
	ret
sysprderr:
	mov ah, notrdy
	stc
	ret

sys_wrt:
	mov cx, es:[bx.count]
	les si, dword ptr es:[bx.transfer_offset]
lpsysw:
	lods byte ptr es:[si]
	pusha
	push ds
	push es
	call word ptr cs:[syswrthdlr]	; jump to handler of current catageory
					; handler
	pop  es
	pop  ds
	popa
	jc syswrt1
	loop lpsysw
	jmp exit
syswrt1:
	les bx, cs:[ptrsav]
	sub es:[bx.count], cx
	jmp err_exit


catswitch:				; switch between different catageory
	cmp al, 0			; handler
	jl caterr			; first check the catageory range
	cmp al, catmax
	jg caterr
	cmp al, 0
	je to_reset	
	dec al
	xor ah, ah
	mov di, offset cs:cathdlrtbl	; then load the handler address into
	add di, ax			; the handling buffer
	add di, ax
	mov di, cs:[di]
	mov cs:[syswrthdlr], di
	clc
	ret
to_reset:
	 mov cs:[syswbfptr], offset cs:syswrtbuf
	 mov cs:[sysrbfhd], offset cs:sysredbuf
	 mov cs:[sysrbftl], offset cs:sysredbuf
	 mov cs:[syswrthdlr], offset cs:catswitch
	clc
	 ret
caterr:
	mov ah, wrflt
	stc
	ret

		
sysinfhdl:				; this is the routine to pass system
					; information to the user
	mov di, offset cs:syswrtbuf	; check whether all the parameter
	add di, 4			; has been got
	cmp  cs:syswbfptr,di
	jl  putsyswbuf
; now pass information to the user
	mov cs:[di], al
	push ds
	push es
	sub di, 3
	mov si, di
	dec di
	xor cx, cx
	mov cl, cs:[di]
	mov di, cs:[si]
	mov es, cs:[si+2]
	mov si, cs
	mov ds, si
	mov si, offset cs:promaddtab
	rep movsw
	pop es
	pop ds
	mov cs:[syswrthdlr], offset cs:catswitch
	mov cs:[syswbfptr], offset cs:syswrtbuf
	clc
	ret
putsyswbuf:
	mov di, cs:[syswbfptr]
	mov byte ptr cs:[di], al
	inc di
	mov cs:[syswbfptr], di
	clc
	ret


blkmaphdl:
	test al, 80h		; test from bios to prom or vise versa
	jz b2p
; now from prom to bios
	and al, 07fh
	mov si, offset cs:inittab
	xor cx, cx
	mov cl, num_of_units
lpscndpbtab:
	mov di, cs:[si]
	cmp al, cs:[di.log_unit_map]
	jne nxtdev
	sub si, offset cs:inittab
	shr si, 1
	mov ax, si
	test cs:[di.othstatus], hd_dsk
	jz blkmapret
	or al, 80h
	jmp blkmapret
nxtdev:
	inc si
	inc si
	loop lpscndpbtab
	mov al, 0ffh
	jmp blkmapret
b2p:				; from bios to prom
	cmp al, num_of_units   ; check whether the unit number exceeds max
	jl b2pcont		; unit allowed
	mov al, 0ffh
	jmp blkmapret
b2pcont:
	mov si, offset cs:inittab ;just get the logical unit mapping from dpb
	xor ah, ah
	add si, ax
	add si, ax
	mov di, cs:[si]
	mov al, cs:[di.log_unit_map]
	test cs:[di.othstatus], hd_dsk
	jz blkmapret
	or al, 80h
blkmapret:
	call sysprdbuf
	mov cs:[syswrthdlr], offset cs:catswitch
	ret	
	
	
;; This is the common exit routines for all the installable driver

bus_exit:
	xor ax, ax
	mov ah, bus_bit+don_bit
	jmp short exit1

cmderr: 
	mov  ah, illopc

err_exit:
	mov al, ah
	test al, mst_sig_bit
	jnz hard_dsk_err
	mov bx, offset err_map_tab
	xlat err_map_tab
	jmp short err_cont
hard_dsk_err:
	and al, not mst_sig_bit
	mov bx, offset hd_err_map_tab
	xlat hd_err_map_tab
err_cont:
	mov ah, err_bit+don_bit
	stc
	jmp   short exit1

exitp	proc  far

exit: 
	xor ax, ax
	mov ah, don_bit
exit1:  
	les bx, cs:[ptrsav]
	mov es:[bx.status], ax
	pop es
	pop ds
;	mov al, byte ptr cs:ss_save
;	prbyte
;	mov al, byte ptr cs:ss_save[1]
;	prbyte
;	mov al, byte ptr cs:sp_save
;	prbyte
;	mov al, byte ptr cs:sp_save[1]
;	prbyte
	mov bx, cs:ss_save
	mov ss, bx
	mov sp, cs:sp_save
	popa
	ret

exitp	endp

stratp proc far

strategy:
	mov word ptr cs:[ptrsav], bx
	mov word ptr cs:[ptrsav+2], es
	ret
stratp endp

ptrsav  dd  ?			;strategy pointer save

sp_save  dw ?
ss_save  dw ?

stkl equ 200h
wrkstk label word
	db   stkl  dup (?)
tows:
;
;

				; error map table
				; to convert error codes passing from
				; GIFDIC to those passing to MSDOS
err_map_tab	db   ?		; no error
	db   bad_dri		; bad call = bad drive request structure length
	db   gen_fai		; dead = general failure
	db   unk_unt		; illdev = unknown unit
	db   unk_cmd		; illopc = unknown command
	db   dev_not_rdy	; notrdy = device not ready
	db   wrt_flt		; wrflt = write fault
	db   red_flt		; rdflt = read fault
	db   prt_out_pap	; outpap = printer out of paper
	db   sec_not_fnd	; nosctr = sector not found
	db   seek_err		; notrk = seek error
	db   unk_med		; illfrmt = unknown media
	db  wrt_pro_vio		; wrprt = write protect violation
	db  crc_err		; crcerr = crc error
	db   gen_fai		; devovr = general failure    
	db   gen_fai		; eccerr = general failure
	db   gen_fai		; framerr = ;;
	db   gen_fai		; parerr = ;;
	db   dev_not_rdy	; timout = not ready
	db   gen_fai		; strtnf = general failure
	db   gen_fai		; endnf = general failure
				; err map table for XEBEC hard disk

hd_err_map_tab	db ?		; 00 = no error
	db   gen_fai		; 00 = general failure
	db   gen_fai		; 02 = general failure
	db   wrt_flt		; 03 = write fault
	db   dev_not_rdy	; 04 = not ready
	db   gen_fai		; 05 = general failure
	db   gen_fai		; 06 = general failure
	db   gen_fai		; 07 = ;;
	db   gen_fai		; 08 = ;;
	db   gen_fai		; 09 = ;;
	db   gen_fai		; 0a = ;;
	db   gen_fai		; 0b = ;;
	db   gen_fai		; 0c = ;;
	db   gen_fai		; 0d = ;;
	db   gen_fai		; 0e = ;;
	db   gen_fai		; 0f = ;;
	db   red_flt		; 10 = read fault
	db   crc_err		; 11 = crc error
	db   sec_not_fnd	; 12 = sector not found
	db   gen_fai		; 13 = general failure
	db   sec_not_fnd	; 14 = sector not found
	db   seek_err		; 15 = track not found (seek error)
	db   gen_fai		; 16 = general failure
	db   gen_fai		; 17 = general failure
	db   gen_fai		; 18 = general failure
	db   gen_fai		; 19 = general failure
	db   gen_fai		; 1a = general failure
	db   gen_fai		; 1b = general failure
	db   gen_fai		; 1c = general failure
	db   gen_fai		; 1d = general failure
	db   gen_fai		; 1e = general failure
	db   gen_fai		; 1f = general failure
	db   gen_fai		; 20 = general failure
	db   sec_not_fnd	; 21 = sector not found
	db   gen_fai		; 22 = general failure
	db   gen_fai		; 23 = general failure
	db   gen_fai		; 24 = general failure
	db   gen_fai		; 25 = general failure
	db   gen_fai		; 26 = general failure
	db   gen_fai		; 27 = general failure
	db   gen_fai		; 28 = general failure
	db   gen_fai		; 29 = general failure
	db   gen_fai		; 30 = ;;
	db   gen_fai		; 31 = ;;
	db   gen_fai		; 32 = ;;
	db   gen_fai		; 33 = ;;
	db   gen_fai		; 34 = ;;
	db   gen_fai		; 35 = ;;
	db   gen_fai		; 36 = ;;
	db   gen_fai		; 37 = ;;
	db   gen_fai		; 38 = ;;
	db   gen_fai		; 39 = ;;
	db   gen_fai		; 3a = ;;
	db   gen_fai		; 3b = ;;
	db   gen_fai		; 3c = ;;
	db   gen_fai		; 3d = ;;
	db   gen_fai		; 3e = ;;
	db   gen_fai		; 3f = ;;



sysinit_offset  dw 0000h
sysinit_seg	dw ?
vermes  db 0ah, 0dh, "BIOS    Ver 1.06   08/05/85", 0ah, 0dh, "$"
first_init:

	mov ax, cs
	mov ss, ax
	mov sp, offset tows
	mov ax, cs
	mov word ptr cs:condev[2], ax
	mov word ptr cs:auxdev[2], ax
	mov word ptr cs:prndev[2], ax
	mov word ptr cs:timdev[2], ax
	mov word ptr cs:dsk_dev[2], ax
getsysinf:				; to get system information
	mov es, ax
	mov di, offset promaddtab
	mov cx, promaddtablen
	int 99h
	mov ax, cs:promaddtab.gifdic_handler
	mov cs:gifoff, ax
	mov ax, cs:promaddtab.pgroup
	mov cs:gifseg, ax
	mov di, offset cs:vermes
	call	print_messages
initcont:
 	mov ax, cs
	mov  cs:sysinit_seg, ax
	add cs:sysinit_seg, ( offset endbios - offset beginbios ) / 16
	mov ax, cs:sysinit_seg
	mov ds, ax
assume ds: seg sysinit
	mov ax, cs
	add ax, biosizs
	mov ds:[current_dos_location], ax
	mov ax, cs:promaddtab.mem_siz_lw
	mov dx, cs:promaddtab.mem_siz_hw
	mov cl, 12
	shl dx, cl
	mov cl, 4
	shr ax, cl
	or  ax, dx
;
;	Now add a check for more memory ( off board )
;
	cmp	ax,4000h		; got xram ??
	jz	try_off_board
	jmp	final_ram_size		; no, cannot use off board ram
try_off_board:
	mov	dx,0e204h		; register file ( cpu access )
	mov	al,3
	out	dx,al			; set the register file for zero base
	mov	dx,0e206h		; register file ( dma access )
	out	dx,al			; set it too
	mov	ax,04000h		; off board access
	mov	es,ax			; segment
	mov	bx,0a55ah		; test pattern
	mov	es:[0],bx		; write it
	cmp	bx,es:[0]		; check it
	jz	is_off_board
	jmp	final_ram_size		; not found
;
;	Found off board memory, now ask user if he wants it
;
is_off_board:
	mov	di,offset cs:ram_question ; message
	call	print_messages

done_ram_question:
;	gifcall	scondev,rdflush,noopt	; clear out response
	mov	cx,8000h		; wait a while for a response
try_response:
	push	cx
	gifcall	scondev,read,noopt	; look for response
	pop	cx
	jnc	got_response		; got input
	loop	try_response		; try n times
on_board_only:				
	mov	ax,4000h		; use on board only
	jmp	final_ram_size

got_response:
	and	al,5fh			; lower to upper case
	push	ax
	gifcall	scondev,write,waitrdy
	pop	ax
	cmp	al,"Y"			; Yes ??
	jnz	on_board_only		; if not, on board only
;
;	Initialise the ram, and size it ( 1/2 mbyte max )
;
	mov	ax,4000h
	mov	es,ax			; initial segment
fill_ram_seg:
	mov	ax,0
	mov	di,0
	mov	cx,8000h
	rep	movsw			; fill with zero

test_ram:
	mov	ax,es			; last segment
	add	ax,1000h		; next segment
	mov	es,ax			; in destination
	mov	word ptr es:[0],0a55ah	; test pattern
	cmp	word ptr es:[0],0a55ah	; match ??
	jz	fill_ram_seg

out_of_ram:
	mov	ax,es			; drop through with result
;
;	save the final result
;
final_ram_size:
	cmp	ax,0c001h		; too big ??
	jc	right_size
	mov	ax,0c000h
right_size:
	mov	ds:[memory_size], ax
	push	ax
	call	print_cr_lf
	pop	ax
	mov	cl,10
	sar	ax,cl
	sub	ax,4
	and	ax,03ch
	mov	di,offset cs:ram_size_table
	add	di,ax
	call	print_messages
	mov	di,offset cs:end_ram_message
	call	print_messages
;
	mov ax, cs
	mov word ptr ds:[device_list+2], ax
	mov word ptr ds:[device_list], offset condev
     	mov ax, cs
	add ax, ((offset first_init - offset init)+50)/16
	mov ds:[final_dos_location], ax
;	echo "f"
;	echo "i"
	mov  bx, offset sysinit_offset
	jmp  dword ptr cs:[bx]
;	jmp sysinit
if ($ - beginbios) mod 16
	org ($-beginbios)+16-(($-beginbios) mod 16)
endif

print_cr_lf:
	mov	di,offset cs:cr_lf

print_messages:
	mov	al,cs:[di]		; get a character
	cmp	al,"$"			; end of string
	jz	done_message		; finished
	push	di
	gifcall	scondev,write,waitrdy	; print char
	pop	di
	inc	di			; next character
	jmp	print_messages		; repeat till done
done_message:
	ret

ram_question	db	"Do you want to use off board RAM ( Y/N ) ?$"

cr_lf	db	0dh,0ah,"$"

ram_size_table:
	db	" 64$"
	db	"128$"
	db	"192$"
	db	"256$"
	db	"320$"
	db	"384$"
	db	"448$"
	db	"512$"
	db	"576$"
	db	"640$"
	db	"704$"
	db	"768$"

end_ram_message:
	db	"K Bytes of MSDOS RAM.",0ah,0dh,"$"


endbios equ $
code	ends
end
	
