TITLE	GET/SET	STATUS -- DISK DRIVER

IF1
%OUT	PASS	1...
ELSE
%OUT	PASS	2...
ENDIF

DGROUP	GROUP	DATA
PGROUP	GROUP	PROG

%OUT	INCLUDING

INCLUDE	SRC\DDRIV.EQU
INCLUDE	SRC\SCBP.EQU
INCLUDE	\GIFI\SRC\GIFMAC.MAC
INCLUDE	\186\XINSTR.MAC

MOTORCHK EQU	0


TASKC	MACRO
	LEA	BX, SECBUF
	CALL	TASK
	MOV	BX, DDBLOC
ENDM


DATA	SEGMENT	WORD PUBLIC 'data'
	ASSUME	DS:DGROUP
	EXTRN	BOOTDRV:BYTE, DRIVLOG:WORD, MAXDRV:BYTE, DDB:BYTE
	EXTRN	DDBLOC:WORD, SECBUF:BYTE, BYTEBUF:BYTE, XBICTAB:BYTE
	EXTRN	DMACNT:WORD, MEDCNT:BYTE, FLPMEDS:BYTE, DDFLG:BYTE
	EXTRN	DUMPHD:WORD,DDWAIT:DWORD
	EXTRN	DGFTAB:WORD, DSFTAB:WORD,SECSIZE:WORD
DATA	ENDS


%OUT	CODE	SEGMENT

	EXTRN	DDBINIT:NEAR, TASK:NEAR, FERR:NEAR, XBINIT:NEAR
PROG	SEGMENT	BYTE PUBLIC 'prog'
	ASSUME	CS:PGROUP
	PUBLIC	DGST, MEDIAC, CNTRLG, GNDRV, OSMP, TDC
	PUBLIC	DSST, MEDIAS, DRVMP, SNDRV, SOSMP, XBICS, XBINI, MSGDUMP
	PUBLIC	TMOCTRL,SETWSR,SETSIZE


; GET STATUS
DGST	PROC	FAR
	AND	DL, 0FEH
	CMP	DL, MXNGS*2		; CHECK NUMBER OF GET STATUS FUNCTIONS
	JB	DG1
	MOV	AH, ILLOPC
	STC
	RET
DG1:
	MOV	BL, DL
	XOR	BH, BH
	CALL	DGFTAB[BX]
	RET
DGST	ENDP


; MEDIA CHECK
MEDIAC	PROC	NEAR
	CALL	DDBINIT
	JNC	MC4
	JMP	MCEXIT
MC4:
	TEST	[BX.MEDIA], NOK
	JZ	MC6
	MOV	AH, DEAD
	STC
	MOV	DH, MDUNK
	MOV	DL, [BX.MEDIA]
	JMP	MCEXIT
MC6:
	TEST	[BX.MEDIA], XBC_
	JNZ	FM

; HARD DISK
	MOV	DX, (MDNCHG*256+HDMED)	; ASSUME NOT CHANGED
	CMP	DL, [BX.MEDIA]
	JE	MC7
	MOV	DH, MDCHG		; CHANGED FOR THE FIRST TIME
	MOV	[BX.MEDIA], DL
MC7:
	MOV	AH, NOERR
	CLC
	RET

; FLOPPY DISK
FM:
	PUSH	AX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	MOV	AX, DS
	MOV	ES, AX

; SEEK AN EVEN TRACK
	LEA	SI, [BX.CMDLEN]
	LEA	DI, [BX.STSLEN]
	MOV	CL, [BX.CTRL]
;
	MOV	AL, [BX.TRK]
	MOV	BYTEBUF, 0		; B0 - SPIN TEST; B1 - AGAIN
	TEST	AL, 1
	JNZ	MC5
	CMP	AL, 0
	JNZ	MC1
	MOV	BYTEBUF, 2
MC5:
; ODD TRACK
	AND	[BX.CB], NMASK
	OR	[BX.CB], (CT3 OR NMCMD)
	MOV	[BX.CBCMD], (FSTIN OR FH)
; STEP IN
	MOV	BYTE PTR [DI], SL3
	MOV	CH, DMAOFF
MCSTIN:
	INC	[BX.TRK]
	CALL	TASK
	INC	BYTEBUF
	TEST	BYTEBUF, 1
	JZ	MC1
IF	MOTORCHK
; IF MOTOR ON, ASSUME NOT CHANGED
	TEST	[BX.SB], FMON
	JZ	MC2
	MOV	DH, MDNCHG
	MOV	DL, [BX.MEDIA]
	JMP	MCEXITPOP
MC2:
ENDIF
	TEST	BYTEBUF, 2
	JNZ	MCSTIN
MC1:

; IDENTIFY MEDIA
	AND	[BX.CB], NMASK
	OR	[BX.CB], CT3
	MOV	[BX.CBCMD], FREADS
	MOV	BYTE PTR [DI], SL3
	MOV	CH, DMAIN
	MOV	DMACNT, SCSZ
	MOV	AL, MEDCNT
	MOV	BYTEBUF, AL		; MEDIA NUMBER COUNTER
	MOV	BP, OFFSET DS:FLPMEDS	; FLOPPY MEDIAS

MEDTRYLP:
	MOV	AH, DS:[BP]

; SET TRACK
	MOV	AL, [BX.TRK]
	TEST	AH, T40
	JZ	MCT80
	SHR	AL, 1
MCT80:
	MOV	[BX.CBTRK], AL
; SET SECTOR
	MOV	[BX.CBSEC], SCMX
	TEST	AH, SC8
	JZ	MCSC9
	MOV	[BX.CBSEC], SCMN
MCSC9:
; SET SIDE
	AND	[BX.CB], (NOT SS1_)
	TEST	AH, HD2
	JNZ	MCHD2
	OR	[BX.CB], SS1_
MCHD2:

	TASKC
	CMP	AH, TMOUT
	JE	MCTMOUT
	TEST	[BX.SB], FNMERR
	JZ	MEDTRYLPEND
	DEC	BYTEBUF
	JZ	MEDTRYERR
; TRY NEXT MEDIA
	INC	BP
	JMP	MEDTRYLP

MEDTRYERR:
	MOV	AH, ILLFRMT
	JMP	SHORT MCERR

MCTMOUT:
	MOV	AH, TIMOUT
MCERR:
	MOV	DH, MDUNK
	MOV	DL, [BX.MEDIA]
	STC
	JMP	SHORT MCEXITPOP

; COMPARE WITH THE ORIGINAL ONE
MEDTRYLPEND:
	MOV	DL, DS:[BP]
	MOV	DH, MDNCHG		; ASSUME NO CHANGE
	CMP	DL, [BX.MEDIA]
	JE	MC3
	MOV	DH, MDCHG
	MOV	[BX.MEDIA], DL
MC3:

	MOV	AH, NOERR
	CLC
MCEXITPOP:
	MOV	BYTEBUF, AH
	POP	ES
	POP	BP
	POP	DI
	POP	CX
	POP	AX
	MOV	AH, BYTEBUF
MCEXIT:
	RET
MEDIAC	ENDP


; CONTROLLER LOGGING
CNTRLG	PROC	NEAR
	MOV	AL, BOOTDRV
	MOV	CX, DRIVLOG
	MOV	AH, NOERR
	CLC
	RET
CNTRLG	ENDP


; NUMBER OF DRIVES
GNDRV	PROC	NEAR
	MOV	AL, MAXDRV
	MOV	AH, NOERR
	CLC
	RET
GNDRV	ENDP


; OS MAP
OSMP	PROC	NEAR
	CALL	DDBINIT
	JC	OMEXIT
	MOV	ES, [BX.BOOTSEC]
	MOV	DH, [BX.STRTSEC+2]
	MOV	DI, WORD PTR [BX.STRTSEC]
	MOV	AL, [BX.IMGSIZE+2]
	MOV	CX, WORD PTR [BX.IMGSIZE]
	MOV	AH, NOERR
	CLC
OMEXIT:
	RET
OSMP	ENDP


; TRACK DENSITY CHECK
TDC	PROC	NEAR
	CALL	DDBINIT
	JNC	TC4
	JMP	TCEXIT
TC4:
	TEST	[BX.MEDIA], NOK
	JZ	TC6
	MOV	AH, DEAD
	MOV	DH, MDUNK
	STC
	JMP	TCEXIT

TC6:
	TEST	[BX.MEDIA], XBC_
	JNZ	TCF

; HARD DISK -- ILLEGAL
	MOV	AH, ILLOPC
	STC
	MOV	DH, MDUNK
	JMP	TCEXIT

; FLOPPY DISK
TCF:
	PUSH	AX
	PUSH	CX
	PUSH	DI
	PUSH	BP
	PUSH	ES
	MOV	AX, DS
	MOV	ES, AX

; SEEK AN EVEN TRACK
	LEA	SI, [BX.CMDLEN]
	LEA	DI, [BX.STSLEN]
	MOV	CL, [BX.CTRL]
;
	MOV	AL, [BX.TRK]
	MOV	BYTEBUF, 0		; B0 - SPIN TEST; B1 - AGAIN
	TEST	AL, 1
	JNZ	TC5
	CMP	AL, 0
	JNZ	TC1
	MOV	BYTEBUF, 2
TC5:
; ODD TRACK
	AND	[BX.CB], NMASK
	OR	[BX.CB], (CT3 OR NMCMD)
	MOV	[BX.CBCMD], (FSTIN OR FH)
; STEP IN
	MOV	BYTE PTR [DI], SL3
	MOV	CH, DMAOFF
TCSTIN:
	INC	[BX.TRK]
	CALL	TASK
	CMP	AH, TMOUT
	JE	TCTMOUT
	INC	BYTEBUF
	TEST	BYTEBUF, 1
	JZ	TC1
IF	MOTORCHK
; IF MOTOR ON, ASSUME NOT CHANGED
	TEST	[BX.SB], FMON
	JZ	TC2
	MOV	DH, MDNCHG
	JMP	TCEXITPOP
TC2:
ENDIF
	TEST	BYTEBUF, 2
	JNZ	TCSTIN
TC1:

; IDENTIFY TRACK DENSITY
	AND	[BX.CB], NMASK
	OR	[BX.CB], CT3
	MOV	[BX.CBCMD], FREADS
	MOV	BYTE PTR [DI], SL3
	MOV	CH, DMAIN
	MOV	DMACNT, SCSZ

; SET TRACK
	MOV	AL, [BX.TRK]
	TEST	[BX.MEDIA], T40
	JZ	TCT80
	SHR	AL, 1
TCT80:
	MOV	[BX.CBTRK], AL
	MOV	[BX.CBSEC], 1
	OR	[BX.CB], SS1_

	TASKC
	CMP	AH, TMOUT
	JE	TCTMOUT
	TEST	[BX.SB], FNMERR
	JZ	TCNCHG
; TRACK DENSITY CHANGED
	XOR	[BX.MEDIA], T40
	MOV	DH, MDCHG
	JMP	SHORT TCEXITPOP

TCTMOUT:
	MOV	AH, TIMOUT
TCERR:
	MOV	DH, MDUNK
	STC
	JMP	SHORT TCEXITPOP

; COMPARE WITH THE ORIGINAL ONE
TCNCHG:
	MOV	DH, MDNCHG
	MOV	AH, NOERR
	CLC

TCEXITPOP:
	MOV	BYTEBUF, AH
	POP	ES
	POP	BP
	POP	DI
	POP	CX
	POP	AX
	MOV	AH, BYTEBUF

TCEXIT:
	MOV	DL, [BX.MEDIA]
	RET
TDC	ENDP


; SET STATUS
DSST	PROC	FAR
	AND	DL, 0FEH
	CMP	DL, MXNSS*2		; CHECK NUMBER OF SET STATUS FUNCTIONS
	JB	DS1
	MOV	AH, ILLOPC
	STC
	RET
DS1:
	MOV	BL, DL
	XOR	BH, BH
	CALL	DSFTAB[BX]
	RET
DSST	ENDP


; MEDIA SET
;
MEDIAS	PROC	NEAR
	CALL	DDBINIT
	JC	MSEXIT
	TEST	[BX.MEDIA], XBC_
	JNZ	MS1

; HARD DISK - ILLEGAL
	MOV	AH, ILLOPC
	STC
	RET

; FLOPPY
MS1:
	OR	DH, XBC_		; CAN't set XEBEC
	MOV	[BX.MEDIA], DH
	MOV	AH, NOERR
	CLC
MSEXIT:
	RET
MEDIAS	ENDP


; DRIVE MAP
DRVMP	PROC	NEAR
	CMP	AL, NUMLDRV
	JB	DM1
	MOV	AH, ILLDEV
	STC
	JMP	SHORT DMEXIT
DM1:
	PUSH	AX
	AND	AX, 7			; 3 BIT ONLY
	SHLAX	DDBSZ2
	ADD	AX, OFFSET DS:DDB
	MOV	BX, AX
	MOV	WORD PTR [BX.DRV], CX
	MOV	[BX.MEDIA], DH
	POP	AX
	MOV	AH, NOERR
	CLC
DMEXIT:
	RET
DRVMP	ENDP


; SET NUMBER OF DRIVES
SNDRV	PROC	NEAR
	CMP	AL, 8
	JBE	SN1
	MOV	AH, BADCALL
	STC
	JMP	SHORT SNEXIT
SN1:
	PUSH	AX
	PUSH	CX
	MOV	MAXDRV, AL
	XOR	AH, AH
	MOV	CX, AX
	JCXZ	SNOK
	XOR	AX, AX
	MOV	BX, OFFSET DS:DDB

; COUNT HARD DISK AND FLOPPY
SNLP:
	TEST	[BX.MEDIA], XBC_
	JNZ	SNFLP
; HARD DISK
	INC	AL
	JMP	SHORT SNLPEND
SNFLP:
; FLOPPY
	INC	AH
SNLPEND:
	ADD	BX, SIZE DDBS
	LOOP	SNLP
	MOV	DRIVLOG, AX
SNOK:
	POP	CX
	POP	AX
	MOV	AH, NOERR
	CLC
SNEXIT:
	RET
SNDRV	ENDP


; SET OS MAP
SOSMP	PROC	NEAR
	MOV	BYTEBUF, AH
	CALL	DDBINIT
	JC	SOEXIT
	MOV	AH, BYTEBUF
	MOV	[BX.BOOTSEC], ES
	MOV	[BX.STRTSEC+2], DH
	MOV	WORD PTR [BX.STRTSEC], DI
	MOV	[BX.IMGSIZE+2], AH
	MOV	WORD PTR [BX.IMGSIZE], CX
	MOV	AH, NOERR
	CLC
SOEXIT:
	RET
SOSMP	ENDP


; XEBEC INIT-CHAR SET

XBICS	PROC	NEAR
	PUSH	AX
	PUSH	CX
	PUSH	DI
	CMP	CH, NUMLDRV
	JB	XS1
; ERROR
	MOV	AH, BADCALL
	STC
	JMP	SHORT XSEXIT
XS1:
	MOV	SI, DI			; [ES:DI] IS THE BUFFER
	MOV	AL, CH
	XOR	AH, AH
	SHLAX	XBICSFT
	ADD	AX, OFFSET DS:XBICTAB
	MOV	DI, AX
	MOV	CX, XBICLEN/2
	PUSH	ES
	MOV	AX, DS
	MOV	ES, AX
	POP	DS
	REP	MOVSW
	PUSH	ES
	MOV	AX, DS
	MOV	ES, AX
	POP	DS
	MOV	AH, NOERR
	CLC
XSEXIT:
	MOV	BYTEBUF, AH
	POP	DI
	POP	CX
	POP	AX
	MOV	AH, BYTEBUF
	RET
XBICS	ENDP


; XEBEC INIT

XBINI	PROC	NEAR
	CMP	CH, NUMLDRV
	JB	XI1
; ERROR
	MOV	AH, BADCALL
	STC
	JMP	SHORT XIEXIT
XI1:
	PUSH	AX
	PUSH	CX
	PUSH	DX
	MOV	AL, CH
	XOR	AH, AH
	SHLAX	XBICSFT
	ADD	AX, OFFSET DS:XBICTAB
	MOV	SI, AX
	MOV	CL, CH
	CALL	XBINIT
	MOV	BYTEBUF, AH
	POP	DX
	POP	CX
	POP	AX
	MOV	AH, BYTEBUF
XIEXIT:
	RET
XBINI	ENDP


MSGDUMP	PROC	NEAR
	TEST	DH, NEWDMPH
	JZ	MG1
	AND	AX, NOT 63
	OR	AX, WRITE*4
	MOV	DUMPHD, AX
MG1:
	AND	DDFLG, NOT TM
	TEST	DH, 80H
	JZ	MG2
	OR	DDFLG, TM
MG2:
	MOV	AH, NOERR
	CLC
	RET
MSGDUMP	ENDP


TMOCTRL	PROC	NEAR
	AND	DDFLG, NOT NOTMO
	TEST	DH, 80H
	JZ	TM1
	OR	DDFLG, NOTMO
TM1:
	MOV	AH, NOERR
	CLC
	RET
TMOCTRL	ENDP

;SET ADDRESS OF DISK HANDLER WAIT,START ROUTINE
;
;ENTRY:
;	ES:DI		ADDRESS
;	AL	BIT 	0
;			0	WAIT HANDLER
;			1	START HANDLER
;
;
SETWSR	PROC	NEAR
	CLI
	MOV	SI,0
	AND	AL,AL
	JZ	SETWSR1			;IF WAIT ROUTINE
	MOV	SI,4
SETWSR1:
	MOV	WORD PTR[SI+DDWAIT],DI
	MOV	WORD PTR[SI+DDWAIT+2],ES
	STI
	RET
SETWSR	ENDP

;SET SIZE
;ENTRY: CX SIZE OF SECTOR
;
;
SETSIZE	PROC	NEAR
	MOV	SECSIZE,CX
	XOR	AH,AH
	RET
SETSIZE	ENDP
;
;
PROG	ENDS

END
