TITLE	RESET	-- DISK DRIVER

IF1
%OUT	PASS	1...
ELSE
%OUT	PASS	2...
ENDIF

DGROUP	GROUP	DATA
PGROUP	GROUP	PROG

%OUT	INCLUDING

INCLUDE	SRC\DDRIV.EQU
INCLUDE	SRC\SCBP.EQU
INCLUDE	\GIFI\SRC\GIFMAC.MAC
INCLUDE	\186\XINSTR.MAC

; INIT AN ENTRY IN THE GET/SET STATUS FUNCTION TABLE
;
INITFTB	MACRO	FUNC
	MOV	AX, OFFSET CS:FUNC
	STOSW
	DEC	CX
ENDM

; INIT FLOPPY MEDIA ERROR-TRY SEQUENCE
;	ASSUME ES IS XDAT; AFTER THEN, DS IS CS
INITMED	MACRO	MEDS
	LOCAL	MEDST, MEDEN
	MOV	SI, OFFSET CS:MEDST
	MOV	CX, OFFSET CS:MEDEN
	SUB	CX, SI
	ASSUME	ES:DGROUP
	MOV	ES:MEDCNT, CL
	ASSUME	ES:NOTHING
	MOV	AX, CS
	MOV	DS, AX
	MOV	DI, OFFSET DS:FLPMEDS
	REP	MOVSB
	JMP	SHORT MEDEN
MEDST	DB	MEDS
MEDEN:
ENDM


DATA	SEGMENT	WORD PUBLIC 'data'
	ASSUME	DS:DGROUP
	EXTRN	DDDSTR:BYTE, DDDEND:BYTE, MEDCNT:BYTE, FLPMEDS:BYTE
	EXTRN	DMACBUF:WORD, CBB:BYTE, SBB:BYTE, DUMPHD:WORD
	EXTRN	XBICTAB:BYTE, DDFLG:BYTE, DRIVLOG:WORD, MAXDRV:BYTE
	EXTRN	HDLOG:BYTE, FPLOG:BYTE, DGFTAB:WORD, DSFTAB:WORD
	EXTRN	DDWAIT:DWORD,DDSTART:DWORD,SECSIZE:WORD
DATA	ENDS


%OUT	CODE	SEGMENT


	EXTRN	DDBINIT:NEAR, RSASI:NEAR, XBINIT:NEAR, SASINT:NEAR
	EXTRN	MEDIAC:NEAR, CNTRLG:NEAR, GNDRV:NEAR, OSMP:NEAR, TDC:NEAR
	EXTRN	MEDIAS:NEAR, DRVMP:NEAR, SNDRV:NEAR, SOSMP:NEAR
	EXTRN	XBICS:NEAR, XBINI:NEAR, MSGDUMP:NEAR, TMOCTRL:NEAR
	EXTRN	SETWSR:NEAR,RSASI:NEAR,SETSIZE:NEAR
	EXTRN	TASK:NEAR
PROG	SEGMENT	BYTE PUBLIC 'prog'
	ASSUME	CS:PGROUP
	EXTRN	DATSEG:WORD
	PUBLIC	DRESET, MRSASI, DFMT

DDWAINT	PROC	FAR
	HLT
	XOR	AH,AH
DDRETF	PROC	FAR
	RET
DDRETF	ENDP
DDWAINT	ENDP

DRESET	PROC	FAR
	CMP	AL, -1
	JE	MRST
	JMP	DRST

; MASTER RESET
MRST:
	PUSHA
	MOV	WORD PTR DS:DDWAIT,OFFSET CS:DDWAINT;INIT DISK HANDLER
	MOV	WORD PTR DS:DDSTART,OFFSET CS:DDRETF;WAIT ROUT PNTR,
	MOV	WORD PTR DS:DDSTART+2,PGROUP;START ROUT PNTR
	MOV	WORD PTR DS:DDWAIT+2,PGROUP
	MOV	SECSIZE,SCSZ
	PUSH	ES
	MOV	AX, DS
	MOV	ES, AX

; CLEAR DISK DRIVE DATA AREA
	MOV	DI, OFFSET DS:DDDSTR
	MOV	CX, OFFSET DS:DDDEND
	SUB	CX, DI
	SHR	CX, 1
	XOR	AX, AX
	REP	STOSW

; MESSAGE DUMP HANDLE
	MOV	ES:DUMPHD, KVDDEV*64+WRITE*4

; INIT GSTATUS FUNCTION TABLE
	MOV	DI, OFFSET DS:DGFTAB
	MOV	CX, MXNGS
	INITFTB	MEDIAC
	INITFTB	CNTRLG
	INITFTB	GNDRV
	INITFTB	OSMP
	INITFTB	TDC
	MOV	AX, OFFSET CS:ILLO
	REP	STOSW

; INIT SSTATUS FUNCTION TABLE
	MOV	DI, OFFSET DS:DSFTAB
	MOV	CX, MXNSS
	INITFTB	MEDIAS
	INITFTB	DRVMP
	INITFTB	SNDRV
	INITFTB	SOSMP
	INITFTB	XBICS
	INITFTB	XBINI
	INITFTB	MSGDUMP
	INITFTB	TMOCTRL
	INITFTB	SETWSR
	INITFTB	SETSIZE
	MOV	AX,OFFSET CS:ILLO
	REP	STOSW

; INIT MEDIA
	PUSH	DS
	INITMED	<11H, 15H, 17H, 14H, 16H>
	POP	DS

; INIT XEBEC TABLE
	MOV	AX, -1
	MOV	DI, OFFSET DS:XBICTAB
	MOV	CX, NUMLDRV*XBICLEN/2
	REP	STOSW

; INIT INT3
	XOR	AX, AX
	MOV	ES, AX
	MOV	DI, INT3VC*4
	MOV	AX, OFFSET CS:SASINT
	CLI
	MOV	ES:[DI], AX
	MOV	AX, CS
	MOV	ES:[DI+2], AX
	STI
	CALL	RSASI
	POP	ES
	POPA
; FOR DYNAMIC MEMORY ALLOCATION CONVENTION
	XOR	DX, DX
	MOV	AH, NOERR
	CLC
;
	RET

ILLO	PROC	NEAR
	MOV	AH, ILLOPC
	STC
	RET
ILLO	ENDP

; DISK RESET
DRST:
	CALL	DDBINIT
	JC	DREXIT
	TEST	[BX.MEDIA], XBC_
	JNZ	FDR

; HARD DISK RESET
HDR:
	MOV	[BX.TRK], 0
	MOV	[BX.MEDIA], NEW
	MOV	[BX.CMDLEN], HCMDL
	MOV	[BX.CBCTRL], XBCTRL
	MOV	AH, NOERR
	CLC

DREXIT:
	MOV	CX, WORD PTR [BX.DRV]
	RET



; FLOPPY DISK RESET
FDR:
	PUSHA
	MOV	[BX.TRK], 0
	MOV	[BX.MEDIA], (NEW OR XBC_)
	MOV	[BX.CMDLEN], FCMDL
	MOV	AL, DS1_
	MOV	CL, [BX.DRV]
	SHR	AL, CL
	MOV	[BX.CB], AL
	OR	[BX.CB], (CT3 OR DBD OR SS1_)
	MOV	[BX.CBTRK], 0
	MOV	[BX.CBSEC], 0
	MOV	[BX.CBCMD], FREST

	TASKM	3, OFF
	JNC	DROK
	OR	[BX.MEDIA], NOK
	CMP	AH, TMOUT
	POPA
	MOV	AH, DEAD
	STC
	JNE	DREXIT
	MOV	AH, TIMOUT
	JMP	DREXIT

DROK:
	POPA
	MOV	AH, NOERR
	JMP	DREXIT

DRESET	ENDP


; RESET SASI AND REPROGRAM THE XEBEC's
;	DESTROYED : AX, DX
MRSASI	PROC	NEAR
	PUSH	BX
	PUSH	CX
	PUSH	SI
	OUTPUT	DMACTRL, DMASTOP
	CALL	RSASI
	MOV	SI, OFFSET DS:XBICTAB
	MOV	BX, 0			; CONTROLLER NUMBER (BUFFER)
	MOV	CX, NUMLDRV

MRLP:
	CMP	WORD PTR [SI], -1
	JNE	MR1
	JMP	SHORT MRLPEND
MR1:
; PROGRAM XEBEC
	PUSH	SI
	XCHG	BX, CX
	CALL	XBINIT
	XCHG	CX, BX
	POP	SI
MRLPEND:
	ADD	SI, XBICLEN
	INC	BX
	LOOP	MRLP

	POP	SI
	POP	CX
	POP	BX
	RET
MRSASI	ENDP


; FORMAT (RETURN WHAT IS NECESSARY FOR FORMAT)

DFMT	PROC	FAR
	CALL	DDBINIT
	JC	FMEXIT
	MOV	DX, OFFSET PGROUP:TASKF
	MOV	DI, OFFSET DGROUP:DMACBUF
	MOV	CX, DS
	MOV	ES, CX
	MOV	CH, [BX.CB]
	MOV	CL, [BX.CTRL]
	MOV	AH, NOERR
	CLC
	MOV	BX, CS
FMEXIT:
	RET
DFMT	ENDP

TASKF	PROC	FAR
	PUSH	SI			; CBB
	PUSH	DS			; CBB, DS
	PUSH	ES			; CBB, DS, ES
	PUSH	DI			; CBB, DS, ES, SBB

; COPY CBB
	PUSH	CX
	MOV	ES, CS:DATSEG
	MOV	DI, OFFSET DS:CBB
	LODSB
	MOV	CL, AL
	XOR	CH, CH
	STOSB
	REP	MOVSB
	POP	CX

; COPY SBB COUNT
	POP	SI			; CBB, DS, ES, (SBB)
	POP	ES			; CBB, DS, (ES)
	PUSH	SI			; CBB, DS, SBB
	MOV	DI, OFFSET DS:SBB
	LODSB
	MOV	DS, CS:DATSEG
	MOV	[DI], AL
	MOV	SI, OFFSET DS:CBB
;
	CALL	TASK
;
	MOV	SI, ES
	POP	DI			; CBB, DS, (SBB)
	POP	ES			; CBB, (DS)
	PUSH	SI			; CBB, ES
	MOV	SI, OFFSET DS:SBB

; COPY SBB
	PUSH	DI
	PUSH	CX
	LODSB
	MOV	CL, AL
	PUSHF
	XOR	CH, CH
	INC	DI
	POPF
	REP	MOVSB
	POP	CX
	POP	DI

	MOV	SI, ES
	MOV	DS, SI
	POP	ES			; CBB, (ES)
	POP	SI			; (CBB)
	RET
TASKF	ENDP


PROG	ENDS

END
P

