	TITLE	INIT FOR INTERLACED SEPARATE VIDEO 520 LINES
	PAGE	60,132
;
;	DEFINITIONS
;
VFROP	EQU	4			;VERTICAL FRONT PORCH BOTH SYNC FIELDS
VSYNCW	EQU	20			;VERT SYNC WIDTH BOTH SYNC FIELDS
VBAP	EQU	4			;VERTICAL BACK PORCH BOTH SYNC FIELDS
HFROP	EQU	4			;HOR FRONT PORCH
HSYNCW	EQU	4			;HOR PULSE WIDTH
HBAP	EQU	0			;HOR BACK PORCH
LINES_CHAR EQU	10


NX	EQU	80			;CHARACTERS PER LINE
NY	EQU	48			;LINES MAIN FIELD
NYR	EQU	4			;RESERVED LINES
NYD	EQU	6			;DUMMY LINES
BASE	EQU	40H			;BASE SEGMENT VIDEO
;
;	INTERNAL DEFINITIONS
;
VFIELDL	EQU	LINES_CHAR*(NY+NYR)	;LINES /FIELD
VFIELDD	EQU	LINES_CHAR*NYD		;DUMMY LINES
HFIELD	EQU	NX/2			;DISPLAYED WORDS
LINES	EQU	VFROP+VFIELDL+VBAP+VSYNCW
WORDS	EQU	HFROP+HFIELD+HBAP+HSYNCW
OAWRDS	EQU	WORDS*LINES+WORDS*VFIELDD
OABYTS	EQU	OAWRDS*2
BBASE	EQU	(BASE AND 0FFFH) SHL 4
VBAL	EQU	VBAP*WORDS*2
VSL	EQU	VSYNCW*WORDS*2
VFRL	EQU	VFROP*WORDS*2
FLDL	EQU	VFIELDL*WORDS*2
CHKL1	EQU	VBAL
CHKL2	EQU	CHKL1+VSL
CHKL3	EQU	CHKL2
CHKL4	EQU	CHKL3+VFRL
CHKL5	EQU	CHKL4+FLDL

RTJPADR	EQU	OABYTS+2-2*WORDS-VFIELDD*WORDS*2
RTJPADR1 EQU	OABYTS+2-VFIELDD*WORDS*2
RTJP	EQU	(BASE SHL 3)+1+WORDS
RTJP1	EQU	RTJP+CHKL4/4-WORDS/2





	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	SRC\VIDMAC.MAC
;
;
PGROUP	GROUP	PROG
	ASSUME	CS:PGROUP
;
;
PROG	SEGMENT	BYTE PUBLIC 'PROG'
;
;
	PUBLIC	VDIS520
	PUBLIC	DATSEG
;
;
	EXTRN	INIATTR:NEAR,CHRGEN:NEAR
;
;
;
;
DATSEG	DW	OAWRDS/8+BASE+1
SLNKLST	PROC	FAR
	MOV	AX,BASE
	MOV	ES,AX
	MOV	BX,CHKL4/2+2-WORDS
	MOV	AX,(BASE SHL 3)+(CHKL4 SHR 1)+2
	MOV	ES:[BX],AX
	MOV	BX,CHKL4+2
	MOV	AX,(BASE SHL 3)+(CHKL4 SHR 1)+2+WORDS
	MOV	CX,VFIELDL+VFIELDD
LDCLP:
	MOV	ES:[BX],AX
	ADD	AX,WORDS
	ADD	BX,WORDS*2
	LOOP	LDCLP
	MOV	BX,RTJPADR
	MOV	WORD PTR ES:[BX],RTJP1
	MOV	BX,RTJPADR1
	MOV	WORD PTR ES:[BX],RTJP
	RET
SLNKLST	ENDP
;
;
IATTR	PROC	FAR
	PUSH	DS
	MOV	BX,OFFSET PGROUP:INIATTRIBU
	JMP	INIATTR
INIEND:
	MOV	DX,ATTRPT
	MOV	AH,30H
	OUT	DX,AX
	POP	DS
	RET
IATTR	ENDP
;
;
VDIS520:
	DW	VDIS520TE
	DB	3			;FLAG INTERLACED VIDEO
	DB	LINES_CHAR		;LINES PER CHARACTER
	DW	LINES			;TOTAL LINES
	DW	WORDS			;TOTAL WORDS
	DW	VFIELDL			;ACTIVE VERTICAL LINES
	DW	HFIELD			;ACTIVE WORDS
	DW	BASE			;VIDEO SEGMENT
	DW	2			;VERTICAL SYNCFIELD 1
	DW	CHKL4/2+2		;VERTICAL SYNC FIELD 2
	DW	CHKL4/2+2-WORDS		;EXIT ADR SYNC FIELD 1
	DW	CHKL4+2			;EXIT ADR SYNC FIELD 2
	DW	CHKL4			;ADDR OF FIRST LINE
	DW	WORDS*2+2		; ;OFFSET TO EXIT ADR OF LINE
	DW	HFROP*2			;OFFSET TO ACTIVE PART OF LINE
	DW	OAWRDS			;TOTAL WORDS
	DW	VFIELDD			;DUMMY LINES
	DW	OFFSET PGROUP:CHRGEN	;CHARGEN ADDR
	DD	IATTR			;$ INIT ROUT ATTRIBUTES
	DD	SLNKLST			;$ INIT ROUT LINK LIST
	DW	WORDS*2			;BYTES PER LINE
	DW	(HFROP+HSYNCW+HBAP)*2
	DW	LINES_CHAR*2*WORDS	;LENGTH CHARACTER LINE
	DW	LINES*WORDS*2-(HBAP+HSYNCW)*2
	DW	VFIELDL*WORDS*2		;LENGTH ACTIVE FIELD
	DW	NX			;ACTIVE BYTES PER LINE
	DW	NX-1			;MAX XCURSOR
	DW	NY-1			;MAX YCURSOR
	DW	NYR			;RESERVED CHARACTER LINES
VDIS520TE EQU	($-VDIS520)/2
;
;
INIATTRIBU:
	ADDRS	0,BASE
;
;	HOR SYNC DURING VERT BACK PORCH FIELD 1
;
	COUNT	VBAP/2
VBAPL:
	ADDA	(WORDS-HSYNCW)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	VBAPL
;
;	VERT SYNC FIELD 1
;
;
;	GENERATE VERTICAL SYNC
;
	COUNT	VSYNCW/2
VSYNCL:
	COUNT	WORDS-HSYNCW
VSYNCL1:
	COPY	1,VERT
	RP	VSYNCL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	RP	VSYNCL
;
;	VERT FRONT PORCH FIELD 1
;
	COUNT	VFROP/2
VFROPL:
	ADDA	(WORDS-HSYNCW)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	VFROPL
	COPY	1,LDCNTR
	SUBA	2
;
;	HALF DUMMY LINE
;
	ADDA	WORDS
;
;	HOR SYNC DURING VERT BACK PORCH FIELD 2
;
;
;	HALF	LINE DELAY TO PERFORM INTERLEAVE
;
	ADDA	WORDS
;
	COUNT	VBAP/2-1
AVBAPL:
	ADDA	(WORDS-HSYNCW)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	AVBAPL
;
;	VERT SYNC FIELD 2
;
	ADDA	WORDS-HSYNCW
	COUNT	(WORDS-HSYNCW)/2
AVSYNCL0:
	COPY	1,VERT
	RP	AVSYNCL0
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
;
;	GENERATE VERTICAL SYNC
;
	COUNT	VSYNCW/2-1
AVSYNCL:
	COUNT	WORDS-HSYNCW
AVSYNCL1:
	COPY	1,VERT
	RP	AVSYNCL1
	COPY	HSYNCW,<HSYNCW DUP (VSYNC)>
	RP	AVSYNCL
	COUNT	(WORDS-HSYNCW)/2
AVSYNCL2:
	COPY	1,VERT
	RP	AVSYNCL2
	ADDA	WORDS-HSYNCW
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
;
;	VERT FRONT PORCH FIELD2
;
	COUNT	VFROP/2
AVFROPL:
	ADDA	(WORDS-HSYNCW)*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	RP	AVFROPL
	COPY	1,LDCNTR
;
;	FIELD1+2
;
;	THIS FIELD IS INTERLACED
;	EVEN LINES ARE CONTAINED IN FIELD 1,ODD IN FIELD 2
;
	COUNT	VFIELDL+VFIELDD
FIELD:
	ADDA	HFROP*2-2
	COUNT	HFIELD
FIELD1:
	COPY	1,NORM
	RP	FIELD1
	ADDA	HBAP*2
	COPY	HSYNCW,<HSYNCW DUP (HSYNC)>
	COPY	1,LDCNTR
	RP	FIELD
	ENDTB	INIEND
;
;
PROG	ENDS
	END

N

(




