	INCLUDE	\GIFI\SRC\GIFMAC.MAC
	INCLUDE	\GIFI\SRC\IDAT.EQU
	INCLUDE	\SYSCON\SYSCON.EQU
	INCLUDE	\186\XINSTR.MAC
	INCLUDE	\GIFI\SRC\FIFO.S86
	.LIST
	.LALL
	PUBLIC	OUTEN
PGROUP	GROUP	PROG
DGROUP	GROUP	DATA
	ASSUME	CS:PGROUP,DS:DGROUP
;
	PAGE	60,132
DATA	SEGMENT	WORD PUBLIC 'DATA'
SCCAR	DB	16 DUP (?)
SCCBR	DB	16 DUP (?)
;
SCCBIFIS DB	BUFFSIZE DUP (?)
SCCBIFIE EQU	$
SCCBOFIS DB	BUFFSIZE DUP (?)
SCCBOFIE EQU	$
SCCAIFIS DB	BUFFSIZE DUP (?)
SCCAIFIE EQU	$
SCCAOFIS DB	BUFFSIZE DUP (?)
SCCAOFIE EQU	$
PRNTOFIS DB	BUFFSIZE DUP (?)
PRNTOFIE EQU	$
;
	PUBLIC	CHARIOSW
	EXTRN	PGRP:WORD,ATB:WORD,DELTAB:WORD
;
;
;
CHARIOSW DD	?
;
;
;
;
;
DATA	ENDS
;
;
PROG	SEGMENT	WORD PUBLIC 'PROG'
;
;
	EXTRN	ICTINIT:NEAR,GIFDIC:FAR,IDAT:FAR,GIFJMP:NEAR
	EXTRN	VDWRITE:FAR,KVDGSTR:FAR,KVDATTR:NEAR
;
;
;
;
;SRD,SWR	READ FROM,WRITE TO SCC REG TABLE [[BX.SCCTBP]+AH]
;
;
SRD	PROC	NEAR
	PUSH	SI
	MOV	SI,[BX.SCCTBP]
	PUSH	AX
	MOV	AL,AH
	MOV	AH,0
	ADD	SI,AX
	POP	AX
	MOV	AL,[SI]
	POP	SI
	RET
SRD	ENDP
;
;
;
SWR	PROC	NEAR
	PUSH	SI
	PUSH	AX
	MOV	AL,AH
	MOV	AH,0
	MOV	SI,[BX.SCCTBP]
	ADD	SI,AX
	POP	AX
	MOV	[SI],AL
	POP	SI
	RET
SWR	ENDP
;
;
;
;ON ENTRY:
;BX POINTS TO DATA AREA
;ES:DI POINTS TO CMD STRING
;
SCCINIT	PROC	FAR			;OUTPUT COMMAND STRING TO SCC
	PUSH	DX
	MOV	DX,[BX.FIFOPORT]	;SCC CMD PORT
	PUSH	CX
	MOV	CL,BYTE PTR ES:[DI]	;INIT LOOP COUNTER
	CLI
SCCINIT1:
	MOV	CH,0
	INC	DI
	MOV	AL,BYTE PTR ES:[DI]
	INC	DI
	TEST	AL,80H			;IF READ MODIFY WRITE
	PUSHF
	AND	AL,0FH
	OUT	DX,AL
	MOV	AH,AL
	POPF
	JZ	SCCINIT11
	CALL	SRD			;READ CURRENT REG CONTENTS FROM TABLE
	AND	AL,ES:[DI]
	OR	AL,ES:[DI+1]
	INC	DI
	JMP	SHORT SCCINIT2
SCCINIT11:
	MOV	AL,BYTE PTR ES:[DI]
	JNZ	SCCINIT2
SCCINIT2:
	CALL	SWR			;UPDATE TABLE
	OUT	DX,AL
	LOOP	SCCINIT1
	STI
	POP	CX
	POP	DX
	RET
SCCINIT	ENDP
;
;
	PUBLIC	CHARIO,CHARIOS,PUTIFI,FIFOIO2,FRETF,FLUSHI,FIFOGSTA
	PUBLIC	FIFOIO,DISEN,SETFPNT
	PUBLIC	WRAHATB,SETINWT,SETOTWT,SETIPROC,SETOTASK,SETITASK
;
;
;	ENABLE SCC 
;	THIS ROUT SHOULD BE CALLED ABOUT 1 SECOND AFTER THE SCC HAS 
;	BEEN INITIALISED
;
CHARIOS	PROC
	MOV	ES,PGRP
	MOV	DL,CMD2SCC
	MOV	DI,OFFSET PGROUP:SCCBBS	;START SCCB
	GIFCALL	DCEDEV,SSTATUS,0
	MOV	DI,OFFSET PGROUP:SCCAS	;START SCCA
	GIFCALL	DTEDEV,SSTATUS,0
	RET
CHARIOS	ENDP
;
;
;
;
;
;	SCC	INTERUPT HANDLERS
;
;
;
;
;
;	SCC INPUT
;
;
SCCI	PROC	FAR
	MOV	AH,AL
	MOV	AL,[BX.FIFOFLGS]
	TEST	AX,BREAK*256+BREAKP	;IF BREAK RECEIVED
	JZ	SCCI0
	TEST	AH,BREAK		;IF BREAK FLAGGED
	JNZ	SCCI00			;FLAG IN USER FLAGS
	CMP	[DELTAB+4],0		;ELSE IF DELAY PENDING
	JNZ	SCCI01			;WAIT
	AND	[BX.FIFOFLGS],NOT BREAKP;ELSE RES PENDING FLAG
	MOV	AL,60H			;RESET ERROR STATUS
	OUT	DX,AL
	ADD	DX,2
	RET
SCCI00:
	MOV	[DELTAB+4],30		;SET 300 MSEK DELAY
	TEST	[BX.FIFOFLGS],BREAKP	;IF BREAK NOT PENDING
	JNZ	SCCI01
	OR	[BX.FIFOFLGS],BREAK+BREAKP;FLAG BREAK,PENDING
SCCI01:
	ADD	DX,2			;DISCARD DATA
	IN	AL,DX
	NOP
	NOP
	NOP
	IN	AL,DX
	NOP
	NOP
	NOP
	IN	AL,DX
	RET				;EXIT INPUT
SCCI0:
	CLI
	MOV	AL,1
	OUT	DX,AL
	NOP
	NOP
	NOP
	IN	AL,DX
	STI
	AND	AL,70H			;IF NO ERR
	MOV	[BX.FIFOERR+1],AL
	JZ	SCCERR2			;EXIT
	TEST	AL,40H			;FRAMING ERROR
	MOV	AH,FRAMERR
	JZ	SCCERR1
	TEST	AL,20H			;OVERRUN ERROR
	MOV	AH,DEVOVR
	JZ	SCCERR1
	TEST	AL,10H			;PARITY ERR
	MOV	AH,PARERR
SCCERR1:
	MOV	[BX.FIFOERR],AH
	MOV	AL,60H			;RESET ERROR STATUS
	OUT	DX,AX
SCCERR2:
	MOV	DI,[BX.FIFOICNT]
	CMP	DI,[BX.FIFOIMX]
	JZ	SCCI81			;FIFO FULL -EXIT
	INC	DX
	INC	DX
	IN	AL,DX			;ELSE READ CHARACTER
	TEST	[BX.FIFOATRB],STRIP	;IF STRIP BIT 7 DISABLED
	JZ	SCCI1			;NO STRIP OF BIT 7
	AND	AL,7FH			;ELSE DO IT
SCCI1:
	CALL	DWORD PTR[BX.FIFOIPRC]
	JNC	SCCI11			;CONTINUE WITH XON/XOFF PROCESSING
	JNZ	PUTIFI1			;STORE CHARACTER
	RET
SCCI11:
	TEST	[BX.FIFOFLGS],MODEN	;IF MODEM IS ENABLED
	JZ	SCCI3
	CMP	DI,[BX.FIFOXOFL]	;TEST FOR MODEM SHOULD BE SWITCHED OFF
	JB	SCCI3
	TEST	[BX.FIFOFLGS],XONEN	;IF XON ENABLED
	JNZ	SCCI2			;DISABLE VIA XOFF
	DEC	DX
	DEC	DX
	PUSH	AX
	MOV	AX,505H			;ELSE DISABLE MODEM VIA HANDSHAKE
	CLI
	OUT	DX,AL
	CALL	SRD
	AND	AL,0FDH
	OUT	DX,AL
	STI
	CALL	SWR
	POP	AX
	JMP	SHORT SCCI6
SCCI2:
	MOV	[BX.FIFOBYTE],XOFF	;OUTPUT XOFF
	JMP	SHORT SCCI6
SCCI3:
	TEST	[BX.FIFOFLGS],XONEN	;IF XON/XOF DISABLED
	JZ	PUTIFI1			;STORE CHARACTER
	CMP	AL,XOFF			;ELSE CHECK FOR XOFF RECEIVED
	JNZ	SCCI5			;IF XOFF
	TEST	[BX.FIFOFLGS],XANY	;IF XANY ENABLED
	JZ	SCCI31
	TEST	[BX.FIFOFLGS],OUTEN	;AND XMITTER TURNED OF
	JZ	SCCI51			;ENABLE IT AGAIN
SCCI31:
	AND	[BX.FIFOFLGS],NOT OUTEN
SCCI81:
	JMP	SHORT SCCI8
SCCI5:
	CMP	AL,XON			;ELSE IF XON
	JNZ	PUTIFI1
	TEST	[BX.FIFOFLGS],OUTDIS	;AND OUTPUT NOT
	JNZ	PUTIFI1			;DISABLED
SCCI51:
	OR	[BX.FIFOFLGS],OUTEN
	JMP	SHORT SCCI8
SCCI6:
	AND	[BX.FIFOFLGS],NOT MODEN	;FLAG MODEM DISABLED
PUTIFI1	PROC	FAR
	MOV	SI,[BX.FIFOIPTI]	;FIFO INPUT PTR SCC INPUT CHANNEL
	MOV	[SI],AL			;STORE IT IN FIFO
	INC	SI
	CMP	SI,[BX.FIFOIFIE]	;IF WRAP AROUND
	JB	SCCI7
	MOV	SI,[BX.FIFOIFIS]	;SET BACK TO START
SCCI7:
	MOV	[BX.FIFOIPTI],SI	;STORE POINTER
	INC	[BX.FIFOICNT]		;CHAR COUNTER +1
SCCI8:
	RET
PUTIFI1	ENDP
SCCI	ENDP
;
;
;
;	SCC OUTPUT
;
;
;
SCCO	PROC	FAR
	INC	DX
	INC	DX
	CMP	[BX.FIFOOCNT],0		;IF FIFO EMPTY
	JZ	SCCO4			;FIFO EMPTY
	DEC	[BX.FIFOOCNT]		;CNT -1
	MOV	SI,[BX.FIFOOPTO]	;OUTPUT POINTER
	MOV	AL,[SI]			;ELSE GET CHAR
	OUT	DX,AX
	INC	SI			;ADV PTR
	CMP	SI,[BX.FIFOOFIE]	;IF WRAP AROUND
	JB	SCCO3
	MOV	SI,[BX.FIFOOFIS]	;SET BACK TO STRT
SCCO3:
	MOV	[BX.FIFOOPTO],SI	;STORE NEW PTR
	RET
SCCO4:
	CALL	DWORD PTR[BX.FIFOOTSK]
	RET
SCCO	ENDP
;
;
;
CHARIO	PROC	FAR
	MOV	WORD PTR CHARIOSW,OFFSET PGROUP:CHARIOD;DISABLE CALLS TO THIS HANDLER
;
;
;	PRNT	FIFO READ
;
;
	MOV	BX,DGROUP:[ATB.PRTDEVA]
	TEST	[BX.FIFOFLGS],STPNDNG+OUTDIS;OR PRINTER STOPPED
	JZ	PRNTOO0
	AND	[BX.FIFOFLGS],NOT STPNDNG
	JMP	SHORT PRNTOO4		;RESET STROBE,STOP OUTPUT
PRNTOO0:
	CMP	[BX.FIFOOCNT],0		;IF FIFO EMPTY
	JZ	PRNTOO3
	MOV	DX,SYSSTAT		;TEST FOR PRINTER IS READY
	IN	AX,DX			;AND NOT OUT OF PAPER
	TEST	AX,(1 SHL PROUTPA)+(1 SHL PRBUSY)
	JZ	PRNTOO1			;OUTPUT CHAR IF READY
	TEST	AX,1 SHL PROUTPA	;ELSE IF OUT OF PAPER
	JZ	PRNTOO5
	MOV	[BX.FIFOERR],OUTPAP	;FLAG OUT OF PAPER ERROR
	JMP	SHORT PRNTOO5
PRNTOO1:
	MOV	SI,[BX.FIFOOPTO]	;OUTPUT POINTER
	MOV	AH,[SI]			;ELSE GET CHAR
	MOV	DX,PRTDAT		;OUTPUT IT
	OUT	DX,AX
	MOV	DX,DATASTB		;GENERATE STROBE
	XOR	AX,AX
	OUT	DX,AL
	INC	SI			;ADV PTR
	CMP	SI,[BX.FIFOOFIE]	;IF WRAP AROUND
	JB	PRNTOO2
	MOV	SI,[BX.FIFOOFIS]	;SET BACK TO STRT
PRNTOO2:
	MOV	[BX.FIFOOPTO],SI	;STORE NEW PTR
	DEC	[BX.FIFOOCNT]		;CNT -1
	TEST	[BX.FIFOFLGS],SLOWSTB	;IF SLOW DATASTROBE
	JZ	PRNTOO4
	OR	[BX.FIFOFLGS],STPNDNG	;FLAG STROBE PENDING
	JMP	SHORT PRNTOO5		;AND LEAVE STROBE ASSERTED
PRNTOO3:
	CALL	DWORD PTR[BX.FIFOOTSK]	;START USER TASK AGAIN
	JMP	SHORT PRNTOO5
PRNTOO4:
	MOV	DX,DATASTB		;DESACTIVATE DATASTROBE PRINTER
	MOV	AL,1
	OUT	DX,AL
PRNTOO5:
;
;
;	SCC HANDLER
;
;
	MOV	BX,[ATB.DCEDEVA]
	MOV	DX,SCCPORT+0
	IN	AL,DX
	TEST	AL,RXRDY+BREAK
	JZ	SCCBNRX
	CALL	SCCI
	DEC	DX
	DEC	DX
	IN	AL,DX
	JMP	SHORT SCCBRXOK
SCCBNRX:
	CALL	DWORD PTR[BX.FIFOITSK]
SCCBRXOK:
	CMP	[BX.FIFOBYTE],0		;IF XON / XOFF HAS TO BE SEND
	JZ	SCCBTX1
	TEST	AL,TXRDY
	JZ	SCCBNTX
	INC	DX
	INC	DX
	MOV	AL,[BX.FIFOBYTE]
	OUT	DX,AL
	JMP	SHORT SCCBNTX
SCCBTX1:
	AND	AL,[BX.FIFOFLGS]	;MASK WITH OUTPUT ENABLE
	TEST	AL,TXRDY
	JZ	SCCBNTX
	CALL	SCCO
SCCBNTX:
	MOV	BX,[ATB.DTEDEVA]
	MOV	DX,SCCPORT+4
	IN	AL,DX
	TEST	AL,RXRDY+BREAK
	JZ	SCCANRX
	CALL	SCCI
	DEC	DX
	DEC	DX
	IN	AL,DX
	JMP	SHORT SCCARXOK
SCCANRX:
	CALL	DWORD PTR[BX.FIFOITSK]
SCCARXOK:
	CMP	[BX.FIFOBYTE],0		;IF XON / XOFF HAS TO BE SEND
	JZ	SCCATX1
	TEST	AL,TXRDY
	JZ	SCCANTX
	INC	DX
	INC	DX
	MOV	AL,[BX.FIFOBYTE]
	OUT	DX,AL
	JMP	SHORT SCCANTX
SCCATX1:
	AND	AL,[BX.FIFOFLGS]	;MASK WITH OUTPUT ENABLE
	TEST	AL,TXRDY
	JZ	SCCANTX
	CALL	SCCO
SCCANTX:
;
;
	MOV	WORD PTR CHARIOSW,OFFSET PGROUP:CHARIO;ENABLE IO AGAIN
;
;
CHARIOD:
	RET
CHARIO	ENDP
;
;
;
;	INPUT FIFO FLUSH
;
;
;
CFLUSHI:
	MOV	BX,[BX]
FLUSHI	PROC	FAR
	MOV	SI,[BX.FIFOIFIS]
	TEST	AH,1			;IF CHARACTER SHOULD BE PUT IN FIFO
	CLI
	JZ	FLUSHI1
	MOV	[SI],AL			;STORE CHARACTER
	INC	SI
FLUSHI1:
	TEST	AH,2			;IF BUFFER SHOULD BE COPIED INTO BUFFER
	JZ	FLUSHI3
	CMP	CX,[BX.FIFOIMX]		;CHECK FOR VALID COUNT
	JBE	FLUSHI2
	MOV	AH,DEVOVR		;FLAG ERROR
	STC
	RET
FLUSHI2:
;	RPMOVB	CX,DI		;MOVE DATA
FLUSHI3:
	MOV	[BX.FIFOIPTI],SI
	STI
	MOV	[BX.FIFOIPTO],SI
	MOV	[BX.FIFOICNT],0
	CLC
	RET
FLUSHI	ENDP
;
;
;
;	OUTPUT FIFO FLUSH
;
;
;
FLUSHO	PROC	FAR
	MOV	SI,[BX.FIFOOFIS]
	MOV	[BX.FIFOOPTI],SI
	MOV	[BX.FIFOOPTO],SI
	MOV	[BX.FIFOOCNT],0
	CLC
	RET
FLUSHO	ENDP
;
;
;
FRETF	PROC	FAR			;FIFO RETURN FAR
	CLC
	RET
FRETF	ENDP
;
;
ENIN	PROC	NEAR
	TEST	[BX.FIFOFLGS],MODEN	;IF MODEM IS CURRENTLY DISABLED
	JNZ	SCCFIO3
	MOV	SI,[BX.FIFOICNT]
	CMP	SI,[BX.FIFOXONL]	;AND MODEM SHOULD BE ENABLED
	JA	SCCFIO3
	TEST	[BX.FIFOFLGS],XONEN	;IF XON IS ENABLED
	JNZ	SCCFIO1			;ENABLE VIA XON
	PUSH	DX
	MOV	DX,[BX.FIFOPORT]	;SCC PORT ADDRESS
	PUSH	AX
	MOV	AX,505H			;ELSE ENABLE MODEM VIA HANDSHAKE
	CLI
	OUT	DX,AL
	CALL	SRD
	OR	AL,2
	OUT	DX,AL
	STI
	CALL	SWR
	POP	AX
	POP	DX
	JMP	SHORT SCCFIO2
SCCFIO1:
	MOV	[BX.FIFOBYTE],XON	;OUTPUT XON
SCCFIO2:
	TEST	[BX.FIFOFLGS],OUTDIS	;IF OUTPUT IS NOT
	JNZ	SCCFIO3			;DISABLED
	OR	[BX.FIFOFLGS],MODEN	;FLAG ENABLED
SCCFIO3:
	RET
ENIN	ENDP
;
;
;	FIFO READ
;
;
CFIFOIO:
	MOV	BX,[BX]
SCCFIO	PROC	FAR			;SCC RAED
	CALL	ENIN
FIFOIO	PROC	FAR
	MOV	SI,[BX.FIFOIPTO]	;OUTPUT POINTER
	TEST	AH,ANYATTR		;IF ATTRIBUTES VALID
	JNZ	FIFOIO3			;SWITCH
;
;
;	CHARACTER MODE
;
;
FIFOIO00:
	CMP	[BX.FIFOICNT],0		;TEST FOR FIFO IS EMPTY
	JZ	FIFOIO1			;FIFO EMPTY
	MOV	AL,[SI]			;ELSE GET CHAR
	DEC	[BX.FIFOICNT]		;CNT -1
	INC	SI			;ADV PTR
	CMP	SI,[BX.FIFOIFIE]	;IF WRAP AROUND
	JB	FIFOIO0
	MOV	SI,[BX.FIFOIFIS]	;SET BACK TO START
FIFOIO0:
	CLC
FIFOIO01:
	MOV	[BX.FIFOIPTO],SI	;STORE NEW PTR
	RET
FIFOIO1:
	PUSH	BX
	CALL	DWORD PTR[BX.FIFOIWT]	;WAIT
	POP	BX
	JMP	FIFOIO			;TRY AGAIN
FIFOIO2:
	TEST	AH,WAIT			;IF IMM RET
	JZ	FIFOIO21		;FLAG NOT READY,EXIT
	RET				;ELSE WAIT
FIFOIO21:
	MOV	AH,NOTRDY		;FLAG NOT READY
	ADD	SP,6
	STC
	RET
FIFOIO3:
	TEST	AH,GENATTRI		;IF ATTRIBUTES FROM TABLE ARE VALID
	JZ	FIFOIO4
	MOV	AH,[BX.FIFOATRB]	;USE THESE BITS
FIFOIO4:
	TEST	AH,BURSTMD		;IF NO BLOCK /STRING MODE
	JZ	FIFOIO00		;CONTINUE IN CHARACTER MODE
;
;
;	BLOCK MODE
;
;
	JCXZ	FIFOIO11		;EXIT IF CHAR CNT=0 OR NO START,STOP CHR VALID
FIFOIO5:
	CMP	[BX.FIFOICNT],0		;IF NO CHARACTERS VALID
	JZ	FIFOIO8			;WAIT
	TEST	AH,STRMD		;ELSE IF STRING MODE
	JNZ	FIFOIO10		;STRING MODE
FIFOIO6:
	MOV	AL,[SI]
	MOV	ES:[DI],AL
	INC	DI
	INC	SI
	CMP	SI,[BX.FIFOIFIE]	;IF WRAP AROUND
	JNZ	FIFOIO7
	MOV	SI,[BX.FIFOIFIS]	;SET BACK TO START
FIFOIO7:
	DEC	[BX.FIFOICNT]		;UNTIL USR BUFFER FULL OR FIFO EMPTY
	LOOPNZ	FIFOIO6
	JCXZ	FIFOIO0			;EXIT IF USR BUFFER FULL
FIFOIO8:
	PUSHA				;ELSE SAVE STATUS
	CALL	DWORD PTR[BX.FIFOIWTB]	;AND WAIT
	POPA
	JMP	FIFOIO5			;CONTINUE
;
;
;	STRING MODE
;
;
FIFOIO10:
	AND	CH,CH			;IF NO START CHAR VALID
	JZ	FIFOIO13		;TRANSFER FROM CURRENT BUFFER
	CMP	[SI],CH			;ELSE SEARCH FOR MATCH
	JNZ	FIFOIO11
	MOV	CH,0			;FLAG FOUND
FIFOIO11:
	INC	SI
	CMP	SI,[BX.FIFOIFIE]
	JNZ	FIFOIO12
	MOV	SI,[BX.FIFOIFIS]
FIFOIO12:
	DEC	[BX.FIFOICNT]
	JNZ	FIFOIO10
	JMP	FIFOIO8			;WAIT
FIFOIO13:
	CMP	ES:[DI-1],CL		;IF END OF STRING FOUND
FIFOIO131:
	JZ	FIFOIO0			;EXIT
	CMP	DI,DX			;IF AT END OF USER BUFFER
	JA	FIFOIO15		;FLAG ERROR
	CMP	SI,[BX.FIFOIFIE]
	JNZ	FIFOIO14
	MOV	SI,[BX.FIFOIFIS]
FIFOIO14:
	DEC	[BX.FIFOICNT]		;IF FIFO NOT EMPTY
	JNZ	FIFOIO13		;LOOP
	CMP	ES:[DI-1],CL		;ELSE IF END OF STRING FOUND
	JZ	FIFOIO131		;EXIT
	JMP	FIFOIO8			;ELSE WAIT 
FIFOIO15:
	MOV	AH,ENDNF		;FLAG NO TERMINATOR FOUND
	STC
	JMP	FIFOIO01
FIFOIO	ENDP
SCCFIO	ENDP
;
;
;	FIFO WRITE
;
;
FIFOOI	PROC	FAR
	TEST	AH,ANYATTR		;IF ANY ATTRIBUTE VALID
	JNZ	FIFOOI3			;EXECUTE IT
;
;
;	CHARACTER MODE
;
;
FIFOOI00:
	MOV	SI,[BX.FIFOOCNT]
	CMP	SI,[BX.FIFOOMX]		;IF FIFO NOT FULL
	JNZ	FIFOOI0			;STORE CHARACTER
	PUSH	AX
	PUSH	BX			;ELSE WAIT
	CALL	DWORD PTR[BX.FIFOOWT]
	POP	BX
	POP	AX
	JMP	FIFOOI
FIFOOI0:
	MOV	SI,[BX.FIFOOPTI]	;POINTER
	MOV	[SI],AL			;STORE CHAR
	INC	SI
	CMP	SI,[BX.FIFOOFIE]	;IF WRAP AROUND
	JB	FIFOOI1
	MOV	SI,[BX.FIFOOFIS]	;SET BACK TO START
FIFOOI1:
	INC	[BX.FIFOOCNT]		;CNT+1
	JMP	SHORT FIFOOI12		;EXIT
FIFOOI2:
	TEST	AH,WAIT			;IF IMMEDIATE RETURN
	JZ	FIFOOI21		;FLAG NOT RDY
	RET				;ELSE WAIT
FIFOOI21:
	MOV	AH,NOTRDY		;FLAG NOT READY
	ADD	SP,8
	STC
	RET
;
;
;	SEL ATTRIBUTEFROM TABLE/REG AH,BURST CHAR MODE
;
;
FIFOOI3:
	TEST	AH,GENATTRI		;IF RF ATTRIBUTES VALID
	JZ	FIFOOI4
	MOV	AH,[BX.FIFOATRB]	;USE THESE ATTRIBUTES
FIFOOI4:
	TEST	AH,BURSTMD		;IF CHARACTER MODE
	JZ	FIFOOI00		;EXECUTE CHARACTER MODE
	JCXZ	FIFOOI12		;EXIT IF NO INPUT STRING/BLOCK
	PUSH	BP
	PUSH	DX
	MOV	BP,[BX.FIFOOMX]		;LENGTH FIFO
	MOV	SI,[BX.FIFOOPTI]	;INPUT POINTER
FIFOOI41:
	CMP	BP,[BX.FIFOOCNT]	;IF FULL
	JZ	FIFOOI7			;WAIT
	TEST	AH,STRMD		;SWITCH BLOCK/STRING MODE
	JNZ	FIFOOI8
;
;
;	BLOCK MODE
;
;
FIFOOI5:
	MOV	AL,ES:[DI]
	MOV	[SI],AL
	INC	SI
	INC	DI
	CMP	SI,[BX.FIFOOFIE]
	JB	FIFOOI6
	MOV	SI,[BX.FIFOOFIS]
FIFOOI6:
	INC	[BX.FIFOOCNT]		;TRANSFER AS LONG  FIFO NOT FULL
	CMP	BP,[BX.FIFOOCNT]
	LOOPNZ	FIFOOI5			;AND USR BUFFER NOT EMPTY
	JCXZ	FIFOOI11		;EXIT IF USR BUFFER EMPTY
FIFOOI7:
	PUSHA
	CALL	DWORD PTR[BX.FIFOOWTB]	;ELSE WAIT
	POPA
	JMP	FIFOOI41
;
;
;	STRING MODE
;
;
FIFOOI8:
	AND	CH,CH			;IF NO START CHAR HAS TO BE FOUND
	JZ	FIFOOI9			;CONTINUE FROM CURRENT POINT
FIFOOI81:
	CMP	DI,DX			;IF AT END OF BUFFER
	JA	FIFOOI13		;FLAG ERROR
	CLD
	SCASB				;ELSE SCAN
	JNZ	FIFOOI81		;AS LONG NO MATCH FOUND
	MOV	CH,0			;ELSE FLG NO START CHAR REQUIRED
FIFOOI9:
	CMP	DI,DX			;IF AT END OF USR BUFFER
	JA	FIFOOI14		;FLAG ERROR
	MOV	AL,ES:[DI]		;TRANSFER UNTIL STOP CHAR FOUND OR FIFO FULL
	INC	DI
	CMP	AL,CL
	JZ	FIFOOI11		;EXIT IF STOP CHAR FOUND
	MOV	[SI],AL
	INC	SI
	CMP	SI,[BX.FIFOOFIE]	;IF WRAP AROUND
	JB	FIFOOI10
	MOV	SI,[BX.FIFOOFIS]	;SET PNTR BACK TO START OF FIFO
FIFOOI10:
	INC	[BX.FIFOOCNT]
	CMP	BP,[BX.FIFOOCNT]	;IF FIFO FULL
	JNZ	FIFOOI9
	JMP	FIFOOI7			;WAIT
FIFOOI11:
	POP	DX
	POP	BP
FIFOOI12:
	CLC
FIFOOI121:
	MOV	[BX.FIFOOPTI],SI	;SAVE NEW POINTER
	RET
FIFOOI13:
	POP	DX
	POP	BP
	MOV	AH,STRTNF		;FLAG START CHARACTER NOT FOUND
	JMP	SHORT FIFOOI15
FIFOOI14:
	POP	DX
	POP	BP
	MOV	AH,ENDNF		;FLAG TERMINATING CHARACTER NOT FOUND
FIFOOI15:
	STC
	JMP	FIFOOI121
FIFOOI	ENDP
;
;
;
;	SET ATTRIBUTES SCC
;
;
;ENTRY:
;	BX	POINTS TO ATTRIBUTE TABLE
;	AH	STANDARD ATTRIBUTE BYTE
;	DL	SWITCH
;	AL	SPEZIAL ATRIBUTES:
;		BIT
;		0	ENABLE XON/XOFF ELSE V24 HANDSHAKE
;
;
SCCSSTA	PROC	FAR
	MOV	SI,OFFSET PGROUP:SCCATTR
	JMP	GIFJMP
SCCSSTA	ENDP
;
;
;
WRAHATB	PROC	FAR
	MOV	[BX.FIFOATRB],AH
	CLC
	RET
WRAHATB	ENDP
;
;
;
;	ENABLE XON/XOFF
;
;
SCCENX	PROC	FAR
	JZ	SCCDSX
	OR	[BX.FIFOFLGS],XONEN
	TEST	AL,2			;IF XANY ENABLED
	JZ	SCCENX1
	OR	[BX.FIFOFLGS],XANY
SCCENX1:
	RET
;
;
;	DISABLE XON/XOFF
;
;
SCCDSX:
	AND	[BX.FIFOFLGS],NOT (XONEN+XANY)
	RET
SCCENX	ENDP
;
;
;
DISEN	PROC	FAR			;ENABLE/DISABLE OUTPUT
	JZ	DISENE			;ENABLE OUTPUT
	OR	[BX.FIFOFLGS],OUTDIS
	AND	[BX.FIFOFLGS],NOT OUTEN
	RET
DISENE:
	AND	[BX.FIFOFLGS],NOT OUTDIS
	RET
DISEN	ENDP
;
;
;
;
SETFPNT	PROC	FAR
	CLI
	MOV	[BX+SI],DI		;STORE USER ROUTINE ADDRESS
	MOV	[BX+SI+2],ES
	STI
	RET
SETFPNT	ENDP
;
;
;
SETINWT	PROC	FAR
	JNZ	SETIWT1
	MOV	SI,FIFOIWT
SETIWT1:
	MOV	SI,FIFOIWTB
	JMP	SHORT SETFPNT
SETINWT	ENDP
;
;
SETOTWT	PROC	FAR
	JNZ	SETOWT1
	MOV	SI,FIFOOWT
	JMP	SHORT SETFPNT
SETOWT1:
	MOV	SI,FIFOOWTB
	JMP	SHORT SETFPNT
SETOTWT	ENDP
;
;
SETIPROC PROC	FAR
	MOV	SI,FIFOIPRC
	JMP	SHORT SETFPNT
SETIPROC ENDP
;
;
SETOTASK PROC	FAR
	MOV	SI,FIFOOTSK
	JMP	SHORT SETFPNT
SETOTASK ENDP
;
;
SETITASK PROC	FAR
	MOV	SI,FIFOITSK
	JMP	SHORT SETFPNT
SETITASK ENDP
;
;
SCCBITS	PROC	FAR			;SET 7 BIT CHAR IF B0,AL=0 ELSE 8BIT
	PUSH	DI
	MOV	AH,0
	MOV	DI,BITSL
	MUL	DI
	MOV	DI,AX
	ADD	DI,OFFSET CS:BITS
SCCBIT1:
	PUSH	ES
	PUSH	CS
	POP	ES
	CALL	SCCINIT			;UTPUT CMD STRING
	POP	ES
	POP	DI
	CLC
	RET
SCCBITS	ENDP
;
;
SCCPARI	PROC	FAR			;EN PARITY IF B0,AL=1 ELSE DISABLE
	PUSH	DI
	MOV	DI,OFFSET PGROUP:NOPAR	;PRES FOR NO PARITY
	JZ	SCCBIT1
	MOV	DI,OFFSET PGROUP:ODDPAR
	TEST	AL,2
	JZ	SCCBIT1
	MOV	DI,OFFSET PGROUP:EVPAR
	JMP	SCCBIT1
SCCPARI	ENDP
;
;
SCCBAUD	PROC	FAR			;SET BAUD RATE
	MOV	AH,0			;POINT TO CONSTANT IN TABLE
	PUSH	DI
	MOV	DI,BAUDL
	MUL	DI
	MOV	DI,AX
	ADD	DI,OFFSET PGROUP:BAUDT
	JMP	SCCBIT1
SCCBAUD	ENDP
;
;
SCCATTR:
	DB	22
	DW	OFFSET PGROUP:WRAHATB
	DW	OFFSET PGROUP:DISEN
	DW	OFFSET PGROUP:SETOTWT
	DW	OFFSET PGROUP:SETOTASK
	DW	OFFSET PGROUP:SETINWT
	DW	OFFSET PGROUP:SETITASK
	DW	OFFSET PGROUP:SETIPROC
	DW	OFFSET PGROUP:SCCENX
	DW	OFFSET PGROUP:SCCINIT
	DW	OFFSET PGROUP:SCCBITS
	DW	OFFSET PGROUP:SCCPARI
	DW	OFFSET PGROUP:SCCBAUD
;
;

SCCGRG	PROC	FAR			;GET SCC STATUS REGISTER
	CALL	ENIN
	MOV	DX,[BX.FIFOPORT]	;GET IO PORT
	IN	AL,DX			;GET STATUS
	AND	AL,TXRDY+RXRDY+DCD+CTS	;MASK OUT INTERESTING BITS
	MOV	AH,AL			;SAVE	
	MOV	AL,[BX.FIFOFLGS]	;GET BREAK BIT
	AND	[BX.FIFOFLGS],NOT BREAK	;RESET BREAK FLAG
	AND	AL,BREAK
	OR	AL,AH			;GET OTHER BITS
	CMP	[BX.FIFOICNT],0		;IF CHARACTER IN BUFFER
	JZ	SCCGRG1
	OR	AL,RXBRDY		;FLAG CHARACTER AVAILABLE
SCCGRG1:
	MOV	SI,[BX.FIFOOCNT]	;IF OUTPUT BUFFER NOT FULL
	CMP	SI,[BX.FIFOOMX]
	JZ	SCCGRG2
	OR	AL,TXBRDY		;FLAG BUFFER RDY
SCCGRG2:
	MOV	AH,0FFH
	XOR	DX,DX
	CMP	WORD PTR[BX.FIFOERR],DX	;IF ERROR PENDING
	JZ	SCCGRG3
	STC
	XCHG	WORD PTR[BX.FIFOERR],DX	;GET,CLR ERROR STATUS
	MOV	AH,DL			;STORE STD ERROR CODE
SCCGRG3:
	RET
SCCGRG	ENDP
;
;
PRNTGRG	PROC	FAR			;GET PRINTER STATUS
	MOV	DX,SYSSTAT		;GET PRINTER STATUS
	IN	AX,DX
	AND	AX,1 SHL PRBUSY		;IF PRINTER NOT BUSY
	JNZ	PRNTGRG1
	OR	AL,TXRDY		;FLAG RDY
PRNTGRG1:
	OR	AL,CTS			;TO BE COMPATIBLE WITH MODEM
	JMP	SHORT SCCGRG		;GET BUFFER,ERROR STATUS
PRNTGRG	ENDP
;
;
;
CSCCGSTA PROC	FAR
	MOV	BX,[BX]
	CMP	[BX.FIFOPORT],0		;IF KVD DEVICE
	JZ	FIFOGSTA
SCCGSTA	PROC	FAR			;GET STATUS INPUT PORT
	CALL	ENIN
FIFOGSTA PROC	FAR
	CMP	[BX.FIFOICNT],0
	MOV	AH,NOTRDY
	STC
	JZ	SCCBGST1		;FIFO EMPTY
	MOV	SI,[BX.FIFOIPTO]	;ELSE GET CHARACTER
	MOV	AL,[SI]
	CLC
SCCBGST1:
	RET
FIFOGSTA ENDP
SCCGSTA	ENDP
CSCCGSTA ENDP
;
;
;	HARDWARE RESET FOR SCC ,RESET FOR SCCB
;
;ENTRY:
;	IF AL = FF THEN HDW RESET OF SCC WILL BE PERFORMED
;	AND THE INTERUPT HANDLER WILL BE INITIALISED
;
;	OTHERWISE OR AFTERWARDS SCC CHANNEL B WILL BE INITIALISED
;
;
;
;
SCCBRST	PROC	FAR
	INC	AL
	JNZ	SCCBRST1
	PUSH	DX
	MOV	DX,SCCPORT+4
	MOV	AL,9
	OUT	DX,AL
	MOV	AL,0C0H
	OUT	DX,AL
	MOV	WORD PTR CHARIOSW,OFFSET PGROUP:CHARIO;ENABLE IO
	MOV	WORD PTR [CHARIOSW+2],PGROUP
	POP	DX
	MOV	AX,OFFSET PGROUP:SCCBRT
	PUSH	DI
	PUSH	ES
	MOV	DI,AX
	CALL	IDAT			;INIT FIFOS
	POP	ES
	POP	DI
	MOV	AX,ES			;IF NO TABLE PRESENT
	OR	AX,DI
	JNZ	SCCBRST1
	MOV	ES,PGRP
	MOV	DI,OFFSET PGROUP:SCCBTB
SCCBRST1:
	CALL	SCCINIT
	CALL	FLUSHO			;FLUSH BUFFERS
	XOR	AH,AH
	CALL	FLUSHI
	MOV	DX,FIFOSE		;LENGTH DATA AREA
	CLC
	RET
SCCBRST	ENDP
;
;
SCCARST	PROC	FAR
	INC	AL
	JNZ	SCCARST1
	MOV	AX,OFFSET PGROUP:SCCART
	PUSH	DI
	PUSH	ES
	MOV	DI,AX
	CALL	IDAT			;INIT FIFOS
	POP	ES
	POP	DI
	MOV	AX,ES			;IF NO TABLE PRESENT
	OR	AX,DI
	JNZ	SCCARST1
	MOV	ES,PGRP
	MOV	DI,OFFSET PGROUP:SCCATB
SCCARST1:
	CALL	SCCINIT
	CALL	FLUSHO			;FLUSH BUFFERS
	XOR	AH,AH
	CALL	FLUSHI
	MOV	DX,FIFOSE		;LENGTH DATA AREA
	CLC
	RET
SCCARST	ENDP
;
;
;
;	PRNT	SET STATUS
;
;
;
SELSTB	PROC	FAR
	JZ	SELSTBF			;SEL FAST DATA STROBE
	OR	[BX.FIFOFLGS],SLOWSTB	;ELSE SLOW
	RET
SELSTBF:
	AND	[BX.FIFOFLGS],NOT SLOWSTB
	RET
SELSTB	ENDP
;
;
PRNTTTR:
	DB	PRNTMAX
	DW	OFFSET PGROUP:WRAHATB
	DW	OFFSET PGROUP:DISEN
	DW	OFFSET PGROUP:SETOWT
	DW	OFFSET PGROUP:SETOTASK
	DW	OFFSET PGROUP:SELSTB
PRNTMAX	EQU	$-PRNTTTR-3
;
;
PRNTSSTA PROC	FAR			;INIT PARAMETERS PRNT
	MOV	SI,OFFSET PGROUP:PRNTTTR
	JMP	GIFJMP
PRNTSSTA ENDP
;
;
PRNTRST	PROC	FAR			;RESET,INIT PRNT
	MOV	DI,OFFSET PGROUP:PRNTRT
	CALL	IDAT			;INIT FIFOS
	MOV	DX,DATASTB		;DESACTIVATE DATASTROBE
	MOV	AL,1
	OUT	DX,AL
	CALL	FLUSHO			;FLUSH BUFFERS
	MOV	DX,FIFOPORT		;LENGTH DATA AREA
	RET
PRNTRST	ENDP
;
;
;
;
;	GENERAL PURPOSE FIFO WRITE
;
;
PUTIFI	PROC	FAR
	MOV	SI,[BX.FIFOICNT]	;IF FIFO FULL
	CMP	SI,[BX.FIFOIMX]
	JB	PUTIFI0
	STC
	RET				;FLAG FULL,EXIT
PUTIFI0:
	CALL	PUTIFI1			;ELSE STORE CHARACTER
	OR	AL,AL
	RET
PUTIFI	ENDP

PLSEL	PROC	FAR
	MOV	SI,[ATB.PRTDEVA]	;INIT FOR PAR PRINTER
	MOV	WORD PTR[BX+6],OFFSET PGROUP:PRNTGRG
	JZ	PLSEL1
	MOV	WORD PTR[BX+6],OFFSET PGROUP:SCCGRG
	MOV	SI,[ATB.DCEDEVA]	;ELSE FOR SER PRINTER (DCE]
	TEST	AL,2			;IF NOT DTE
	JZ	PLSEL1
	MOV	SI,[ATB.DTEDEVA]	;ELSE FOR SER PRINTER (DTE]
PLSEL1:
	MOV	[BX],SI			;STORE POINTER TO DATA AREA
	MOV	[SI.FIFOCHNL],AL	;STORE NUMBER OF CHANNEL
	RET
PLSEL	ENDP
;
;
;	RESET SYSTEM  PRINTER
;
PLRST	PROC	FAR
	MOV	BX,DX
	XOR	AX,AX
	CALL	PLSEL			;SET TO PARALLEL PRINTER CHANNEL
	MOV	WORD PTR[BX+2],OFFSET PGROUP:FIFOOI;INIT POINTERS
	MOV	WORD PTR[BX+4],OFFSET PGROUP:FLUSHO;OUTPUT,FLUSH ROUT
	CLC
	MOV	DX,8
	RET
PLRST	ENDP
;
;
;
;
PLATTR:
	DB	0
	DW	OFFSET PGROUP:PLSEL
;
;
PLSSTA	PROC	FAR			;SET STATUS SYSTEM PRINTER
	TEST	DL,80H			;IF LOCAL FUNCTION
	JNZ	PLSSTA1			;EXECUTE
	MOV	BX,[BX]			;POINT TO DATA AREA
	MOV	SI,OFFSET PGROUP:PRNTTTR ;ELSE EXECUTE DRIVER SPECIFIC 
	CMP	[BX.FIFOCHNL],0		;SETUP ROUTINE 
	JZ	PLSSTA2			;FOR PARALLEL PRINTER
	MOV	SI,OFFSET PGROUP:SCCATTR ;OR FOR SERIAL CHANNELS
PLSSTA1:
	MOV	SI,OFFSET PGROUP:PLATTR
PLSSTA2:
	JMP	GIFJMP
PLSSTA	ENDP
;
;
CLSEL	PROC	FAR			;CONSOLE SELECT 
	AND	AL,AL			;IF KVD SELECT
	JZ	CLSEL1			;INIT FOR KVD
	MOV	WORD PTR[BX+2],OFFSET PGROUP:FIFOOI;ELSE INIT FOR DTE,DCE
	MOV	WORD PTR[BX+4],OFFSET PGROUP:FLUSHO
	MOV	WORD PTR[BX+6],OFFSET PGROUP:SCCGRG
	MOV	SI,[ATB.DCEDEVA]
	TEST	AL,1			;IF DCE
	JNZ	CLSEL2			;SET ADRS DATA AREA
	MOV	SI,[ATB.DTEDEVA]	;ELSE FOR DTE
	JMP	SHORT CLSEL2
CLSEL1:
	MOV	WORD PTR[BX+2],OFFSET PGROUP:VDWRITE;INIT FOR VIDEO
	MOV	WORD PTR[BX+6],OFFSET PGROUP:KVDGSTR
	MOV	WORD PTR[BX+4],OFFSET PGROUP:FRETF
	MOV	SI,[ATB.KVDDEVA]
CLSEL2:
	MOV	[BX],SI
	MOV	[SI.FIFOCHNL],AL	;STORE NUMBER OF CHANNEL
	RET
CLSEL	ENDP
;
;
;
;	RESET SYSTEM,DEBUGGER CONSOLE
;
CLRST	PROC	FAR
	MOV	BX,DX
	XOR	AX,AX
	CALL	CLSEL			;SET TO VIDEO CHANNEL
	CLC
	MOV	DX,8			;8 BYTES DATA AREA
	RET
CLRST	ENDP
;
;
CLWRITE	PROC	FAR			;CONSOLE WRITE
	MOV	SI,BX
	MOV	BX,[BX]			;RELOAD BX WITH DRIVER DATA AREA
	JMP	[SI+2]
CLWRITE	ENDP
;
;
CLOFLUSH PROC	FAR			;CONSOLE OUTPUT FLUSH
	MOV	SI,BX
	MOV	BX,[BX]
	JMP	[SI+4]
CLOFLUSH ENDP
;
;
CLATTR:
	DB	0
	DW	OFFSET PGROUP:CLSEL
;
;
CLSSTA	PROC	FAR			;SET STATUS SYSTEM CONSOLE
	TEST	DL,80H			;IF LOCAL FUNCTION
	JNZ	CLSSTA1			;EXECUTE
	MOV	BX,[BX]			;POINT TO DATA AREA
	MOV	SI,OFFSET PGROUP:KVDATTR ;ELSE EXECUTE DRIVER SPECIFIC 
	CMP	[BX.FIFOCHNL],0		;SETUP ROUTINE 
	JZ	CLSSTA2			;FOR PARALLEL PRINTER
	MOV	SI,OFFSET PGROUP:SCCATTR ;OR FOR SERIAL CHANNELS
CLSSTA1:
	MOV	SI,OFFSET PGROUP:CLATTR
CLSSTA2:
	JMP	GIFJMP
CLSSTA	ENDP
;
;
CLGRG	PROC	FAR			;GET DEVICE STATUS REGISTER
	MOV	SI,BX
	MOV	BX,[BX]
	PUSHI	PGROUP
	PUSHI	<OFFSET PGROUP:CLGRG1>
	JMP	[SI+6]
CLGRG1:
	MOV	BL,[BX.FIFOCHNL]	;GET CHANNEL NUMBER
	RET
CLGRG	ENDP

	PUBLIC	CHARTAB
CHARTAB:
;	DCE SCCB (2)
;
	DW	2*64+8			;DEV 2,8 CALLS
	DW	OFFSET PGROUP:SCCBRST
	DW	OFFSET PGROUP:SCCGRG
	DW	OFFSET PGROUP:SCCGSTA
	DW	OFFSET PGROUP:SCCSSTA
	DW	OFFSET PGROUP:SCCFIO
	DW	OFFSET PGROUP:FIFOOI
	DW	OFFSET PGROUP:FLUSHI
	DW	OFFSET PGROUP:FLUSHO
;
;	DTE SCCA (4)
;
	DW	4*64+8			;DEV 4,8 CALLS
	DW	OFFSET PGROUP:SCCARST
	DW	OFFSET PGROUP:SCCGRG
	DW	OFFSET PGROUP:SCCGSTA
	DW	OFFSET PGROUP:SCCSSTA
	DW	OFFSET PGROUP:SCCFIO
	DW	OFFSET PGROUP:FIFOOI
	DW	OFFSET PGROUP:FLUSHI
	DW	OFFSET PGROUP:FLUSHO
;
;	PARALLEL PRINTER (6)
;
	DW	6*64+8			;DEV 6,8 CALLS
	DW	OFFSET PGROUP:PRNTRST
	DW	OFFSET PGROUP:PRNTGRG
	DW	0FFFFH
	DW	OFFSET PGROUP:PRNTSSTA
	DW	0FFFFH
	DW	OFFSET PGROUP:FIFOOI
	DW	0FFFFH
	DW	OFFSET PGROUP:FLUSHO
;
;	LOGICAL PRINT DEVICE (10) DTE/PRT
;
	DW	10*64+8			;DEV 10,8 CALLS
	DW	OFFSET PGROUP:PLRST
	DW	OFFSET PGROUP:CLGRG
	DW	0FFFFH
	DW	OFFSET PGROUP:PLSSTA
	DW	0FFFFH
	DW	OFFSET PGROUP:CLWRITE
	DW	0FFFFH
	DW	OFFSET PGROUP:CLOFLUSH
;
;	SYSTEM CONSOLE (11) DCE/DTE/KVD
;
	DW	11*64+8			;DEV 11,8 CALLS
	DW	OFFSET PGROUP:CLRST
	DW	OFFSET PGROUP:CLGRG
	DW	OFFSET PGROUP:CSCCGSTA
	DW	OFFSET PGROUP:CLSSTA
	DW	OFFSET PGROUP:CFIFOIO
	DW	OFFSET PGROUP:CLWRITE
	DW	OFFSET PGROUP:CFLUSHI
	DW	OFFSET PGROUP:CLOFLUSH
;
;	DEBUGGER CONSOLE (12) DCE/DTE/KVD
;
	DW	12*64+8			;DEV 12,8 CALLS
	DW	OFFSET PGROUP:CLRST
	DW	OFFSET PGROUP:CLGRG
	DW	OFFSET PGROUP:CSCCGSTA
	DW	OFFSET PGROUP:CLSSTA
	DW	OFFSET PGROUP:CFIFOIO
	DW	OFFSET PGROUP:CLWRITE
	DW	OFFSET PGROUP:CFLUSHI
	DW	OFFSET PGROUP:CLOFLUSH
;
;	SYSTEM AUXILLERY (13) DCE/DTE/KVD
;
	DW	13*64+8			;DEV 13,8 CALLS
	DW	OFFSET PGROUP:CLRST
	DW	OFFSET PGROUP:CLGRG
	DW	OFFSET PGROUP:CSCCGSTA
	DW	OFFSET PGROUP:CLSSTA
	DW	OFFSET PGROUP:CFIFOIO
	DW	OFFSET PGROUP:CLWRITE
	DW	OFFSET PGROUP:CFLUSHI
	DW	OFFSET PGROUP:CLOFLUSH
	DW	0FFFFH
;
;
sccatb	db	SCCATE,9,80H,9,0,4,44h,3,0E0h,11,56h,12,10,13,0,14,1,5,68h
	db	15,0
sccate	equ	($-sccatb-1)/2
;
sccbtb	db	SCCBTE,9,40h,9,0,4,44h,3,0E0h,11,0d4h,12,10,13,0,14,1,5,068H
	db	15,0
sccbte	equ	($-sccbtb-1)/2
;
SCCBBS:
	DB	SCCBBSE,3,0E1H,5,0E8H
SCCBBSE	EQU	($-SCCBBS-1)/2
;
SCCAS:
	DB	SCCASE,3,0E1H,5,0E8H
SCCASE	EQU	($-SCCAS-1)/2
;
;
BITS:
	DB	3,83H,3FH,40H,85H,9FH,20H;7BITS,1STOP
	DB	84H,0F3H,4
BITSL	EQU	$-BITS
	DB	3,83H,3FH,40H,85H,9FH,20H;7BITS,2STOP
	DB	84H,0F3H,0CH
	db	3,83h,03FH,0C0H,85H,9FH,60H;8BITS,1STOP
	DB	84H,0F3H,4
	db	3,83h,03FH,0C0H,85H,9FH,60H;8BITS,2STOP
	DB	84H,0F3H,0CH
NOPAR:
	DB	2,81H,0FBH,0,84H,0FEH,0	;DIS PARITY
ODDPAR:
	DB	3,81H,0FBH,4,84H,0FEH,1	;ODD PARITY
	DB	84H,0FDH,0
EVPAR:
	DB	3,81H,0FBH,4,84H,0FEH,1	;EVEN PARITY
	DB	84H,0FDH,2
;
;
BAUDT:
BMAC	MACRO	CONST
	DB	2,12
	DB	CONST AND 0FFH		;LOWER CONST
	DB	13
	DB	CONST SHR 8
	ENDM

	BMAC	1045			;110
BAUDL	EQU	$-BAUDT
	BMAC	382			;300
	BMAC	190			;600
	BMAC	94			;1200
	BMAC	46			;2400
	BMAC	22			;4800
	BMAC	10			;9600
	BMAC	4			;19200
;
;
SCCBRT:
	DW	(SCCBRTE-SCCBRT)/2
	DW	ALLBX,0,FIFOSE
	DW	OFFSET DGROUP:SCCBOFIS
	DW	OFFSET DGROUP:SCCBOFIS
	DW	0
	DW	BUFFSIZE
	DD	FIFOOI2
	DD	FRETF
	DD	FRETF
	DW	OFFSET DGROUP:SCCBOFIS
	DW	OFFSET DGROUP:SCCBOFIE
	DB	0,0,0,0
	DB	OUTEN,0
	DW	SCCPORT
	DW	OFFSET DGROUP:SCCBIFIS
	DW	OFFSET DGROUP:SCCBIFIS
	DW	0
	DW	BUFFSIZE
	DD	FIFOIO2
	DD	FRETF
	DD	FRETF
	DW	OFFSET DGROUP:SCCBIFIS
	DW	OFFSET DGROUP:SCCBIFIE
	DW	BUFFSIZE-10
	DW	BUFFSIZE-10
	DD	FRETF
	DW	OFFSET DGROUP:SCCBR
SCCBRTE:
SCCART:
	DW	(SCCARTE-SCCART)/2
	DW	ALLBX,0,FIFOSE
	DW	OFFSET DGROUP:SCCAOFIS
	DW	OFFSET DGROUP:SCCAOFIS
	DW	0
	DW	BUFFSIZE
	DD	FIFOOI2
	DD	FRETF
	DD	FRETF
	DW	OFFSET DGROUP:SCCAOFIS
	DW	OFFSET DGROUP:SCCAOFIE
	DB	0,0,0,0
	DB	OUTEN,0
	DW	SCCPORT+4
	DW	OFFSET DGROUP:SCCAIFIS
	DW	OFFSET DGROUP:SCCAIFIS
	DW	0
	DW	BUFFSIZE
	DD	FIFOIO2
	DD	FRETF
	DD	FRETF
	DW	OFFSET DGROUP:SCCAIFIS
	DW	OFFSET DGROUP:SCCAIFIE
	DW	BUFFSIZE-10
	DW	BUFFSIZE-10
	DD	FRETF
	DW	OFFSET DGROUP:SCCAR
SCCARTE:
PRNTRT:
	DW	(PRNTRTE-PRNTRT)/2
	DW	ALLBX,0,FIFOPORT
	DW	OFFSET DGROUP:PRNTOFIS
	DW	OFFSET DGROUP:PRNTOFIS
	DW	0
	DW	BUFFSIZE
	DD	FIFOOI2
	DD	FRETF
	DD	FRETF
	DW	OFFSET DGROUP:PRNTOFIS
	DW	OFFSET DGROUP:PRNTOFIE
	DW	0,0,0
PRNTRTE:
PROG	ENDS
;
	END
