	page	60,132
; TEST PROGRAM FOR BOOT ROM BY WALTER CHAN
; 1 : CHECKSUM OF ROM LOCAION FROM ROMBOT TO ROMTOP
romtop	equ	0ffffh
rombot	equ	0f800h
romsz	equ	4000h		; in word size
nmipot	equ	0e196h		; nmi enable if 1
vidatr	equ	0e180h		; video attribute port
nmiovl	equ	8		; nmi vector number 2
nmiovh	equ	0ah		; nmi vector segment
;
DGROUP	GROUP	DATA
PGROUP	GROUP	PROG
PROG	SEGMENT	BYTE PUBLIC 'PROG'
	ASSUME	DS:DGROUP
	ASSUME	CS:PGROUP
	EXTRN	DATSEG:WORD
start:
	mov	ds,cs:datseg
	cmp	word ptr ntst,055aah
	jnz	test
	jmp	sysini
test:
      	mov	ax,rombot
	mov	ds,ax		; init data segment
	mov	cx,romsz	; get rom size into counter
	mov	ax,0
	mov	bx,ax
sum:	add	ax,[bx]		; add up all data
	add	bx,2
	loop	sum
	cmp	ax,0
	jz	nmi
	mov	bl,ckserr	; chksum error code
	cmp	word ptr cs:chksfg,055aah ;if checksum is not valid
	jz	genchs
	jmp	dsperr
genchs:
	sub	ax,055a9h	; else generate checksum
	neg	ax
	mov	ss,ax		; save checksum
nmi:	mov	ax,0
	mov	ds,ax		; init data segment
	mov	ax, offset nmioff ; get nmi handler offset
	mov	ds:nmiovl,ax	; write to nmi vector
	mov	ax,prog
	mov	ds:nmiovh,ax
	jmp	short nmi1
nmioff:	mov	bl,parerr	; load parity error code
	jmp	dsperr
nmi1:	mov	dx,nmipot	; load nmi enable port
	mov	ax,1
	out	dx,ax		; enable nmi
	mov	dx,vidatr	; load video attribute port
	mov	ax,0
	out	dx,ax
; RAMTEST FROM 0:0 TO 2000:0[-1] / 4000:0[-1]
; 128K RAM : SP=2 --- 256KRAM : SP=4
pat1	equ	5555h
pat2	equ	0aaaah
k128	equ	0		; 128k start segment addr.
k256	equ	2000h		; 256k start segment addr.
segsz	equ	8000h		; segment size in word count
segpag	equ	1000h		; segment page increment
;
	mov	ax,k128
	mov	ds,ax		; init data segment
	mov	ax,pat1		; load test pattern1
	mov	bx,0
	mov	[bx],ax		; write pat1 into 0:0
	mov	dx,k256
	mov	ds,dx		; ds: point to xram
	not	ax
	mov	[bx],ax		; write pat2 into xram 2000:0
	mov	ax,k128
	mov	ds,ax
	mov	ax,[bx]		; read from 0:0
	mov	bx,4		; count for 4 segments
	cmp	ax,pat1		; if ax=pat1 then xram present
	jz	rwrt2
	cmp	ax,pat2		; if ax=pat2 then xram absent
	jz	rwrt1
	mov	bl,ramerr	; otherwise ram error
	jmp	dsperr
; to write 55 or aa into ram depent on parity
rwrt1:	shr	bl,1		; 2 segment-page since no xram
rwrt2:	mov	sp,bx		; save segment-page into sp
	xor	di,di
	mov	es,di		; init. es
rwrt:	mov	cx,segsz	; load segment size
rwrt3:	inc	di
	dec	di		; to get the parity flag
	mov	ax,pat1
	jp	rwrt4
	not	ax
rwrt4:	stosw			; write test pattern into ram
	loop	rwrt3		; loop for a segment-page [64k]
	mov	ax,es
	add	ax,segpag
	mov	es,ax		; update es: to a new page
	dec	bl
	jnz	rwrt		; repeat for 2 or 4 seg-page
; check the ram and write the complement back
	mov	bp,1		; switch for check and recheck
rrchk:	mov	es,di		; init. es:
	mov	bx,sp		; load the seg-page count
rchk:	mov	cx,segsz
rchk1:	inc	di
	dec	di		; to get the parity flag
	mov	ax,pat1
	jnp	rchk5
	not	ax
rchk5:	test	bp,1		; test for check=1 or recheck=0
	jz	rrchk2		; recheck if bp=0
rchk2:	not	word ptr es:[di] ; complement the memory
	xor	ax,es:[di]
	jz	rchk3		; if ax=es:di then memory ok
	jmp	short rchk4
rrchk2:	mov	dx,es:[di]	; load pattern from ram
	xor	es:[di],dx	; clear ram
	xor	ax,dx
	jz	rchk3
rchk4:	mov	bl,ramerr	; load ram error code
	jmp	dsperr
rchk3:	add	di,2
	loop	rchk1		; loop for 1 seg-page [64k]
	mov	ax,es
	add	ax,segpag	; update seg-page
	mov	es,ax
	dec	bl
	jnz	rchk		; repeat for 2 or 4 seg-page
	dec	bp		; bp=1 check ram --- bp=0 recheck
	jz	rrchk
	extrn	sysini:near
	jmp	sysini

; display error routine
; led port : 0e19eh , on when low
; checksum error : bl = 0ch L-L-S-S
; parity error   : bl = 0eh L-L-L-S
; ram data error : bl = 0ah L-S-L-S
led	equ	0e19eh
ckserr	equ	0ch
parerr	equ	0eh
ramerr	equ	0ah
;
dsperr:
	mov	dx,led
dsp1:	mov	cx,4
	mov	bh,bl
dsp2:	ror	bh,1
	push	cx
	mov	cx,8		; long delay time = 8
	jc	dsp3		; short delay for nc
	mov	cx,2		; short delay time = 2
dsp3:	mov	ax,0
	out	dx,ax		; turn-on led
delay1:	push	cx
	mov	cx,romtop	; get ffff
delay2:	loop	delay2		; delay loop
	pop	cx
	loop	delay1
	mov	ax,1
	out	dx,ax		; turn off led
	mov	ax,4
	mov	cx,romtop
delay3:	loop	delay3		; delay between on-off period
	dec	ax
	jnz	delay3
	pop	cx
	loop	dsp2		; count for 4 period
	jmp	dsp1		; countless loop
chksum:	dw	0ffffh		; dummy word for 2's complement
chksfg	dw	055aah		; checksum valid flag if <> 55aah
	public	tflg
tflg	db	0
prog	ends
DATA	SEGMENT	WORD PUBLIC 'DATA'
	ASSUME	DS:DGROUP
	public	ntst
NTST	DW	?
DATA	ENDS
;
end	start
