/*	Convergent Technologies - System V - Oct 1984	*/
/*	"@(#)ocurse.h	1.1"	*/

/* 4/17/81 (Berkeley) @(#)curses.h	1.7 */
# ifndef WINDOW

# include	<stdio.h>
 
# include	<termio.h>

# define	bool	char
# define	reg	register

# define	ERR	(0)
# define	OK	(1)
# define	TRUE	(1)
# define	FALSE	(0)

# define	_SUBWIN		01
# define	_ENDLINE	02
# define	_FULLWIN	04
# define	_SCROLLWIN	010
# define	_FLUSH		020
# define	_STANDOUT	0200
# define	_NOCHANGE	-1

# define	_puts(s)	tputs(s, 0, _putchar);

typedef struct termio	TERMIO;

/*
 * Capabilities from termcap
 */

extern bool     AM, BS, CA, DA, DB, EO, GT, HZ, IN, MI, MS, NC, OS, UL,
		XN;
extern char     *AL, *BC, *BT, *CD, *CE, *CL, *CM, *DC, *DL, *DM, *DO,
		*ED, *EI, *HO, *IC, *IM, *IP, *LL, *MA, *ND, *SE, *SF,
		*SO, *SR, *TA, *TE, *TI, *UC, *UE, *UP, *US, *VB, *VE,
		*VS, PC;
#ifdef GRAPHICS
extern char	*AS, *AE;
extern char	*TL, *TR, *LT, *RT, *BL, *BR, *VR, *HR, *BB;
extern char	*NTL,*NTR,*NLT,*NRT,*NBL,*NBR,*NVR,*NHR,
			*KTL,*KTR,*KLT,*KRT,*KBL,*KBR,*KVR,*KHR;

/*
 *	Box types.
 */
#define	BOXOLD		0	/* as in box() */
#define BOXNSIM		0x01	/* thin line simple box */
#define BOXKSIM		0x11	/* thick line simple box */
#define BOXNHD		0x02	/* thin line headed box */
#define BOXKHD		0x12	/* thick line headed box */
#define BOXNBLOB	0x03	/* thin line headed box with highlight */
#define BOXKBLOB	0x13	/* thick line headed box with highlight */

/*
 *	Special characters for box edges.
 *	Before outputting this character, switch to alternate char set,
 *	and use appropriate graphics character.
 */
#define BETLC		0x00	/* tl/TL: top left corner */
#define BETRC		0x01	/* tr/TR: top right corner */
#define BELTE		0x02	/* lt/LT: left edge T */
#define BERTE		0x03	/* rt/RT: right edge T */
#define BEBLC		0x04	/* bl/BL: bottom left corner */
#define BEBRC		0x05	/* br/BR: bottom right corner */
#define BEVER		0x06	/* vr/VR: vertical line */
#define BEHOR		0x07	/* hr/HR: horizontal line */
#define BEBLOB		0x08	/* bb   : blob */
#define BEMAX		BEBLOB	/* largest special character for boxes */
#endif

/*
 * From the tty modes...
 */

extern bool	NONL, UPPERCASE, normtty, _pfast;

struct _win_st {
	short	_cury, _curx;
	short	_maxy, _maxx;
	short	_begy, _begx;
	short	_flags;
#ifdef GRAPHICS
	short	_boxtyp;
#endif
	bool	_clear;
	bool	_leave;
	bool	_scroll;
	char	**_y;
	short	*_firstch;
	short	*_lastch;
};

# define	WINDOW	struct _win_st

extern bool	My_term, _echoit, _rawmode, _endwin;

extern char	*Def_term, ttytype[];

extern int	LINES, COLS, _tty_ch;

extern TERMIO	_tty, _stty;

extern WINDOW	*stdscr, *curscr;

/*
 *	Define VOID to stop lint from generating "null effect"
 * comments.
 */
# ifdef lint
int	__void__;
# define	VOID(x)	(__void__ = (int) (x))
# else
#ifndef VOID
# define	VOID(x)	(x)
# endif
# endif

/*
 * psuedo functions for standard screen
 */
# define	addch(ch)	VOID(waddch(stdscr, ch))
# define	getch()		VOID(wgetch(stdscr))
# define	addstr(str)	VOID(waddstr(stdscr, str))
# define	getstr(str)	VOID(wgetstr(stdscr, str))
# define	move(y, x)	VOID(wmove(stdscr, y, x))
# define	clear()		VOID(wclear(stdscr))
# define	erase()		VOID(werase(stdscr))
# define	clrtobot()	VOID(wclrtobot(stdscr))
# define	clrtoeol()	VOID(wclrtoeol(stdscr))
# define	insertln()	VOID(winsertln(stdscr))
# define	deleteln()	VOID(wdeleteln(stdscr))
# define	refresh()	VOID(wrefresh(stdscr))
# define	inch()		VOID(winch(stdscr))
# define	insch(c)	VOID(winsch(stdscr,c))
# define	delch()		VOID(wdelch(stdscr))
# define	standout()	VOID(wstandout(stdscr))
# define	standend()	VOID(wstandend(stdscr))

/*
 * mv functions
 */
#define	mvwaddch(win,y,x,ch)	VOID(wmove(win,y,x)==ERR?ERR:waddch(win,ch))
#define	mvwgetch(win,y,x)	VOID(wmove(win,y,x)==ERR?ERR:wgetch(win))
#define	mvwaddstr(win,y,x,str)	VOID(wmove(win,y,x)==ERR?ERR:waddstr(win,str))
#define	mvwgetstr(win,y,x)	VOID(wmove(win,y,x)==ERR?ERR:wgetstr(win))
#define	mvwinch(win,y,x)	VOID(wmove(win,y,x) == ERR ? ERR : winch(win))
#define	mvwdelch(win,y,x)	VOID(wmove(win,y,x) == ERR ? ERR : wdelch(win))
#define	mvwinsch(win,y,x,c)	VOID(wmove(win,y,x) == ERR ? ERR:winsch(win,c))
#define	mvaddch(y,x,ch)		mvwaddch(stdscr,y,x,ch)
#define	mvgetch(y,x)		mvwgetch(stdscr,y,x)
#define	mvaddstr(y,x,str)	mvwaddstr(stdscr,y,x,str)
#define	mvgetstr(y,x)		mvwgetstr(stdscr,y,x)
#define	mvinch(y,x)		mvwinch(stdscr,y,x)
#define	mvdelch(y,x)		mvwdelch(stdscr,y,x)
#define	mvinsch(y,x,c)		mvwinsch(stdscr,y,x,c)

/*
 * psuedo functions
 */

#define	clearok(win,bf)	 (win->_clear = bf)
#define	leaveok(win,bf)	 (win->_leave = bf)
#define	scrollok(win,bf) (win->_scroll = bf)
#define flushok(win,bf)	 (bf ? (win->_flags |= _FLUSH):(win->_flags &= ~_FLUSH))
#define	getyx(win,y,x)	 y = win->_cury, x = win->_curx
#define	winch(win)	 (win->_y[win->_cury][win->_curx])

#define raw()	 (_tty.c_cc[VMIN]=1, _tty.c_cc[VTIME]=0, _tty.c_oflag &= ~OPOST,_tty.c_lflag &= ~(ICANON|ISIG), _pfast=_rawmode=TRUE, ioctl(_tty_ch,TCSETA,&_tty))
#define noraw()	 (_tty.c_cc[VEOF]=CEOF, _tty.c_cc[VEOL]=CNUL,_tty.c_oflag |= OPOST,_tty.c_lflag|=ICANON|ISIG,_rawmode=FALSE,_pfast=FALSE,ioctl(_tty_ch,TCSETA,&_tty))
#define crmode() (_tty.c_cc[VMIN]=1, _tty.c_cc[VTIME]=0,_tty.c_lflag &= ~ICANON, _rawmode = TRUE, ioctl(_tty_ch,TCSETA,&_tty))
#define nocrmode() (_tty.c_cc[VEOF]=CEOF, _tty.c_cc[VEOL]=CNUL,_tty.c_lflag |= ICANON, _rawmode = FALSE, ioctl(_tty_ch,TCSETA,&_tty))
#define echo()	 (_tty.c_lflag |= ECHO, _echoit = TRUE, ioctl(_tty_ch, TCSETA, &_tty))
#define noecho() (_tty.c_lflag &= ~ECHO, _echoit = FALSE, ioctl(_tty_ch, TCSETA, &_tty))
#define nl()	 (_tty.c_iflag |= ICRNL,_tty.c_oflag |= (ONLCR|OCRNL),_pfast = _rawmode,ioctl(_tty_ch, TCSETA, &_tty))
#define nonl()	 (_tty.c_iflag &= ~ICRNL,_tty.c_oflag &= ~(ONLCR|OCRNL), _pfast = TRUE, ioctl(_tty_ch, TCSETA, &_tty))
#define	savetty() (ioctl (_tty_ch, TCGETA, &_tty), _stty = _tty)
#define	resetty() (_tty = _stty, ioctl(_tty_ch, TCSETA, &_tty))

WINDOW	*initscr(), *newwin(), *subwin();
char	*longname();

# endif
