/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)cmap.h	1.3"	*/

#ifndef cmap_h
#define cmap_h

/*
 * core map entry
 */
struct cmap
{
unsigned int 	c_next:12,	/* index of next free list entry */
		c_prev:12,	/* index of previous free list entry */
		c_lock:1,	/* locked for raw i/o or pagein */
		c_want:1,	/* wanted */
		c_intrans:1,	/* intransit bit */
		c_free:1,	/* on the free list */
		c_gone:1,	/* associated page has been released */
		c_type:3,	/* type CSYS or CTEXT or CSTACK or CDATA */
		c_page:12,	/* virtual page number in segment */
		c_pgacc:2,	/* access status of the physical page */
		c_ndx:10,	/* if valid, has index of owner proc or text */
		c_reserved:8;	/* rounds sizeof(struct cmap) to 8 bytes */
};

#define	CMHEAD	0

extern struct	cmap *cmap;
extern struct	cmap *ecmap;
extern int	ncmap;
extern int	firstfree, maxfree;
extern int	ecmx;			/* cmap index of ecmap */

/* bits defined in c_type */

#define	CSYS		0		/* none of below */
#define	CTEXT		1		/* belongs to shared text segment */
#define	CDATA		2		/* belongs to data segment */
#define	CSTACK		3		/* belongs to stack segment */

#define	pgtocm(x)	((short)((x) - firstfree + 1))
#define	cmtopg(x)	((x) -1 + firstfree)
#endif
