/*	Convergent Technologies - System V - May 1983	*/
/*	"@(#)errno.h	1.4"	*/

/*
 * Error codes
 */

#define	EPERM	1	/* Not super-user			*/
#define	ENOENT	2	/* No such file or directory		*/
#define	ESRCH	3	/* No such process			*/
#define	EINTR	4	/* interrupted system call		*/
#define	EIO	5	/* I/O error				*/
#define	ENXIO	6	/* No such device or address		*/
#define	E2BIG	7	/* Arg list too long			*/
#define	ENOEXEC	8	/* Exec format error			*/
#define	EBADF	9	/* Bad file number			*/
#define	ECHILD	10	/* No children				*/
#define	EAGAIN	11	/* No more processes			*/
#define	ENOMEM	12	/* Not enough core			*/
#define	EACCES	13	/* Permission denied			*/
#define	EFAULT	14	/* Bad address				*/
#define	ENOTBLK	15	/* Block device required		*/
#define	EBUSY	16	/* Mount device busy			*/
#define	EEXIST	17	/* File exists				*/
#define	EXDEV	18	/* Cross-device link			*/
#define	ENODEV	19	/* No such device			*/
#define	ENOTDIR	20	/* Not a directory			*/
#define	EISDIR	21	/* Is a directory			*/
#define	EINVAL	22	/* Invalid argument			*/
#define	ENFILE	23	/* File table overflow			*/
#define	EMFILE	24	/* Too many open files			*/
#define	ENOTTY	25	/* Not a typewriter			*/
#define	ETXTBSY	26	/* Text file busy			*/
#define	EFBIG	27	/* File too large			*/
#define	ENOSPC	28	/* No space left on device		*/
#define	ESPIPE	29	/* Illegal seek				*/
#define	EROFS	30	/* Read only file system		*/
#define	EMLINK	31	/* Too many links			*/
#define	EPIPE	32	/* Broken pipe				*/
#define	EDOM	33	/* Math arg out of domain of func	*/
#define	ERANGE	34	/* Math result not representable	*/
#define	ENOMSG	35	/* No message of desired type		*/
#define	EIDRM	36	/* Identifier removed			*/
#define	ECHRNG	37	/* Channel number out of range		*/
#define	EL2NSYNC 38	/* Level 2 not synchronized		*/
#define	EL3HLT	39	/* Level 3 halted			*/
#define	EL3RST	40	/* Level 3 reset			*/
#define	ELNRNG	41	/* Link number out of range		*/
#define	EUNATCH 42	/* Protocol driver not attached		*/
#define	ENOCSI	43	/* No CSI structure available		*/
#define	EL2HLT	44	/* Level 2 halted			*/

/* Convergent Error Returns */
#define EBADE	50	/* invalid exchange			*/
#define EBADR	51	/* invalid request descriptor		*/
#define EXFULL	52	/* exchange full			*/
#define ENOANO	53	/* no anode				*/
#define EBADRQC	54	/* invalid request code			*/
#define EBADSLT	55	/* invalid slot				*/
#define EDEADLOCK 56	/* file locking deadlock error		*/

/* Errors from 4.2 BSD picked up to support sockets */
/* Note that the numbers are different from 4.2 numbering */

/* non-blocking and interrupt i/o */
#define	EWOULDBLOCK	60		/* Operation would block */
#define	EINPROGRESS	61		/* Operation now in progress */
#define	EALREADY	62		/* Operation already in progress */
/* ipc/network software */

	/* argument errors */
#define	ENOTSOCK	63		/* Socket operation on non-socket */
#define	EDESTADDRREQ	64		/* Destination address required */
#define	EMSGSIZE	65		/* Message too long */
#define	EPROTOTYPE	66		/* Protocol wrong type for socket */
#define	EPROTONOSUPPORT	67		/* Protocol not supported */
#define	ESOCKTNOSUPPORT	68		/* Socket type not supported */
#define	EOPNOTSUPP	69		/* Operation not supported on socket */
#define	EPFNOSUPPORT	70		/* Protocol family not supported */
#define	EAFNOSUPPORT	71		/* Address family not supported by protocol family */
#define	EADDRINUSE	72		/* Address already in use */
#define	EADDRNOTAVAIL	73		/* Can't assign requested address */

	/* operational errors */
#define	ENETDOWN	74		/* Network is down */
#define	ENETUNREACH	75		/* Network is unreachable */
#define	ENETRESET	76		/* Network dropped connection on reset */
#define	ECONNABORTED	77		/* Software caused connection abort */
#define	ECONNRESET	78		/* Connection reset by peer */
#define	ENOBUFS		79		/* No buffer space available */
#define	EISCONN		80		/* Socket is already connected */
#define	ENOTCONN	81		/* Socket is not connected */
#define	ESHUTDOWN	82		/* Can't send after socket shutdown */
#define	ETOOMANYREFS	83		/* Too many references: can't splice */
#define	ETIMEDOUT	84		/* Connection timed out */
#define	ECONNREFUSED	85		/* Connection refused */


/* should be rearranged */
#define	EHOSTDOWN	86		/* Host is down */
#define	EHOSTUNREACH	87		/* No route to host */
#define	ENOPROTOOPT	88		/* Protocol not available */
